/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.dumpers;

import edu.umn.cs.melt.copper.compiletime.dumpers.FullParserDumper;
import edu.umn.cs.melt.copper.compiletime.lrdfa.LR0DFA;
import edu.umn.cs.melt.copper.compiletime.lrdfa.LR0ItemSet;
import edu.umn.cs.melt.copper.compiletime.lrdfa.LRLookaheadAndLayoutSets;
import edu.umn.cs.melt.copper.compiletime.lrdfa.TransparentPrefixes;
import edu.umn.cs.melt.copper.compiletime.parsetable.LRParseTable;
import edu.umn.cs.melt.copper.compiletime.parsetable.LRParseTableConflict;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CopperASTBean;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.ContextSets;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.PSSymbolTable;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.ParserSpec;
import edu.umn.cs.melt.copper.main.CopperDumpType;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.BitSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XHTMLParserDumper
extends FullParserDumper {
    private static final String COPPER_DUMP_NAMESPACE = "http://melt.cs.umn.edu/copper/xmlns/xmldump/0.9";

    public XHTMLParserDumper(PSSymbolTable symbolTable, ParserSpec spec, ContextSets contextSets, LR0DFA dfa, LRLookaheadAndLayoutSets lookahead, LRParseTable parseTable, TransparentPrefixes prefixes) throws ParserConfigurationException {
        super(symbolTable, spec, contextSets, dfa, lookahead, parseTable, prefixes);
    }

    @Override
    public void dump(CopperDumpType type, PrintStream out) throws IOException, UnsupportedOperationException {
        if (type != CopperDumpType.HTML && type != CopperDumpType.XML) {
            throw new UnsupportedOperationException(this.getClass().getName() + " only supports dump type " + (Object)((Object)CopperDumpType.HTML) + " and " + (Object)((Object)CopperDumpType.XML));
        }
        switch (type) {
            case HTML: {
                XMLOutputWriterDOM xmloutD = null;
                try {
                    xmloutD = new XMLOutputWriterDOM();
                }
                catch (ParserConfigurationException ex) {
                    throw new IOException(ex);
                }
                this.generateXMLDump(xmloutD);
                DOMSource source = new DOMSource(xmloutD.document);
                StreamSource xslt = new StreamSource(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("resources/edu/umn/cs/melt/copper/compiletime/dumpformat.xslt")));
                TransformerFactory fact = TransformerFactory.newInstance();
                Transformer tr = null;
                try {
                    tr = fact.newTransformer(xslt);
                }
                catch (TransformerException ex) {
                    throw new IOException(ex);
                }
                StringWriter wr = new StringWriter();
                StreamResult output = new StreamResult(wr);
                try {
                    tr.transform(source, output);
                }
                catch (TransformerException ex) {
                    throw new IOException(ex);
                }
                out.print(wr.toString());
                break;
            }
            case XML: {
                XMLOutputWriterSAX xmloutS = null;
                try {
                    xmloutS = new XMLOutputWriterSAX(new PrintWriter(out));
                    xmloutS.sw.writeStartDocument();
                    this.generateXMLDump(xmloutS);
                    xmloutS.sw.writeEndDocument();
                    xmloutS.sw.flush();
                    break;
                }
                catch (XMLStreamException ex) {
                    throw new IOException(ex);
                }
            }
        }
    }

    private <EX extends Exception> void generateXMLDump(XMLOutputWriter<EX> xmlout) throws EX {
        int statenum;
        int j;
        xmlout.writeStartElement("CopperXMLDump");
        xmlout.writeDefaultNamespace(COPPER_DUMP_NAMESPACE);
        int i = this.spec.grammars.nextSetBit(0);
        while (i >= 0) {
            CopperASTBean gn = (CopperASTBean)this.symbolTable.get(i);
            xmlout.writeStartElement("Grammar");
            xmlout.writeAttribute("tag", String.valueOf(i));
            xmlout.writeAttribute("id", this.generateName(gn));
            if (gn.hasDisplayName()) {
                xmlout.writeStartElement("DisplayName");
                xmlout.writeCharacters(gn.getDisplayName());
                xmlout.writeEndElement();
            }
            xmlout.writeEndElement();
            i = this.spec.grammars.nextSetBit(i + 1);
        }
        i = this.spec.terminals.nextSetBit(0);
        while (i >= 0) {
            CopperASTBean t = (CopperASTBean)this.symbolTable.get(i);
            xmlout.writeStartElement("Terminal");
            xmlout.writeAttribute("tag", this.generateTag(i));
            xmlout.writeAttribute("id", this.generateName(t));
            if (this.spec.owners[i] != -1 && this.spec.grammars.get(this.spec.owners[i])) {
                xmlout.writeAttribute("owner", String.valueOf(this.spec.owners[i]));
            }
            if (t.hasDisplayName()) {
                xmlout.writeStartElement("DisplayName");
                xmlout.writeCharacters(t.getDisplayName());
                xmlout.writeEndElement();
            }
            xmlout.writeEndElement();
            i = this.spec.terminals.nextSetBit(i + 1);
        }
        i = this.spec.nonterminals.nextSetBit(0);
        while (i >= 0) {
            CopperASTBean nt = (CopperASTBean)this.symbolTable.get(i);
            xmlout.writeStartElement("Nonterminal");
            xmlout.writeAttribute("tag", this.generateTag(i));
            xmlout.writeAttribute("id", this.generateName(nt));
            if (this.spec.owners[i] != -1 && this.spec.grammars.get(this.spec.owners[i])) {
                xmlout.writeAttribute("owner", String.valueOf(this.spec.owners[i]));
            }
            if (nt.hasDisplayName()) {
                xmlout.writeStartElement("DisplayName");
                xmlout.writeCharacters(nt.getDisplayName());
                xmlout.writeEndElement();
            }
            xmlout.writeEndElement();
            i = this.spec.nonterminals.nextSetBit(i + 1);
        }
        i = this.spec.productions.nextSetBit(0);
        while (i >= 0) {
            CopperASTBean p = (CopperASTBean)this.symbolTable.get(i);
            xmlout.writeStartElement("Production");
            xmlout.writeAttribute("tag", this.generateTag(i));
            xmlout.writeAttribute("id", this.generateName(p));
            if (this.spec.owners[i] != -1 && this.spec.grammars.get(this.spec.owners[i])) {
                xmlout.writeAttribute("owner", String.valueOf(this.spec.owners[i]));
            }
            if (p.hasDisplayName()) {
                xmlout.writeStartElement("DisplayName");
                xmlout.writeCharacters(p.getDisplayName());
                xmlout.writeEndElement();
            }
            xmlout.writeStartElement("LHS");
            xmlout.writeCharacters(this.generateTag(this.spec.pr.getLHS(i)));
            xmlout.writeEndElement();
            xmlout.writeStartElement("RHS");
            for (j = 0; j < this.spec.pr.getRHSLength(i); ++j) {
                int rhsSym = this.spec.pr.getRHSSym(i, j);
                if (this.spec.terminals.get(rhsSym)) {
                    xmlout.writeStartElement("Terminal");
                } else {
                    xmlout.writeStartElement("Nonterminal");
                }
                xmlout.writeAttribute("ref", this.generateTag(rhsSym));
                xmlout.writeEndElement();
            }
            xmlout.writeEndElement();
            xmlout.writeEndElement();
            i = this.spec.productions.nextSetBit(i + 1);
        }
        xmlout.writeStartElement("PrecedenceGraph");
        int t = this.spec.terminals.nextSetBit(0);
        while (t >= 0) {
            xmlout.writeStartElement("Vertex");
            xmlout.writeAttribute("tag", this.generateTag(t));
            xmlout.writeEndElement();
            int u = this.spec.terminals.nextSetBit(0);
            while (u >= 0) {
                if (this.spec.t.precedences.hasEdge(t, u)) {
                    xmlout.writeStartElement("Edge");
                    xmlout.writeAttribute("submits", this.generateTag(t));
                    xmlout.writeAttribute("dominates", this.generateTag(u));
                    xmlout.writeEndElement();
                }
                u = this.spec.terminals.nextSetBit(u + 1);
            }
            t = this.spec.terminals.nextSetBit(t + 1);
        }
        xmlout.writeEndElement();
        i = this.spec.disambiguationFunctions.nextSetBit(0);
        while (i >= 0) {
            CopperASTBean df = (CopperASTBean)this.symbolTable.get(i);
            xmlout.writeStartElement("DisambiguationFunction");
            xmlout.writeAttribute("tag", this.generateTag(i));
            xmlout.writeAttribute("id", df.getName().toString());
            if (this.spec.df.hasDisambiguateTo(i)) {
                xmlout.writeAttribute("disambiguateTo", this.generateTag(this.spec.df.getDisambiguateTo(i)));
            }
            xmlout.writeAttribute("appliesToSubsets", String.valueOf(this.spec.df.getApplicableToSubsets(i)));
            j = this.spec.df.getMembers(i).nextSetBit(0);
            while (j >= 0) {
                xmlout.writeStartElement("Member");
                xmlout.writeAttribute("ref", this.generateTag(j));
                xmlout.writeEndElement();
                j = this.spec.df.getMembers(i).nextSetBit(j + 1);
            }
            xmlout.writeEndElement();
            i = this.spec.disambiguationFunctions.nextSetBit(i + 1);
        }
        xmlout.writeStartElement("ContextSets");
        i = this.spec.nonterminals.nextSetBit(0);
        while (i >= 0) {
            xmlout.writeStartElement("First");
            xmlout.writeAttribute("of", String.valueOf(i));
            int j2 = this.contextSets.getFirst(i).nextSetBit(0);
            while (j2 >= 0) {
                xmlout.writeStartElement("Member");
                xmlout.writeAttribute("ref", this.generateTag(j2));
                xmlout.writeEndElement();
                j2 = this.contextSets.getFirst(i).nextSetBit(j2 + 1);
            }
            xmlout.writeEndElement();
            i = this.spec.nonterminals.nextSetBit(i + 1);
        }
        i = this.spec.nonterminals.nextSetBit(0);
        while (i >= 0) {
            xmlout.writeStartElement("FirstNT");
            xmlout.writeAttribute("of", String.valueOf(i));
            int j3 = this.contextSets.getFirstNTs(i).nextSetBit(0);
            while (j3 >= 0) {
                xmlout.writeStartElement("Member");
                xmlout.writeAttribute("ref", this.generateTag(j3));
                xmlout.writeEndElement();
                j3 = this.contextSets.getFirstNTs(i).nextSetBit(j3 + 1);
            }
            xmlout.writeEndElement();
            i = this.spec.nonterminals.nextSetBit(i + 1);
        }
        BitSet syms = this.spec.terminals;
        while (syms != null) {
            int i2 = syms.nextSetBit(0);
            while (i2 >= 0) {
                xmlout.writeStartElement("Follow");
                xmlout.writeAttribute("of", String.valueOf(i2));
                j = this.contextSets.getFollow(i2).nextSetBit(0);
                while (j >= 0) {
                    xmlout.writeStartElement("Member");
                    xmlout.writeAttribute("ref", this.generateTag(j));
                    xmlout.writeEndElement();
                    j = this.contextSets.getFollow(i2).nextSetBit(j + 1);
                }
                xmlout.writeEndElement();
                i2 = syms.nextSetBit(i2 + 1);
            }
            syms = syms == this.spec.terminals ? this.spec.nonterminals : null;
        }
        xmlout.writeStartElement("Nullable");
        int i3 = this.spec.nonterminals.nextSetBit(0);
        while (i3 >= 0) {
            if (this.contextSets.isNullable(i3)) {
                xmlout.writeStartElement("Member");
                xmlout.writeAttribute("ref", this.generateTag(i3));
                xmlout.writeEndElement();
            }
            i3 = this.spec.terminals.nextSetBit(i3 + 1);
        }
        xmlout.writeEndElement();
        xmlout.writeEndElement();
        xmlout.writeStartElement("LALR_DFA");
        for (statenum = 1; statenum < this.dfa.size(); ++statenum) {
            LR0ItemSet state = this.dfa.getItemSet(statenum);
            xmlout.writeStartElement("State");
            xmlout.writeAttribute("id", String.valueOf(statenum));
            xmlout.writeAttribute("tag", "ds" + statenum);
            for (int item = 0; item < state.size(); ++item) {
                xmlout.writeStartElement("Item");
                xmlout.writeAttribute("production", this.generateTag(state.getProduction(item)));
                xmlout.writeAttribute("marker", String.valueOf(state.getPosition(item)));
                int la = this.lookahead.getLookahead(statenum, item).nextSetBit(0);
                while (la >= 0) {
                    xmlout.writeStartElement("Lookahead");
                    xmlout.writeAttribute("ref", this.generateTag(la));
                    xmlout.writeEndElement();
                    la = this.lookahead.getLookahead(statenum, item).nextSetBit(la + 1);
                }
                xmlout.writeEndElement();
            }
            int X = this.dfa.getTransitionLabels(statenum).nextSetBit(0);
            while (X >= 0) {
                xmlout.writeStartElement("Transition");
                xmlout.writeAttribute("label", this.generateTag(X));
                xmlout.writeAttribute("dest", "ds" + this.dfa.getTransition(statenum, X));
                xmlout.writeEndElement();
                X = this.dfa.getTransitionLabels(statenum).nextSetBit(X + 1);
            }
            xmlout.writeEndElement();
        }
        xmlout.writeEndElement();
        xmlout.writeStartElement("LRParseTable");
        for (statenum = 1; statenum < this.parseTable.size(); ++statenum) {
            xmlout.writeStartElement("State");
            xmlout.writeAttribute("tag", "tr" + statenum);
            xmlout.writeAttribute("id", String.valueOf(statenum));
            BitSet shiftable = new BitSet();
            shiftable.or(this.parseTable.getValidLA(statenum));
            shiftable.andNot(this.spec.nonterminals);
            if (!shiftable.isEmpty()) {
                int t2;
                int layout = this.lookahead.getLayout(statenum).nextSetBit(0);
                while (layout >= 0) {
                    xmlout.writeStartElement("Layout");
                    xmlout.writeAttribute("tag", this.generateTag(layout));
                    t2 = shiftable.nextSetBit(0);
                    while (t2 >= 0) {
                        xmlout.writeStartElement("Follow");
                        xmlout.writeAttribute("ref", this.generateTag(t2));
                        xmlout.writeEndElement();
                        t2 = shiftable.nextSetBit(t2 + 1);
                    }
                    xmlout.writeEndElement();
                    layout = this.lookahead.getLayout(statenum).nextSetBit(layout + 1);
                }
                int prefix = this.prefixes.getPrefixes(statenum).nextSetBit(0);
                while (prefix >= 0) {
                    xmlout.writeStartElement("Prefix");
                    xmlout.writeAttribute("tag", this.generateTag(prefix));
                    t2 = this.prefixes.getFollowingTerminals(statenum, prefix).nextSetBit(0);
                    while (t2 >= 0) {
                        xmlout.writeStartElement("Follow");
                        xmlout.writeAttribute("ref", this.generateTag(t2));
                        xmlout.writeEndElement();
                        t2 = this.prefixes.getFollowingTerminals(statenum, prefix).nextSetBit(t2 + 1);
                    }
                    xmlout.writeEndElement();
                    prefix = this.prefixes.getPrefixes(statenum).nextSetBit(prefix + 1);
                }
                int t3 = shiftable.nextSetBit(0);
                while (t3 >= 0) {
                    xmlout.writeStartElement("ParseCell");
                    xmlout.writeAttribute("id", this.generateTag(t3));
                    switch (this.parseTable.getActionType(statenum, t3)) {
                        case 1: 
                        case 2: {
                            this.addParseAction(xmlout, t3, this.parseTable.getActionType(statenum, t3), this.parseTable.getActionParameter(statenum, t3));
                            break;
                        }
                        case 3: {
                            LRParseTableConflict conflict = this.parseTable.getConflict(this.parseTable.getActionParameter(statenum, t3));
                            if (conflict.shift != -1) {
                                this.addParseAction(xmlout, t3, (byte)1, conflict.shift);
                            }
                            int r = conflict.reduce.nextSetBit(0);
                            while (r >= 0) {
                                this.addParseAction(xmlout, t3, (byte)2, r);
                                r = conflict.reduce.nextSetBit(r + 1);
                            }
                            break;
                        }
                    }
                    xmlout.writeEndElement();
                    t3 = shiftable.nextSetBit(t3 + 1);
                }
            }
            BitSet gotoable = new BitSet();
            gotoable.or(this.parseTable.getValidLA(statenum));
            gotoable.andNot(this.spec.terminals);
            int nt = gotoable.nextSetBit(0);
            while (nt >= 0) {
                xmlout.writeStartElement("GotoCell");
                xmlout.writeAttribute("id", this.generateTag(nt));
                this.addParseAction(xmlout, nt, (byte)1, this.parseTable.getActionParameter(statenum, nt));
                xmlout.writeEndElement();
                nt = gotoable.nextSetBit(nt + 1);
            }
            xmlout.writeEndElement();
        }
        xmlout.writeEndElement();
        xmlout.writeEndElement();
    }

    private String generateName(CopperASTBean bean) {
        if (this.symbolTable.getParser(this.spec.parser).isUnitary() || !this.spec.grammars.get(this.spec.owners[this.symbolTable.get(bean)])) {
            return bean.getName().toString();
        }
        return this.symbolTable.getGrammar(this.spec.owners[this.symbolTable.get(bean)]).getName() + "$" + bean.getName();
    }

    private String generateTag(int i) {
        return String.valueOf(i);
    }

    private <EX extends Exception> void addParseAction(XMLOutputWriter<EX> xmlout, int sym, byte type, int parameter) throws EX {
        if (type == 1 && sym == this.spec.getEOFTerminal()) {
            xmlout.writeStartElement("Accept");
            xmlout.writeEndElement();
        } else if (type == 1 && this.spec.nonterminals.get(sym)) {
            xmlout.writeStartElement("Goto");
            xmlout.writeAttribute("dest", "tr" + parameter);
            xmlout.writeEndElement();
        } else if (type == 1) {
            xmlout.writeStartElement("Shift");
            xmlout.writeAttribute("dest", "tr" + parameter);
            xmlout.writeEndElement();
        } else {
            xmlout.writeStartElement("Reduce");
            xmlout.writeAttribute("prod", this.generateTag(parameter));
            xmlout.writeEndElement();
        }
    }

    private static class XMLOutputWriterDOM
    implements XMLOutputWriter<RuntimeException> {
        public Document document;
        private Element currentElement;

        public XMLOutputWriterDOM() throws ParserConfigurationException {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.document = builder.newDocument();
            this.currentElement = null;
        }

        @Override
        public void writeStartElement(String name) {
            this.currentElement = this.currentElement == null ? (Element)this.document.appendChild(this.document.createElementNS(XHTMLParserDumper.COPPER_DUMP_NAMESPACE, name)) : (Element)this.currentElement.appendChild(this.document.createElementNS(XHTMLParserDumper.COPPER_DUMP_NAMESPACE, name));
        }

        @Override
        public void writeDefaultNamespace(String namespaceURI) {
        }

        @Override
        public void writeCharacters(String text) {
            this.currentElement.setTextContent(text);
        }

        @Override
        public void writeAttribute(String key, String value) {
            this.currentElement.setAttribute(key, value);
        }

        @Override
        public void writeEndElement() {
            Node n = this.currentElement.getParentNode();
            this.currentElement = n.getNodeType() == 1 ? (Element)this.currentElement.getParentNode() : null;
        }
    }

    private static interface XMLOutputWriter<EX extends Exception> {
        public void writeStartElement(String var1) throws EX;

        public void writeDefaultNamespace(String var1) throws EX;

        public void writeCharacters(String var1) throws EX;

        public void writeAttribute(String var1, String var2) throws EX;

        public void writeEndElement() throws EX;
    }

    private static class XMLOutputWriterSAX
    implements XMLOutputWriter<XMLStreamException> {
        private XMLStreamWriter sw;

        public XMLOutputWriterSAX(Writer w) throws XMLStreamException {
            this.sw = XMLOutputFactory.newInstance().createXMLStreamWriter(w);
        }

        @Override
        public void writeStartElement(String name) throws XMLStreamException {
            this.sw.writeStartElement(name);
        }

        @Override
        public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
            this.sw.writeDefaultNamespace(namespaceURI);
        }

        @Override
        public void writeCharacters(String text) throws XMLStreamException {
            this.sw.writeCharacters(text);
        }

        @Override
        public void writeAttribute(String key, String value) throws XMLStreamException {
            this.sw.writeAttribute(key, value);
        }

        @Override
        public void writeEndElement() throws XMLStreamException {
            this.sw.writeEndElement();
        }
    }
}

