/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.legacy.compiletime.finiteautomaton.oldnfa;

import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.Symbol;
import edu.umn.cs.melt.copper.legacy.compiletime.auxiliary.CharacterRange;
import edu.umn.cs.melt.copper.legacy.compiletime.auxiliary.Mergable;
import edu.umn.cs.melt.copper.runtime.auxiliary.Pair;
import edu.umn.cs.melt.copper.runtime.io.ScannerBuffer;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class NFAState
implements Iterable<Pair<CharacterRange, NFAState>>,
Mergable<NFAState> {
    public static final char EmptyChar = ScannerBuffer.EOFIndicator;
    private HashSet<Symbol> identifier = new HashSet();
    private HashSet<Symbol> accepts;
    private Hashtable<CharacterRange, HashSet<NFAState>> transitions;

    public NFAState(Symbol identifier, Symbol acceptsFor) {
        if (identifier != null) {
            this.identifier.add(identifier);
        }
        this.accepts = new HashSet();
        if (acceptsFor != null) {
            this.accepts.add(acceptsFor);
        }
        this.transitions = new Hashtable();
    }

    public NFAState(HashSet<Symbol> identifier, HashSet<Symbol> accepts) {
        if (identifier != null) {
            this.identifier.addAll(identifier);
        }
        this.accepts = new HashSet();
        if (accepts != null) {
            this.accepts.addAll(accepts);
        }
        this.transitions = new Hashtable();
    }

    public HashSet<Symbol> getIdentifier() {
        return this.identifier;
    }

    public HashSet<Symbol> getAccepts() {
        return this.accepts;
    }

    @Override
    public Iterator<Pair<CharacterRange, NFAState>> iterator() {
        return new FAStateIterator(this.transitions);
    }

    public Iterable<CharacterRange> getTransitionSymbols() {
        return this.transitions.keySet();
    }

    public Iterable<NFAState> getTransitions(CharacterRange sym) {
        if (this.transitions.containsKey(sym)) {
            return this.transitions.get(sym);
        }
        return new HashSet<NFAState>();
    }

    public boolean addAcceptSyms(HashSet<Symbol> newAccepts) {
        return this.accepts.addAll(newAccepts);
    }

    public boolean addTransition(Character symbol, NFAState newState) {
        return this.addTransition(new CharacterRange(symbol.charValue()), newState);
    }

    public boolean addTransition(CharacterRange symbol, NFAState newState) {
        if (!this.transitions.containsKey(symbol)) {
            this.transitions.put(symbol, new HashSet());
        }
        return this.transitions.get(symbol).add(newState);
    }

    public void compressTransitions() {
        Hashtable revMap = new Hashtable();
        for (CharacterRange cr : this.transitions.keySet()) {
            if (!revMap.containsKey(this.transitions.get(cr))) {
                revMap.put(this.transitions.get(cr), new HashSet());
            }
            ((HashSet)revMap.get(this.transitions.get(cr))).add(cr);
        }
        this.transitions.clear();
        for (HashSet dest : revMap.keySet()) {
            for (CharacterRange cr : CharacterRange.consolidateAdjacentRanges((Iterable)revMap.get(dest))) {
                if (!this.transitions.containsKey(cr)) {
                    this.transitions.put(cr, new HashSet());
                }
                this.transitions.get(cr).addAll(dest);
            }
        }
    }

    public boolean equals(Object rhs) {
        if (rhs instanceof NFAState) {
            return this.identifier.equals(((NFAState)rhs).identifier);
        }
        return false;
    }

    public String toString() {
        String rv = "State " + this.identifier;
        if (!this.accepts.isEmpty()) {
            rv = rv + ", accepts for " + this.accepts + ",";
        }
        rv = rv + " -> [ ";
        for (Pair<CharacterRange, NFAState> transition : this) {
            rv = rv + "(";
            rv = transition.first().equals(new CharacterRange(EmptyChar)) ? rv + "(eps)" : rv + transition.first();
            rv = rv + "," + transition.second().identifier.toString() + ") ";
        }
        rv = rv + "]";
        return rv;
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    @Override
    public boolean union(NFAState rhs) {
        if (this.equals(rhs)) {
            return this.accepts.addAll(rhs.accepts);
        }
        return false;
    }

    @Override
    public boolean intersect(NFAState rhs) {
        if (this.equals(rhs)) {
            return this.accepts.retainAll(rhs.accepts);
        }
        return false;
    }

    private class FAStateIterator
    implements Iterator<Pair<CharacterRange, NFAState>> {
        private Hashtable<CharacterRange, HashSet<NFAState>> table;
        private CharacterRange presentKey;
        private Iterator<CharacterRange> keyIterator;
        private Iterator<NFAState> valueIterator;

        public FAStateIterator(Hashtable<CharacterRange, HashSet<NFAState>> table) {
            this.table = table;
            this.keyIterator = table.keySet().iterator();
            this.valueIterator = null;
        }

        @Override
        public Pair<CharacterRange, NFAState> next() {
            if (this.valueIterator == null) {
                if (!this.keyIterator.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.presentKey = this.keyIterator.next();
                this.valueIterator = this.table.get(this.presentKey).iterator();
            }
            if (!this.valueIterator.hasNext()) {
                throw new NoSuchElementException();
            }
            Pair<CharacterRange, NFAState> rv = new Pair<CharacterRange, NFAState>(this.presentKey, this.valueIterator.next());
            if (!this.valueIterator.hasNext()) {
                this.valueIterator = null;
            }
            return rv;
        }

        @Override
        public boolean hasNext() {
            if (this.valueIterator != null) {
                return this.valueIterator.hasNext();
            }
            return this.keyIterator.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

