/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.legacy.compiletime.logging;

import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.GrammarSource;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.LexicalDisambiguationGroup;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.NonTerminal;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.Production;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.Terminal;
import edu.umn.cs.melt.copper.legacy.compiletime.finiteautomaton.lalrengine.lalr1.LALR1DFA;
import edu.umn.cs.melt.copper.legacy.compiletime.finiteautomaton.lalrengine.lalr1.LALR1State;
import edu.umn.cs.melt.copper.legacy.compiletime.finiteautomaton.lalrengine.lalr1.LALR1StateItem;
import edu.umn.cs.melt.copper.legacy.compiletime.finiteautomaton.lalrengine.lalr1.LALR1Transition;
import edu.umn.cs.melt.copper.legacy.compiletime.logging.GrammarDumper;
import edu.umn.cs.melt.copper.legacy.compiletime.parsetable.AcceptAction;
import edu.umn.cs.melt.copper.legacy.compiletime.parsetable.FullReduceAction;
import edu.umn.cs.melt.copper.legacy.compiletime.parsetable.ParseAction;
import edu.umn.cs.melt.copper.legacy.compiletime.parsetable.ParseActionVisitor;
import edu.umn.cs.melt.copper.legacy.compiletime.parsetable.ReadOnlyParseTable;
import edu.umn.cs.melt.copper.legacy.compiletime.parsetable.ShiftAction;
import java.io.PrintStream;
import java.util.Hashtable;

public class PlainTextGrammarDumper
extends GrammarDumper
implements ParseActionVisitor<String, RuntimeException> {
    private PrintStream finalOutputStream;
    private GrammarSource grammar;
    private LALR1DFA dfa;
    private ReadOnlyParseTable parseTable;
    private Hashtable<Object, Integer> numbering;
    private static final int TERMINALS_PER_LINE = 5;
    private static final int NONTERMINALS_PER_LINE = 5;
    private static final int PRODUCTIONS_PER_LINE = 5;
    private static final int ACTIONS_PER_LINE = 2;
    private static final int GOTO_ACTIONS_PER_LINE = 3;

    public PlainTextGrammarDumper(PrintStream finalOutputStream, GrammarSource grammar, LALR1DFA dfa, ReadOnlyParseTable parseTable) {
        this.finalOutputStream = finalOutputStream;
        this.grammar = grammar;
        this.dfa = dfa;
        this.parseTable = parseTable;
        this.numbering = new Hashtable();
    }

    @Override
    public void logPlain() {
    }

    @Override
    public void dumpDisambigGroups() {
        int i = 0;
        this.finalOutputStream.print("===== DISAMBIGUATION FUNCTIONS/GROUPS =====\n");
        for (LexicalDisambiguationGroup group : this.grammar.getDisambiguationGroups()) {
            this.finalOutputStream.print("[" + i + "]{" + group.getName() + " : " + group.getMembers().toString() + "}\n");
            this.numbering.put(group, i++);
        }
    }

    @Override
    public void dumpNonTerminals() {
        int i = 0;
        this.finalOutputStream.print("===== NONTERMINALS =====\n");
        for (NonTerminal nt : this.grammar.getNT()) {
            this.finalOutputStream.print("[" + i + "]" + nt + " ");
            if (!this.grammar.getDisplayName(nt.getId()).equals(nt.getId().toString())) {
                this.finalOutputStream.print("(" + this.grammar.getDisplayName(nt.getId()) + ") ");
            }
            this.numbering.put(nt, i++);
            if (i % 5 != 0) continue;
            this.finalOutputStream.print("\n");
        }
        if (i % 5 != 0) {
            this.finalOutputStream.print("\n");
        }
    }

    @Override
    public void dumpLALR1DFA() {
        this.finalOutputStream.print("===== LALR(1) DFA =====\n");
        for (int statenum = 0; statenum <= this.parseTable.getLastState(); ++statenum) {
            LALR1State state = this.dfa.getState(statenum);
            this.finalOutputStream.print("-------------------\nlalr_state [" + statenum + "]: {\n");
            for (LALR1StateItem item : state.getItems()) {
                this.finalOutputStream.print("    [" + item + ", {");
                for (Terminal lookahead : this.dfa.getLookahead(state, item)) {
                    this.finalOutputStream.print(lookahead.toString() + " ");
                }
                this.finalOutputStream.print("}]\n");
            }
            this.finalOutputStream.print("}\n");
            for (LALR1Transition transition : this.dfa.getTransitions(state)) {
                this.finalOutputStream.print("transition on " + transition.getLabel() + " to state " + this.dfa.getLabel(transition.getDest()) + "\n");
            }
        }
    }

    @Override
    public void dumpParseTable() {
        int i;
        int statenum;
        this.finalOutputStream.print("===== PARSE TABLE =====\n");
        for (statenum = 0; statenum <= this.parseTable.getLastState(); ++statenum) {
            Object terms;
            this.finalOutputStream.print("From state #" + statenum + "\n");
            i = 0;
            if (!this.parseTable.hasShiftable(statenum)) continue;
            if (this.parseTable.hasLayout(statenum)) {
                for (Terminal terminal : this.parseTable.getLayout(statenum)) {
                    terms = "";
                    for (Terminal t : this.parseTable.getShiftableFollowingLayout(statenum, terminal)) {
                        if (!((String)terms).equals("")) {
                            terms = (String)terms + ",";
                        }
                        terms = (String)terms + this.numbering.get(t);
                    }
                    this.finalOutputStream.print(" [layout term " + this.numbering.get(terminal) + " -> terms " + (String)terms + "]\n");
                }
            }
            if (this.parseTable.hasPrefixes(statenum)) {
                for (Terminal terminal : this.parseTable.getPrefixes(statenum)) {
                    terms = "";
                    for (Terminal t : this.parseTable.getShiftableFollowingPrefix(statenum, terminal)) {
                        if (!((String)terms).equals("")) {
                            terms = (String)terms + ",";
                        }
                        terms = (String)terms + this.numbering.get(t);
                    }
                    this.finalOutputStream.print(" [prefix term " + this.numbering.get(terminal) + " -> terms " + (String)terms + "]\n");
                }
            }
            for (Terminal terminal : this.parseTable.getShiftable(statenum)) {
                for (ParseAction action : this.parseTable.getParseActions(statenum, terminal)) {
                    this.finalOutputStream.print(" [term " + this.numbering.get(terminal) + ":" + action.acceptVisitor(this) + "]");
                    if (++i % 2 != 0) continue;
                    this.finalOutputStream.print("\n");
                }
            }
            if (i % 2 == 0) continue;
            this.finalOutputStream.print("\n");
        }
        this.finalOutputStream.print("===== GOTO TABLE =====\n");
        for (statenum = 0; statenum <= this.parseTable.getLastState(); ++statenum) {
            this.finalOutputStream.print("From state #" + statenum + "\n");
            i = 0;
            if (!this.parseTable.hasGotoable(statenum)) continue;
            for (NonTerminal nonTerminal : this.parseTable.getGotoable(statenum)) {
                ShiftAction action = this.parseTable.getGotoAction(statenum, nonTerminal);
                this.finalOutputStream.print(" [nonterm " + this.numbering.get(nonTerminal) + "->state " + action.getDestState() + "]");
                if (++i % 3 != 0) continue;
                this.finalOutputStream.print("\n");
            }
            if (i % 3 == 0) continue;
            this.finalOutputStream.print("\n");
        }
    }

    @Override
    public void dumpPrecedenceGraph() {
        this.finalOutputStream.print("===== LEXICAL PRECEDENCE GRAPH =====\n");
        this.finalOutputStream.print(this.grammar.getPrecedenceRelationsGraph().toString());
    }

    @Override
    public void dumpProductions() {
        int i = 0;
        this.finalOutputStream.print("===== PRODUCTIONS =====\n");
        for (NonTerminal nt : this.grammar.getNT()) {
            if (!this.grammar.pContains(nt)) continue;
            for (Production p : this.grammar.getP(nt)) {
                this.finalOutputStream.print("[" + i + "]" + p + " ");
                this.numbering.put(p, i++);
                if (i % 5 != 0) continue;
                this.finalOutputStream.print("\n");
            }
        }
        if (i % 5 != 0) {
            this.finalOutputStream.print("\n");
        }
    }

    @Override
    public void dumpTerminals() {
        int i = 0;
        this.finalOutputStream.print("===== TERMINALS =====\n");
        for (Terminal t : this.grammar.getT()) {
            this.finalOutputStream.print("[" + i + "]" + t + " ");
            if (!this.grammar.getDisplayName(t.getId()).equals(t.getId().toString())) {
                this.finalOutputStream.print("(" + this.grammar.getDisplayName(t.getId()) + ") ");
            }
            this.numbering.put(t, i++);
            if (i % 5 != 0) continue;
            this.finalOutputStream.print("\n");
        }
        if (i % 5 != 0) {
            this.finalOutputStream.print("\n");
        }
    }

    @Override
    public String visitAcceptAction(AcceptAction action) throws RuntimeException {
        return "ACCEPT";
    }

    @Override
    public String visitFullReduceAction(FullReduceAction action) throws RuntimeException {
        return "REDUCE(with prod " + this.numbering.get(action.getProd()) + ")";
    }

    @Override
    public String visitShiftAction(ShiftAction action) throws RuntimeException {
        return "SHIFT(to state " + action.getDestState() + ")";
    }

    @Override
    public void dumpPreamble() {
    }

    @Override
    public void dumpPostamble() {
    }
}

