/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.auxiliary.counterexample;

public class ColoredStringBuilder {
    private static final String ANSI_RESET = "\u001b[0m";
    private static final String[] ansiColors = new String[]{"\u001b[36m", "\u001b[33m", "\u001b[32m", "\u001b[34m", "\u001b[31m", "\u001b[35m"};
    private StringBuilder sb = new StringBuilder();
    private int colorEscapeCount;
    private static int currentColor = 0;

    public static void incrementCurrentColor() {
        currentColor = currentColor + 1 == ansiColors.length ? 0 : ++currentColor;
    }

    public static void decrementCurrentColor() {
        currentColor = currentColor - 1 < 0 ? ansiColors.length - 1 : --currentColor;
    }

    public void appendColored(String input) {
        ++this.colorEscapeCount;
        this.sb.append(ansiColors[currentColor]);
        this.sb.append(input);
    }

    public void append(String input) {
        this.sb.append(input);
    }

    public int length() {
        return this.sb.length() - this.colorEscapeCount * 5;
    }

    public String toString() {
        this.sb.append(ANSI_RESET);
        return this.sb.toString();
    }
}

