/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.builders;

import edu.umn.cs.melt.copper.compiletime.auxiliary.SetOfCharsSyntax;
import edu.umn.cs.melt.copper.compiletime.scannerdfa.GeneralizedDFA;
import edu.umn.cs.melt.copper.compiletime.scannerdfa.GeneralizedNFA;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CharacterSetRegex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.ChoiceRegex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.ConcatenationRegex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.EmptyStringRegex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.KleeneStarRegex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.MacroHoleRegex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.Regex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.visitors.RegexBeanVisitor;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.ParserSpec;
import edu.umn.cs.melt.copper.runtime.auxiliary.Pair;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeMap;

public class SingleScannerDFABuilder {
    private TreeMap<Integer, Regex> regexes;
    private BitSet terminals;
    private int eofTerminal;
    private TransitionLabelCalculator transitionLabelCalculator;
    private AutomatonGenerator automatonGenerator;
    private GeneralizedNFA nfa;

    private SingleScannerDFABuilder(TreeMap<Integer, Regex> regexes, BitSet terminals, int eofTerminal) {
        this.regexes = regexes;
        this.terminals = terminals;
        this.eofTerminal = eofTerminal;
        this.transitionLabelCalculator = new TransitionLabelCalculator();
        this.automatonGenerator = new AutomatonGenerator();
    }

    public static GeneralizedDFA build(ParserSpec spec) {
        TreeMap<Integer, Regex> regexes = new TreeMap<Integer, Regex>();
        int t = spec.terminals.nextSetBit(0);
        while (t >= 0) {
            regexes.put(t, spec.t.getRegex(t));
            t = spec.terminals.nextSetBit(t + 1);
        }
        return new SingleScannerDFABuilder(regexes, spec.terminals, spec.getEOFTerminal()).buildScannerDFA();
    }

    public static GeneralizedDFA build(TreeMap<Integer, Regex> regexes, BitSet terminals, int eofTerminal) {
        return new SingleScannerDFABuilder(regexes, terminals, eofTerminal).buildScannerDFA();
    }

    private GeneralizedDFA buildScannerDFA() {
        HashSet allCharRanges = new HashSet();
        int t = this.terminals.nextSetBit(0);
        while (t >= 0) {
            if (t != this.eofTerminal) {
                allCharRanges.addAll(this.regexes.get(t).acceptVisitor(this.transitionLabelCalculator));
            }
            t = this.terminals.nextSetBit(t + 1);
        }
        this.nfa = new GeneralizedNFA(this.terminals.cardinality(), allCharRanges.size());
        BitSet allStartStates = new BitSet();
        int t2 = this.terminals.nextSetBit(0);
        while (t2 >= 0) {
            if (t2 != this.eofTerminal) {
                Pair<Integer, BitSet> states = this.regexes.get(t2).acceptVisitor(this.automatonGenerator);
                allStartStates.set(states.first());
                int j = states.second().nextSetBit(0);
                while (j >= 0) {
                    this.nfa.addAcceptSymbol(j, t2);
                    j = states.second().nextSetBit(j + 1);
                }
            }
            t2 = this.terminals.nextSetBit(t2 + 1);
        }
        int newStartState = this.nfa.addState();
        this.nfa.addEpsilonTransitions(newStartState, allStartStates);
        GeneralizedDFA dfa = this.nfa.determinize(newStartState);
        return dfa;
    }

    private class AutomatonGenerator
    implements RegexBeanVisitor<Pair<Integer, BitSet>, RuntimeException> {
        private AutomatonGenerator() {
        }

        @Override
        public Pair<Integer, BitSet> visitChoiceRegex(ChoiceRegex bean) throws RuntimeException {
            int newStartState = SingleScannerDFABuilder.this.nfa.addState();
            BitSet accepts = new BitSet();
            for (Regex sexp : bean.getSubexps()) {
                Pair<Integer, BitSet> subs = sexp.acceptVisitor(this);
                accepts.or(subs.second());
                SingleScannerDFABuilder.this.nfa.addEpsilonTransition(newStartState, subs.first());
            }
            return Pair.cons(newStartState, accepts);
        }

        @Override
        public Pair<Integer, BitSet> visitConcatenationRegex(ConcatenationRegex bean) throws RuntimeException {
            int newStartState = -1;
            Pair<Integer, BitSet> currentSub = null;
            Pair<Integer, BitSet> prevSub = null;
            for (Regex subexp : bean.getSubexps()) {
                currentSub = subexp.acceptVisitor(this);
                if (prevSub != null) {
                    int i = ((BitSet)prevSub.second()).nextSetBit(0);
                    while (i >= 0) {
                        SingleScannerDFABuilder.this.nfa.addEpsilonTransition(i, currentSub.first());
                        i = prevSub.second().nextSetBit(i + 1);
                    }
                } else {
                    newStartState = currentSub.first();
                }
                prevSub = currentSub;
            }
            return Pair.cons(newStartState, currentSub.second());
        }

        @Override
        public Pair<Integer, BitSet> visitKleeneStarRegex(KleeneStarRegex bean) throws RuntimeException {
            int newStartState = SingleScannerDFABuilder.this.nfa.addState();
            BitSet newAccepts = new BitSet(newStartState + 1);
            newAccepts.set(newStartState);
            Pair<Integer, BitSet> sub = bean.getSubexp().acceptVisitor(this);
            SingleScannerDFABuilder.this.nfa.addEpsilonTransition(newStartState, sub.first());
            int i = sub.second().nextSetBit(0);
            while (i >= 0) {
                SingleScannerDFABuilder.this.nfa.addEpsilonTransition(i, newStartState);
                i = sub.second().nextSetBit(i + 1);
            }
            return Pair.cons(newStartState, newAccepts);
        }

        @Override
        public Pair<Integer, BitSet> visitEmptyStringRegex(EmptyStringRegex bean) throws RuntimeException {
            int newState = SingleScannerDFABuilder.this.nfa.addState();
            BitSet accepts = new BitSet(newState + 1);
            accepts.set(newState);
            return Pair.cons(newState, accepts);
        }

        @Override
        public Pair<Integer, BitSet> visitCharacterSetRegex(CharacterSetRegex bean, SetOfCharsSyntax chars) throws RuntimeException {
            int startState = SingleScannerDFABuilder.this.nfa.addState();
            int acceptState = SingleScannerDFABuilder.this.nfa.addState();
            SingleScannerDFABuilder.this.nfa.addTransition(chars, startState, acceptState);
            BitSet accepts = new BitSet(acceptState + 1);
            accepts.set(acceptState);
            return Pair.cons(startState, accepts);
        }

        @Override
        public Pair<Integer, BitSet> visitMacroHoleRegex(MacroHoleRegex bean) throws RuntimeException {
            throw new UnsupportedOperationException("Undefined macro '" + bean.getMacroName() + "'");
        }
    }

    private class TransitionLabelCalculator
    implements RegexBeanVisitor<HashSet<SetOfCharsSyntax>, RuntimeException> {
        private TransitionLabelCalculator() {
        }

        @Override
        public HashSet<SetOfCharsSyntax> visitChoiceRegex(ChoiceRegex bean) throws RuntimeException {
            HashSet<SetOfCharsSyntax> rv = new HashSet<SetOfCharsSyntax>();
            for (Regex sexp : bean.getSubexps()) {
                rv.addAll((Collection<SetOfCharsSyntax>)sexp.acceptVisitor(this));
            }
            return rv;
        }

        @Override
        public HashSet<SetOfCharsSyntax> visitConcatenationRegex(ConcatenationRegex bean) throws RuntimeException {
            HashSet<SetOfCharsSyntax> rv = new HashSet<SetOfCharsSyntax>();
            for (Regex sexp : bean.getSubexps()) {
                rv.addAll((Collection<SetOfCharsSyntax>)sexp.acceptVisitor(this));
            }
            return rv;
        }

        @Override
        public HashSet<SetOfCharsSyntax> visitKleeneStarRegex(KleeneStarRegex bean) throws RuntimeException {
            return bean.getSubexp().acceptVisitor(this);
        }

        @Override
        public HashSet<SetOfCharsSyntax> visitEmptyStringRegex(EmptyStringRegex bean) throws RuntimeException {
            return new HashSet<SetOfCharsSyntax>();
        }

        @Override
        public HashSet<SetOfCharsSyntax> visitCharacterSetRegex(CharacterSetRegex bean, SetOfCharsSyntax chars) throws RuntimeException {
            HashSet<SetOfCharsSyntax> rv = new HashSet<SetOfCharsSyntax>();
            rv.add(chars);
            return rv;
        }

        @Override
        public HashSet<SetOfCharsSyntax> visitMacroHoleRegex(MacroHoleRegex bean) throws RuntimeException {
            throw new UnsupportedOperationException("Undefined macro '" + bean.getMacroName() + "'");
        }
    }
}

