/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.ide.silver.property.ui;

import edu.umn.cs.melt.ide.silver.property.Property;
import edu.umn.cs.melt.ide.silver.property.ui.AbstractPropertyControl;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class TextPropertyControl
extends AbstractPropertyControl {
    private Label info;
    private Text input;

    public TextPropertyControl(Composite panel, String name) {
        super(panel, name);
    }

    public TextPropertyControl(Composite panel, String name, String display, String defaultVal, boolean isRequired) {
        super(panel, name, display, defaultVal, isRequired);
    }

    @Override
    public Control getInfoControl() {
        if (this.info == null) {
            this.info = new Label(this.panel, 0);
            this.info.setText(this.display);
        }
        return this.info;
    }

    @Override
    public Control getInputControl() {
        if (this.input == null) {
            this.input = new Text(this.panel, 2048);
        }
        return this.input;
    }

    @Override
    public Property getProperty() {
        return Property.makeStringProperty(this.name, this.input.getText(), this.defaultVal, this.display, this.isRequired);
    }

    @Override
    public boolean validate() {
        String value = this.input.getText();
        if (!this.isFilled(value)) {
            this.input.setToolTipText("This field cannot be empty.");
            this.input.setBackground(this.panel.getDisplay().getSystemColor(3));
            return false;
        }
        this.reset();
        return true;
    }

    private void reset() {
        this.input.setToolTipText(null);
        this.input.setBackground(this.panel.getDisplay().getSystemColor(1));
    }

    @Override
    public String getKey() {
        return this.name;
    }

    @Override
    public void setValue(String value) {
        this.input.setText(value);
    }
}

