/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.lrdfa;

import edu.umn.cs.melt.copper.compiletime.auxiliary.SymbolTable;
import edu.umn.cs.melt.copper.compiletime.lrdfa.LR0DFA;
import edu.umn.cs.melt.copper.compiletime.lrdfa.LRLookaheadAndLayoutSets;
import edu.umn.cs.melt.copper.compiletime.lrdfa.LRLookaheadSets;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CopperASTBean;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.ParserSpec;

public class LRDFAPrinter {
    public static String toString(SymbolTable<CopperASTBean> symbolTable, ParserSpec spec, LR0DFA dfa) {
        return LRDFAPrinter.toString(symbolTable, spec, dfa, null);
    }

    public static String toString(SymbolTable<CopperASTBean> symbolTable, ParserSpec spec, LR0DFA dfa, LRLookaheadSets lookaheadSets) {
        boolean hasLayouts = lookaheadSets instanceof LRLookaheadAndLayoutSets;
        StringBuffer rv = new StringBuffer();
        for (int i = 0; i < dfa.size(); ++i) {
            int k;
            int j;
            rv.append("State ").append(i).append(":\n");
            for (j = 0; j < dfa.getItemSet(i).size(); ++j) {
                rv.append("    ");
                rv.append(symbolTable.get(spec.pr.getLHS(dfa.getItemSet(i).getProduction(j))).getDisplayName());
                rv.append(" ::=");
                for (k = 0; k < spec.pr.getRHSLength(dfa.getItemSet(i).getProduction(j)); ++k) {
                    if (k == dfa.getItemSet(i).getPosition(j)) {
                        rv.append(" (*)");
                    }
                    rv.append(" ").append(symbolTable.get(spec.pr.getRHSSym(dfa.getItemSet(i).getProduction(j), k)).getDisplayName());
                }
                if (dfa.getItemSet(i).getPosition(j) == spec.pr.getRHSLength(dfa.getItemSet(i).getProduction(j))) {
                    rv.append(" (*)");
                }
                if (lookaheadSets != null) {
                    rv.append("   [");
                    boolean first = true;
                    int k2 = lookaheadSets.getLookahead(i, j).nextSetBit(0);
                    while (k2 >= 0) {
                        if (first) {
                            first = false;
                        } else {
                            rv.append(",");
                        }
                        rv.append(symbolTable.get(k2).getDisplayName());
                        k2 = lookaheadSets.getLookahead(i, j).nextSetBit(k2 + 1);
                    }
                    rv.append("]");
                }
                rv.append("\n");
            }
            if (hasLayouts) {
                rv.append("  Layouts: [");
                boolean first = true;
                k = ((LRLookaheadAndLayoutSets)lookaheadSets).getLayout(i).nextSetBit(0);
                while (k >= 0) {
                    if (first) {
                        first = false;
                    } else {
                        rv.append(",");
                    }
                    rv.append(symbolTable.get(k).getDisplayName());
                    k = ((LRLookaheadAndLayoutSets)lookaheadSets).getLayout(i).nextSetBit(k + 1);
                }
                rv.append("]\n");
            }
            j = dfa.getTransitionLabels(i).nextSetBit(0);
            while (j >= 0) {
                rv.append("  Transition on symbol ").append(symbolTable.get(j).getDisplayName()).append(" to state ").append(dfa.getTransition(i, j)).append("\n");
                j = dfa.getTransitionLabels(i).nextSetBit(j + 1);
            }
        }
        return rv.toString();
    }
}

