/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.spec.numeric;

import edu.umn.cs.melt.copper.compiletime.auxiliary.SymbolTable;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CopperASTBean;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.PSSymbolTable;
import java.util.BitSet;

public class ContextSets {
    protected BitSet[] first;
    protected BitSet[] firstNTs;
    protected BitSet[] follow;
    protected boolean[] nullable;

    public final BitSet getFirst(int s) {
        return this.first[s];
    }

    public final BitSet getFirstNTs(int s) {
        return this.firstNTs[s];
    }

    public final BitSet getFollow(int s) {
        return this.follow[s];
    }

    public final boolean isNullable(int s) {
        return this.nullable[s];
    }

    public final void setNullable(int s, boolean n) {
        this.nullable[s] = n;
    }

    public ContextSets(int symbolCount) {
        this.first = new BitSet[symbolCount];
        this.firstNTs = new BitSet[symbolCount];
        this.follow = new BitSet[symbolCount];
        this.nullable = new boolean[symbolCount];
        for (int i = 0; i < symbolCount; ++i) {
            this.first[i] = new BitSet();
            this.firstNTs[i] = new BitSet();
            this.follow[i] = new BitSet();
        }
    }

    public String toString(SymbolTable<CopperASTBean> symbolTable) {
        StringBuffer rv = new StringBuffer();
        for (int i = 0; i < this.first.length; ++i) {
            rv.append("first(").append(symbolTable.get(i).getDisplayName()).append(") = ").append(PSSymbolTable.bitSetPrettyPrint(this.first[i], symbolTable, "  ", 80)).append("\n");
            rv.append("firstNTs(").append(symbolTable.get(i).getDisplayName()).append(") = ").append(PSSymbolTable.bitSetPrettyPrint(this.firstNTs[i], symbolTable, "  ", 80)).append("\n");
            rv.append("follow(" + symbolTable.get(i).getDisplayName() + ") = " + PSSymbolTable.bitSetPrettyPrint(this.follow[i], symbolTable, "  ", 80)).append("\n");
            rv.append(symbolTable.get(i).getDisplayName()).append(" is");
            if (!this.nullable[i]) {
                rv.append(" NOT");
            }
            rv.append(" nullable\n\n");
        }
        return rv.toString();
    }
}

