/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.runtime.engines.single;

import edu.umn.cs.melt.copper.runtime.auxiliary.internal.PrettyPrinter;
import edu.umn.cs.melt.copper.runtime.engines.CopperParser;
import edu.umn.cs.melt.copper.runtime.engines.CopperScanner;
import edu.umn.cs.melt.copper.runtime.engines.semantics.VirtualLocation;
import edu.umn.cs.melt.copper.runtime.engines.single.SingleDFAParseStackNode;
import edu.umn.cs.melt.copper.runtime.engines.single.scanner.SingleDFAMatchData;
import edu.umn.cs.melt.copper.runtime.io.CircleTokenBuffer;
import edu.umn.cs.melt.copper.runtime.io.InputPosition;
import edu.umn.cs.melt.copper.runtime.io.ScannerBuffer;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.Stack;

public abstract class SingleDFAEngine<ROOT, EXCEPT extends Exception>
implements CopperParser<ROOT, EXCEPT>,
CopperScanner<SingleDFAParseStackNode, SingleDFAMatchData, EXCEPT> {
    public static final int STATE_ERROR = 0;
    public static final int STATE_SHIFT = 1;
    public static final int STATE_GOTO = 1;
    public static final int STATE_REDUCE = 2;
    public static final int STATE_ACCEPT = 3;
    public static final int SYMBOL_TERMINAL = 0;
    public static final int SYMBOL_NONTERM = 1;
    public static final int SYMBOL_PRODUCTION = 2;
    public static final int TERMINAL_VERSATILE = 0;
    public static final int TERMINAL_EXCLUSIVELY_LAYOUT = 1;
    public static final int TERMINAL_EXCLUSIVELY_PREFIX = 2;
    public static final int TERMINAL_EXCLUSIVELY_SHIFTABLE = 4;
    public static final int TERMINAL_UNUSED = 7;
    protected Stack<SingleDFAParseStackNode> parseStack;
    protected VirtualLocation virtualLocation;
    protected SingleDFAParseStackNode currentState;
    protected SingleDFAMatchData scanResult;
    protected ScannerBuffer charBuffer;
    protected CircleTokenBuffer<SingleDFAMatchData> tokenBuffer;
    protected BitSet lastShiftable;
    protected InputPosition lastPosition;
    protected SingleDFAMatchData lastMatched;
    protected boolean functionalDisambiguationUsed;
    protected boolean lastMatchFromQueue;
    protected int lastAction;
    protected SingleDFAMatchData disjointMatch;

    public static int newSymbol(int symType, int index) {
        return (symType & 3) << 29 | index & 0x1FFFFFFF;
    }

    public static int newAction(int symType, int index) {
        return (symType & 3) << 29 | index & 0x1FFFFFFF;
    }

    public static int actionIndex(int action) {
        return action & 0x1FFFFFFF;
    }

    public static int actionType(int action) {
        return action >> 29 & 3;
    }

    public static BitSet newBitVec(int totalBits, int ... newBits) {
        BitSet rv = new BitSet(totalBits);
        SingleDFAEngine.setBits(rv, newBits);
        return rv;
    }

    public static void setBits(BitSet vec, int ... newBits) {
        for (int bit : newBits) {
            vec.set(bit);
        }
    }

    public String bitVecToString(BitSet vec) {
        return PrettyPrinter.bitSetPrettyPrint(vec, this.getSymbolDisplayNames(), "   ", 1);
    }

    public ArrayList<String> bitVecToRealStringList(BitSet vec) {
        ArrayList<String> stringList = new ArrayList<String>();
        int i = vec.nextSetBit(0);
        while (i >= 0) {
            stringList.add(this.getSymbolNames()[i]);
            i = vec.nextSetBit(i + 1);
        }
        return stringList;
    }

    public ArrayList<String> bitVecToDisplayStringList(BitSet vec) {
        ArrayList<String> stringList = new ArrayList<String>();
        int i = vec.nextSetBit(0);
        while (i >= 0) {
            stringList.add(this.getSymbolDisplayNames()[i]);
            i = vec.nextSetBit(i + 1);
        }
        return stringList;
    }

    public abstract int getTERMINAL_COUNT();

    public abstract int getGRAMMAR_SYMBOL_COUNT();

    public abstract int getSYMBOL_COUNT();

    public abstract int getPARSER_STATE_COUNT();

    public abstract int getSCANNER_STATE_COUNT();

    public abstract int getDISAMBIG_GROUP_COUNT();

    public abstract int getSCANNER_START_STATENUM();

    public abstract int getPARSER_START_STATENUM();

    public abstract int getEOF_SYMNUM();

    public abstract int getEPS_SYMNUM();

    public abstract String[] getSymbolNames();

    public abstract String[] getSymbolDisplayNames();

    public abstract int[] getSymbolNumbers();

    public abstract int[] getProductionLHSs();

    public abstract int[][] getParseTable();

    public abstract BitSet[] getShiftableSets();

    public abstract BitSet[] getLayoutSets();

    public abstract BitSet[] getPrefixSets();

    public abstract int[] getTerminalUses();

    public abstract BitSet[][] getLayoutMaps();

    public abstract BitSet[][] getPrefixMaps();

    public abstract BitSet[] getDisambiguationGroups();

    public abstract BitSet getShiftableUnion();

    public abstract BitSet[] getAcceptSets();

    public abstract BitSet[] getRejectSets();

    public abstract BitSet[] getPossibleSets();

    public abstract int[][] getDelta();

    public abstract int[] getCmap();

    protected static boolean cheq(char input, char single) {
        return input == single;
    }

    protected static boolean chin(char input, char min, char max) {
        return input >= min && input <= max;
    }

    protected abstract int transition(int var1, char var2);

    protected abstract int runDisambiguationAction(InputPosition var1, SingleDFAMatchData var2) throws IOException, EXCEPT;

    protected abstract Object runSemanticAction(InputPosition var1, Object[] var2, int var3) throws IOException, EXCEPT;

    protected abstract Object runSemanticAction(InputPosition var1, SingleDFAMatchData var2) throws IOException, EXCEPT;

    public void runPostParseCode(Object __root) throws IOException, EXCEPT {
    }

    @Override
    public ROOT parse(Reader input) throws IOException, EXCEPT {
        return this.parse(input, "<stdin>");
    }

    @Override
    public abstract ROOT parse(Reader var1, String var2) throws IOException, EXCEPT;

    @Override
    public ROOT parse(String text) throws IOException, EXCEPT {
        return this.parse(text, "<StringBuffer>");
    }

    @Override
    public ROOT parse(String text, String inputName) throws IOException, EXCEPT {
        StringReader reader = new StringReader(text);
        return this.parse(reader, inputName);
    }

    @Override
    public SingleDFAMatchData pullToken(SingleDFAParseStackNode currentState) throws EXCEPT {
        return null;
    }

    protected abstract String formatError(String var1);

    protected abstract void reportError(String var1) throws EXCEPT;

    protected abstract void reportSyntaxError() throws EXCEPT;

    protected SingleDFAMatchData layoutScan(boolean runDisjoint, SingleDFAMatchData previousResult) throws IOException, EXCEPT {
        SingleDFAMatchData finalMatches;
        BitSet shiftable = this.getShiftableSets()[this.currentState.statenum];
        InputPosition whence = runDisjoint ? (!previousResult.layouts.isEmpty() ? previousResult.layouts.getLast().followingPos : this.currentState.pos) : this.currentState.pos;
        this.charBuffer.advanceBufferTo(whence.getPos());
        if (!runDisjoint && whence.equals(this.lastPosition) && this.lastAction != 1) {
            if (this.lastMatchFromQueue) {
                this.lastShiftable = shiftable;
                return this.lastMatched;
            }
            if (this.lastMatched != null && !this.functionalDisambiguationUsed) {
                boolean partiallyDisjoint = false;
                BitSet diff = new BitSet();
                diff.or(this.lastMatched.terms);
                diff.andNot(shiftable);
                boolean bl = partiallyDisjoint = !diff.isEmpty();
                if (!partiallyDisjoint) {
                    this.lastShiftable = shiftable;
                    return this.lastMatched;
                }
            }
        }
        this.lastPosition = whence;
        this.lastShiftable = shiftable;
        this.functionalDisambiguationUsed = false;
        this.lastMatchFromQueue = false;
        LinkedList<SingleDFAMatchData> layouts = new LinkedList<SingleDFAMatchData>();
        block5: while (true) {
            finalMatches = this.maybeDisjointScan(whence, shiftable, layouts, runDisjoint);
            if (finalMatches.terms.cardinality() > 1) {
                if (finalMatches.terms.get(this.getEOF_SYMNUM()) && finalMatches.lexeme.isEmpty()) {
                    finalMatches.terms.clear();
                    finalMatches.terms.set(this.getEOF_SYMNUM());
                    finalMatches.firstTerm = this.getEOF_SYMNUM();
                } else {
                    this.functionalDisambiguationUsed = true;
                    int disambiguatedTerm = this.runDisambiguationAction(this.currentState.pos, finalMatches);
                    if (disambiguatedTerm == -1) {
                        int firstActionIndex = finalMatches.firstTerm;
                        int action = this.getParseTable()[this.currentState.statenum][firstActionIndex];
                        if (SingleDFAEngine.actionType(action) == 2) {
                            disambiguatedTerm = firstActionIndex;
                        }
                        int j = finalMatches.terms.nextSetBit(firstActionIndex + 1);
                        while (j >= 0) {
                            if (action != this.getParseTable()[this.currentState.statenum][j]) {
                                disambiguatedTerm = -1;
                                break;
                            }
                            j = finalMatches.terms.nextSetBit(j + 1);
                        }
                    }
                    if (disambiguatedTerm == -1) {
                        if (!runDisjoint) {
                            this.reportError(this.formatError("Lexical ambiguity between tokens:\n" + this.bitVecToString(finalMatches.terms)));
                            return finalMatches;
                        }
                    } else {
                        finalMatches.terms.clear();
                        finalMatches.terms.set(disambiguatedTerm);
                        finalMatches.firstTerm = disambiguatedTerm;
                    }
                }
                if (finalMatches.terms.cardinality() > 1) {
                    return finalMatches;
                }
            }
            if (finalMatches.terms.isEmpty() || runDisjoint && !shiftable.get(finalMatches.firstTerm)) break;
            int useAs = this.getTerminalUses()[finalMatches.firstTerm];
            if (useAs == 0) {
                useAs = this.getLayoutSets()[this.currentState.statenum].get(finalMatches.firstTerm) ? 1 : (this.getPrefixSets()[this.currentState.statenum].get(finalMatches.firstTerm) ? 2 : 4);
            }
            switch (useAs) {
                case 4: {
                    if (!finalMatches.terms.isEmpty()) {
                        this.lastMatched = finalMatches;
                    }
                    return finalMatches;
                }
                case 1: {
                    whence = InputPosition.advance(whence, finalMatches.lexeme.length(), finalMatches.lexeme);
                    if (finalMatches.lexeme.length() == 0) {
                        if (layouts.isEmpty()) {
                            layouts.add(finalMatches);
                        }
                        shiftable = (BitSet)shiftable.clone();
                        shiftable.andNot(this.getLayoutSets()[this.currentState.statenum]);
                        continue block5;
                    }
                    layouts.add(finalMatches);
                    continue block5;
                }
                case 2: {
                    layouts.add(finalMatches);
                    shiftable = this.getPrefixMaps()[this.currentState.statenum][finalMatches.firstTerm];
                    whence = InputPosition.advance(whence, finalMatches.lexeme.length(), finalMatches.lexeme);
                    continue block5;
                }
            }
            this.reportError(this.formatError("Cannot determine whether terminal is layout, prefix, or shiftable --- bug in scanner"));
        }
        if (!finalMatches.terms.isEmpty()) {
            this.lastMatched = finalMatches;
        }
        return finalMatches;
    }

    protected SingleDFAMatchData maybeDisjointScan(InputPosition whence, BitSet shiftable, LinkedList<SingleDFAMatchData> layouts, boolean runDisjoint) throws IOException {
        if (!runDisjoint) {
            return this.simpleScan(whence, shiftable, layouts);
        }
        return this.simpleScan(whence, this.getShiftableUnion(), layouts);
    }

    protected SingleDFAMatchData simpleScan(InputPosition whence, BitSet shiftable, LinkedList<SingleDFAMatchData> layouts) throws IOException {
        if (!this.tokenBuffer.isEmpty()) {
            SingleDFAMatchData tok = this.tokenBuffer.poll();
            tok.precedingPos = whence;
            tok.followingPos = whence;
            this.lastMatchFromQueue = true;
            return tok;
        }
        int currentState = this.getSCANNER_START_STATENUM();
        char symbol = '\u0000';
        BitSet shiftableS = (BitSet)shiftable.clone();
        BitSet present = SingleDFAEngine.newBitVec(this.getTERMINAL_COUNT(), new int[0]);
        InputPosition presentPos = whence;
        InputPosition p = InputPosition.copy(whence);
        while (true) {
            BitSet tP = (BitSet)this.getPossibleSets()[currentState].clone();
            tP.and(shiftableS);
            if (p.equals(whence) && shiftableS.get(this.getEOF_SYMNUM())) {
                tP.set(this.getEOF_SYMNUM());
            }
            if (tP.isEmpty()) break;
            shiftableS.and(tP);
            BitSet tA = (BitSet)this.getAcceptSets()[currentState].clone();
            tA.and(shiftableS);
            if (!tA.isEmpty()) {
                present = tA;
                presentPos = InputPosition.copy(p);
            } else {
                BitSet tR = (BitSet)this.getRejectSets()[currentState].clone();
                tR.and(shiftableS);
                if (!tR.isEmpty()) {
                    present.clear();
                    presentPos = whence;
                }
            }
            symbol = this.charBuffer.charAt(p.getPos());
            if (symbol == ScannerBuffer.EOFIndicator) break;
            currentState = this.transition(currentState, symbol);
            p = InputPosition.advance(p, symbol);
        }
        if (symbol == ScannerBuffer.EOFIndicator && p.equals(whence) && shiftableS.get(this.getEOF_SYMNUM())) {
            present.set(this.getEOF_SYMNUM());
            return new SingleDFAMatchData(present, whence, p, "", layouts);
        }
        return new SingleDFAMatchData(present, whence, presentPos, this.charBuffer.readStringFromBuffer(whence.getPos(), presentPos.getPos()), layouts);
    }

    protected void startEngine(InputPosition initialPos) throws IOException, EXCEPT {
        this.parseStack = new Stack();
        this.parseStack.push(new SingleDFAParseStackNode(this.getPARSER_START_STATENUM(), initialPos, null));
        this.tokenBuffer = new CircleTokenBuffer();
        this.virtualLocation = new VirtualLocation(initialPos.getFileName(), 1, 0);
        this.currentState = null;
        this.disjointMatch = null;
        this.functionalDisambiguationUsed = false;
        this.lastAction = 1;
        this.lastMatchFromQueue = false;
        this.lastPosition = null;
        this.lastMatched = null;
        this.lastShiftable = null;
        this.scanResult = null;
    }

    protected Object runEngine() throws IOException, EXCEPT {
        while (true) {
            this.currentState = this.parseStack.peek();
            SingleDFAMatchData scanResult = this.layoutScan(false, null);
            if (scanResult.terms.isEmpty()) {
                this.disjointMatch = this.layoutScan(true, scanResult);
                for (SingleDFAMatchData layout : scanResult.layouts) {
                    this.runSemanticAction(layout.precedingPos, layout);
                    this.virtualLocation.defaultUpdateAutomatic(layout.lexeme);
                }
                this.parseStack.push(new SingleDFAParseStackNode(this.currentState.statenum, scanResult.followingPos, null));
                this.currentState = this.parseStack.peek();
                this.reportSyntaxError();
                this.parseStack.pop();
                this.currentState = this.parseStack.peek();
            } else if (scanResult.terms.cardinality() > 1) {
                throw new RuntimeException("Ambiguous match: " + this.bitVecToDisplayStringList(scanResult.terms));
            }
            int action = this.getParseTable()[this.currentState.statenum][scanResult.firstTerm];
            switch (SingleDFAEngine.actionType(action)) {
                case 3: {
                    for (SingleDFAMatchData layout : scanResult.layouts) {
                        this.runSemanticAction(layout.precedingPos, layout);
                        this.virtualLocation.defaultUpdateAutomatic(layout.lexeme);
                    }
                    return this.parseStack.peek().synthAttr;
                }
                case 1: {
                    int nextState = SingleDFAEngine.actionIndex(action);
                    for (SingleDFAMatchData layout : scanResult.layouts) {
                        this.runSemanticAction(layout.precedingPos, layout);
                        this.virtualLocation.defaultUpdateAutomatic(layout.lexeme);
                    }
                    Object synthAttr = this.runSemanticAction(scanResult.precedingPos, scanResult);
                    this.virtualLocation.defaultUpdateAutomatic(scanResult.lexeme);
                    this.parseStack.push(new SingleDFAParseStackNode(nextState, scanResult.followingPos, synthAttr));
                    break;
                }
                case 2: {
                    int production = SingleDFAEngine.actionIndex(action);
                    int productionLength = SingleDFAEngine.actionIndex(this.getSymbolNumbers()[production]);
                    int productionLHS = SingleDFAEngine.actionIndex(this.getProductionLHSs()[production - this.getGRAMMAR_SYMBOL_COUNT()]);
                    Object[] children = new Object[productionLength];
                    for (int i = productionLength - 1; i >= 0; --i) {
                        children[i] = this.parseStack.pop().synthAttr;
                    }
                    int gotoState = SingleDFAEngine.actionIndex(this.getParseTable()[this.parseStack.peek().statenum][productionLHS]);
                    Object synthAttr = this.runSemanticAction(this.currentState.pos, children, production);
                    this.parseStack.push(new SingleDFAParseStackNode(gotoState, this.currentState.pos, synthAttr));
                    break;
                }
                default: {
                    this.disjointMatch = scanResult;
                    this.reportSyntaxError();
                }
            }
            this.lastAction = SingleDFAEngine.actionType(action);
        }
    }
}

