/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.CMDContextVisualization;
import common.DecoratedNode;
import common.Lazy;
import common.Node;
import common.RTTIManager;
import common.TopNode;
import common.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.Stack;

public class Debug {
    private DecoratedNode root;
    private DecoratedNode currentNode;
    private Stack<DecoratedNode> nodeStack;
    HashMap<Integer, StringObjectPair> currentNodeSynthAttrs;
    HashMap<Integer, StringObjectPair> currentNodeInhAttrs;
    HashMap<Integer, StringObjectPair> currentNodeLocalAttrs;
    private int currentLine;
    private int currentColumn;

    public static DecoratedNode runDebug(DecoratedNode tree) {
        Debug debug = new Debug();
        debug.runingDebug(tree);
        return tree;
    }

    /*
     * Unable to fully structure code
     */
    public void runingDebug(DecoratedNode tree) {
        inp = new Scanner(System.in);
        System.out.println("Enter characters, and 'q' to quit.");
        toggleProdDisplay = true;
        toggleCStackDisplay = true;
        toggleHeadlessAttributes = false;
        this.root = tree;
        this.currentNode = tree;
        this.nodeStack = new Stack<E>();
        if (toggleProdDisplay) {
            this.printProduction(this.currentNode);
        }
        cStack = new CMDContextVisualization("********************************");
        cStack.push(this.currentNode);
        if (toggleCStackDisplay) {
            cStack.show();
        }
        block47: while (true) {
            System.out.print(">DEBUGGER-PROMPT$");
            userInput = inp.nextLine();
            userInputList = userInput.split(" ");
            var10_10 = userInputList[0];
            var11_11 = -1;
            switch (var10_10.hashCode()) {
                case 3739: {
                    if (!var10_10.equals("up")) break;
                    var11_11 = 0;
                    break;
                }
                case 117: {
                    if (!var10_10.equals("u")) break;
                    var11_11 = 1;
                    break;
                }
                case 3089570: {
                    if (!var10_10.equals("down")) break;
                    var11_11 = 2;
                    break;
                }
                case 100: {
                    if (!var10_10.equals("d")) break;
                    var11_11 = 3;
                    break;
                }
                case 3594468: {
                    if (!var10_10.equals("undo")) break;
                    var11_11 = 4;
                    break;
                }
                case 483313230: {
                    if (!var10_10.equals("forwards")) break;
                    var11_11 = 5;
                    break;
                }
                case 3237472: {
                    if (!var10_10.equals("into")) break;
                    var11_11 = 6;
                    break;
                }
                case 1354491076: {
                    if (!var10_10.equals("backtrack")) break;
                    var11_11 = 7;
                    break;
                }
                case -868304044: {
                    if (!var10_10.equals("toggle")) break;
                    var11_11 = 8;
                    break;
                }
                case 3449687: {
                    if (!var10_10.equals("prod")) break;
                    var11_11 = 9;
                    break;
                }
                case 3244: {
                    if (!var10_10.equals("eq")) break;
                    var11_11 = 10;
                    break;
                }
                case -1235006146: {
                    if (!var10_10.equals("listSynth")) break;
                    var11_11 = 11;
                    break;
                }
                case -1244575278: {
                    if (!var10_10.equals("listInher")) break;
                    var11_11 = 12;
                    break;
                }
                case 3322014: {
                    if (!var10_10.equals("list")) break;
                    var11_11 = 13;
                    break;
                }
                case 108: {
                    if (!var10_10.equals("l")) break;
                    var11_11 = 14;
                    break;
                }
                case 3619493: {
                    if (!var10_10.equals("view")) break;
                    var11_11 = 15;
                    break;
                }
                case 118: {
                    if (!var10_10.equals("v")) break;
                    var11_11 = 16;
                    break;
                }
                case 103145323: {
                    if (!var10_10.equals("local")) break;
                    var11_11 = 17;
                    break;
                }
                case 3198785: {
                    if (!var10_10.equals("help")) break;
                    var11_11 = 18;
                    break;
                }
                case 3127582: {
                    if (!var10_10.equals("exit")) break;
                    var11_11 = 19;
                    break;
                }
                case 113: {
                    if (!var10_10.equals("q")) break;
                    var11_11 = 20;
                    break;
                }
                case 3482191: {
                    if (!var10_10.equals("quit")) break;
                    var11_11 = 21;
                }
            }
            switch (var11_11) {
                case 0: 
                case 1: {
                    if (userInputList.length != 1) {
                        System.out.println("invalid, correct usage: up<>");
                        break;
                    }
                    if (this.currentNode.getParent().getParent() instanceof TopNode || this.currentNode.getParent() == null) {
                        System.out.println("Root Node has no parent");
                        break;
                    }
                    if (this.currentNode.getParent() == null) {
                        System.out.println("Null parent");
                        break;
                    }
                    this.nodeStack.push(this.currentNode);
                    this.currentNode = this.currentNode.getParent();
                    if (toggleProdDisplay) {
                        this.printProduction(this.currentNode);
                    }
                    cStack.pop();
                    if (!toggleCStackDisplay) continue block47;
                    cStack.show();
                    break;
                }
                case 2: 
                case 3: {
                    childNum = -1;
                    if (userInputList.length != 1) ** GOTO lbl139
                    System.out.println("Which child?");
                    this.printChildren(this.currentNode);
                    childNum = Debug.inputInt(inp);
                    if (childNum == -1) {
                        break;
                    }
                    ** GOTO lbl148
lbl139:
                    // 1 sources

                    if (userInputList.length != 2) ** GOTO lbl146
                    try {
                        childNum = Integer.parseInt(userInputList[1]);
                        ** GOTO lbl148
                    }
                    catch (NumberFormatException e) {
                        System.out.println("invalid, correct usage: down <node #>");
                        break;
                    }
lbl146:
                    // 1 sources

                    System.out.println("invalid, correct usage: down <node #>");
                    break;
lbl148:
                    // 2 sources

                    if ((childNode = this.down(childNum)) == null) {
                        System.out.println("invalid child number");
                        break;
                    }
                    this.nodeStack.push(this.currentNode);
                    this.currentNode = childNode;
                    if (toggleProdDisplay) {
                        this.printProduction(this.currentNode);
                    }
                    cStack.push(this.currentNode);
                    if (!toggleCStackDisplay) continue block47;
                    cStack.show();
                    break;
                }
                case 4: {
                    if (userInputList.length != 1) {
                        System.out.println("invalid, correct usage: undo<>");
                        break;
                    }
                    if (this.nodeStack.empty()) {
                        System.out.println("invalid no node to undo");
                        break;
                    }
                    this.currentNode = newNode = this.nodeStack.pop();
                    if (toggleProdDisplay) {
                        this.printProduction(this.currentNode);
                    }
                    cStack.pop();
                    if (!toggleCStackDisplay) continue block47;
                    cStack.show();
                    break;
                }
                case 5: {
                    if (userInputList.length != 1) {
                        System.out.println("invalid, correct usage: forwards<>");
                        break;
                    }
                    childNode = this.forwards(this.currentNode);
                    if (childNode == null) {
                        System.out.println("invalid no node to forward");
                        break;
                    }
                    System.out.println("going forward");
                    this.currentNode = childNode;
                    if (toggleProdDisplay) {
                        this.printProduction(this.currentNode);
                    }
                    cStack.push(this.currentNode);
                    if (!toggleCStackDisplay) continue block47;
                    cStack.show();
                    break;
                }
                case 6: {
                    if (userInputList.length != 2) {
                        System.out.println("invalid, correct usage: forwards <attribute>");
                        break;
                    }
                    childNode = this.into(this.currentNode, userInputList[1]);
                    if (childNode == null) {
                        System.out.println("invalid input");
                        break;
                    }
                    System.out.println("going inot");
                    this.currentNode = childNode;
                    break;
                }
                case 7: {
                    if (userInputList.length != 1) {
                        System.out.println("invalid, correct usage: backtrack<>");
                        break;
                    }
                    childNode = this.backtrack(this.currentNode);
                    if (childNode == null) {
                        System.out.println("invalid no node to backtrack to");
                        break;
                    }
                    System.out.println("going backwrds");
                    this.currentNode = childNode;
                    if (toggleProdDisplay) {
                        this.printProduction(this.currentNode);
                    }
                    cStack.push(this.currentNode);
                    if (!toggleCStackDisplay) continue block47;
                    cStack.show();
                    break;
                }
                case 8: {
                    if (userInputList.length != 2) {
                        System.out.println("please indicate what you want to toggle ex: 'toggle prodDisplay'");
                        break;
                    }
                    if (userInputList[1].equals("prodDisplay")) {
                        if (toggleProdDisplay) {
                            System.out.println("Production Display off");
                            toggleProdDisplay = false;
                        } else {
                            System.out.println("Production Display on");
                            toggleProdDisplay = true;
                        }
                    }
                    if (userInputList[1].equals("fullAttributeNames")) {
                        if (toggleHeadlessAttributes) {
                            System.out.println("Headless Attributes off");
                            toggleHeadlessAttributes = false;
                        } else {
                            System.out.println("Headless Attributes on");
                            toggleHeadlessAttributes = true;
                        }
                    }
                    if (userInputList[1].equals("cStackDisplay")) {
                        if (toggleCStackDisplay) {
                            System.out.println("cStack Display off");
                            toggleCStackDisplay = false;
                            break;
                        }
                        System.out.println("cStack Display on");
                        toggleCStackDisplay = true;
                        break;
                    }
                    System.out.println("legal toggles: prodDisplay, fullAttributeNames");
                    break;
                }
                case 9: {
                    if (userInputList.length != 1) {
                        System.out.println("invalid, correct usage: prod<>");
                        break;
                    }
                    this.printProduction(this.currentNode);
                    break;
                }
                case 10: {
                    if (userInputList.length != 1 && userInputList.length != 2) {
                        System.out.println("invalid, correct usage: eq<attr?>");
                        break;
                    }
                    System.out.println("do the eq stuff");
                    break;
                }
                case 11: {
                    if (userInputList.length != 1 && userInputList.length != 2) {
                        System.out.println("invalid, correct usage: listSynth<node?>");
                        break;
                    }
                    if (this.listSynth(this.currentNode) != 0) continue block47;
                    System.out.println("no synthesized attributes");
                    break;
                }
                case 12: {
                    if (userInputList.length != 1 && userInputList.length != 2) {
                        System.out.println("invalid, correct usage: listInher<node?>");
                        break;
                    }
                    if (this.listInher(this.currentNode) != 0) continue block47;
                    System.out.println("no inherited attributes");
                    break;
                }
                case 13: 
                case 14: {
                    if (userInputList.length != 1 && userInputList.length != 2) {
                        System.out.println("invalid, correct usage: list<node?>");
                        break;
                    }
                    this.printAttributes(this.currentNode, toggleHeadlessAttributes);
                    break;
                }
                case 15: 
                case 16: {
                    attributeName = "";
                    attributeNum = 0;
                    attributeList = Debug.allAttributesList(this.currentNode);
                    if (userInputList.length != 1) ** GOTO lbl292
                    System.out.println("Which attribute?");
                    this.printAttributes(this.currentNode, toggleHeadlessAttributes);
                    attributeNum = Debug.inputInt(inp);
                    if (attributeNum == -1) continue block47;
                    if (attributeNum >= attributeList.size()) {
                        System.out.println("Invaild attribute number");
                        break;
                    }
                    attributeName = attributeList.get(attributeNum);
                    ** GOTO lbl305
lbl292:
                    // 1 sources

                    if (userInputList.length != 2) ** GOTO lbl303
                    try {
                        attributeNum = Integer.parseInt(userInputList[1]);
                        attributeName = attributeList.get(attributeNum);
                        ** GOTO lbl305
                    }
                    catch (NumberFormatException e) {
                        System.out.println("invalid, correct usage: view <node #>");
                        break;
                    }
                    catch (IndexOutOfBoundsException e) {
                        System.out.println("Index out of bounds");
                        break;
                    }
lbl303:
                    // 1 sources

                    System.out.println("invalid, correct usage: down <node #>");
                    break;
lbl305:
                    // 2 sources

                    this.printAttrFromName(this.currentNode, attributeName);
                    break;
                }
                case 17: {
                    Debug.listLocalAttrs(this.currentNode);
                    break;
                }
                case 18: {
                    System.out.println("up");
                    System.out.println("down <node>");
                    System.out.println("view <attr>");
                    System.out.println("forwards");
                    System.out.println("backtrack");
                    System.out.println("prod");
                    System.out.println("eq");
                    System.out.println("listSynth");
                    System.out.println("listInher");
                    System.out.println("list");
                    System.out.println("exit");
                    break;
                }
                case 19: 
                case 20: 
                case 21: {
                    System.out.println("debugger out");
                    break block47;
                }
                default: {
                    System.out.println("invalid input call help for legal inputs");
                    System.out.println(userInput);
                }
            }
        }
    }

    public void setCurrentNode(DecoratedNode node) {
        this.currentNodeSynthAttrs = null;
        this.currentNodeInhAttrs = null;
        this.currentNodeLocalAttrs = null;
        this.currentNode = node;
    }

    public DecoratedNode up() {
        if (this.currentNode.getParent() != null) {
            this.currentNode = this.currentNode.getParent();
            return this.currentNode;
        }
        return null;
    }

    public DecoratedNode down(int child) {
        String[] child_productions = this.currentNode.undecorate().getProdleton().getChildTypes();
        try {
            System.out.println("null name: " + child_productions[child]);
            if (child_productions[child].equals("null")) {
                return null;
            }
            DecoratedNode childNode = this.currentNode.childDecorated(child);
            return childNode;
        }
        catch (NullPointerException e) {
            System.out.println("Null pointer");
            return null;
        }
        catch (IndexOutOfBoundsException e) {
            System.out.println("Index out of bound");
            return null;
        }
    }

    public static int inputInt(Scanner inp) {
        boolean continueLoop = true;
        int returnInt = -1;
        String stopper = "";
        while (continueLoop) {
            System.out.print(">DEBUGGER-PROMPT$");
            if (inp.hasNextInt()) {
                returnInt = inp.nextInt();
                inp.nextLine();
                continueLoop = false;
                continue;
            }
            stopper = inp.nextLine();
            if (stopper.equals("e")) {
                continueLoop = false;
                continue;
            }
            System.out.println("Please choose an integer or e to exit");
        }
        return returnInt;
    }

    public void printChildren(DecoratedNode node) {
        String[] child_productions = node.undecorate().getProdleton().getChildTypes();
        for (int i = 0; i < child_productions.length; ++i) {
            System.out.println(Integer.toString(i) + ": " + child_productions[i] + " ");
        }
    }

    public DecoratedNode forwards(DecoratedNode node) {
        if (node.getNode().hasForward()) {
            this.currentNode = node.forward();
            return this.currentNode;
        }
        return null;
    }

    public DecoratedNode backtrack(DecoratedNode node) {
        this.currentNode = node.getForwardParent();
        return this.currentNode;
    }

    public void printProduction(DecoratedNode node) {
        String partent_production = node.undecorate().getProdleton().getTypeUnparse();
        String[] child_productions = node.undecorate().getProdleton().getChildTypes();
        System.out.print(partent_production + " ");
        for (int i = 0; i < child_productions.length; ++i) {
            System.out.print(child_productions[i] + " ");
        }
        System.out.print("\n");
    }

    public void eqSynth(int attribute) {
    }

    public void eqInher(int attribute) {
    }

    public int listSynth(DecoratedNode node) {
        RTTIManager.Prodleton<? extends Node> prodleton = node.getNode().getProdleton();
        RTTIManager.Nonterminalton<? extends Node> nonterminalton = prodleton.getNonterminalton();
        Set<String> synAttrSet = nonterminalton.getAllSynth();
        int num_attr = 0;
        for (String synAttr : synAttrSet) {
            System.out.println("Attribute = " + synAttr);
            ++num_attr;
        }
        return num_attr;
    }

    public int listInher(DecoratedNode node) {
        RTTIManager.Prodleton<? extends Node> prodleton = node.getNode().getProdleton();
        RTTIManager.Nonterminalton<? extends Node> nonterminalton = prodleton.getNonterminalton();
        Set<String> inhAttrSet = nonterminalton.getAllInh();
        int num_attr = 0;
        for (String inhAttr : inhAttrSet) {
            System.out.println("Attribute = " + inhAttr);
            ++num_attr;
        }
        return num_attr;
    }

    public void printAttributes(DecoratedNode node, boolean toggleHeadlessAttributes) {
        List<String> attributeList = Debug.allAttributesList(node);
        if (toggleHeadlessAttributes) {
            attributeList = this.removeHeaders(Debug.allAttributesList(node));
        }
        int i = 0;
        for (String attribute : attributeList) {
            System.out.println(Integer.toString(i) + ": " + attribute);
            ++i;
        }
    }

    public List<String> removeHeaders(List<String> stringList) {
        ArrayList<String> headlessList = new ArrayList<String>();
        for (String element : stringList) {
            int lastIndex = element.lastIndexOf(":");
            if (lastIndex == -1) {
                headlessList.add(element);
                continue;
            }
            headlessList.add(element.substring(lastIndex + 1));
        }
        return headlessList;
    }

    public void printAttrFromName(DecoratedNode node, String printAttribute) {
        Map<String, Object> attributeMap = Debug.allAttributesObjectMap(node);
        System.out.println(Util.genericShow(attributeMap.get(printAttribute)));
    }

    public static List<String> listLocalAttrs(DecoratedNode node) {
        int count = node.getNode().getNumberOfLocalAttrs();
        ArrayList<String> listLocals = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            Lazy attribute = node.getNode().getLocal(i);
            Object o = attribute.eval(node);
            listLocals.add(node.getNode().getNameOfLocalAttr(i));
        }
        return listLocals;
    }

    public DecoratedNode into(DecoratedNode node, String attriburteName) {
        Map<String, Object> attributeMap = Debug.allAttributesObjectMap(node);
        if (attributeMap.containsKey(attriburteName)) {
            System.out.println("In into function");
            Object attributeObject = attributeMap.get(attriburteName);
            return (DecoratedNode)attributeObject;
        }
        return null;
    }

    public static List<String> allAttributesList(DecoratedNode node) {
        RTTIManager.Prodleton<? extends Node> prodleton = node.getNode().getProdleton();
        RTTIManager.Nonterminalton<? extends Node> nonterminalton = prodleton.getNonterminalton();
        List<String> attributeList = nonterminalton.alphabeticalAttributes();
        List<String> localAttributeList = Debug.listLocalAttrs(node);
        attributeList.addAll(localAttributeList);
        attributeList.sort(null);
        return attributeList;
    }

    public static Map<String, Object> allAttributesObjectMap(DecoratedNode node) {
        List<String> attributeList = Debug.allAttributesList(node);
        RTTIManager.Prodleton<? extends Node> prodleton = node.getNode().getProdleton();
        RTTIManager.Nonterminalton<? extends Node> nonterminalton = prodleton.getNonterminalton();
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        for (String attribute : attributeList) {
            Integer index;
            if (nonterminalton.getSynOccursIndices().keySet().contains(attribute)) {
                index = nonterminalton.getSynOccursIndex(attribute);
                Lazy synthAttribute = node.getNode().getSynthesized(index);
                Object o = synthAttribute.eval(node);
                attributeMap.put(attribute, o);
                continue;
            }
            if (nonterminalton.getInhOccursIndices().keySet().contains(attribute)) {
                index = nonterminalton.getInhOccursIndex(attribute);
                Object o = node.evalInhSomehowButPublic(index);
                attributeMap.put(attribute, o);
                continue;
            }
            List<String> listLocals = Debug.listLocalAttrs(node);
            Integer index2 = listLocals.indexOf(attribute);
            Lazy localAttribute = node.getNode().getLocal(index2);
            Object o = localAttribute.eval(node);
            attributeMap.put(attribute, o);
        }
        return attributeMap;
    }

    public boolean isContractum(DecoratedNode node) {
        return node.getNode().hasForward();
    }

    public static class StringObjectPair {
        private String stringValue;
        private Object objectValue;

        public StringObjectPair(String stringValue, Object objectValue) {
            this.stringValue = stringValue;
            this.objectValue = objectValue;
        }

        public String getString() {
            return this.stringValue;
        }

        public Object getObject() {
            return this.objectValue;
        }
    }
}

