/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.DecoratedNode;
import common.FileCoordinate;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class NodeContextMessage {
    private boolean has_been_initialized = false;
    private int num_index;
    private int translation_x;
    private int higher_order_y;
    private String text_repr;
    private String prod_name;
    private String filename;
    private FileCoordinate fc_start;
    private FileCoordinate fc_end;
    private boolean is_redex;
    private boolean is_contractum;
    private int contractum_of;
    private boolean is_new;
    private boolean is_attribute_root;
    private int attribute_of;

    public String GetSection0() {
        return Integer.toString(this.num_index);
    }

    public String GetSection1() {
        String res = "";
        boolean first_set = false;
        if (this.translation_x > 0) {
            res = res + "TRANSLATION-" + this.translation_x;
            first_set = true;
        }
        if (this.higher_order_y > 0) {
            if (first_set) {
                res = res + " & ";
            }
            res = res + "HIGHER-ORDER-" + this.higher_order_y;
        }
        return res;
    }

    public String GetSection2() {
        return this.text_repr;
    }

    public String GetSection3() {
        String res = "prod: " + this.prod_name + "\n" + this.filename + " lines: " + this.fc_start.getRow() + ":" + this.fc_start.getCol() + " -> " + this.fc_end.getRow() + ":" + this.fc_end.getCol();
        return res;
    }

    public String GetSection4() {
        String res = "";
        if (this.is_redex) {
            res = res + "*is-redex\n";
        }
        if (this.is_contractum) {
            res = res + "*is-contractum of " + this.contractum_of + "\n";
        }
        if (this.is_new) {
            res = res + "*is-new\n";
        }
        if (this.is_attribute_root) {
            res = res + "*is-attribute_root\n";
        }
        return res;
    }

    public NodeContextMessage(DecoratedNode node, int num_index) {
        this.num_index = num_index;
        this.prod_name = node.getNode().getName();
        this.fill_in_rows_and_cols(node);
        this.set_labels(node);
        this.initialize_headers(node);
        if (this.translation_x > 0 || this.higher_order_y > 0 || this.is_attribute_root || this.is_contractum || this.is_new) {
            this.pretty_print(node);
        } else {
            this.pull_filelines();
        }
        this.has_been_initialized = true;
    }

    private void initialize_headers(DecoratedNode node) {
        this.translation_x = node.getIsTranslation();
        this.higher_order_y = node.getIsAttribute();
    }

    private void fill_in_rows_and_cols(DecoratedNode node) {
        this.fc_start = node.getStartCoordinates();
        this.fc_end = node.getEndCoordinates();
        this.filename = node.getFilename();
    }

    private void set_labels(DecoratedNode node) {
        this.is_redex = node.getIsRedex();
        this.is_contractum = node.getIsContractum();
        this.contractum_of = this.num_index - 1;
        this.is_new = node.getIsNew();
        this.is_attribute_root = node.getIsAttributeRoot();
        this.attribute_of = this.num_index - 1;
    }

    private void pretty_print(DecoratedNode node) {
        this.text_repr = node.getPrettyPrint();
    }

    private void pull_filelines() {
        try (BufferedReader br = new BufferedReader(new FileReader(this.filename));){
            int row;
            int col = 1;
            String res = "";
            for (row = 1; row < this.fc_start.getRow(); ++row) {
                String string = br.readLine();
            }
            while (col < this.fc_start.getCol()) {
                int n = br.read();
                ++col;
            }
            while (row < this.fc_end.getRow()) {
                res = res + br.readLine();
                res = res + '\n';
                ++row;
            }
            while (col <= this.fc_end.getCol()) {
                char c = (char)br.read();
                res = res + Character.toString(c);
                ++col;
            }
            br.close();
            this.text_repr = res;
        }
        catch (IOException e) {
            System.out.println("ERROR READING FROM FILE " + this.filename);
            e.printStackTrace();
        }
    }

    public String toString() {
        return this.GetSection0() + "\n" + this.GetSection1() + "\n" + this.GetSection2() + "\n" + this.GetSection3() + "\n" + this.GetSection4();
    }
}

