/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.logging.messages;

import edu.umn.cs.melt.copper.compiletime.auxiliary.SymbolTable;
import edu.umn.cs.melt.copper.compiletime.logging.CompilerLevel;
import edu.umn.cs.melt.copper.compiletime.logging.CompilerLogMessage;
import edu.umn.cs.melt.copper.compiletime.parsetable.LRParseTable;
import edu.umn.cs.melt.copper.compiletime.parsetable.LRParseTableConflict;
import edu.umn.cs.melt.copper.compiletime.parsetable.LRParseTablePrinter;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CopperASTBean;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.ParserSpec;
import edu.umn.cs.melt.copper.runtime.auxiliary.internal.PrettyPrinter;
import java.util.BitSet;

public class ParseTableConflictMessage
implements CompilerLogMessage {
    private SymbolTable<CopperASTBean> symbolTable;
    private ParserSpec spec;
    private LRParseTableConflict conflict;
    private byte resolvedActionType;
    private int resolvedActionParameter;

    public ParseTableConflictMessage(SymbolTable<CopperASTBean> symbolTable, ParserSpec spec, LRParseTable parseTable, LRParseTableConflict conflict) {
        this.symbolTable = symbolTable;
        this.spec = spec;
        this.conflict = conflict;
        this.resolvedActionType = parseTable.getActionType(conflict.getState(), conflict.getSymbol());
        this.resolvedActionParameter = parseTable.getActionParameter(conflict.getState(), conflict.getSymbol());
    }

    @Override
    public CompilerLevel getLevel() {
        if (this.resolvedActionType == 3) {
            return CompilerLevel.QUIET;
        }
        return CompilerLevel.VERBOSE;
    }

    @Override
    public int getType() {
        return 5;
    }

    public boolean isResolved() {
        return this.resolvedActionType == 3;
    }

    @Override
    public boolean isError() {
        return this.isResolved();
    }

    @Override
    public boolean isFatalError() {
        return false;
    }

    @Override
    public String toString() {
        StringBuffer rv = new StringBuffer();
        if (!this.isResolved()) {
            rv.append("P");
        } else {
            rv.append("Unresolvable p");
        }
        rv.append("arse table conflict at ").append("parser state ").append(this.conflict.getState()).append(", on terminal ").append(this.symbolTable.get(this.conflict.getSymbol()).getDisplayName()).append(":\n");
        String[] actions = new String[(this.conflict.shift != -1 ? 1 : 0) + this.conflict.reduce.cardinality()];
        int i = 0;
        if (this.conflict.shift != -1) {
            actions[i++] = LRParseTablePrinter.printAction(this.symbolTable, this.spec, this.conflict.getState(), this.conflict.getSymbol(), (byte)1, this.conflict.shift);
        }
        int k = this.conflict.reduce.nextSetBit(0);
        while (k >= 0) {
            actions[i++] = LRParseTablePrinter.printAction(this.symbolTable, this.spec, this.conflict.getState(), this.conflict.getSymbol(), (byte)2, k);
            k = this.conflict.reduce.nextSetBit(k + 1);
        }
        BitSet allActions = new BitSet();
        allActions.set(0, actions.length);
        rv.append(PrettyPrinter.bitSetPrettyPrint(allActions, actions, "  ", 1));
        if (this.resolvedActionType == 0) {
            rv.append("\n  Resolved in favor of an error action.");
        } else if (this.resolvedActionType != 3) {
            rv.append("\n  Resolved in favor of " + LRParseTablePrinter.printAction(this.symbolTable, this.spec, this.conflict.getState(), this.conflict.getSymbol(), this.resolvedActionType, this.resolvedActionParameter));
        }
        return rv.toString();
    }
}

