/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.runtime.auxiliary.internal;

import java.util.regex.Pattern;

public class QuotedStringFormatter {
    private static Pattern javaWhitespace = Pattern.compile("[ \t\n]*");

    public static String formatOutputLexeme(String lexeme) {
        String rv = lexeme;
        rv = rv.replaceAll("\\\\", "\\\\\\\\");
        rv = rv.replaceAll("\\n", "\\\\\\\\n");
        rv = rv.replaceAll("\\r", "\\\\\\\\r");
        rv = rv.replaceAll("\\\"", "\\\\\\\"");
        return rv;
    }

    public static String formatQuotedString(String q) {
        String rv = q;
        rv = rv.replaceAll("\\\\", "\\\\\\\\");
        rv = rv.replaceAll("\\t", "\\\\\\\\t");
        rv = rv.replaceAll("\\n", "\\\\\\\\n");
        rv = rv.replaceAll("\\r", "\\\\\\\\r");
        rv = rv.replaceAll("\\\"", "\\\\\\\"");
        rv = rv.replaceAll("   ", " \\\\\\\\s ");
        return rv;
    }

    public static char getRepresentedCharacter(String quoted) {
        if (quoted.equals("\\n")) {
            return '\n';
        }
        if (quoted.equals("\\r")) {
            return '\r';
        }
        if (quoted.equals("\\t")) {
            return '\t';
        }
        if (quoted.equals("\\s")) {
            return ' ';
        }
        return quoted.charAt(1);
    }

    public static String quoteChar(char q) {
        switch (q) {
            case '\r': {
                return "\\r";
            }
            case '\n': {
                return "\\n";
            }
            case '\t': {
                return "\\t";
            }
            case '\"': 
            case '\'': 
            case '\\': {
                return "\\" + q;
            }
        }
        return String.valueOf(q);
    }

    public static boolean isJavaWhitespace(String str) {
        return javaWhitespace.matcher(str).matches();
    }
}

