/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.ContextStack;
import common.DecoratedNode;
import common.FileContextVisualization;
import common.Lazy;
import common.Node;
import common.RTTIManager;
import common.SimplifiedContextStack;
import common.Thunk;
import common.Util;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.Stack;
import silver.core.Init;
import silver.core.NLocation;

public class Debug {
    private DecoratedNode root;
    private DecoratedNode currentNode;
    private Stack<DecoratedNode> nodeStack;
    private FileContextVisualization cStack;
    private ContextStack contextStack;
    private SimplifiedContextStack sStack;
    HashMap<Integer, StringObjectPair> currentNodeSynthAttrs;
    HashMap<Integer, StringObjectPair> currentNodeInhAttrs;
    HashMap<Integer, StringObjectPair> currentNodeLocalAttrs;
    private int currentLine;
    private int currentColumn;
    private boolean toggleNameDisplay;
    private boolean toggleCStackDisplay;
    private boolean toggleHeadlessAttributes;
    private String[] toggleChoices;

    public static DecoratedNode runDebug(DecoratedNode tree) {
        Debug debug = new Debug();
        debug.runingDebug(tree);
        return tree;
    }

    /*
     * Unable to fully structure code
     */
    public void runingDebug(DecoratedNode tree) {
        inp = new Scanner(System.in);
        this.toggleNameDisplay = false;
        this.toggleCStackDisplay = true;
        this.toggleHeadlessAttributes = false;
        this.toggleChoices = new String[]{"nameDisplay", "cStackDisplay", "fullAttributeNames"};
        this.root = tree;
        this.currentNode = tree;
        this.nodeStack = new Stack<E>();
        this.cStack = new FileContextVisualization("context.txt", "********************************");
        this.cStack.push(this.currentNode);
        this.contextStack = this.cStack.getContextStack();
        this.sStack = new SimplifiedContextStack(this.contextStack);
        this.sStack.generateHTMLFile();
        System.out.println("Enter characters, and 'q' to quit.");
        if (this.toggleCStackDisplay) {
            this.cStack.show();
        }
        if (this.toggleNameDisplay) {
            this.printName(this.currentNode);
        }
        block58: while (true) {
            System.out.print(">DEBUGGER-PROMPT$");
            userInput = inp.nextLine();
            userInputList = userInput.split(" ");
            var6_5 = userInputList[0];
            var7_6 = -1;
            switch (var6_5.hashCode()) {
                case 3739: {
                    if (!var6_5.equals("up")) break;
                    var7_6 = 0;
                    break;
                }
                case 117: {
                    if (!var6_5.equals("u")) break;
                    var7_6 = 1;
                    break;
                }
                case 3089570: {
                    if (!var6_5.equals("down")) break;
                    var7_6 = 2;
                    break;
                }
                case 100: {
                    if (!var6_5.equals("d")) break;
                    var7_6 = 3;
                    break;
                }
                case 3594468: {
                    if (!var6_5.equals("undo")) break;
                    var7_6 = 4;
                    break;
                }
                case 483313230: {
                    if (!var6_5.equals("forwards")) break;
                    var7_6 = 5;
                    break;
                }
                case 102: {
                    if (!var6_5.equals("f")) break;
                    var7_6 = 6;
                    break;
                }
                case 1354491076: {
                    if (!var6_5.equals("backtrack")) break;
                    var7_6 = 7;
                    break;
                }
                case 1356771568: {
                    if (!var6_5.equals("backwards")) break;
                    var7_6 = 8;
                    break;
                }
                case 98: {
                    if (!var6_5.equals("b")) break;
                    var7_6 = 9;
                    break;
                }
                case -868304044: {
                    if (!var6_5.equals("toggle")) break;
                    var7_6 = 10;
                    break;
                }
                case 3373707: {
                    if (!var6_5.equals("name")) break;
                    var7_6 = 11;
                    break;
                }
                case 581637964: {
                    if (!var6_5.equals("equation")) break;
                    var7_6 = 12;
                    break;
                }
                case 3244: {
                    if (!var6_5.equals("eq")) break;
                    var7_6 = 13;
                    break;
                }
                case -1235006146: {
                    if (!var6_5.equals("listSynth")) break;
                    var7_6 = 14;
                    break;
                }
                case -1244575278: {
                    if (!var6_5.equals("listInher")) break;
                    var7_6 = 15;
                    break;
                }
                case 3322014: {
                    if (!var6_5.equals("list")) break;
                    var7_6 = 16;
                    break;
                }
                case 108: {
                    if (!var6_5.equals("l")) break;
                    var7_6 = 17;
                    break;
                }
                case 3619493: {
                    if (!var6_5.equals("view")) break;
                    var7_6 = 18;
                    break;
                }
                case 118: {
                    if (!var6_5.equals("v")) break;
                    var7_6 = 19;
                    break;
                }
                case 1374064807: {
                    if (!var6_5.equals("algoDebugg")) break;
                    var7_6 = 20;
                    break;
                }
                case 97: {
                    if (!var6_5.equals("a")) break;
                    var7_6 = 21;
                    break;
                }
                case 103145323: {
                    if (!var6_5.equals("local")) break;
                    var7_6 = 22;
                    break;
                }
                case 3198785: {
                    if (!var6_5.equals("help")) break;
                    var7_6 = 23;
                    break;
                }
                case 3127582: {
                    if (!var6_5.equals("exit")) break;
                    var7_6 = 24;
                    break;
                }
                case 113: {
                    if (!var6_5.equals("q")) break;
                    var7_6 = 25;
                    break;
                }
                case 3482191: {
                    if (!var6_5.equals("quit")) break;
                    var7_6 = 26;
                }
            }
            switch (var7_6) {
                case 0: 
                case 1: {
                    if (userInputList.length != 1) {
                        System.out.println("invalid, correct usage: up");
                        break;
                    }
                    if (this.up() == -1) continue block58;
                    this.updateDisplay();
                    break;
                }
                case 2: 
                case 3: {
                    childName = "";
                    if (userInputList.length == 1) {
                        currentProduction = this.currentNode.undecorate().getProdleton().getTypeUnparse();
                        listCurrentProduction = currentProduction.split("\\s+");
                        childNames = Arrays.copyOfRange(listCurrentProduction, 2, listCurrentProduction.length);
                        System.out.println("Which child?");
                        Debug.displayArray(childNames);
                        System.out.print(">DEBUGGER-PROMPT$");
                        childName = inp.nextLine();
                    } else if (userInputList.length == 2) {
                        childName = userInputList[1];
                    } else {
                        System.out.println("invalid, correct usage: down <node name>");
                        break;
                    }
                    try {
                        if (this.down(childName) == -1) {
                            System.out.println("invalid child");
                        }
                    }
                    catch (NullPointerException e) {
                        System.out.println("Null pointer");
                        break;
                    }
                    catch (IndexOutOfBoundsException e) {
                        System.out.println("Index out of bound");
                        break;
                    }
                    this.updateDisplay();
                    break;
                }
                case 4: {
                    if (userInputList.length != 1) {
                        System.out.println("invalid, correct usage: undo");
                        break;
                    }
                    if (this.undo() == -1) continue block58;
                    this.updateDisplay();
                    break;
                }
                case 5: 
                case 6: {
                    if (userInputList.length != 1) {
                        System.out.println("invalid, correct usage: forwards<>");
                        break;
                    }
                    if (this.forwards() == -1) continue block58;
                    this.updateDisplay();
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    if (userInputList.length != 1) {
                        System.out.println("invalid, correct usage: backtrack<>");
                        break;
                    }
                    if (this.backtrack() == -1) continue block58;
                    this.updateDisplay();
                    break;
                }
                case 10: {
                    toggleInput = "";
                    if (userInputList.length == 1) {
                        System.out.println("Which toggle?");
                        Debug.displayArray(this.toggleChoices);
                        System.out.print(">DEBUGGER-PROMPT$");
                        toggleInput = inp.nextLine();
                    } else if (userInputList.length == 2) {
                        toggleInput = userInputList[1];
                    } else {
                        System.out.println("invalid, correct usage: toggle <toggle name>");
                        break;
                    }
                    this.toggle(toggleInput);
                    break;
                }
                case 11: {
                    if (userInputList.length != 1) {
                        System.out.println("invalid, correct usage: name");
                        break;
                    }
                    this.printName(this.currentNode);
                    break;
                }
                case 12: 
                case 13: {
                    attributeNameInput = "";
                    if (userInputList.length == 1) {
                        attributeListView = Debug.allAttributesList(this.currentNode);
                        attributeArrayView = attributeListView.toArray(new String[attributeListView.size()]);
                        System.out.println("Which attribute?");
                        Debug.displayArray(attributeArrayView);
                        System.out.print(">DEBUGGER-PROMPT$");
                        attributeNameInput = inp.nextLine();
                    } else if (userInputList.length == 2) {
                        attributeNameInput = userInputList[1];
                    } else {
                        System.out.println("invalid, correct usage: eq <node name>");
                        break;
                    }
                    try {
                        if (this.equationHelper(attributeNameInput) != -1) continue block58;
                        System.out.println("invalid attribute");
                    }
                    catch (IndexOutOfBoundsException e) {
                        System.out.println("Index out of bounds");
                    }
                    continue block58;
                }
                case 14: {
                    if (userInputList.length != 1 && userInputList.length != 2) {
                        System.out.println("invalid, correct usage: listSynth<node?>");
                        break;
                    }
                    if (this.listSynth(this.currentNode) != 0) continue block58;
                    System.out.println("no synthesized attributes");
                    break;
                }
                case 15: {
                    if (userInputList.length != 1 && userInputList.length != 2) {
                        System.out.println("invalid, correct usage: listInher <node?>");
                        break;
                    }
                    if (this.listInher(this.currentNode) != 0) continue block58;
                    System.out.println("no inherited attributes");
                    break;
                }
                case 16: 
                case 17: {
                    if (userInputList.length != 1 && userInputList.length != 2) {
                        System.out.println("invalid, correct usage: list<node?>");
                        break;
                    }
                    this.printAttributes(this.currentNode, this.toggleHeadlessAttributes);
                    break;
                }
                case 18: 
                case 19: {
                    attributeName = "";
                    attributeNum = 0;
                    attributeList = Debug.allAttributesList(this.currentNode);
                    if (userInputList.length != 1) ** GOTO lbl269
                    System.out.println("Which attribute?");
                    attriburteArray = attributeList.toArray(new String[attributeList.size()]);
                    attributeNum = Debug.chooseFormList(inp, attriburteArray);
                    if (attributeNum == -1) continue block58;
                    if (attributeNum >= attributeList.size()) {
                        System.out.println("Invaild attribute number");
                        break;
                    }
                    attributeName = attributeList.get(attributeNum);
                    ** GOTO lbl282
lbl269:
                    // 1 sources

                    if (userInputList.length != 2) ** GOTO lbl280
                    try {
                        attributeNum = Integer.parseInt(userInputList[1]);
                        attributeName = attributeList.get(attributeNum);
                        ** GOTO lbl282
                    }
                    catch (NumberFormatException e) {
                        System.out.println("invalid, correct usage: view <node #>");
                        break;
                    }
                    catch (IndexOutOfBoundsException e) {
                        System.out.println("Index out of bounds");
                        break;
                    }
lbl280:
                    // 1 sources

                    System.out.println("invalid, correct usage: view <node #>");
                    break;
lbl282:
                    // 2 sources

                    this.printAttrFromName(this.currentNode, attributeName);
                    this.attributeDataHTML(this.currentNode, attributeName);
                    break;
                }
                case 20: 
                case 21: {
                    attributeName = "";
                    attributeNum = 0;
                    attributeList = Debug.allAttributesList(this.currentNode);
                    if (userInputList.length != 1) ** GOTO lbl299
                    System.out.println("Which attribute?");
                    attriburteArray = attributeList.toArray(new String[attributeList.size()]);
                    attributeNum = Debug.chooseFormList(inp, attriburteArray);
                    if (attributeNum == -1) continue block58;
                    if (attributeNum >= attributeList.size()) {
                        System.out.println("Invaild attribute number");
                        break;
                    }
                    attributeName = attributeList.get(attributeNum);
                    ** GOTO lbl312
lbl299:
                    // 1 sources

                    if (userInputList.length != 2) ** GOTO lbl310
                    try {
                        attributeNum = Integer.parseInt(userInputList[1]);
                        attributeName = attributeList.get(attributeNum);
                        ** GOTO lbl312
                    }
                    catch (NumberFormatException e) {
                        System.out.println("invalid, correct usage: view <node #>");
                        break;
                    }
                    catch (IndexOutOfBoundsException e) {
                        System.out.println("Index out of bounds");
                        break;
                    }
lbl310:
                    // 1 sources

                    System.out.println("invalid, correct usage: view <node #>");
                    break;
lbl312:
                    // 2 sources

                    this.algorithmicDebugg(this.currentNode, attributeName, inp);
                    break;
                }
                case 22: {
                    if (userInputList.length != 1 && userInputList.length != 2) {
                        System.out.println("invalid, correct usage: local <node?>");
                        break;
                    }
                    listLocals = Debug.getLocalAttrs(this.currentNode);
                    if (listLocals.size() == 0) {
                        System.out.println("no inherited attributes");
                        break;
                    }
                    var15_21 = listLocals.iterator();
                    while (true) {
                        if (!var15_21.hasNext()) continue block58;
                        localAttribute = var15_21.next();
                        System.out.println("Attribute = " + localAttribute);
                    }
                }
                case 23: {
                    if (userInputList.length == 1) {
                        System.out.println("call help with one of these keywords to see its functionality:");
                        System.out.println("toggle <feature>");
                        System.out.println("up");
                        System.out.println("down <node>");
                        System.out.println("view <attr>");
                        System.out.println("forwards");
                        System.out.println("backtrack");
                        System.out.println("prod");
                        System.out.println("eq");
                        System.out.println("listSynth");
                        System.out.println("listInher");
                        System.out.println("local");
                        System.out.println("list");
                        System.out.println("into");
                        System.out.println("exit");
                        break;
                    }
                    if (userInputList.length == 2) {
                        if (userInputList[1].equals("up")) {
                            System.out.println("The current node changes to its the parent");
                            break;
                        }
                        if (userInputList[1].equals("down")) {
                            System.out.println("The current node changes to its child");
                            System.out.println("One optional input is the child number you want to travel to");
                            System.out.println("If no input is provided you will be prompted with a choice of child");
                            System.out.println("You cn call this function with \"d\"");
                            break;
                        }
                        if (userInputList[1].equals("view")) {
                            System.out.println("look at the value of an attribute in the current node");
                            System.out.println("One optional input is the attribute number you want to view");
                            System.out.println("If no input is provided you will be prompted with a choice of attribute");
                            System.out.println("You can call this function with \"v\"");
                            break;
                        }
                        if (userInputList[1].equals("forwards")) {
                            System.out.println("The current node changes to its forward");
                            break;
                        }
                        if (userInputList[1].equals("backtrack")) {
                            System.out.println("The current node changes to its backtrack");
                            break;
                        }
                        if (userInputList[1].equals("prod")) {
                            System.out.println("prints the production of the current node");
                            break;
                        }
                        if (userInputList[1].equals("eq")) {
                            System.out.println("prints the equation of the current node");
                            break;
                        }
                        if (userInputList[1].equals("listSynth")) {
                            System.out.println("prints the Synthisized attributes of the current node");
                            break;
                        }
                        if (userInputList[1].equals("listInher")) {
                            System.out.println("prints the inherited attributes of the current node");
                            break;
                        }
                        if (userInputList[1].equals("list")) {
                            System.out.println("prints the attributes of the current node");
                            break;
                        }
                        if (userInputList[1].equals("local")) {
                            System.out.println("prints the local attributes of the current node");
                            break;
                        }
                        if (userInputList[1].equals("into")) {
                            System.out.println("The current node changes to its higer order attribute");
                            System.out.println("One optional input is the attribute number you want to go into");
                            System.out.println("If no input is provided you will be prompted with a choice of attribute");
                            break;
                        }
                        if (userInputList[1].equals("toggle")) {
                            System.out.println("Activate or disactivate a feature");
                            System.out.println("One input is the feature number you want to toggle");
                            System.out.println("If no input is provided you will be prompted with a choice of toggles");
                            break;
                        }
                        System.out.println("try just calling help");
                        break;
                    }
                    System.out.println("try just calling help");
                    break;
                }
                case 24: 
                case 25: 
                case 26: {
                    System.out.println("debugger out");
                    break block58;
                }
                default: {
                    System.out.println("invalid input call help for legal inputs");
                }
            }
        }
    }

    public void setCurrentNode(DecoratedNode node) {
        this.currentNodeSynthAttrs = null;
        this.currentNodeInhAttrs = null;
        this.currentNodeLocalAttrs = null;
        this.currentNode = node;
    }

    public Integer up() {
        if (this.currentNode.isRoot()) {
            System.out.println("Root Node has no parent");
            return -1;
        }
        this.nodeStack.push(this.currentNode);
        this.currentNode = this.currentNode.getParent();
        this.cStack.pop();
        this.sStack.generateHTMLFile();
        return 1;
    }

    public void updateDisplay() {
        block23: {
            try {
                List<String> attributeList = Debug.allAttributesList(this.currentNode);
                Map<String, Lazy> lazyMap = Debug.allAttributesLazyMap(this.currentNode);
                Lazy attributeLazy = lazyMap.get(attributeList.get(0));
                NLocation loc = attributeLazy.getSourceLocation();
                if (loc == null) break block23;
                String file = loc.synthesized(Init.silver_core_filename__ON__silver_core_Location).toString();
                int attributeLine = (Integer)loc.synthesized(Init.silver_core_line__ON__silver_core_Location);
                int currentLineNumber = 1;
                int productionLineNum = 0;
                try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (line.contains("::=")) {
                            productionLineNum = currentLineNumber;
                        }
                        if (currentLineNumber >= attributeLine) break;
                        ++currentLineNumber;
                    }
                    this.writeTojson(file, productionLineNum, productionLineNum);
                    this.sendMessageToExtension("1");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (NullPointerException e) {
                System.out.println("Failed to update json");
            }
        }
        Map<String, Object> attributeMap = Debug.allAttributesThunkMap(this.currentNode);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter("attribute_values.html"));){
            writer.write("<!DOCTYPE html>\n");
            writer.write("<html>\n");
            writer.write("<body>\n");
            writer.write("<pre>\n");
            for (Map.Entry<String, Object> entry : attributeMap.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (value instanceof Thunk) {
                    writer.write(key + ": THUNKING...");
                } else {
                    writer.write(key + ": " + Util.genericShow(value));
                }
                writer.newLine();
            }
            writer.write("</pre>\n");
            writer.write("</body>\n");
            writer.write("</html>\n");
        }
        catch (IOException e) {
            System.err.println("Error writing to file: " + e.getMessage());
        }
        if (this.toggleNameDisplay) {
            this.printName(this.currentNode);
        }
        if (this.toggleCStackDisplay) {
            this.cStack.show();
        }
    }

    public Integer down(String childName) {
        String[] childProductions;
        String currentProduction = this.currentNode.undecorate().getProdleton().getTypeUnparse();
        String[] listCurrentProduction = currentProduction.split("\\s+");
        Object[] childNames = Arrays.copyOfRange(listCurrentProduction, 2, listCurrentProduction.length);
        int childNum = Arrays.binarySearch(childNames, childName);
        if (childNum < 0) {
            childNum = this.prefixSearch((String[])childNames, childName);
        }
        if ((childProductions = this.currentNode.undecorate().getProdleton().getChildTypes())[childNum].equals("null")) {
            return -1;
        }
        this.nodeStack.push(this.currentNode);
        this.currentNode = this.currentNode.childDecorated(childNum);
        this.cStack.push(this.currentNode);
        this.sStack.generateHTMLFile();
        return 1;
    }

    public Integer prefixSearch(String[] array, String prefix) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].startsWith(prefix)) continue;
            return i;
        }
        return -1;
    }

    public Integer undo() {
        DecoratedNode newNode;
        if (this.nodeStack.empty()) {
            System.out.println("invalid no node to undo");
            return -1;
        }
        this.currentNode = newNode = this.nodeStack.pop();
        this.cStack.pop();
        this.sStack.generateHTMLFile();
        return 1;
    }

    public Integer forwards() {
        if (this.currentNode.getNode().hasForward()) {
            this.nodeStack.push(this.currentNode);
            this.currentNode = this.currentNode.forward();
            this.cStack.push(this.currentNode);
            this.sStack.generateHTMLFile();
            return 1;
        }
        System.out.println("invalid no node to forward");
        return -1;
    }

    public Integer backtrack() {
        DecoratedNode nextNode = this.currentNode.getForwardParent();
        if (nextNode == null) {
            System.out.println("invalid no node to backtrack to");
            return -1;
        }
        this.nodeStack.push(this.currentNode);
        this.currentNode = nextNode;
        this.cStack.pop();
        this.sStack.generateHTMLFile();
        return 1;
    }

    public Integer toggle(String toggleInput) {
        String toggleChoice = "";
        if (Arrays.asList(this.toggleChoices).contains(toggleInput)) {
            toggleChoice = toggleInput;
        } else {
            int toggleNum = this.prefixSearch(this.toggleChoices, toggleInput);
            if (toggleNum > -1) {
                toggleChoice = this.toggleChoices[toggleNum];
            } else {
                System.out.println("No such toggle");
                return -1;
            }
        }
        if (toggleChoice.equals("nameDisplay")) {
            if (this.toggleNameDisplay) {
                System.out.println("Production Display off");
                this.toggleNameDisplay = false;
            } else {
                System.out.println("Production Display on");
                this.toggleNameDisplay = true;
            }
        } else if (toggleChoice.equals("fullAttributeNames")) {
            if (this.toggleHeadlessAttributes) {
                System.out.println("Headless Attributes off");
                this.toggleHeadlessAttributes = false;
            } else {
                System.out.println("Headless Attributes on");
                this.toggleHeadlessAttributes = true;
            }
        } else if (toggleChoice.equals("cStackDisplay")) {
            if (this.toggleCStackDisplay) {
                System.out.println("cStack Display off");
                this.toggleCStackDisplay = false;
            } else {
                System.out.println("cStack Display on");
                this.toggleCStackDisplay = true;
            }
        } else {
            System.out.println("legal toggles: nameDisplay, fullAttributeNames, cStackDisplay");
        }
        return 1;
    }

    public void printName(DecoratedNode node) {
        String parentProduction = node.undecorate().getProdleton().getTypeUnparse();
        System.out.println(parentProduction);
    }

    public Integer equationHelper(String attributeName) {
        List<String> attributeList = Debug.allAttributesList(this.currentNode);
        Object[] attributeArray = attributeList.toArray(new String[attributeList.size()]);
        int attributeNum = Arrays.binarySearch(attributeArray, attributeName);
        if (attributeNum < 0) {
            attributeNum = this.prefixSearch((String[])attributeArray, attributeName);
        }
        if (attributeNum < 0) {
            attributeNum = Debug.suffixSearch((String[])attributeArray, ":" + attributeName);
        }
        this.displayEquation(this.currentNode, (String)attributeArray[attributeNum]);
        this.attributeDataHTML(this.currentNode, "");
        return 1;
    }

    public static Integer suffixSearch(String[] array, String suffix) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].endsWith(suffix)) continue;
            return i;
        }
        return -1;
    }

    private void sendMessageToExtension(String message) {
        String host = "127.0.0.1";
        int port = 19387;
        try (Socket socket = new Socket(host, port);
             PrintWriter out = new PrintWriter(socket.getOutputStream(), true);){
            out.println(message);
            System.out.println("Message sent to extension: " + message);
        }
        catch (IOException e) {
            System.err.println("Couldn't connect to the extension server at " + host + ":" + port);
            System.err.println(e.getMessage());
        }
    }

    public void displayEquation(DecoratedNode node, String attriburteName) {
        Lazy attributeLazy;
        NLocation loc;
        Map<String, Lazy> lazyMap = Debug.allAttributesLazyMap(node);
        if (lazyMap.containsKey(attriburteName) && (loc = (attributeLazy = lazyMap.get(attriburteName)).getSourceLocation()) != null) {
            String file = loc.synthesized(Init.silver_core_filename__ON__silver_core_Location).toString();
            int line = (Integer)loc.synthesized(Init.silver_core_line__ON__silver_core_Location);
            int endline = (Integer)loc.synthesized(Init.silver_core_endLine__ON__silver_core_Location);
            Debug.equationHTML(file, line, endline);
            this.writeTojson(file, line, endline);
            this.sendMessageToExtension("1");
        }
    }

    public void writeTojson(String filename, int lineNumber, int endline) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(".debugger_communicator.json"));){
            String currentDirectory = System.getProperty("user.dir");
            int lastIndex = filename.lastIndexOf("/");
            String fileEnd = filename.substring(lastIndex + 1);
            writer.write("{\"file_path\": \"" + currentDirectory + "/" + fileEnd + "\", \"line_begin\": " + lineNumber + ", \"line_end\": " + endline + "}");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void equationHTML(String filename, int lineNumber, int endline) {
        try (BufferedReader br1 = new BufferedReader(new FileReader(filename));
             BufferedWriter writer = new BufferedWriter(new FileWriter("current_production.html"));){
            String line;
            writer.write("<!DOCTYPE html>\n");
            writer.write("<html>\n");
            writer.write("<body>\n");
            int currentLineNumber = 1;
            int productionLineNum = 0;
            while ((line = br1.readLine()) != null) {
                if (line.contains("::=")) {
                    productionLineNum = currentLineNumber;
                }
                if (currentLineNumber >= lineNumber) break;
                ++currentLineNumber;
            }
            currentLineNumber = 1;
            br1.close();
            BufferedReader br2 = new BufferedReader(new FileReader(filename));
            writer.write("<pre>\n");
            while ((line = br2.readLine()) != null) {
                if (currentLineNumber == lineNumber) {
                    writer.write("<span style=\"color: red;\"><strong>");
                }
                if (currentLineNumber >= productionLineNum) {
                    writer.write(line);
                    if (currentLineNumber == endline) {
                        writer.write("</strong></span>");
                        writer.newLine();
                    }
                    writer.newLine();
                }
                if (currentLineNumber >= productionLineNum && line.trim().equals("}")) break;
                ++currentLineNumber;
            }
            writer.write("</pre>\n");
            writer.write("</body>\n");
            writer.write("</html>\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int listSynth(DecoratedNode node) {
        RTTIManager.Prodleton<? extends Node> prodleton = node.getNode().getProdleton();
        RTTIManager.Nonterminalton<? extends Node> nonterminalton = prodleton.getNonterminalton();
        Set<String> synAttrSet = nonterminalton.getAllSynth();
        int numAttr = 0;
        for (String synAttr : synAttrSet) {
            System.out.println("Attribute = " + synAttr);
            ++numAttr;
        }
        return numAttr;
    }

    public int listInher(DecoratedNode node) {
        RTTIManager.Prodleton<? extends Node> prodleton = node.getNode().getProdleton();
        RTTIManager.Nonterminalton<? extends Node> nonterminalton = prodleton.getNonterminalton();
        Set<String> inhAttrSet = nonterminalton.getAllInh();
        int numAttr = 0;
        for (String inhAttr : inhAttrSet) {
            System.out.println("Attribute = " + inhAttr);
            ++numAttr;
        }
        return numAttr;
    }

    public void printAttributes(DecoratedNode node, boolean toggleHeadlessAttributes) {
        List<String> attributeList = Debug.allAttributesList(node);
        if (toggleHeadlessAttributes) {
            attributeList = this.removeHeaders(Debug.allAttributesList(node));
        }
        int i = 0;
        for (String attribute : attributeList) {
            System.out.println(Integer.toString(i) + ": " + attribute);
            ++i;
        }
    }

    public List<String> removeHeaders(List<String> stringList) {
        ArrayList<String> headlessList = new ArrayList<String>();
        for (String element : stringList) {
            int lastIndex = element.lastIndexOf(":");
            if (lastIndex == -1) {
                headlessList.add(element);
                continue;
            }
            headlessList.add(element.substring(lastIndex + 1));
        }
        return headlessList;
    }

    public void printAttrFromName(DecoratedNode node, String printAttribute) {
        Map<String, Object> attributeMap = Debug.allAttributesThunkMap(node);
        Object finalThunk = attributeMap.get(printAttribute);
        System.out.println(Util.genericShow(Util.demand(finalThunk)));
    }

    public void attributeDataHTML(DecoratedNode node, String printAttribute) {
        Map<String, Object> attributeMap = Debug.allAttributesThunkMap(node);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter("attribute_values.html"));){
            writer.write("<!DOCTYPE html>\n");
            writer.write("<html>\n");
            writer.write("<body>\n");
            writer.write("<pre>\n");
            for (Map.Entry<String, Object> entry : attributeMap.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (key.equals(printAttribute)) {
                    writer.write("<mark>");
                    writer.write(key + ": " + Util.genericShow(Util.demand(value)));
                    writer.write("</mark>");
                } else if (value instanceof Thunk) {
                    writer.write(key + ": THUNKING...");
                } else {
                    writer.write(key + ": " + Util.genericShow(value));
                }
                writer.newLine();
            }
            writer.write("</pre>\n");
            writer.write("</body>\n");
            writer.write("</html>\n");
        }
        catch (IOException e) {
            System.err.println("Error writing to file: " + e.getMessage());
        }
    }

    public int algorithmicDebugg(DecoratedNode node, String attriburteName, Scanner inp) {
        String[] equationComponents;
        Lazy attributeLazy;
        NLocation loc;
        String equationString = "";
        Map<String, Lazy> lazyMap = Debug.allAttributesLazyMap(node);
        if (lazyMap.containsKey(attriburteName) && (loc = (attributeLazy = lazyMap.get(attriburteName)).getSourceLocation()) != null) {
            String filePath = loc.synthesized(Init.silver_core_filename__ON__silver_core_Location).toString();
            int startLine = (Integer)loc.synthesized(Init.silver_core_line__ON__silver_core_Location);
            int endLine = (Integer)loc.synthesized(Init.silver_core_endLine__ON__silver_core_Location);
            System.out.println("Equation:");
            try {
                equationString = Debug.getLines(filePath, startLine, endLine);
                System.out.println();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        System.out.println("Data:");
        Map<String, Object> attributeMap = Debug.allAttributesThunkMap(node);
        String partentProduction = node.undecorate().getProdleton().getTypeUnparse();
        int index1 = partentProduction.indexOf("::");
        int index2 = attriburteName.indexOf(":");
        String parentNameInEquation = partentProduction.substring(0, index1) + "." + attriburteName.substring(index2 + 1);
        System.out.println(parentNameInEquation + ": " + Util.genericShow(Util.demand(attributeMap.get(attriburteName))));
        String currentProduction = node.undecorate().getProdleton().getTypeUnparse();
        String[] listCurrentProduction = currentProduction.split("\\s+");
        String[] childFullNames = Arrays.copyOfRange(listCurrentProduction, 2, listCurrentProduction.length);
        String[] childFrontNames = new String[childFullNames.length];
        String[] childBackNames = new String[childFullNames.length];
        for (int i = 0; i < childFullNames.length; ++i) {
            index1 = childFullNames[i].indexOf("::");
            childFrontNames[i] = childFullNames[i].substring(0, index1) + ".";
            index2 = childFullNames[i].indexOf(":");
            childBackNames[i] = childFullNames[i].substring(index2 + 2);
        }
        ArrayList<String> dependentAttributes = new ArrayList<String>();
        block3: for (String component : equationComponents = equationString.split("\\s+")) {
            for (String childFront : childFrontNames) {
                if (!component.startsWith(childFront)) continue;
                dependentAttributes.add(component);
                continue block3;
            }
        }
        String[] dependentAttributesArray = dependentAttributes.toArray(new String[0]);
        int inputInt = -1;
        if (dependentAttributesArray.length <= 0) {
            return 0;
        }
        System.out.println();
        System.out.println("Pick the next node to investigate");
        inputInt = Debug.chooseFormList(inp, dependentAttributesArray);
        if (inputInt == -1) {
            return -1;
        }
        String chosenAttribute = dependentAttributesArray[inputInt];
        String[] chosenAttributeComponents = chosenAttribute.split("\\.");
        String nextChildName = "";
        for (String fullName : childFullNames) {
            if (!fullName.startsWith(chosenAttributeComponents[0] + "::")) continue;
            nextChildName = fullName;
        }
        System.out.println(nextChildName);
        if (this.down(nextChildName) == -1) {
            System.out.println("invalid child");
        }
        List<String> attributeList = Debug.allAttributesList(this.currentNode);
        String nextAttributeName = "";
        for (String element : attributeList) {
            String[] parts = element.split(":");
            if (parts.length != 2 || !chosenAttributeComponents[1].startsWith(parts[1])) continue;
            nextAttributeName = element;
        }
        System.out.println(nextAttributeName);
        if (nextChildName != "") {
            this.algorithmicDebugg(this.currentNode, nextAttributeName, inp);
        }
        return -1;
    }

    public static String getLines(String filePath, int startLine, int endLine) throws IOException {
        String returnString = "";
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
            String line;
            int currentLine;
            for (currentLine = 1; (line = reader.readLine()) != null && currentLine < startLine; ++currentLine) {
            }
            while (line != null && currentLine <= endLine) {
                System.out.println(line);
                returnString = returnString + line;
                line = reader.readLine();
                ++currentLine;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return returnString;
    }

    public static List<String> getLocalAttrs(DecoratedNode node) {
        int count = node.getNode().getNumberOfLocalAttrs();
        ArrayList<String> listLocals = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            Lazy attribute = node.getNode().getLocal(i);
            Object o = attribute.eval(node);
            listLocals.add(node.getNode().getNameOfLocalAttr(i));
        }
        return listLocals;
    }

    public DecoratedNode into(DecoratedNode node, String attriburteName) {
        Map<String, Object> attributeMap = Debug.allAttributesObjectMap(node);
        if (attributeMap.containsKey(attriburteName)) {
            System.out.println("In into function");
            Object attributeObject = attributeMap.get(attriburteName);
            return (DecoratedNode)attributeObject;
        }
        return null;
    }

    public static List<String> allAttributesList(DecoratedNode node) {
        RTTIManager.Prodleton<? extends Node> prodleton = node.getNode().getProdleton();
        RTTIManager.Nonterminalton<? extends Node> nonterminalton = prodleton.getNonterminalton();
        List<String> attributeList = nonterminalton.alphabeticalAttributes();
        List<String> localAttributeList = Debug.getLocalAttrs(node);
        attributeList.addAll(localAttributeList);
        attributeList.sort(null);
        return attributeList;
    }

    public static Map<String, Object> allAttributesObjectMap(DecoratedNode node) {
        List<String> attributeList = Debug.allAttributesList(node);
        RTTIManager.Prodleton<? extends Node> prodleton = node.getNode().getProdleton();
        RTTIManager.Nonterminalton<? extends Node> nonterminalton = prodleton.getNonterminalton();
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        for (String attribute : attributeList) {
            Integer index;
            if (nonterminalton.getSynOccursIndices().keySet().contains(attribute)) {
                index = nonterminalton.getSynOccursIndex(attribute);
                Lazy synthAttribute = node.getNode().getSynthesized(index);
                Object o = synthAttribute.eval(node);
                attributeMap.put(attribute, o);
                continue;
            }
            if (nonterminalton.getInhOccursIndices().keySet().contains(attribute)) {
                index = nonterminalton.getInhOccursIndex(attribute);
                Object o = node.evalInhSomehowButPublic(index);
                attributeMap.put(attribute, o);
                continue;
            }
            List<String> listLocals = Debug.getLocalAttrs(node);
            Integer index2 = listLocals.indexOf(attribute);
            Lazy localAttribute = node.getNode().getLocal(index2);
            Object o = localAttribute.eval(node);
            attributeMap.put(attribute, o);
        }
        return attributeMap;
    }

    public static Map<String, Object> allAttributesThunkMap(DecoratedNode node) {
        List<String> attributeList = Debug.allAttributesList(node);
        RTTIManager.Prodleton<? extends Node> prodleton = node.getNode().getProdleton();
        RTTIManager.Nonterminalton<? extends Node> nonterminalton = prodleton.getNonterminalton();
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        for (String attribute : attributeList) {
            Object o;
            Integer index;
            if (nonterminalton.getSynOccursIndices().keySet().contains(attribute)) {
                index = nonterminalton.getSynOccursIndex(attribute);
                o = node.contextSynthesizedLazy(index);
                attributeMap.put(attribute, o);
                continue;
            }
            if (nonterminalton.getInhOccursIndices().keySet().contains(attribute)) {
                index = nonterminalton.getInhOccursIndex(attribute);
                o = node.contextInheritedLazy(index);
                attributeMap.put(attribute, o);
                continue;
            }
            List<String> listLocals = Debug.getLocalAttrs(node);
            Integer index2 = listLocals.indexOf(attribute);
            Object o2 = node.localLazy(index2);
            attributeMap.put(attribute, o2);
        }
        return attributeMap;
    }

    public static Map<String, Lazy> allAttributesLazyMap(DecoratedNode node) {
        List<String> attributeList = Debug.allAttributesList(node);
        RTTIManager.Prodleton<? extends Node> prodleton = node.getNode().getProdleton();
        RTTIManager.Nonterminalton<? extends Node> nonterminalton = prodleton.getNonterminalton();
        HashMap<String, Lazy> attributeMap = new HashMap<String, Lazy>();
        for (String attribute : attributeList) {
            Integer index;
            if (nonterminalton.getSynOccursIndices().keySet().contains(attribute)) {
                index = nonterminalton.getSynOccursIndex(attribute);
                Lazy synthAttribute = node.getNode().getSynthesized(index);
                attributeMap.put(attribute, synthAttribute);
                continue;
            }
            if (nonterminalton.getInhOccursIndices().keySet().contains(attribute)) {
                index = nonterminalton.getInhOccursIndex(attribute);
                Lazy inheritedAttribute = node.getInheritedAttribute(index);
                attributeMap.put(attribute, inheritedAttribute);
                continue;
            }
            List<String> listLocals = Debug.getLocalAttrs(node);
            Integer index2 = listLocals.indexOf(attribute);
            Lazy localAttribute = node.getNode().getLocal(index2);
            attributeMap.put(attribute, localAttribute);
        }
        return attributeMap;
    }

    public static void displayArray(String[] array) {
        for (String element : array) {
            System.out.println(element);
        }
    }

    public static String autofill(String[] options, Scanner inp) {
        String input;
        while ((input = inp.nextLine()).isEmpty()) {
        }
        if (input.endsWith("\t")) {
            String prefix = input.substring(0, input.lastIndexOf("\t"));
            return Debug.autoComplete(prefix, options);
        }
        return input;
    }

    private static String autoComplete(String prefix, String[] options) {
        for (String option : options) {
            if (!option.startsWith(prefix)) continue;
            return option;
        }
        return "";
    }

    public static Integer chooseFormList(Scanner inp, String[] list) {
        for (int i = 0; i < list.length; ++i) {
            System.out.println(Integer.toString(i) + ": " + list[i]);
        }
        boolean continueLoop = true;
        int returnInt = -1;
        String stopper = "";
        while (continueLoop) {
            System.out.print(">DEBUGGER-PROMPT$");
            if (inp.hasNextInt()) {
                returnInt = inp.nextInt();
                inp.nextLine();
                continueLoop = false;
                continue;
            }
            stopper = inp.nextLine();
            if (stopper.equals("q")) {
                continueLoop = false;
                continue;
            }
            System.out.println("Please choose an integer or q to exit");
        }
        return returnInt;
    }

    public boolean isContractum(DecoratedNode node) {
        return node.getNode().hasForward();
    }

    public static class StringObjectPair {
        private String stringValue;
        private Object objectValue;

        public StringObjectPair(String stringValue, Object objectValue) {
            this.stringValue = stringValue;
            this.objectValue = objectValue;
        }

        public String getString() {
            return this.stringValue;
        }

        public Object getObject() {
            return this.objectValue;
        }
    }
}

