/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.DecoratedNode;
import common.FileCoordinate;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class NodeContextMessage {
    private int numIndex;
    private int translationX;
    private int higherOrderY;
    private String textRepr;
    private String prodName;
    private String filename;
    private FileCoordinate fcStart;
    private FileCoordinate fcEnd;
    private boolean isRedex;
    private boolean isContractum;
    private int contractumOf;
    private boolean isAttributeRoot;
    private int attributeOf;

    public String GetSection0() {
        return Integer.toString(this.numIndex);
    }

    public String GetSection1() {
        String res = "";
        boolean firstSet = false;
        if (this.translationX > 0) {
            res = res + "TRANSLATION-" + this.translationX;
            firstSet = true;
        }
        if (this.higherOrderY > 0) {
            if (firstSet) {
                res = res + " & ";
            }
            res = res + "HIGHER-ORDER-" + this.higherOrderY;
        }
        return res;
    }

    public String GetSection2() {
        return this.textRepr;
    }

    public String GetSection3() {
        String res = "prod: " + this.prodName + "\n" + this.filename + " lines: " + this.fcStart.getRow() + ":" + this.fcStart.getCol() + " -> " + this.fcEnd.getRow() + ":" + this.fcEnd.getCol();
        return res;
    }

    public String GetSection4() {
        String res = "";
        if (this.isRedex) {
            res = res + "*is-redex\n";
        }
        if (this.isContractum) {
            res = res + "*is-contractum of " + this.contractumOf + "\n";
        }
        if (this.isAttributeRoot) {
            res = res + "*is-attribute_root\n";
        }
        return res;
    }

    public NodeContextMessage(DecoratedNode node, int numIndex) {
        this.numIndex = numIndex;
        this.prodName = node.getNode().getName();
        this.fillInRowsAndCols(node);
        this.setLabels(node);
        this.initializeHeaders(node);
        if (this.translationX > 0 || this.higherOrderY > 0 || this.isAttributeRoot || this.isContractum) {
            this.prettyPrint(node);
        } else {
            this.pullFilelines();
        }
    }

    private void initializeHeaders(DecoratedNode node) {
        this.translationX = node.getIsTranslation();
        this.higherOrderY = node.getIsAttribute();
    }

    private void fillInRowsAndCols(DecoratedNode node) {
        this.fcStart = node.getStartCoordinates();
        this.fcEnd = node.getEndCoordinates();
        this.filename = node.getFilename();
    }

    private void setLabels(DecoratedNode node) {
        this.isRedex = node.getIsRedex();
        this.isContractum = node.getIsContractum();
        this.isAttributeRoot = node.getIsAttributeRoot();
        this.contractumOf = this.numIndex - 1;
        this.attributeOf = this.numIndex - 1;
    }

    private void prettyPrint(DecoratedNode node) {
        this.textRepr = node.getPrettyPrint();
    }

    private void pullFilelines() {
        try (BufferedReader br = new BufferedReader(new FileReader(this.filename));){
            int row;
            int col = 1;
            String res = "";
            for (row = 1; row < this.fcStart.getRow(); ++row) {
                String string = br.readLine();
            }
            while (col < this.fcStart.getCol()) {
                int n = br.read();
                ++col;
            }
            while (row < this.fcEnd.getRow()) {
                res = res + br.readLine();
                res = res + '\n';
                ++row;
            }
            while (col <= this.fcEnd.getCol()) {
                char c = (char)br.read();
                res = res + Character.toString(c);
                ++col;
            }
            br.close();
            this.textRepr = res;
        }
        catch (IOException e) {
            System.out.println("ERROR READING FROM FILE " + this.filename);
            e.printStackTrace();
        }
    }

    public String toString() {
        return this.GetSection0() + "\n" + this.GetSection1() + "\n" + this.GetSection2() + "\n" + this.GetSection3() + "\n" + this.GetSection4();
    }

    public int getTranslationX() {
        return this.translationX;
    }

    public int getHigherOrderY() {
        return this.higherOrderY;
    }

    public String getTextRepr() {
        return this.textRepr;
    }

    public String getProdName() {
        return this.prodName;
    }

    public String getFilenmae() {
        return this.filename;
    }

    public FileCoordinate getFileCoordianteStart() {
        return this.fcStart;
    }

    public FileCoordinate getFileCoordianteEnd() {
        return this.fcEnd;
    }

    public boolean isRedex() {
        return this.isRedex;
    }

    public boolean isContractum() {
        return this.isContractum;
    }

    public int getContractumOf() {
        return this.contractumOf;
    }

    public boolean isAttributeRoot() {
        return this.isAttributeRoot;
    }

    public int getAttributeOf() {
        return this.attributeOf;
    }
}

