/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.intermediate.syntaxtranslator;

import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.GrammarName;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.Symbol;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.intermediate.IntermediateConsNode;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.intermediate.IntermediateNodeVisitor;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.intermediate.IntermediateSymbolNode;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.intermediate.IntermediateSymbolSort;
import edu.umn.cs.melt.copper.legacy.compiletime.logging.CompilerLogMessageSort;
import edu.umn.cs.melt.copper.legacy.compiletime.logging.CompilerLogger;
import edu.umn.cs.melt.copper.runtime.auxiliary.Pair;
import edu.umn.cs.melt.copper.runtime.io.InputPosition;
import edu.umn.cs.melt.copper.runtime.logging.CopperException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;

public class AttributeConsolidator
implements IntermediateNodeVisitor<GrammarName, GrammarName, CopperException> {
    public CompilerLogger logger;
    public Hashtable<Symbol, IntermediateSymbolNode> consolidatedNodes;

    public AttributeConsolidator(CompilerLogger logger) {
        this.logger = logger;
        this.consolidatedNodes = new Hashtable();
    }

    @Override
    public GrammarName visitIntermediateSymbolNode(IntermediateSymbolNode node, GrammarName inheritance) throws CopperException {
        if (!this.consolidatedNodes.containsKey(node.name)) {
            this.consolidatedNodes.put(node.name, node);
            node.owner = inheritance;
            if (node.sort == IntermediateSymbolSort.GRAMMAR_NAME) {
                node.owner = new GrammarName(node.name);
                return node.owner;
            }
        } else {
            if (this.consolidatedNodes.get((Object)node.name).sort != node.sort) {
                if (this.logger.isLoggable(CompilerLogMessageSort.ERROR)) {
                    this.logger.logErrorMessage(CompilerLogMessageSort.ERROR, node.attributes.get("location").first(), (Object)((Object)this.consolidatedNodes.get((Object)node.name).sort) + " '" + node.name + "' referenced here as a " + (Object)((Object)node.sort));
                }
                return null;
            }
            HashSet<String> attributes = new HashSet<String>(node.attributes.keySet());
            attributes.retainAll(this.consolidatedNodes.get((Object)node.name).attributes.keySet());
            attributes.remove("location");
            if (!attributes.isEmpty()) {
                boolean isConflicting = false;
                for (String attr : attributes) {
                    if (this.mergeAttr(node, attr) != null) continue;
                    isConflicting = true;
                    break;
                }
                if (isConflicting) {
                    if (this.logger.isLoggable(CompilerLogMessageSort.ERROR)) {
                        this.logger.logErrorMessage(CompilerLogMessageSort.ERROR, node.attributes.get("location").first(), "Conflicting definition involving " + (Object)((Object)node.sort) + " '" + node.name + "': multiple specifications of attributes " + attributes);
                    }
                    return null;
                }
            }
            for (String attr : node.attributes.keySet()) {
                this.consolidatedNodes.get((Object)node.name).attributes.put(attr, this.mergeAttr(node, attr));
            }
        }
        return null;
    }

    public Pair<InputPosition, Object> mergeAttr(IntermediateSymbolNode node, String attr) {
        if (!this.consolidatedNodes.get((Object)node.name).attributes.containsKey(attr) || this.consolidatedNodes.get((Object)node.name).attributes.get(attr).second() == null || this.consolidatedNodes.get((Object)node.name).attributes.get(attr).second().equals(node.attributes.get(attr).second())) {
            return node.attributes.get(attr);
        }
        if (node.attributes.get(attr).second() == null) {
            return this.consolidatedNodes.get((Object)node.name).attributes.get(attr);
        }
        Object newAttrObj = node.attributes.get(attr).second();
        Object oldAttrObj = this.consolidatedNodes.get((Object)node.name).attributes.get(attr).second();
        if (!oldAttrObj.getClass().equals(newAttrObj.getClass())) {
            return null;
        }
        if (attr.equals("location")) {
            return this.consolidatedNodes.get((Object)node.name).attributes.get("location");
        }
        if (node.name.equals(Symbol.symbol(" startCode ")) && attr.equals("code")) {
            if (!(oldAttrObj instanceof String)) {
                return null;
            }
            if (((String)newAttrObj).matches(".*package.*")) {
                return Pair.cons(this.consolidatedNodes.get((Object)node.name).attributes.get(attr).first(), (String)newAttrObj + (String)oldAttrObj);
            }
            return Pair.cons(this.consolidatedNodes.get((Object)node.name).attributes.get(attr).first(), (String)oldAttrObj + (String)newAttrObj);
        }
        if (attr.equals("classes")) {
            if (!(oldAttrObj instanceof LinkedList) || !(newAttrObj instanceof LinkedList)) {
                return null;
            }
            HashSet<String> newAttrs = new HashSet<String>();
            for (String id : (LinkedList)oldAttrObj) {
                newAttrs.add(id);
            }
            for (String id : (LinkedList)newAttrObj) {
                newAttrs.add(id);
            }
            LinkedList newAttrList = new LinkedList(newAttrs);
            return Pair.cons(this.consolidatedNodes.get((Object)node.name).attributes.get(attr).first(), newAttrList);
        }
        return null;
    }

    @Override
    public GrammarName visitIntermediateConsNode(IntermediateConsNode node, GrammarName inheritance) throws CopperException {
        GrammarName carName = node.car.acceptVisitor(this, inheritance);
        GrammarName cdrName = node.cdr.acceptVisitor(this, carName != null ? carName : inheritance);
        if (inheritance != null && (carName != null || cdrName != null)) {
            return inheritance;
        }
        if (inheritance != null) {
            return inheritance;
        }
        if (carName != null) {
            return carName;
        }
        if (cdrName != null) {
            return cdrName;
        }
        return inheritance;
    }
}

