/*
 * Decompiled with CFR 0.152.
 */
package common.rawlib;

import common.ConsCell;
import common.NodeFactory;
import common.OriginContext;
import common.javainterop.ConsCellCollection;
import common.javainterop.SilverComparator;
import java.util.Iterator;
import java.util.TreeSet;

public final class RawTreeSet {
    public static TreeSet<Object> empty(NodeFactory<Integer> cmp) {
        return new TreeSet<Object>(new SilverComparator(cmp));
    }

    public static TreeSet<Object> addList(ConsCell l, TreeSet<Object> t) {
        TreeSet ret = (TreeSet)t.clone();
        ret.addAll(new ConsCellCollection(l));
        return ret;
    }

    public static ConsCell toList(TreeSet<Object> t) {
        return ConsCellCollection.fromReverseIterator(t.descendingIterator());
    }

    public static TreeSet<Object> union(TreeSet<Object> l, TreeSet<Object> r) {
        TreeSet ret = (TreeSet)l.clone();
        ret.addAll(r);
        return ret;
    }

    public static TreeSet<Object> intersect(TreeSet<Object> l, TreeSet<Object> r) {
        TreeSet ret = (TreeSet)l.clone();
        ret.retainAll(r);
        return ret;
    }

    public static TreeSet<Object> difference(TreeSet<Object> l, TreeSet<Object> r) {
        TreeSet ret = (TreeSet)l.clone();
        ret.removeAll(r);
        return ret;
    }

    public static boolean contains(Object o, TreeSet<Object> t) {
        return t.contains(o);
    }

    public static boolean subset(TreeSet<Object> l, TreeSet<Object> r) {
        return r.containsAll(l);
    }

    public static boolean containsAll(ConsCell l, TreeSet<Object> r) {
        return r.containsAll(new ConsCellCollection(l));
    }

    public static boolean isEmpty(TreeSet<Object> s) {
        return s.isEmpty();
    }

    public static int size(TreeSet<Object> s) {
        return s.size();
    }

    public static TreeSet<Object> filter(NodeFactory<Boolean> cmp, TreeSet<Object> s) {
        TreeSet ret = (TreeSet)s.clone();
        Iterator x = ret.iterator();
        while (x.hasNext()) {
            if (cmp.invoke(OriginContext.FFI_CONTEXT, new Object[]{x.next()}, null).booleanValue()) continue;
            x.remove();
        }
        return ret;
    }

    public static TreeSet<Object> removeAll(ConsCell rm, TreeSet<Object> s) {
        TreeSet ret = (TreeSet)s.clone();
        ret.removeAll(new ConsCellCollection(rm));
        return ret;
    }
}

