/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.Decorable;
import common.DecoratedNode;
import common.Lazy;
import common.RTTIManager;
import common.TransOccursInfo;
import common.Typed;
import common.exceptions.SilverException;
import common.exceptions.TraceException;

public abstract class Node
implements Decorable,
Typed {
    public final boolean isUnique;
    private Node undecoratedValue = null;

    protected Node(boolean isUnique) {
        this.isUnique = isUnique;
    }

    public abstract Node updateAnnos(Object[] var1);

    @Override
    public DecoratedNode decorate(DecoratedNode parent, Lazy[] inhs, Lazy decSite) {
        return new DecoratedNode(this.getNumberOfChildren(), this.getNumberOfInhAttrs(), this.getNumberOfSynAttrs(), this.getNumberOfLocalAttrs(), this, parent, inhs, null, false, decSite);
    }

    @Override
    public DecoratedNode decorate(DecoratedNode parent, Lazy[] inhs, DecoratedNode fwdParent, boolean isProdForward) {
        return new DecoratedNode(this.getNumberOfChildren(), this.getNumberOfInhAttrs(), this.getNumberOfSynAttrs(), this.getNumberOfLocalAttrs(), this, parent, inhs, fwdParent, isProdForward, null);
    }

    public final Node undecorate(DecoratedNode context) {
        if (this.undecoratedValue == null) {
            try {
                this.undecoratedValue = this.evalUndecorate(context);
            }
            catch (Throwable t) {
                throw this.handleUndecorateError(context, t);
            }
        }
        return this.undecoratedValue;
    }

    private final SilverException handleUndecorateError(DecoratedNode context, Throwable t) {
        return new TraceException("While undecorating " + context.getDebugID(), t);
    }

    public abstract int getNumberOfSynAttrs();

    public abstract String getNameOfSynAttr(int var1);

    public abstract TransOccursInfo getTransOccurs(int var1);

    public abstract Lazy getDefaultSynthesized(int var1);

    public abstract int getNumberOfInhAttrs();

    public abstract String getNameOfInhAttr(int var1);

    public abstract String[] getAnnoNames();

    public abstract Object getAnno(String var1);

    public abstract String getName();

    public abstract int getNumberOfChildren();

    public abstract String getChildName(int var1);

    public abstract boolean isChildDecorable(int var1);

    public abstract Object getChild(int var1);

    public abstract Object getChildLazy(int var1);

    public abstract Lazy getChildDecSite(int var1);

    public abstract Lazy[] getChildInheritedAttributes(int var1);

    public abstract int getNumberOfLocalAttrs();

    public abstract boolean isLocalDecorable(int var1);

    public abstract String getNameOfLocalAttr(int var1);

    public abstract Lazy getLocal(int var1);

    public abstract Lazy getLocalDecSite(int var1);

    public abstract boolean getLocalIsForward(int var1);

    public abstract Lazy[] getLocalInheritedAttributes(int var1);

    public abstract boolean hasForward();

    public abstract Node evalForward(DecoratedNode var1);

    public abstract Node evalUndecorate(DecoratedNode var1);

    public abstract Lazy[] getForwardInheritedAttributes();

    public abstract Lazy getSynthesized(int var1);

    public abstract RTTIManager.Prodleton<? extends Node> getProdleton();
}

