/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.ide.silver.misc;

import common.DecoratedNode;
import common.StringCatter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import silver.core.Init;
import silver.core.NLocation;
import silver.langutil.NMessage;

public class Problem {
    public static final int UNKNOWN = -1;
    public static final int INFO = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    private IPath file;
    private int column;
    private int line;
    private int startInd;
    private int endInd;
    private String message;
    private int level;
    private boolean projMsg = false;

    private static Problem createFileProblem(IPath file, int line, int column, int startInd, int endInd, int severity, String message) {
        return new Problem(file, column, line, message, severity, startInd, endInd, false);
    }

    private static Problem createProjectProblem(int severity, String message) {
        return new Problem(null, -1, -1, message, severity, -1, -1, true);
    }

    private Problem(IPath file, int column, int line, String message, int level, int startInd, int endInd, boolean projMsg) {
        this.file = file;
        this.column = column;
        this.line = line;
        this.message = message;
        this.level = level;
        this.startInd = startInd;
        this.endInd = endInd;
        this.projMsg = projMsg;
    }

    public boolean buildBlocker() {
        return this.level == 2;
    }

    public static Problem extractProblem(NMessage ideMsg) {
        DecoratedNode ideMsgDecNode = ideMsg.decorate();
        String message = ((StringCatter)ideMsgDecNode.synthesized(silver.langutil.Init.silver_langutil_message__ON__silver_langutil_Message)).toString();
        int severity = (Integer)ideMsgDecNode.synthesized(silver.langutil.Init.silver_langutil_severity__ON__silver_langutil_Message);
        NLocation where_node = (NLocation)ideMsgDecNode.synthesized(silver.langutil.Init.silver_langutil_where__ON__silver_langutil_Message);
        DecoratedNode where = where_node.decorate();
        String filename = ((StringCatter)where.synthesized(Init.silver_core_filename__ON__silver_core_Location)).toString();
        boolean isProjMsg = filename.equals("");
        if (isProjMsg) {
            return Problem.createProjectProblem(severity, message);
        }
        int line = (Integer)where.synthesized(Init.silver_core_line__ON__silver_core_Location);
        int column = (Integer)where.synthesized(Init.silver_core_column__ON__silver_core_Location);
        int index = (Integer)where.synthesized(Init.silver_core_index__ON__silver_core_Location);
        int endIndex = (Integer)where.synthesized(Init.silver_core_endIndex__ON__silver_core_Location);
        return Problem.createFileProblem((IPath)new Path(filename), line, column, index, endIndex, severity, message);
    }

    public void createMarker(IProject project, String markerType) throws CoreException {
        if (this.projMsg) {
            IMarker marker = project.createMarker(markerType);
            marker.setAttribute("message", (Object)this.message);
            marker.setAttribute("severity", this.level);
        } else {
            IFile f = project.getLocation().isPrefixOf(this.file) ? project.getFile(this.file.makeRelativeTo(project.getLocation())) : project.getFile(this.file);
            if (!f.exists()) {
                IMarker marker = project.createMarker(markerType);
                marker.setAttribute("message", (Object)("Unknown file with error message: " + f.getFullPath().toString() + " : " + this.message));
                marker.setAttribute("severity", this.level);
                return;
            }
            IMarker marker = f.createMarker(markerType);
            marker.setAttribute("message", (Object)this.message);
            marker.setAttribute("lineNumber", this.line);
            int index = this.startInd;
            if (index != -1) {
                marker.setAttribute("charStart", index);
            }
            if ((index = this.endInd) != -1) {
                marker.setAttribute("charEnd", index);
            }
            marker.setAttribute("severity", this.level);
        }
    }
}

