/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.ide.silver.property;

public class Property {
    public static String SPLITTER = "/";
    private String name;
    private Type type;
    private boolean required;
    private String display;
    private String defaultVal;
    private String sValue;
    private int iValue;

    private Property(String name, Type type, String sValue, int iValue) {
        this(name, type, sValue, iValue, "", false, "");
    }

    private Property(String name, Type type, String sValue, int iValue, String defaultVal, boolean required, String display) {
        this.name = name;
        this.type = type;
        this.sValue = sValue;
        this.iValue = iValue;
        this.defaultVal = defaultVal;
        this.required = required;
        this.display = display;
    }

    public static Property parseProperty(String key, String value) {
        String[] strs = key.split(SPLITTER);
        if (strs.length == 2) {
            Type type = Type.getType(strs[1]);
            switch (type) {
                case STRING: {
                    return Property.makeStringProperty(strs[0], value);
                }
                case PATH: {
                    return Property.makePathProperty(strs[0], value);
                }
                case URL: {
                    return Property.makeURLProperty(strs[0], value);
                }
                case INTEGER: {
                    return Property.makeIntegerProperty(strs[0], Integer.parseInt(value));
                }
            }
        }
        return Property.makeStringProperty(key, value);
    }

    public static Property makePathProperty(String name, String path) {
        return new Property(name, Type.PATH, path, 0);
    }

    public static Property makeURLProperty(String name, String url) {
        return new Property(name, Type.URL, url, 0);
    }

    public static Property makeStringProperty(String name, String str) {
        return new Property(name, Type.STRING, str, 0);
    }

    public static Property makeIntegerProperty(String name, int val) {
        return new Property(name, Type.INTEGER, "", val);
    }

    public static Property makePathProperty(String name, String path, String defaultVal, String display, boolean required) {
        return new Property(name, Type.PATH, path, 0, defaultVal, required, display);
    }

    public static Property makeURLProperty(String name, String url, String defaultVal, String display, boolean required) {
        return new Property(name, Type.URL, url, 0, defaultVal, required, display);
    }

    public static Property makeStringProperty(String name, String str, String defaultVal, String display, boolean required) {
        return new Property(name, Type.STRING, str, 0, defaultVal, required, display);
    }

    public static Property makeIntegerProperty(String name, int val, String defaultVal, String display, boolean required) {
        return new Property(name, Type.INTEGER, "", val, defaultVal, required, display);
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public String getSValue() {
        if (this.type != Type.INTEGER) {
            return this.sValue;
        }
        return String.valueOf(this.iValue);
    }

    public void setSValue(String sValue) {
        this.sValue = sValue;
    }

    public int getIValue() {
        return this.iValue;
    }

    public void setIValue(int iValue) {
        this.iValue = iValue;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getDisplay() {
        return this.display;
    }

    public String getDefault() {
        return this.defaultVal;
    }

    public void reset() {
        if (this.type != Type.INTEGER) {
            this.setSValue(this.defaultVal);
        } else {
            try {
                this.setIValue(Integer.parseInt(this.defaultVal));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public static enum Type {
        STRING,
        PATH,
        URL,
        INTEGER;


        static Type getType(String name) {
            if ("string".equals(name)) {
                return STRING;
            }
            if ("path".equals(name)) {
                return PATH;
            }
            if ("url".equals(name)) {
                return URL;
            }
            return INTEGER;
        }

        static String getString(Type type) {
            switch (type) {
                case STRING: {
                    return "string";
                }
                case PATH: {
                    return "path";
                }
                case URL: {
                    return "url";
                }
                case INTEGER: {
                    return "integer";
                }
            }
            return "string";
        }
    }
}

