/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.DecoratedNode;
import common.NodeContextMessage;
import java.util.Iterator;
import java.util.Stack;

public class ContextStack {
    private Stack<NodeContextMessage> stack = new Stack();
    private int height = 0;
    private int next_index = 1;

    public void push(DecoratedNode n) {
        ++this.height;
        NodeContextMessage ncm = new NodeContextMessage(n, this.next_index++);
        this.stack.push(ncm);
    }

    public NodeContextMessage pop() {
        --this.height;
        --this.next_index;
        return this.stack.pop();
    }

    public NodeContextMessage peak() {
        return this.stack.peek();
    }

    public int get_height() {
        return this.height;
    }

    public Iterator<NodeContextMessage> iterator() {
        return this.stack.iterator();
    }

    public NodeContextMessage get(int index) {
        int stackIndex = this.stack.size() - index - 1;
        if (stackIndex >= 0 && stackIndex < this.stack.size()) {
            return (NodeContextMessage)this.stack.get(stackIndex);
        }
        throw new IndexOutOfBoundsException("Index " + index + " is out of bounds.");
    }
}

