/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.DecoratedNode;
import common.FileContextVisualization;
import common.Lazy;
import common.Node;
import common.RTTIManager;
import common.TopNode;
import common.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.Stack;

public class Debug {
    private DecoratedNode root;
    private DecoratedNode currentNode;
    private Stack<DecoratedNode> nodeStack;
    HashMap<Integer, StringObjectPair> currentNodeSynthAttrs;
    HashMap<Integer, StringObjectPair> currentNodeInhAttrs;
    HashMap<Integer, StringObjectPair> currentNodeLocalAttrs;
    private int currentLine;
    private int currentColumn;

    public static DecoratedNode runDebug(DecoratedNode tree) {
        Debug debug = new Debug();
        debug.runingDebug(tree);
        return tree;
    }

    /*
     * Unable to fully structure code
     */
    public void runingDebug(DecoratedNode tree) {
        inp = new Scanner(System.in);
        System.out.println("Enter characters, and 'q' to quit.");
        toggleNameDisplay = false;
        toggleCStackDisplay = true;
        toggleHeadlessAttributes = false;
        toggleChoices = new String[]{"prodDisplay", "cStackDisplay", "fullAttributeNames"};
        this.root = tree;
        this.currentNode = tree;
        this.nodeStack = new Stack<E>();
        if (toggleNameDisplay) {
            this.printName(this.currentNode);
        }
        cStack = new FileContextVisualization("context.txt", "********************************");
        cStack.push(this.currentNode);
        if (toggleCStackDisplay) {
            cStack.show();
        }
        contextStack = cStack.getContextStack();
        block50: while (true) {
            System.out.print(">DEBUGGER-PROMPT$");
            userInput = inp.nextLine();
            userInputList = userInput.split(" ");
            var12_12 = userInputList[0];
            var13_13 = -1;
            switch (var12_12.hashCode()) {
                case 3739: {
                    if (!var12_12.equals("up")) break;
                    var13_13 = 0;
                    break;
                }
                case 117: {
                    if (!var12_12.equals("u")) break;
                    var13_13 = 1;
                    break;
                }
                case 3089570: {
                    if (!var12_12.equals("down")) break;
                    var13_13 = 2;
                    break;
                }
                case 100: {
                    if (!var12_12.equals("d")) break;
                    var13_13 = 3;
                    break;
                }
                case 3594468: {
                    if (!var12_12.equals("undo")) break;
                    var13_13 = 4;
                    break;
                }
                case 483313230: {
                    if (!var12_12.equals("forwards")) break;
                    var13_13 = 5;
                    break;
                }
                case 3237472: {
                    if (!var12_12.equals("into")) break;
                    var13_13 = 6;
                    break;
                }
                case 1354491076: {
                    if (!var12_12.equals("backtrack")) break;
                    var13_13 = 7;
                    break;
                }
                case -868304044: {
                    if (!var12_12.equals("toggle")) break;
                    var13_13 = 8;
                    break;
                }
                case 3449687: {
                    if (!var12_12.equals("prod")) break;
                    var13_13 = 9;
                    break;
                }
                case 3244: {
                    if (!var12_12.equals("eq")) break;
                    var13_13 = 10;
                    break;
                }
                case -1235006146: {
                    if (!var12_12.equals("listSynth")) break;
                    var13_13 = 11;
                    break;
                }
                case -1244575278: {
                    if (!var12_12.equals("listInher")) break;
                    var13_13 = 12;
                    break;
                }
                case 3322014: {
                    if (!var12_12.equals("list")) break;
                    var13_13 = 13;
                    break;
                }
                case 108: {
                    if (!var12_12.equals("l")) break;
                    var13_13 = 14;
                    break;
                }
                case 3619493: {
                    if (!var12_12.equals("view")) break;
                    var13_13 = 15;
                    break;
                }
                case 118: {
                    if (!var12_12.equals("v")) break;
                    var13_13 = 16;
                    break;
                }
                case 103145323: {
                    if (!var12_12.equals("local")) break;
                    var13_13 = 17;
                    break;
                }
                case 3198785: {
                    if (!var12_12.equals("help")) break;
                    var13_13 = 18;
                    break;
                }
                case 3127582: {
                    if (!var12_12.equals("exit")) break;
                    var13_13 = 19;
                    break;
                }
                case 113: {
                    if (!var12_12.equals("q")) break;
                    var13_13 = 20;
                    break;
                }
                case 3482191: {
                    if (!var12_12.equals("quit")) break;
                    var13_13 = 21;
                }
            }
            switch (var13_13) {
                case 0: 
                case 1: {
                    if (userInputList.length != 1) {
                        System.out.println("invalid, correct usage: up<>");
                        break;
                    }
                    if (this.currentNode.getParent().getParent() instanceof TopNode || this.currentNode.getParent() == null) {
                        System.out.println("Root Node has no parent");
                        break;
                    }
                    if (this.currentNode.getParent() == null) {
                        System.out.println("Null parent");
                        break;
                    }
                    this.nodeStack.push(this.currentNode);
                    this.currentNode = this.currentNode.getParent();
                    if (toggleNameDisplay) {
                        this.printName(this.currentNode);
                    }
                    cStack.pop();
                    if (!toggleCStackDisplay) continue block50;
                    cStack.show();
                    break;
                }
                case 2: 
                case 3: {
                    childNum = -1;
                    if (this.currentNode.getNode().hasForward()) {
                        System.out.println("can't go down on a forwarding node");
                        break;
                    }
                    if (userInputList.length != 1) ** GOTO lbl143
                    System.out.println("Which child?");
                    childNum = Debug.chooseFormList(inp, this.currentNode.undecorate().getProdleton().getChildTypes());
                    if (childNum == -1) {
                        break;
                    }
                    ** GOTO lbl152
lbl143:
                    // 1 sources

                    if (userInputList.length != 2) ** GOTO lbl150
                    try {
                        childNum = Integer.parseInt(userInputList[1]);
                        ** GOTO lbl152
                    }
                    catch (NumberFormatException e) {
                        System.out.println("invalid, correct usage: down <node #>");
                        break;
                    }
lbl150:
                    // 1 sources

                    System.out.println("invalid, correct usage: down <node #>");
                    break;
lbl152:
                    // 2 sources

                    if ((childNode = this.down(childNum)) == null) {
                        System.out.println("invalid child number");
                        break;
                    }
                    this.nodeStack.push(this.currentNode);
                    this.currentNode = childNode;
                    if (toggleNameDisplay) {
                        this.printName(this.currentNode);
                    }
                    cStack.push(this.currentNode);
                    if (!toggleCStackDisplay) continue block50;
                    cStack.show();
                    break;
                }
                case 4: {
                    if (userInputList.length != 1) {
                        System.out.println("invalid, correct usage: undo<>");
                        break;
                    }
                    if (this.nodeStack.empty()) {
                        System.out.println("invalid no node to undo");
                        break;
                    }
                    this.currentNode = newNode = this.nodeStack.pop();
                    if (toggleNameDisplay) {
                        this.printName(this.currentNode);
                    }
                    cStack.pop();
                    if (!toggleCStackDisplay) continue block50;
                    cStack.show();
                    break;
                }
                case 5: {
                    if (userInputList.length != 1) {
                        System.out.println("invalid, correct usage: forwards<>");
                        break;
                    }
                    childNode = this.forwards(this.currentNode);
                    if (childNode == null) {
                        System.out.println("invalid no node to forward");
                        break;
                    }
                    System.out.println("going forward");
                    this.currentNode = childNode;
                    if (toggleNameDisplay) {
                        this.printName(this.currentNode);
                    }
                    cStack.push(this.currentNode);
                    if (!toggleCStackDisplay) continue block50;
                    cStack.show();
                    break;
                }
                case 6: {
                    attributeNameinto = "";
                    attributeNuminto = 0;
                    attributeListinto = Debug.allAttributesList(this.currentNode);
                    if (userInputList.length != 1) ** GOTO lbl209
                    System.out.println("Which attribute?");
                    attriburteArrayinto = attributeListinto.toArray(new String[attributeListinto.size()]);
                    attributeNuminto = Debug.chooseFormList(inp, attriburteArrayinto);
                    if (attributeNuminto == -1) continue block50;
                    if (attributeNuminto >= attributeListinto.size()) {
                        System.out.println("Invaild attribute number");
                        break;
                    }
                    attributeNameinto = attributeListinto.get(attributeNuminto);
                    ** GOTO lbl222
lbl209:
                    // 1 sources

                    if (userInputList.length != 2) ** GOTO lbl220
                    try {
                        attributeNuminto = Integer.parseInt(userInputList[1]);
                        attributeNameinto = attributeListinto.get(attributeNuminto);
                        ** GOTO lbl222
                    }
                    catch (NumberFormatException e) {
                        System.out.println("invalid, correct usage: view <node #>");
                        break;
                    }
                    catch (IndexOutOfBoundsException e) {
                        System.out.println("Index out of bounds");
                        break;
                    }
lbl220:
                    // 1 sources

                    System.out.println("invalid, correct usage: into <node #>");
                    break;
lbl222:
                    // 2 sources

                    childNode = this.into(this.currentNode, attributeNameinto);
                    if (childNode == null) {
                        System.out.println("invalid input");
                        break;
                    }
                    System.out.println("going into");
                    this.currentNode = childNode;
                    break;
                }
                case 7: {
                    if (userInputList.length != 1) {
                        System.out.println("invalid, correct usage: backtrack<>");
                        break;
                    }
                    childNode = this.backtrack(this.currentNode);
                    if (childNode == null) {
                        System.out.println("invalid no node to backtrack to");
                        break;
                    }
                    System.out.println("going backwrds");
                    this.currentNode = childNode;
                    if (toggleNameDisplay) {
                        this.printName(this.currentNode);
                    }
                    cStack.pop();
                    if (!toggleCStackDisplay) continue block50;
                    cStack.show();
                    break;
                }
                case 8: {
                    toggelChoice = "";
                    if (userInputList.length == 1) {
                        toggelChoice = toggleChoices[Debug.chooseFormList(inp, toggleChoices)];
                    } else if (userInputList.length == 2) {
                        toggelChoice = userInputList[1];
                    }
                    if (toggelChoice.equals("prodDisplay")) {
                        if (toggleNameDisplay) {
                            System.out.println("Production Display off");
                            toggleNameDisplay = false;
                            break;
                        }
                        System.out.println("Production Display on");
                        toggleNameDisplay = true;
                        break;
                    }
                    if (toggelChoice.equals("fullAttributeNames")) {
                        if (toggleHeadlessAttributes) {
                            System.out.println("Headless Attributes off");
                            toggleHeadlessAttributes = false;
                            break;
                        }
                        System.out.println("Headless Attributes on");
                        toggleHeadlessAttributes = true;
                        break;
                    }
                    if (toggelChoice.equals("cStackDisplay")) {
                        if (toggleCStackDisplay) {
                            System.out.println("cStack Display off");
                            toggleCStackDisplay = false;
                            break;
                        }
                        System.out.println("cStack Display on");
                        toggleCStackDisplay = true;
                        break;
                    }
                    System.out.println("legal toggles: prodDisplay, fullAttributeNames, cStackDisplay");
                    break;
                }
                case 9: {
                    if (userInputList.length != 1) {
                        System.out.println("invalid, correct usage: prod<>");
                        break;
                    }
                    this.printProduction(this.currentNode);
                    break;
                }
                case 10: {
                    if (userInputList.length != 1 && userInputList.length != 2) {
                        System.out.println("invalid, correct usage: eq<attr?>");
                        break;
                    }
                    System.out.println("do the eq stuff");
                    break;
                }
                case 11: {
                    if (userInputList.length != 1 && userInputList.length != 2) {
                        System.out.println("invalid, correct usage: listSynth<node?>");
                        break;
                    }
                    if (this.listSynth(this.currentNode) != 0) continue block50;
                    System.out.println("no synthesized attributes");
                    break;
                }
                case 12: {
                    if (userInputList.length != 1 && userInputList.length != 2) {
                        System.out.println("invalid, correct usage: listInher <node?>");
                        break;
                    }
                    if (this.listInher(this.currentNode) != 0) continue block50;
                    System.out.println("no inherited attributes");
                    break;
                }
                case 13: 
                case 14: {
                    if (userInputList.length != 1 && userInputList.length != 2) {
                        System.out.println("invalid, correct usage: list<node?>");
                        break;
                    }
                    this.printAttributes(this.currentNode, toggleHeadlessAttributes);
                    break;
                }
                case 15: 
                case 16: {
                    attributeName = "";
                    attributeNum = 0;
                    attributeList = Debug.allAttributesList(this.currentNode);
                    if (userInputList.length != 1) ** GOTO lbl325
                    System.out.println("Which attribute?");
                    attriburteArray = attributeList.toArray(new String[attributeList.size()]);
                    attributeNum = Debug.chooseFormList(inp, attriburteArray);
                    if (attributeNum == -1) continue block50;
                    if (attributeNum >= attributeList.size()) {
                        System.out.println("Invaild attribute number");
                        break;
                    }
                    attributeName = attributeList.get(attributeNum);
                    ** GOTO lbl338
lbl325:
                    // 1 sources

                    if (userInputList.length != 2) ** GOTO lbl336
                    try {
                        attributeNum = Integer.parseInt(userInputList[1]);
                        attributeName = attributeList.get(attributeNum);
                        ** GOTO lbl338
                    }
                    catch (NumberFormatException e) {
                        System.out.println("invalid, correct usage: view <node #>");
                        break;
                    }
                    catch (IndexOutOfBoundsException e) {
                        System.out.println("Index out of bounds");
                        break;
                    }
lbl336:
                    // 1 sources

                    System.out.println("invalid, correct usage: view <node #>");
                    break;
lbl338:
                    // 2 sources

                    this.printAttrFromName(this.currentNode, attributeName);
                    break;
                }
                case 17: {
                    if (userInputList.length != 1 && userInputList.length != 2) {
                        System.out.println("invalid, correct usage: local <node?>");
                        break;
                    }
                    listLocals = Debug.getLocalAttrs(this.currentNode);
                    if (listLocals.size() == 0) {
                        System.out.println("no inherited attributes");
                        break;
                    }
                    var23_28 = listLocals.iterator();
                    while (true) {
                        if (!var23_28.hasNext()) continue block50;
                        localAttribute = var23_28.next();
                        System.out.println("Attribute = " + localAttribute);
                    }
                }
                case 18: {
                    if (userInputList.length == 1) {
                        System.out.println("call help with one of these keywords to see its functionality:");
                        System.out.println("toggle <feature>");
                        System.out.println("up");
                        System.out.println("down <node>");
                        System.out.println("view <attr>");
                        System.out.println("forwards");
                        System.out.println("backtrack");
                        System.out.println("prod");
                        System.out.println("eq");
                        System.out.println("listSynth");
                        System.out.println("listInher");
                        System.out.println("local");
                        System.out.println("list");
                        System.out.println("into");
                        System.out.println("exit");
                        break;
                    }
                    if (userInputList.length == 2) {
                        if (userInputList[1].equals("up")) {
                            System.out.println("The current node changes to its the parent");
                            break;
                        }
                        if (userInputList[1].equals("down")) {
                            System.out.println("The current node changes to its child");
                            System.out.println("One optional input is the child number you want to travel to");
                            System.out.println("If no input is provided you will be prompted with a choice of child");
                            System.out.println("You cn call this function with \"d\"");
                            break;
                        }
                        if (userInputList[1].equals("view")) {
                            System.out.println("look at the value of an attribute in the current node");
                            System.out.println("One optional input is the attribute number you want to view");
                            System.out.println("If no input is provided you will be prompted with a choice of attribute");
                            System.out.println("You can call this function with \"v\"");
                            break;
                        }
                        if (userInputList[1].equals("forwards")) {
                            System.out.println("The current node changes to its forward");
                            break;
                        }
                        if (userInputList[1].equals("backtrack")) {
                            System.out.println("The current node changes to its backtrack");
                            break;
                        }
                        if (userInputList[1].equals("prod")) {
                            System.out.println("prints the production of the current node");
                            break;
                        }
                        if (userInputList[1].equals("eq")) {
                            System.out.println("prints the equation of the current node");
                            break;
                        }
                        if (userInputList[1].equals("listSynth")) {
                            System.out.println("prints the Synthisized attributes of the current node");
                            break;
                        }
                        if (userInputList[1].equals("listInher")) {
                            System.out.println("prints the inherited attributes of the current node");
                            break;
                        }
                        if (userInputList[1].equals("list")) {
                            System.out.println("prints the attributes of the current node");
                            break;
                        }
                        if (userInputList[1].equals("local")) {
                            System.out.println("prints the local attributes of the current node");
                            break;
                        }
                        if (userInputList[1].equals("into")) {
                            System.out.println("The current node changes to its higer order attribute");
                            System.out.println("One optional input is the attribute number you want to go into");
                            System.out.println("If no input is provided you will be prompted with a choice of attribute");
                            break;
                        }
                        if (userInputList[1].equals("toggle")) {
                            System.out.println("Activate or disactivate a feature");
                            System.out.println("One input is the feature number you want to toggle");
                            System.out.println("If no input is provided you will be prompted with a choice of toggles");
                            break;
                        }
                        System.out.println("try just calling help");
                        break;
                    }
                    System.out.println("try just calling help");
                    break;
                }
                case 19: 
                case 20: 
                case 21: {
                    System.out.println("debugger out");
                    break block50;
                }
                default: {
                    System.out.println("invalid input call help for legal inputs");
                }
            }
        }
    }

    public void setCurrentNode(DecoratedNode node) {
        this.currentNodeSynthAttrs = null;
        this.currentNodeInhAttrs = null;
        this.currentNodeLocalAttrs = null;
        this.currentNode = node;
    }

    public DecoratedNode up() {
        if (this.currentNode.getParent() != null) {
            this.currentNode = this.currentNode.getParent();
            return this.currentNode;
        }
        return null;
    }

    public DecoratedNode down(int child) {
        String[] child_productions = this.currentNode.undecorate().getProdleton().getChildTypes();
        try {
            if (child_productions[child].equals("null")) {
                return null;
            }
            DecoratedNode childNode = this.currentNode.childDecorated(child);
            return childNode;
        }
        catch (NullPointerException e) {
            System.out.println("Null pointer");
            return null;
        }
        catch (IndexOutOfBoundsException e) {
            System.out.println("Index out of bound");
            return null;
        }
    }

    public void printChildren(DecoratedNode node) {
        String[] child_productions = node.undecorate().getProdleton().getChildTypes();
        for (int i = 0; i < child_productions.length; ++i) {
            System.out.println(Integer.toString(i) + ": " + child_productions[i] + " ");
        }
    }

    public DecoratedNode forwards(DecoratedNode node) {
        if (node.getNode().hasForward()) {
            this.currentNode = node.forward();
            return this.currentNode;
        }
        return null;
    }

    public DecoratedNode backtrack(DecoratedNode node) {
        this.currentNode = node.getForwardParent();
        return this.currentNode;
    }

    public void printProduction(DecoratedNode node) {
        String partent_production = node.undecorate().getProdleton().getTypeUnparse();
        String[] child_productions = node.undecorate().getProdleton().getChildTypes();
        System.out.print(partent_production + " ");
        for (int i = 0; i < child_productions.length; ++i) {
            System.out.print(child_productions[i] + " ");
        }
        System.out.print("\n");
    }

    public void printName(DecoratedNode node) {
        String name = node.undecorate().getProdleton().getName();
        System.out.println(name);
    }

    public void eqSynth(int attribute) {
    }

    public void eqInher(int attribute) {
    }

    public int listSynth(DecoratedNode node) {
        RTTIManager.Prodleton<? extends Node> prodleton = node.getNode().getProdleton();
        RTTIManager.Nonterminalton<? extends Node> nonterminalton = prodleton.getNonterminalton();
        Set<String> synAttrSet = nonterminalton.getAllSynth();
        int num_attr = 0;
        for (String synAttr : synAttrSet) {
            System.out.println("Attribute = " + synAttr);
            ++num_attr;
        }
        return num_attr;
    }

    public int listInher(DecoratedNode node) {
        RTTIManager.Prodleton<? extends Node> prodleton = node.getNode().getProdleton();
        RTTIManager.Nonterminalton<? extends Node> nonterminalton = prodleton.getNonterminalton();
        Set<String> inhAttrSet = nonterminalton.getAllInh();
        int num_attr = 0;
        for (String inhAttr : inhAttrSet) {
            System.out.println("Attribute = " + inhAttr);
            ++num_attr;
        }
        return num_attr;
    }

    public void printAttributes(DecoratedNode node, boolean toggleHeadlessAttributes) {
        List<String> attributeList = Debug.allAttributesList(node);
        if (toggleHeadlessAttributes) {
            attributeList = this.removeHeaders(Debug.allAttributesList(node));
        }
        int i = 0;
        for (String attribute : attributeList) {
            System.out.println(Integer.toString(i) + ": " + attribute);
            ++i;
        }
    }

    public List<String> removeHeaders(List<String> stringList) {
        ArrayList<String> headlessList = new ArrayList<String>();
        for (String element : stringList) {
            int lastIndex = element.lastIndexOf(":");
            if (lastIndex == -1) {
                headlessList.add(element);
                continue;
            }
            headlessList.add(element.substring(lastIndex + 1));
        }
        return headlessList;
    }

    public void printAttrFromName(DecoratedNode node, String printAttribute) {
        Map<String, Object> attributeMap = Debug.allAttributesObjectMap(node);
        System.out.println(Util.genericShow(attributeMap.get(printAttribute)));
    }

    public static List<String> getLocalAttrs(DecoratedNode node) {
        int count = node.getNode().getNumberOfLocalAttrs();
        ArrayList<String> listLocals = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            Lazy attribute = node.getNode().getLocal(i);
            Object o = attribute.eval(node);
            listLocals.add(node.getNode().getNameOfLocalAttr(i));
        }
        return listLocals;
    }

    public DecoratedNode into(DecoratedNode node, String attriburteName) {
        Map<String, Object> attributeMap = Debug.allAttributesObjectMap(node);
        if (attributeMap.containsKey(attriburteName)) {
            System.out.println("In into function");
            Object attributeObject = attributeMap.get(attriburteName);
            return (DecoratedNode)attributeObject;
        }
        return null;
    }

    public static List<String> allAttributesList(DecoratedNode node) {
        RTTIManager.Prodleton<? extends Node> prodleton = node.getNode().getProdleton();
        RTTIManager.Nonterminalton<? extends Node> nonterminalton = prodleton.getNonterminalton();
        List<String> attributeList = nonterminalton.alphabeticalAttributes();
        List<String> localAttributeList = Debug.getLocalAttrs(node);
        attributeList.addAll(localAttributeList);
        attributeList.sort(null);
        return attributeList;
    }

    public static Map<String, Object> allAttributesObjectMap(DecoratedNode node) {
        List<String> attributeList = Debug.allAttributesList(node);
        RTTIManager.Prodleton<? extends Node> prodleton = node.getNode().getProdleton();
        RTTIManager.Nonterminalton<? extends Node> nonterminalton = prodleton.getNonterminalton();
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        for (String attribute : attributeList) {
            Integer index;
            if (nonterminalton.getSynOccursIndices().keySet().contains(attribute)) {
                index = nonterminalton.getSynOccursIndex(attribute);
                Lazy synthAttribute = node.getNode().getSynthesized(index);
                Object o = synthAttribute.eval(node);
                attributeMap.put(attribute, o);
                continue;
            }
            if (nonterminalton.getInhOccursIndices().keySet().contains(attribute)) {
                index = nonterminalton.getInhOccursIndex(attribute);
                Object o = node.evalInhSomehowButPublic(index);
                attributeMap.put(attribute, o);
                continue;
            }
            List<String> listLocals = Debug.getLocalAttrs(node);
            Integer index2 = listLocals.indexOf(attribute);
            Lazy localAttribute = node.getNode().getLocal(index2);
            Object o = localAttribute.eval(node);
            attributeMap.put(attribute, o);
        }
        return attributeMap;
    }

    public static Integer chooseFormList(Scanner inp, String[] list) {
        for (int i = 0; i < list.length; ++i) {
            System.out.println(Integer.toString(i) + ": " + list[i]);
        }
        boolean continueLoop = true;
        int returnInt = -1;
        String stopper = "";
        while (continueLoop) {
            System.out.print(">DEBUGGER-PROMPT$");
            if (inp.hasNextInt()) {
                returnInt = inp.nextInt();
                inp.nextLine();
                continueLoop = false;
                continue;
            }
            stopper = inp.nextLine();
            if (stopper.equals("e")) {
                continueLoop = false;
                continue;
            }
            System.out.println("Please choose an integer or e to exit");
        }
        return returnInt;
    }

    public boolean isContractum(DecoratedNode node) {
        return node.getNode().hasForward();
    }

    public static class StringObjectPair {
        private String stringValue;
        private Object objectValue;

        public StringObjectPair(String stringValue, Object objectValue) {
            this.stringValue = stringValue;
            this.objectValue = objectValue;
        }

        public String getString() {
            return this.stringValue;
        }

        public Object getObject() {
            return this.objectValue;
        }
    }
}

