/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.ContextStack;
import common.Feature;
import common.NodeContextMessage;
import common.SimplifiedContextBox;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Stack;

public class SimplifiedContextStack {
    private ContextStack full_stack;
    private Stack<SimplifiedContextBox> simple_stack = new Stack();
    private boolean need_set_all_prods = true;
    private Production[] productions;
    private int[] partition = new int[this.full_stack.get_height()];

    public SimplifiedContextStack(ContextStack full_stack) {
        this.full_stack = full_stack;
    }

    public Stack<SimplifiedContextBox> getSimplifiedStack() {
        this.need_set_all_prods = true;
        this.makeSimplifiedStack();
        return this.simple_stack;
    }

    private void makeSimplifiedStack() {
        this.simple_stack = new Stack();
        this.fillInPartition();
        int prev_partition_index = -1;
        int start = 0;
        int end = -1;
        for (int i = 0; i < this.partition.length; ++i) {
            if (this.partition[i] > prev_partition_index) {
                SimplifiedContextBox sbox = this.makeSimplifiedBox(start, end);
                this.simple_stack.push(sbox);
                end = start = i;
                continue;
            }
            ++end;
        }
        SimplifiedContextBox sbox = this.makeSimplifiedBox(start, end);
        this.simple_stack.push(sbox);
    }

    private SimplifiedContextBox makeSimplifiedBox(int i, int j) {
        if (j > i) {
            System.out.println("Invalid Partition Indices: " + i + ", " + j);
            return null;
        }
        SimplifiedContextBox sbox = new SimplifiedContextBox();
        NodeContextMessage first = this.full_stack.get(i);
        NodeContextMessage last = this.full_stack.get(j);
        sbox.translation_x = first.getTranslationX();
        sbox.higher_order_y = first.getHigherOrderY();
        sbox.text_syntax = first.getTextRepr();
        sbox.syntax_to_highlight = last.getTextRepr();
        this.SetAllProds();
        sbox.prods_visited = Arrays.copyOfRange(this.productions, i, j + 1);
        sbox.features = new ArrayList<Feature>();
        this.fillInFeaturesList(sbox, i, j);
        return sbox;
    }

    private void fillInFeaturesList(SimplifiedContextBox sbox, int i, int j) {
        for (int k = i; k <= j; ++k) {
            Feature f;
            String targetName;
            String nodeName;
            NodeContextMessage node = this.full_stack.get(k);
            if (node.isRedex()) {
                nodeName = this.productions[k].toString();
                targetName = "";
                if (k < j) {
                    targetName = this.productions[k + 1].toString();
                }
                f = new Feature(nodeName, "redex", targetName);
                sbox.features.add(f);
            }
            if (node.isContractum()) {
                nodeName = this.productions[k].toString();
                targetName = "";
                if (k > 0) {
                    targetName = this.productions[k - 1].toString();
                }
                f = new Feature(nodeName, "contractum", targetName);
                sbox.features.add(f);
            }
            if (node.isNew()) {
                nodeName = this.productions[k].toString();
                Feature f2 = new Feature(nodeName, "new");
                sbox.features.add(f2);
            }
            if (!node.isAttributeRoot()) continue;
            nodeName = this.productions[k].toString();
            targetName = "";
            if (k > 0) {
                targetName = this.productions[k - 1].toString();
            }
            f = new Feature(nodeName, "attribute root", targetName);
            sbox.features.add(f);
        }
    }

    private void SetAllProds() {
        int prod_index;
        if (!this.need_set_all_prods) {
            return;
        }
        Production[] all_prods = new Production[this.full_stack.get_height()];
        for (int index = 0; index < this.full_stack.get_height(); ++index) {
            all_prods[index].name = this.full_stack.get(index).getProdName();
            all_prods[index].index = -1;
        }
        for (prod_index = 0; prod_index < all_prods.length; ++prod_index) {
            int seq_num = 1;
            String name = all_prods[prod_index].name;
            for (int visit_index = 0; visit_index < prod_index; ++visit_index) {
                String cur_name = all_prods[visit_index].name;
                if (cur_name.compareTo(name) != 0) continue;
                ++seq_num;
            }
            all_prods[prod_index].index = seq_num;
        }
        for (prod_index = 0; prod_index < all_prods.length; ++prod_index) {
            if (all_prods[prod_index].index != 1) continue;
            boolean is_unique = true;
            for (int k = 0; k < all_prods.length; ++k) {
                if (k == prod_index || all_prods[k].name.compareTo(all_prods[prod_index].name) != 0) continue;
                is_unique = false;
                break;
            }
            if (!is_unique) continue;
            all_prods[prod_index].index = 0;
        }
        this.productions = all_prods;
        this.need_set_all_prods = false;
    }

    private void fillInPartition() {
        this.partition = new int[this.full_stack.get_height()];
        int previous_x = 0;
        int previous_y = 0;
        int partition_index = 0;
        for (int i = 0; i < this.full_stack.get_height(); ++i) {
            NodeContextMessage node = this.full_stack.get(0);
            int cur_x = node.getTranslationX();
            int cur_y = node.getHigherOrderY();
            if (cur_x == previous_x && cur_y == previous_y) {
                this.partition[i] = partition_index;
                continue;
            }
            previous_x = cur_x;
            previous_y = cur_y;
            this.partition[i] = ++partition_index;
        }
    }

    public static class Production {
        public String name;
        public int index;

        public Production(String name, int index) {
            this.name = name;
            this.index = index;
        }

        public String toString() {
            if (this.index == 0) {
                return this.name;
            }
            return this.name + " (" + this.index + ")";
        }
    }
}

