/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.DecoratedNode;
import common.Lazy;
import common.exceptions.CycleException;
import common.exceptions.CycleTraceException;

public class Thunk<T> {
    private Object o;
    private int demanded = 0;

    public Thunk(Evaluable<T> e) {
        assert (e != null);
        this.o = e;
    }

    public T eval() {
        if (this.o instanceof Evaluable) {
            ++this.demanded;
            if (this.demanded > 1) {
                throw new CycleException("Cycle detected in execution");
            }
            try {
                this.o = ((Evaluable)this.o).eval();
            }
            catch (Throwable t) {
                this.handleEvalError(t);
            }
            assert (this.o != null);
        }
        return (T)this.o;
    }

    private void handleEvalError(Throwable t) {
        if (this.demanded > 1) {
            throw new CycleTraceException("Cycle begins here", t);
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new RuntimeException(t);
    }

    public static Thunk<Object> fromLazy(Lazy l, DecoratedNode ctx) {
        return new Thunk<Object>(() -> l.eval(ctx));
    }

    public static Object transformUndecorate(Object t) {
        if (t instanceof DecoratedNode) {
            return ((DecoratedNode)t).undecorate();
        }
        return Thunk.transformUndecorateThunk((Thunk)t);
    }

    private static Object transformUndecorateThunk(Thunk<DecoratedNode> t) {
        if (t.o instanceof Evaluable) {
            return new Thunk<Object>(() -> ((DecoratedNode)t.eval()).undecorate());
        }
        return t.eval().undecorate();
    }

    public static interface Evaluable<T> {
        public T eval();
    }
}

