/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.logging.messages;

import edu.umn.cs.melt.copper.compiletime.logging.CompilerLevel;
import edu.umn.cs.melt.copper.compiletime.logging.CompilerLogMessage;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.GrammarStatistics;

public class FinalReportMessage
implements CompilerLogMessage {
    private GrammarStatistics stats;

    public FinalReportMessage(GrammarStatistics stats) {
        this.stats = stats;
    }

    @Override
    public CompilerLevel getLevel() {
        return CompilerLevel.REGULAR;
    }

    @Override
    public int getType() {
        return 15;
    }

    @Override
    public boolean isError() {
        return false;
    }

    @Override
    public boolean isFatalError() {
        return false;
    }

    @Override
    public String toString() {
        StringBuffer rv = new StringBuffer();
        rv.append("-------------\nFinal report:\n-------------\n");
        rv.append("Parser and scanner specification\n   has " + this.stats.terminalCount + " terminal" + (this.stats.terminalCount == 1 ? "" : "s") + ", " + this.stats.nonterminalCount + " nonterminal" + (this.stats.nonterminalCount == 1 ? "" : "s") + ", " + this.stats.productionCount + " production" + (this.stats.productionCount == 1 ? "" : "s") + ",\n   and " + this.stats.disambiguationFunctionCount + " disambiguation function" + (this.stats.disambiguationFunctionCount == 1 ? "" : "s") + " declared,\n");
        rv.append("   producing " + this.stats.parseStateCount + " unique parse state" + (this.stats.parseStateCount == 1 ? "" : "s") + "\n");
        rv.append("   and " + this.stats.scannerStateCount + " unique scanner state" + (this.stats.scannerStateCount == 1 ? "" : "s") + ".\n");
        rv.append(this.stats.uselessNTs.cardinality() + " useless nonterminal" + (this.stats.uselessNTs.cardinality() == 1 ? "" : "s") + ".\n");
        rv.append(this.stats.malformedRegexTerminals.cardinality() + " malformed regex" + (this.stats.malformedRegexTerminals.cardinality() == 1 ? "" : "es") + ".\n");
        if (this.stats.parseTableConflictCount == 0) {
            rv.append("No parse table conflicts detected.\n");
        } else {
            rv.append(this.stats.unresolvedParseTableConflictCount + " unresolved parse table conflict" + (this.stats.unresolvedParseTableConflictCount == 1 ? "" : "s") + ":\n   " + this.stats.shiftReduceParseTableConflictCount + " shift/reduce conflict" + (this.stats.shiftReduceParseTableConflictCount == 1 ? "" : "s") + ", " + this.stats.reduceReduceParseTableConflictCount + " reduce/reduce, " + (this.stats.parseTableConflictCount - this.stats.unresolvedParseTableConflictCount) + " resolved.\n");
        }
        if (this.stats.lexicalAmbiguityCount == 0) {
            rv.append("No lexical ambiguities detected.");
        } else {
            int unresolvedLexicalAmbiguityCount = this.stats.lexicalAmbiguityCount - (this.stats.contextResolvedLexicalAmbiguityCount + this.stats.disambiguationFunctionResolvedLexicalAmbiguityCount);
            rv.append(unresolvedLexicalAmbiguityCount + " unresolved lexical ambiguit" + (unresolvedLexicalAmbiguityCount == 1 ? "y" : "ies") + ":\n");
            rv.append("   " + this.stats.contextResolvedLexicalAmbiguityCount + " resolved by context, " + this.stats.disambiguationFunctionResolvedLexicalAmbiguityCount + " by disambiguation function/group.");
        }
        if (this.stats.codeOutput) {
            rv.append("\nParser code output to ").append(this.stats.codeOutputTo).append(".");
        } else {
            rv.append("\nNo parser code output.");
        }
        if (this.stats.mdaRun) {
            rv.append("\n----------\nModular determinism analysis " + (this.stats.mdaPassed ? "passed" : "failed") + ".\n");
            rv.append(this.stats.followSpilledNTCount + " nonterminal" + (this.stats.followSpilledNTCount == 1 ? "" : "s") + " with follow spillage.\n");
            rv.append("Composed parser has " + this.stats.hostStateCount + " host state" + (this.stats.hostStateCount == 1 ? "" : "s") + ", " + this.stats.extStateCount + " extension state" + (this.stats.extStateCount == 1 ? "" : "s") + ",\n");
            rv.append(this.stats.newHostStateCount + " new-host state" + (this.stats.newHostStateCount == 1 ? "" : "s") + ", and " + this.stats.unpartitionableStateCount + " unpartitionable state" + (this.stats.unpartitionableStateCount == 1 ? "" : "s") + ".");
        }
        return rv.toString();
    }
}

