/*
 * Decompiled with CFR 0.152.
 */
package common.rawlib;

import common.ConsCell;
import common.NodeFactory;
import common.javainterop.ConsCellCollection;
import common.javainterop.SilverComparator;
import java.util.TreeMap;
import silver.core.NPair;
import silver.core.Ppair;

public final class RawTreeMap {
    public static TreeMap<Object, ConsCell> empty(NodeFactory<Integer> cmp) {
        return new TreeMap<Object, ConsCell>(new SilverComparator(cmp));
    }

    public static TreeMap<Object, ConsCell> addList(ConsCell l, TreeMap<Object, ConsCell> t) {
        if (l.nil()) {
            return t;
        }
        TreeMap ret = (TreeMap)t.clone();
        for (NPair elem : new ConsCellCollection(l)) {
            assert (elem instanceof Ppair);
            ConsCell existing = RawTreeMap.lookup(elem.getChild(0), ret);
            ret.put(elem.getChild(0), new ConsCell(elem.getChild(1), existing));
        }
        return ret;
    }

    public static ConsCell keys(TreeMap<Object, ConsCell> t) {
        ConsCell ret = ConsCell.nil;
        for (Object key : t.descendingKeySet()) {
            ret = new ConsCell(key, ret);
        }
        return ret;
    }

    public static ConsCell toList(TreeMap<Object, ConsCell> t) {
        ConsCell ret = ConsCell.nil;
        for (Object key : t.descendingKeySet()) {
            for (Object value : new ConsCellCollection(t.get(key))) {
                ret = new ConsCell(new Ppair(key, value), ret);
            }
        }
        return ret;
    }

    public static ConsCell lookup(Object k, TreeMap<Object, ConsCell> t) {
        ConsCell r = t.get(k);
        return r == null ? ConsCell.nil : r;
    }

    public static TreeMap<Object, ConsCell> update(Object k, ConsCell v, TreeMap<Object, ConsCell> t) {
        TreeMap ret = (TreeMap)t.clone();
        ret.put(k, v);
        return ret;
    }
}

