/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.CodeProberDiagnostic;
import common.CollectionAttribute;
import common.ConsCell;
import common.DataNode;
import common.Decorable;
import common.DecoratedTypeRep;
import common.FunctionNode;
import common.Lazy;
import common.Node;
import common.OriginContext;
import common.Thunk;
import common.TopNode;
import common.Tracked;
import common.TransInhs;
import common.TransOccursInfo;
import common.Typed;
import common.Util;
import common.exceptions.MissingDefinitionException;
import common.exceptions.SilverException;
import common.exceptions.SilverInternalError;
import common.exceptions.TraceException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import silver.core.Alocation;
import silver.core.Init;
import silver.core.NLocation;
import silver.core.NMaybe;
import silver.core.PgetOriginNotesString;
import silver.core.PgetParsedOriginLocation;
import silver.core.Pjust;

public class DecoratedNode
implements Decorable,
Typed {
    public OriginContext originCtx;
    protected final Node self;
    protected DecoratedNode forwardParent;
    protected DecoratedNode parent;
    protected boolean isProdForward;
    protected final DecoratedNode[] childrenValues;
    protected DecoratedNode forwardValue;
    protected final Object[] inheritedValues;
    protected final Object[] synthesizedValues;
    protected Lazy[] inheritedAttributes;
    protected Lazy decorationSite;
    protected final Object[] localValues;
    private static String cprMainFilePath = null;
    private boolean hasLocs = false;
    private boolean isInMainFile = false;
    private boolean isInMainFileSet = false;
    private int startLine = 0;
    private int startColumn = 0;
    private int endLine = 0;
    private int endColumn = 0;

    DecoratedNode(int cc, int ic, int sc, int lc, Node self, DecoratedNode parent, Lazy[] inhs, DecoratedNode forwardParent, boolean isProdForward, Lazy decorationSite) {
        this.self = self;
        this.parent = parent;
        this.originCtx = parent != null ? parent.originCtx : null;
        this.forwardParent = forwardParent;
        this.isProdForward = isProdForward;
        this.decorationSite = decorationSite;
        this.inheritedAttributes = inhs != null && inhs.length < ic ? Arrays.copyOf(inhs, ic) : inhs;
        this.childrenValues = cc > 0 ? new DecoratedNode[cc] : null;
        this.inheritedValues = ic > 0 ? new Object[ic] : null;
        this.synthesizedValues = sc > 0 ? new Object[sc] : null;
        this.localValues = lc > 0 ? new Object[lc] : null;
    }

    DecoratedNode(int cc, int lc, FunctionNode self) {
        this.self = self;
        this.parent = TopNode.singleton;
        this.inheritedAttributes = null;
        this.forwardParent = null;
        this.isProdForward = false;
        this.childrenValues = new DecoratedNode[cc];
        this.inheritedValues = null;
        this.synthesizedValues = null;
        this.localValues = lc > 0 ? new Object[lc] : null;
    }

    public final Node undecorate() {
        if (this.self.isUnique) {
            return this.self.undecorate(this);
        }
        return this.self;
    }

    @Override
    public DecoratedNode decorate(DecoratedNode parent, Lazy[] inhs, Lazy decSite) {
        if (this.forwardParent == null && !(parent instanceof TopNode)) {
            if (inhs != null) {
                this.inheritedAttributes = this.inheritedAttributes == null ? new Lazy[this.self.getNumberOfInhAttrs()] : (Lazy[])this.inheritedAttributes.clone();
                this.copyInhOverrides(parent, this.inheritedAttributes, inhs);
            }
            this.decorationSite = decSite != null ? decSite.withContext(parent) : null;
        }
        return this;
    }

    private void copyInhOverrides(DecoratedNode parent, Lazy[] inhs, Lazy[] newInhs) {
        assert (inhs.length >= newInhs.length);
        for (int i = 0; i < newInhs.length; ++i) {
            if (newInhs[i] == null) continue;
            Lazy newInh = newInhs[i].withContext(parent);
            if (inhs[i] == null) {
                inhs[i] = newInh;
                continue;
            }
            if (!(inhs[i] instanceof TransInhs)) continue;
            assert (newInhs[i] instanceof TransInhs);
            this.copyInhOverrides(parent, ((TransInhs)inhs[i]).inhs, ((TransInhs)newInh).inhs);
        }
    }

    @Override
    public DecoratedNode decorate(DecoratedNode parent, Lazy[] inhs, DecoratedNode fwdParent, boolean prodFwrd) {
        if (this.forwardParent == null) {
            this.decorate(parent, inhs, null);
            this.forwardParent = fwdParent;
            this.isProdForward = prodFwrd;
        }
        return this;
    }

    public final Node getNode() {
        return this.self;
    }

    public final DecoratedNode getForwardParent() {
        if (this.forwardParent == null) {
            throw new SilverInternalError("Attempted to access forwardParent of " + this.getDebugID() + ", which is not a forward tree.");
        }
        return this.forwardParent;
    }

    public Object child(int child) {
        if (this.self.isChildDecorable(child)) {
            return this.childDecorated(child);
        }
        return this.childAsIs(child);
    }

    public <T> T childAsIs(int child) {
        return (T)this.self.getChild(child);
    }

    public DecoratedNode childDecorated(int child) {
        DecoratedNode o = this.childrenValues[child];
        if (o == null) {
            o = this.createDecoratedChild(child);
            assert (o != null);
            this.childrenValues[child] = o;
        }
        return o;
    }

    private final DecoratedNode createDecoratedChild(int child) {
        assert (this.self.isChildDecorable(child));
        return ((Decorable)this.self.getChild(child)).decorate(this, this.self.getChildInheritedAttributes(child), this.self.getChildDecSite(child));
    }

    public Object local(int attribute) {
        if (this.self.isLocalDecorable(attribute)) {
            return this.localDecorated(attribute);
        }
        return this.localAsIs(attribute);
    }

    public <T> T localAsIs(int attribute) {
        Object o = this.localValues[attribute];
        if (o == null) {
            o = this.evalLocalAsIs(attribute);
            assert (o != null);
            this.localValues[attribute] = o;
        }
        return (T)o;
    }

    private final Object evalLocalAsIs(int attribute) {
        try {
            return this.self.getLocal(attribute).eval(this);
        }
        catch (Throwable t) {
            throw this.handleLocalError(attribute, t);
        }
    }

    private final SilverException handleLocalError(int attribute, Throwable t) {
        if (this.self.getLocal(attribute) == null) {
            return new MissingDefinitionException("Local '" + this.self.getNameOfLocalAttr(attribute) + "' not defined in " + this.getDebugID());
        }
        return new TraceException("While evaling local '" + this.self.getNameOfLocalAttr(attribute) + "' in " + this.getDebugID(), t);
    }

    public DecoratedNode localDecorated(int attribute) {
        Object o = this.localValues[attribute];
        if (o == null) {
            o = this.evalLocalDecorated(attribute);
            assert (o != null);
            this.localValues[attribute] = o;
        }
        return (DecoratedNode)o;
    }

    private final DecoratedNode evalLocalDecorated(int attribute) {
        assert (this.self.isLocalDecorable(attribute));
        Decorable localAsIs = (Decorable)this.evalLocalAsIs(attribute);
        Lazy[] inhs = this.self.getLocalInheritedAttributes(attribute);
        if (this.self.getLocalIsForward(attribute)) {
            return localAsIs.decorate(this, inhs, this, false);
        }
        return localAsIs.decorate(this, inhs, this.self.getLocalDecSite(attribute));
    }

    public <T> T synthesized(int attribute) {
        Object o = this.synthesizedValues[attribute];
        if (o == null) {
            o = this.evalSyn(attribute);
            assert (o != null);
            this.synthesizedValues[attribute] = o;
        }
        return (T)o;
    }

    private final Object evalSyn(int attribute) {
        Lazy l = this.self.getSynthesized(attribute);
        if (l != null) {
            try {
                if (l instanceof CollectionAttribute) {
                    CollectionAttribute prodAttr = (CollectionAttribute)l;
                    if (!prodAttr.appliedNTFix) {
                        prodAttr.appliedNTFix = true;
                        CollectionAttribute ntAttr = (CollectionAttribute)this.self.getDefaultSynthesized(attribute);
                        if (ntAttr != null) {
                            prodAttr.getPieces().addAll(ntAttr.getPieces());
                        }
                    }
                }
                return l.eval(this);
            }
            catch (Throwable t) {
                throw new TraceException("While evaling syn '" + this.self.getNameOfSynAttr(attribute) + "' in " + this.getDebugID(), t);
            }
        }
        if (this.self.hasForward()) {
            try {
                return this.forward().synthesized(attribute);
            }
            catch (Throwable t) {
                throw new TraceException("While evaling syn '" + this.self.getNameOfSynAttr(attribute) + "' via forward in " + this.getDebugID(), t);
            }
        }
        l = this.self.getDefaultSynthesized(attribute);
        if (l != null) {
            try {
                return l.eval(this);
            }
            catch (Throwable t) {
                throw new TraceException("While evaling default for syn '" + this.self.getNameOfSynAttr(attribute) + "' in " + this.getDebugID(), t);
            }
        }
        throw new MissingDefinitionException("Synthesized attribute '" + this.self.getNameOfSynAttr(attribute) + "' not defined in " + this.getDebugID());
    }

    public DecoratedNode translation(int attribute, int inhsAttribute, int decSiteAttribute) {
        DecoratedNode o = (DecoratedNode)this.synthesizedValues[attribute];
        if (o == null) {
            o = this.evalTrans(attribute, inhsAttribute, decSiteAttribute);
            assert (o != null);
            this.synthesizedValues[attribute] = o;
        }
        return o;
    }

    private final DecoratedNode evalTrans(int attribute, int inhsAttribute, int decSiteAttribute) {
        Decorable d;
        Lazy l = this.self.getSynthesized(attribute);
        if (l != null) {
            try {
                d = (Decorable)l.eval(this);
            }
            catch (Throwable t) {
                throw new TraceException("While evaling trans '" + this.self.getNameOfSynAttr(attribute) + "' in " + this.getDebugID(), t);
            }
        } else if (this.self.hasForward()) {
            try {
                d = this.forward().translation(attribute, inhsAttribute, decSiteAttribute);
            }
            catch (Throwable t) {
                throw new TraceException("While evaling trans '" + this.self.getNameOfSynAttr(attribute) + "' via forward in " + this.getDebugID(), t);
            }
        } else {
            l = this.self.getDefaultSynthesized(attribute);
            if (l != null) {
                try {
                    d = (Decorable)l.eval(this);
                }
                catch (Throwable t) {
                    throw new TraceException("While evaling default for trans '" + this.self.getNameOfSynAttr(attribute) + "' in " + this.getDebugID(), t);
                }
            } else {
                throw new MissingDefinitionException("Translation attribute '" + this.self.getNameOfSynAttr(attribute) + "' not defined in " + this.getDebugID());
            }
        }
        while (this.decorationSite != null) {
            Object decSiteTree;
            Lazy decSite = this.decorationSite;
            this.decorationSite = null;
            try {
                decSiteTree = decSite.eval(this.parent);
            }
            catch (Throwable t) {
                throw new TraceException("While evaling decoration of trans '" + this.self.getNameOfSynAttr(attribute) + "' via decoration site of " + this.getDebugID() + " in " + this.parent.getDebugID(), t);
            }
            if (this == decSiteTree) continue;
            throw new SilverInternalError("Decoration site for " + this.getDebugID() + " returned a different tree: " + decSiteTree.toString());
        }
        Lazy[] inhs = null;
        if (this.inheritedAttributes != null && this.inheritedAttributes[inhsAttribute] != null) {
            if (this.inheritedAttributes[inhsAttribute] instanceof TransInhs) {
                inhs = ((TransInhs)this.inheritedAttributes[inhsAttribute]).withContext((DecoratedNode)this.parent).inhs;
            } else {
                throw new SilverInternalError("Supplied trans inhs attribute not TransInhs!");
            }
        }
        Lazy decSite = null;
        if (this.inheritedAttributes != null && this.inheritedAttributes[decSiteAttribute] != null) {
            decSite = this.inheritedAttributes[decSiteAttribute].withContext(this.parent);
        } else if (this.forwardParent != null && this.isProdForward && this.forwardParent.synthesizedValues[attribute] == null) {
            decSite = context -> this.forwardParent.translation(attribute, inhsAttribute, decSiteAttribute);
        }
        return d.decorate(this, inhs, decSite);
    }

    public Object synthesizedOrTranslation(int attribute) {
        TransOccursInfo transOccurs = this.self.getTransOccurs(attribute);
        if (transOccurs == null) {
            return this.synthesized(attribute);
        }
        return this.translation(attribute, transOccurs.inhsAttribute, transOccurs.decSiteAttribute);
    }

    public DecoratedNode forward() {
        if (this.forwardValue == null) {
            this.forwardValue = this.evalForward();
            assert (this.forwardValue != null);
        }
        return this.forwardValue;
    }

    public DecoratedNode forwardOrThis() {
        return this.self.hasForward() ? this.forward() : this;
    }

    private final DecoratedNode evalForward() {
        try {
            return this.self.evalForward(this).decorate(this, this.self.getForwardInheritedAttributes(), this, true);
        }
        catch (Throwable t) {
            throw this.handleFwdError(t);
        }
    }

    private final RuntimeException handleFwdError(Throwable t) {
        return new TraceException("While evaling forward equation in " + this.getDebugID(), t);
    }

    public <T> T inherited(int attribute) {
        Object o = this.inheritedValues[attribute];
        if (o == null) {
            o = this.evalInhSomehow(attribute);
            assert (o != null);
            this.inheritedValues[attribute] = o;
        }
        return (T)o;
    }

    private final Object evalInhSomehow(int attribute) {
        if (this.inheritedAttributes != null && this.inheritedAttributes[attribute] != null) {
            return this.evalInhHere(attribute);
        }
        return this.evalInhViaDecSiteOrFwrd(attribute);
    }

    private final Object evalInhViaDecSiteOrFwrd(int attribute) {
        if (this.decorationSite != null) {
            return this.evalInhViaDecSite(attribute);
        }
        return this.evalInhViaFwdP(attribute);
    }

    private final Object evalInhViaDecSite(int attribute) {
        Object decSiteTree;
        Lazy decSite = this.decorationSite;
        this.decorationSite = null;
        try {
            decSiteTree = decSite.eval(this.parent);
        }
        catch (Throwable t) {
            throw new TraceException("While evaling inh '" + this.self.getNameOfInhAttr(attribute) + "' via decoration site of " + this.getDebugID() + " in " + this.parent.getDebugID(), t);
        }
        if (this != decSiteTree) {
            throw new SilverInternalError("Decoration site for " + this.getDebugID() + " returned a different tree: " + decSiteTree.toString());
        }
        return this.evalInhSomehow(attribute);
    }

    private final Object evalInhViaFwdP(int attribute) {
        try {
            return this.forwardParent.inherited(attribute);
        }
        catch (Throwable t) {
            throw this.handleInhFwdPError(attribute, t);
        }
    }

    private final SilverException handleInhFwdPError(int attribute, Throwable t) {
        if (this.forwardParent == null) {
            return new MissingDefinitionException("Inherited attribute '" + this.self.getNameOfInhAttr(attribute) + "' not provided to " + this.getDebugID() + " by " + this.parent.getDebugID());
        }
        return new TraceException("While evaling inh '" + this.self.getNameOfInhAttr(attribute) + "' via forward in " + this.getDebugID(), t);
    }

    private final Object evalInhHere(int attribute) {
        try {
            return this.inheritedAttributes[attribute].eval(this.parent);
        }
        catch (Throwable t) {
            throw this.handleInhHereError(attribute, t);
        }
    }

    private final SilverException handleInhHereError(int attribute, Throwable t) {
        return new TraceException("While evaling inh '" + this.self.getNameOfInhAttr(attribute) + "' in " + this.getDebugID(), t);
    }

    public final Object childDecoratedLazy(int child) {
        if (this.childrenValues[child] != null) {
            return this.childrenValues[child];
        }
        return new Thunk<Object>(() -> this.childDecorated(child));
    }

    public final Object childUndecoratedLazy(int child) {
        return new Thunk<Object>(() -> this.childDecorated(child).undecorate());
    }

    public final Object childAsIsLazy(int child) {
        return this.self.getChildLazy(child);
    }

    public final Object localLazy(int index) {
        if (this.localValues[index] != null) {
            return this.localValues[index];
        }
        return new Thunk<Object>(() -> this.local(index));
    }

    public final Object localDecoratedLazy(int index) {
        if (this.localValues[index] != null) {
            return this.localValues[index];
        }
        return new Thunk<Object>(() -> this.localDecorated(index));
    }

    public final Object localAsIsLazy(int index) {
        if (this.localValues[index] != null) {
            return this.localValues[index];
        }
        return new Thunk<Object>(() -> this.localAsIs(index));
    }

    public final Object childDecoratedSynthesizedLazy(int child, int index) {
        DecoratedNode v = this.childrenValues[child];
        if (v != null) {
            return v.contextSynthesizedLazy(index);
        }
        return new Thunk<Object>(() -> this.childDecorated(child).synthesized(index));
    }

    public final Object childAsIsSynthesizedLazy(int child, int index) {
        Object v = this.self.getChildLazy(child);
        if (!(v instanceof Thunk)) {
            return ((DecoratedNode)v).contextSynthesizedLazy(index);
        }
        return new Thunk<Object>(() -> ((DecoratedNode)this.childAsIs(child)).synthesized(index));
    }

    public final Object contextSynthesizedLazy(int index) {
        if (this.synthesizedValues[index] != null) {
            return this.synthesizedValues[index];
        }
        return new Thunk<Object>(() -> this.synthesized(index));
    }

    public final Object contextInheritedLazy(int index) {
        if (this.inheritedValues[index] != null) {
            return this.inheritedValues[index];
        }
        return new Thunk<Object>(() -> this.inherited(index));
    }

    @Override
    public final DecoratedTypeRep getType() {
        return new DecoratedTypeRep(this.self.getType());
    }

    public final String getDebugID() {
        if (this.self == null) {
            return "<top>";
        }
        NLocation loc = null;
        String notes = "";
        if (this.self instanceof Alocation) {
            loc = ((Alocation)((Object)this.self)).getAnno_silver_core_location();
        } else if (this.self instanceof Tracked) {
            NMaybe maybeLoc = PgetParsedOriginLocation.invoke(OriginContext.FFI_CONTEXT, this.self);
            if (maybeLoc instanceof Pjust) {
                loc = (NLocation)maybeLoc.getChild(0);
            }
            notes = PgetOriginNotesString.invoke(OriginContext.FFI_CONTEXT, this.self).toString();
        }
        Object qualifier = Integer.toHexString(System.identityHashCode(this));
        if (loc != null) {
            String file = loc.synthesized(Init.silver_core_filename__ON__silver_core_Location).toString();
            int line = (Integer)loc.synthesized(Init.silver_core_line__ON__silver_core_Location);
            int col = (Integer)loc.synthesized(Init.silver_core_column__ON__silver_core_Location);
            qualifier = (String)qualifier + ", " + file + ":" + Integer.toString(line) + ":" + Integer.toString(col);
        }
        if (!notes.isEmpty()) {
            qualifier = (String)qualifier + ", " + notes;
        }
        return "'" + this.self.getName() + "' (" + (String)qualifier + ")";
    }

    public final String toString() {
        return this.getDebugID();
    }

    public int getNumChild() {
        int res = 0;
        for (int i = 0; i < this.self.getNumberOfChildren(); ++i) {
            if (!this.isChildTree(i)) continue;
            ++res;
        }
        return res;
    }

    public DecoratedNode getChild(int idx) {
        int i = 0;
        while (!this.isChildTree(i)) {
            ++i;
        }
        for (int j = 0; j < idx; ++j) {
            ++i;
            while (!this.isChildTree(i)) {
                ++i;
            }
        }
        if (this.self.getChild(i) instanceof DataNode) {
            return this.decorateDataNode((DataNode)this.self.getChild(i));
        }
        return this.childDecorated(i);
    }

    private boolean isChildTree(int idx) {
        return this.self.isChildDecorable(idx) || this.self.getChild(idx) instanceof DataNode;
    }

    private DecoratedNode decorateDataNode(DataNode d) {
        DecoratedNode dn = d.decorate();
        if (dn.parent == TopNode.singleton) {
            dn.parent = this;
        }
        return dn;
    }

    public DecoratedNode getParent() {
        if (this.parent instanceof TopNode || this.parent.self instanceof FunctionNode) {
            return null;
        }
        return this.parent;
    }

    public static void setCprMainFilePath(String path) {
        cprMainFilePath = path;
    }

    public void setIsInMainFile(boolean isInMainFile) {
        this.isInMainFile = isInMainFile;
        this.isInMainFileSet = true;
        int nc = this.getNumChild();
        for (int i = 0; i < nc; ++i) {
            this.getChild(i).setIsInMainFile(isInMainFile);
        }
    }

    private final void determineLocs() {
        if (this.hasLocs) {
            return;
        }
        this.hasLocs = true;
        DataNode loc = null;
        if (cprMainFilePath == null) {
            throw new SilverInternalError("Code Prober main file path not set!");
        }
        if (this.self != null) {
            NMaybe maybeLoc;
            if (this.self instanceof Alocation) {
                loc = ((Alocation)((Object)this.self)).getAnno_silver_core_location();
            } else if (this.self instanceof Tracked && (maybeLoc = PgetParsedOriginLocation.invoke(OriginContext.FFI_CONTEXT, this.self)) instanceof Pjust) {
                loc = (NLocation)maybeLoc.getChild(0);
            }
        }
        if (loc != null) {
            String fileName = loc.synthesized(Init.silver_core_filename__ON__silver_core_Location).toString();
            if (!this.isInMainFileSet) {
                this.isInMainFile = cprMainFilePath.equals(fileName);
            }
            if (this.isInMainFile) {
                this.startLine = (Integer)loc.synthesized(Init.silver_core_line__ON__silver_core_Location);
                this.startColumn = (Integer)loc.synthesized(Init.silver_core_column__ON__silver_core_Location);
                this.endLine = (Integer)loc.synthesized(Init.silver_core_endLine__ON__silver_core_Location);
                this.endColumn = (Integer)loc.synthesized(Init.silver_core_endColumn__ON__silver_core_Location);
            }
            if (this.getNumChild() > 0) {
                DecoratedNode firstChild = this.getChild(0);
                firstChild.determineLocs();
                if (!this.isInMainFile || this.startLine > firstChild.startLine) {
                    this.startLine = firstChild.startLine;
                    this.startColumn = firstChild.startColumn;
                } else if (this.startLine == firstChild.startLine && this.startColumn > firstChild.startColumn) {
                    this.startColumn = firstChild.startColumn;
                }
                DecoratedNode lastChild = this.getChild(this.getNumChild() - 1);
                lastChild.determineLocs();
                if (!this.isInMainFile || this.endLine < lastChild.endLine) {
                    this.endLine = lastChild.endLine;
                    this.endColumn = lastChild.endColumn;
                } else if (this.endLine == lastChild.endLine && this.endColumn < lastChild.endColumn) {
                    this.endColumn = lastChild.endColumn;
                }
            }
        }
    }

    public boolean cpr_isInsideExternalFile() {
        this.determineLocs();
        return !this.isInMainFile;
    }

    public int cpr_getStartLine() {
        this.determineLocs();
        return this.startLine;
    }

    public int cpr_getStartColumn() {
        this.determineLocs();
        return this.startColumn;
    }

    public int cpr_getEndLine() {
        this.determineLocs();
        return this.endLine;
    }

    public int cpr_getEndColumn() {
        this.determineLocs();
        return this.endColumn;
    }

    private boolean hasLocInfo() {
        return this.self instanceof Alocation || this.self instanceof Tracked;
    }

    public boolean cpr_nodeListVisible() {
        this.determineLocs();
        if (!this.isInMainFile) {
            return false;
        }
        return this.hasLocInfo();
    }

    public String cpr_nodeLabel() {
        String fullName = this.self.getName();
        return fullName.substring(fullName.lastIndexOf(58) + 1);
    }

    public String cpr_astLabel() {
        Object pp = this.findPPOrUnparse();
        if (pp == null) {
            return null;
        }
        if (((String)pp).length() > 20) {
            pp = ((String)pp).substring(0, 17) + "...";
        }
        return pp;
    }

    private String findPPOrUnparse() {
        int i;
        for (i = 0; i < this.self.getNumberOfSynAttrs(); ++i) {
            if (!this.self.getNameOfSynAttr(i).equals("silver:langutil:pp")) continue;
            return Util.showDoc(this.synthesized(i), 80).toString();
        }
        for (i = 0; i < this.self.getNumberOfSynAttrs(); ++i) {
            if (!this.self.getNameOfSynAttr(i).equals("silver:langutil:unparse")) continue;
            return this.synthesized(i).toString();
        }
        return null;
    }

    public List<String> cpr_propertyListShow() {
        int i;
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("l:grammar");
        properties.add("l:show");
        if (this.self.hasForward()) {
            properties.add("l:forward");
        }
        if (this.forwardParent != null) {
            properties.add("l:forwardParent");
        }
        for (i = 0; i < this.self.getNumberOfChildren(); ++i) {
            properties.add("l:" + this.self.getNameOfChild(i));
        }
        for (i = 0; i < this.self.getNumberOfLocalAttrs(); ++i) {
            properties.add("l:" + this.self.getNameOfLocalAttr(i));
        }
        for (i = 0; i < this.self.getNumberOfSynAttrs(); ++i) {
            properties.add("l:" + this.self.getNameOfSynAttr(i));
        }
        for (i = 0; i < this.self.getNumberOfInhAttrs(); ++i) {
            if (this.self.getNameOfInhAttr(i) == null) continue;
            properties.add("l:" + this.self.getNameOfInhAttr(i));
        }
        String[] annoNames = this.self.getAnnoNames();
        for (int i2 = 0; i2 < annoNames.length; ++i2) {
            properties.add("l:" + annoNames[i2]);
        }
        return properties;
    }

    public String cpr_lGetChildName(String name) {
        for (int i = 0; i < this.self.getNumberOfChildren(); ++i) {
            if (!name.equals(this.self.getNameOfChild(i))) continue;
            return this.self.getNameOfChild(i);
        }
        return null;
    }

    public String cpr_lGetAspectName(String propName) {
        int i;
        for (i = 0; i < this.self.getNumberOfLocalAttrs(); ++i) {
            if (!propName.equals(this.self.getNameOfLocalAttr(i))) continue;
            return DecoratedNode.getSourceFileName(this.self.getLocal(i));
        }
        if (this.inheritedAttributes != null) {
            for (i = 0; i < this.self.getNumberOfInhAttrs(); ++i) {
                if (!propName.equals(this.self.getNameOfInhAttr(i))) continue;
                return DecoratedNode.getSourceFileName(this.inheritedAttributes[i]);
            }
        }
        for (i = 0; i < this.self.getNumberOfSynAttrs(); ++i) {
            if (!propName.equals(this.self.getNameOfSynAttr(i))) continue;
            return DecoratedNode.getSourceFileName(this.self.getSynthesized(i));
        }
        return null;
    }

    private static String getSourceFileName(Lazy l) {
        if (l == null) {
            return null;
        }
        return l.getSourceLocation().synthesized(Init.silver_core_filename__ON__silver_core_Location).toString();
    }

    public Object cpr_lInvoke(String propName) {
        int i;
        if (propName.equals("grammar")) {
            String fullName = this.self.getName();
            return fullName.substring(0, fullName.lastIndexOf(58));
        }
        if (propName.equals("show")) {
            return Util.genericShow(this.self);
        }
        if (propName.equals("forward")) {
            return this.makeCprInvokeResult(this.forward());
        }
        if (propName.equals("forwardParent")) {
            return this.makeCprInvokeResult(this.forwardParent);
        }
        for (i = 0; i < this.self.getNumberOfChildren(); ++i) {
            if (!propName.equals(this.self.getNameOfChild(i))) continue;
            return this.makeCprInvokeResult(this.child(i));
        }
        for (i = 0; i < this.self.getNumberOfLocalAttrs(); ++i) {
            if (!propName.equals(this.self.getNameOfLocalAttr(i))) continue;
            return this.makeCprInvokeResult(this.local(i));
        }
        for (i = 0; i < this.self.getNumberOfInhAttrs(); ++i) {
            if (!propName.equals(this.self.getNameOfInhAttr(i))) continue;
            return this.makeCprInvokeResult(this.inherited(i));
        }
        for (i = 0; i < this.self.getNumberOfSynAttrs(); ++i) {
            if (!propName.equals(this.self.getNameOfSynAttr(i))) continue;
            return this.makeCprInvokeResult(this.synthesizedOrTranslation(i));
        }
        String[] annoNames = this.self.getAnnoNames();
        for (int i2 = 0; i2 < annoNames.length; ++i2) {
            if (!propName.equals(annoNames[i2])) continue;
            return this.makeCprInvokeResult(this.self.getAnno(annoNames[i2]));
        }
        throw new SilverInternalError("Unknown property '" + propName + "' for " + this.getDebugID());
    }

    private Object makeCprInvokeResult(Object o) {
        if (o instanceof DecoratedNode && ((DecoratedNode)o).determineParentPropertyName() != null) {
            return o;
        }
        if (o.getClass().getSuperclass().getName().equals("silver.langutil.pp.NDocument")) {
            return Util.showDoc(o, 80).toString();
        }
        if (o instanceof ConsCell && o != ConsCell.nil && ((ConsCell)o).head().getClass().getSuperclass().getName().equals("silver.langutil.NMessage")) {
            return CodeProberDiagnostic.fromMessageList((ConsCell)o);
        }
        if (o instanceof DataNode) {
            return this.decorateDataNode((DataNode)o);
        }
        return Util.genericShow(o).toString();
    }

    public Object[] cpr_describeParentConnection() {
        String parentPropertyName = this.determineParentPropertyName();
        if (parentPropertyName == null) {
            return null;
        }
        return new Object[]{"l:" + parentPropertyName};
    }

    private String determineParentPropertyName() {
        int i;
        if (this == this.parent.forwardValue) {
            return "forward";
        }
        for (i = 0; i < this.parent.self.getNumberOfChildren(); ++i) {
            if (this != this.parent.childrenValues[i]) continue;
            return this.self.getNameOfChild(i);
        }
        for (i = 0; i < this.parent.self.getNumberOfLocalAttrs(); ++i) {
            if (this != this.parent.localValues[i]) continue;
            return this.parent.self.getNameOfLocalAttr(i);
        }
        for (i = 0; i < this.parent.self.getNumberOfSynAttrs(); ++i) {
            if (this != this.parent.synthesizedValues[i]) continue;
            return this.parent.self.getNameOfSynAttr(i);
        }
        if (this.self instanceof DataNode) {
            for (i = 0; i < this.parent.self.getNumberOfChildren(); ++i) {
                if (this.self != this.parent.self.getChild(i)) continue;
                return this.parent.self.getNameOfChild(i);
            }
            for (i = 0; i < this.parent.self.getNumberOfLocalAttrs(); ++i) {
                if (this.self != this.parent.localValues[i]) continue;
                return this.parent.self.getNameOfLocalAttr(i);
            }
            for (i = 0; i < this.parent.self.getNumberOfInhAttrs(); ++i) {
                if (this.self != this.parent.inheritedValues[i]) continue;
                return this.parent.self.getNameOfInhAttr(i);
            }
            for (i = 0; i < this.parent.self.getNumberOfSynAttrs(); ++i) {
                if (this.self != this.parent.synthesizedValues[i]) continue;
                return this.parent.self.getNameOfSynAttr(i);
            }
            String[] annoNames = this.self.getAnnoNames();
            for (int i2 = 0; i2 < annoNames.length; ++i2) {
                if (this.self != this.parent.self.getAnno(annoNames[i2])) continue;
                return annoNames[i2];
            }
        }
        return null;
    }
}

