/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.DecoratedNode;
import common.Lazy;
import common.RTTIManager;
import common.exceptions.SilverInternalError;
import java.util.Arrays;
import java.util.List;

public abstract class Decorator {
    public abstract void decorate(RTTIManager.Prodleton<?> var1);

    public static void applyDecorators(List<Decorator> nonterminal, RTTIManager.Prodleton<?> production) {
        for (Decorator decorator : nonterminal) {
            decorator.decorate(production);
        }
    }

    protected static void decorateAutoCopy(RTTIManager.Prodleton<?> production, String attribute) {
        String[] oi = production.getNonterminalton().getOccursInh();
        int attrindex = Arrays.asList(oi).indexOf(attribute);
        if (attrindex == -1) {
            throw new SilverInternalError("Attribute doesn't occur on NT it is supposed to?");
        }
        acLazy eq = new acLazy(attrindex);
        String[] childTypes = production.getChildTypes();
        Lazy[][] inheritedAttributes = production.getChildInheritedAttributes();
        for (int i = 0; i < childTypes.length; ++i) {
            if (childTypes[i] == null) continue;
            RTTIManager.Nonterminalton<?> nt = RTTIManager.getNonterminalton(childTypes[i]);
            if (nt == null) {
                throw new SilverInternalError("Cannot find nonterminal " + childTypes[i]);
            }
            String[] occurs = nt.getOccursInh();
            int loc = Arrays.asList(occurs).indexOf(attribute);
            if (loc == -1 || inheritedAttributes[i][loc] != null) continue;
            inheritedAttributes[i][loc] = eq;
        }
    }

    private static class acLazy
    implements Lazy {
        private final int attr;

        acLazy(int s) {
            this.attr = s;
        }

        @Override
        public Object eval(DecoratedNode context) {
            return context.inherited(this.attr);
        }
    }
}

