/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.parsetable;

import edu.umn.cs.melt.copper.compiletime.auxiliary.SymbolTable;
import edu.umn.cs.melt.copper.compiletime.parsetable.LRParseTable;
import edu.umn.cs.melt.copper.compiletime.parsetable.LRParseTableConflict;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CopperASTBean;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.PSSymbolTable;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.ParserSpec;

public class LRParseTablePrinter {
    public static String toString(SymbolTable<CopperASTBean> symbolTable, ParserSpec spec, LRParseTable parseTable) {
        StringBuffer rv = new StringBuffer();
        for (int state = 0; state < parseTable.size(); ++state) {
            rv.append("State ").append(state).append(":\n");
            rv.append("  Valid lookahead:\n");
            rv.append(PSSymbolTable.bitSetPrettyPrint(parseTable.getValidLA(state), symbolTable, "        ", 80));
            rv.append("\n  Actions:\n");
            int t = parseTable.getValidLA(state).nextSetBit(0);
            while (t >= 0) {
                rv.append("    ").append(symbolTable.get(t).getDisplayName()).append(" : ");
                LRParseTablePrinter.printAction(rv, symbolTable, spec, state, t, parseTable.getActionType(state, t), parseTable.getActionParameter(state, t));
                rv.append("\n");
                t = parseTable.getValidLA(state).nextSetBit(t + 1);
            }
        }
        for (int i = 0; i < parseTable.getConflictCount(); ++i) {
            LRParseTableConflict conflict = parseTable.getConflict(i);
            rv.append("  Parse table conflict in cell (" + conflict.getState() + "," + symbolTable.get(conflict.getSymbol()).getDisplayName() + ") among actions\n");
            if (conflict.shift != -1) {
                rv.append("    ");
                LRParseTablePrinter.printAction(rv, symbolTable, spec, conflict.getState(), conflict.getSymbol(), (byte)1, conflict.shift);
                rv.append("\n");
            }
            int p = conflict.reduce.nextSetBit(0);
            while (p >= 0) {
                rv.append("    ");
                LRParseTablePrinter.printAction(rv, symbolTable, spec, conflict.getState(), conflict.getSymbol(), (byte)2, p);
                rv.append("\n");
                p = conflict.reduce.nextSetBit(p + 1);
            }
            if (parseTable.getActionType(conflict.getState(), conflict.getSymbol()) != 3) {
                rv.append("  Resolved in favor of \"");
                LRParseTablePrinter.printAction(rv, symbolTable, spec, conflict.getState(), conflict.getSymbol(), parseTable.getActionType(conflict.getState(), conflict.getSymbol()), parseTable.getActionParameter(conflict.getState(), conflict.getSymbol()));
                rv.append("\"\n");
                continue;
            }
            rv.append("  UNRESOLVED");
        }
        return rv.toString();
    }

    private static void printAction(StringBuffer rv, SymbolTable<CopperASTBean> symbolTable, ParserSpec spec, int state, int t, byte actionType, int actionParameter) {
        switch (actionType) {
            case 1: {
                if (t == spec.getEOFTerminal()) {
                    rv.append("ACCEPT");
                    break;
                }
                if (spec.terminals.get(t)) {
                    rv.append("SHIFT(").append(actionParameter).append(")");
                    break;
                }
                rv.append("GOTO(").append(actionParameter).append(")");
                break;
            }
            case 2: {
                rv.append("REDUCE(");
                rv.append(symbolTable.get(spec.pr.getLHS(actionParameter)).getDisplayName());
                rv.append(" ::=");
                for (int i = 0; i < spec.pr.getRHSLength(actionParameter); ++i) {
                    rv.append(" ").append(symbolTable.get(spec.pr.getRHSSym(actionParameter, i)).getDisplayName());
                }
                rv.append(")");
                break;
            }
            case 3: {
                rv.append("*UNRESOLVED CONFLICT*");
                break;
            }
            default: {
                rv.append("[ERROR]");
            }
        }
    }

    public static String printAction(SymbolTable<CopperASTBean> symbolTable, ParserSpec spec, int state, int t, byte actionType, int actionParameter) {
        StringBuffer rv = new StringBuffer();
        LRParseTablePrinter.printAction(rv, symbolTable, spec, state, t, actionType, actionParameter);
        return rv.toString();
    }
}

