/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.ConsCell;
import common.DecoratedNode;
import common.Lazy;
import common.Node;
import common.SilverCopperParser;
import common.StringCatter;
import common.Terminal;
import common.Thunk;
import common.exceptions.CycleTraceException;
import common.exceptions.SilverError;
import common.exceptions.TraceException;
import common.javainterop.ConsCellCollection;
import edu.umn.cs.melt.copper.runtime.logging.CopperParserException;
import edu.umn.cs.melt.copper.runtime.logging.CopperSyntaxError;
import java.io.File;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import silver.core.NMaybe;
import silver.core.NParseResult;
import silver.core.NTerminalDescriptor;
import silver.core.Pjust;
import silver.core.Ploc;
import silver.core.Pnothing;
import silver.core.PparseFailed;
import silver.core.PparseSucceeded;
import silver.core.PsyntaxError;
import silver.core.PterminalDescriptor;
import silver.core.PunknownParseError;

public final class Util {
    private static String forceInit;
    private static ArrayList<Integer> freeThisToPrintErrors;
    private static int i;

    public static void init() {
    }

    public static void stackProbe(int count) {
        if (count != 0) {
            Util.stackProbe(count - 1);
        }
    }

    public static void stackProbe() {
    }

    public static <T> T uncheckedCast(Object o) {
        return (T)o;
    }

    public static <T> T demand(Object c) {
        if (c instanceof Thunk) {
            return ((Thunk)c).eval();
        }
        return (T)c;
    }

    public static <T> T demandIndex(Object[] cs, int i) {
        T result = Util.demand(cs[i]);
        cs[i] = result;
        return result;
    }

    public static Lazy[] populateInh(int size, int[] idx, Lazy[] val) {
        Lazy[] result = new Lazy[size];
        for (int i = 0; i < idx.length; ++i) {
            result[idx[i]] = val[i];
        }
        return result;
    }

    public static Object error(Object o) {
        System.err.print(o);
        throw new SilverError(o.toString());
    }

    public static NMaybe safetoInt(String s) {
        try {
            return new Pjust((Object)Integer.valueOf(s));
        }
        catch (NumberFormatException e) {
            return new Pnothing();
        }
    }

    public static boolean isAlpha(String sb) {
        boolean result = true;
        for (int i = 0; result && i < sb.length(); ++i) {
            result = Character.isLetter(sb.charAt(i));
        }
        return result;
    }

    public static boolean isDigit(String sb) {
        boolean result = true;
        for (int i = 0; result && i < sb.length(); ++i) {
            result = Character.isDigit(sb.charAt(i));
        }
        return result;
    }

    public static boolean isSpace(String sb) {
        boolean result = true;
        for (int i = 0; result && i < sb.length(); ++i) {
            result = Character.isWhitespace(sb.charAt(i));
        }
        return result;
    }

    public static boolean isUpper(String sb) {
        boolean result = true;
        for (int i = 0; result && i < sb.length(); ++i) {
            result = Character.isUpperCase(sb.charAt(i));
        }
        return result;
    }

    public static boolean isLower(String sb) {
        boolean result = true;
        for (int i = 0; result && i < sb.length(); ++i) {
            result = Character.isLowerCase(sb.charAt(i));
        }
        return result;
    }

    public static Object io(Object i, Object o) {
        return o;
    }

    public static int genInt() {
        return i++;
    }

    public static void printStackCauses(Throwable e) {
        freeThisToPrintErrors = null;
        System.err.println("\nAn error occurred.  Silver stack trace follows. (To see full traces including java elements, SILVERTRACE=1)\n");
        if (!"1".equals(System.getenv("SILVERTRACE"))) {
            Throwable t = e;
            while (t != null) {
                StackTraceElement[] st = t.getStackTrace();
                String msg = t.getLocalizedMessage();
                if (msg == null) {
                    msg = t.toString();
                }
                if (t instanceof CycleTraceException) {
                    System.err.println("\tCycle begins here:");
                } else if (st.length == 0) {
                    System.err.println("(??): " + msg);
                } else if (st[0].getClassName().startsWith("common.")) {
                    System.err.println("(" + st[0].getFileName().replaceAll("[a-z]", "") + st[0].getLineNumber() + "): " + msg);
                } else {
                    System.err.println("(" + st[0].getClassName() + " in " + st[0].getFileName() + ":" + st[0].getLineNumber() + "): " + msg);
                    if (t instanceof NullPointerException && st.length > 1) {
                        System.err.println("\t1 up: " + st[1].getClassName() + " in " + st[1].getFileName() + ":" + st[1].getLineNumber());
                        if (st.length > 2) {
                            System.err.println("\t2 up: " + st[2].getClassName() + " in " + st[2].getFileName() + ":" + st[2].getLineNumber());
                        }
                    }
                }
                String lastCause = t.getLocalizedMessage();
                int repeats = 0;
                for (t = t.getCause(); t != null && lastCause.equals(t.getLocalizedMessage()); t = t.getCause()) {
                    ++repeats;
                }
                if (repeats <= 0) continue;
                System.err.println("\t(last line repeats " + repeats + " more times)");
            }
        } else {
            throw new RuntimeException(e);
        }
        System.exit(-2);
    }

    public static String namesToString(String[] names, String none) {
        String result = names.length > 0 ? names[0] : none;
        for (int i = 1; i < names.length; ++i) {
            result = result + ", " + names[i];
        }
        return result;
    }

    public static StringCatter escapeString(StringCatter s) {
        return new StringCatter(Util.escapeString(s.toString()));
    }

    public static String escapeString(String s) {
        StringBuilder sb = new StringBuilder();
        block9: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static StringCatter unescapeString(StringCatter s) {
        return new StringCatter(Util.unescapeString(s.toString()));
    }

    public static String unescapeString(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                if (++i >= s.length()) continue;
                char c1 = s.charAt(i);
                switch (c1) {
                    case 't': {
                        sb.append("\t");
                        break;
                    }
                    case 'b': {
                        sb.append("\b");
                        break;
                    }
                    case 'n': {
                        sb.append("\n");
                        break;
                    }
                    case 'r': {
                        sb.append("\r");
                        break;
                    }
                    case 'f': {
                        sb.append("\f");
                        break;
                    }
                    case '\"': {
                        sb.append("\"");
                        break;
                    }
                    case '\\': {
                        sb.append("\\");
                        break;
                    }
                    default: {
                        sb.append(c1);
                        break;
                    }
                }
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static StringCatter hackyhackyUnparse(Object o) {
        StringBuilder sb = new StringBuilder();
        Util.hackyhackyUnparseObject(o, sb);
        return new StringCatter(sb.toString());
    }

    private static void hackyhackyUnparseObject(Object o, StringBuilder sb) {
        if (o instanceof Node) {
            Util.hackyhackyUnparseNode((Node)o, sb);
        } else if (o instanceof DecoratedNode) {
            Util.hackyhackyUnparseNode(((DecoratedNode)o).getNode(), sb);
        } else if (o instanceof Terminal) {
            Terminal t = (Terminal)o;
            sb.append("'" + t.lexeme + "'");
        } else if (o instanceof StringCatter) {
            sb.append("\"" + o.toString() + "\"");
        } else if (o instanceof Integer || o instanceof Float || o instanceof Boolean) {
            sb.append(o.toString());
        } else if (o instanceof ConsCell) {
            Util.hackyhackyUnparseList((ConsCell)o, sb);
        } else {
            sb.append("<OBJ " + o.toString() + ">");
        }
    }

    private static void hackyhackyUnparseNode(Node n, StringBuilder sb) {
        sb.append(n.getName() + "(");
        int nc = n.getNumberOfChildren();
        for (int i = 0; i < nc; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            Util.hackyhackyUnparseObject(n.getChild(i), sb);
        }
        String[] annos = n.getAnnoNames();
        for (int i = 0; i < annos.length; ++i) {
            if (nc != 0 || i != 0) {
                sb.append(", ");
            }
            sb.append(annos[i] + "=");
            Util.hackyhackyUnparseObject(n.getAnno(annos[i]), sb);
        }
        sb.append(")");
    }

    private static void hackyhackyUnparseList(ConsCell c, StringBuilder sb) {
        sb.append("[");
        ConsCell i = c;
        while (!i.nil()) {
            if (i != c) {
                sb.append(", ");
            }
            Util.hackyhackyUnparseObject(i.head(), sb);
            i = i.tail();
        }
        sb.append("]");
    }

    public static <ROOT> NParseResult callCopperParser(SilverCopperParser<ROOT> parser, Object string, Object file) {
        String javaString = ((StringCatter)Util.demand(string)).toString();
        String javaFile = ((StringCatter)Util.demand(file)).toString();
        try {
            Object tree = parser.parse(new StringReader(javaString), javaFile);
            Object terminals = Util.getTerminals(parser);
            return new PparseSucceeded(tree, terminals);
        }
        catch (CopperSyntaxError e) {
            Ploc loc = new Ploc((Object)new StringCatter(e.getVirtualFileName()), (Object)e.getVirtualLine(), (Object)e.getVirtualColumn(), (Object)e.getVirtualLine(), (Object)(e.getVirtualColumn() + 1), (Object)((int)e.getRealCharIndex()), (Object)((int)e.getRealCharIndex() + 1));
            PsyntaxError err = new PsyntaxError((Object)new StringCatter(e.getMessage()), (Object)loc, (Object)Util.convertStrings(e.getExpectedTerminalsDisplay().iterator()), (Object)Util.convertStrings(e.getMatchedTerminalsDisplay().iterator()));
            Object terminals = Util.getTerminals(parser);
            return new PparseFailed((Object)err, terminals);
        }
        catch (CopperParserException e) {
            PunknownParseError err = new PunknownParseError((Object)new StringCatter(e.getMessage()), file);
            return new PparseFailed((Object)err, null);
        }
        catch (Throwable t) {
            throw new TraceException("An error occurred while parsing", t);
        }
    }

    private static Object getTerminals(SilverCopperParser<?> parser) {
        List<Terminal> tokens = parser.getTokens();
        return new Thunk<ConsCell>(() -> {
            List tds = tokens.stream().map(Util::terminalToTerminalDescriptor).collect(Collectors.toList());
            return ConsCellCollection.fromList(tds);
        });
    }

    private static NTerminalDescriptor terminalToTerminalDescriptor(Terminal t) {
        return new PterminalDescriptor((Object)t.lexeme, (Object)Util.convertStrings(Arrays.stream(t.getLexerClasses()).iterator()), (Object)new StringCatter(t.getName()), (Object)Terminal.extractLocation(t));
    }

    private static ConsCell convertStrings(Iterator<String> i) {
        if (!i.hasNext()) {
            return ConsCell.nil;
        }
        return new ConsCell(new StringCatter(i.next()), Util.convertStrings(i));
    }

    public static StringCatter determineSilverHomePath(Class<?> clazz) {
        URI jarLocation;
        try {
            jarLocation = clazz.getProtectionDomain().getCodeSource().getLocation().toURI();
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to find install location of Silver runtime.", t);
        }
        File home = new File(jarLocation).getParentFile().getParentFile();
        return new StringCatter(home.getPath());
    }

    public static ConsCell bitSetToList(BitSet b) {
        ConsCell result = ConsCell.nil;
        int i = b.nextSetBit(0);
        while (i >= 0) {
            result = new ConsCell(i, result);
            i = b.nextSetBit(i + 1);
        }
        return result;
    }

    static {
        i = 0;
    }
}

