/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.DecoratedNode;
import common.FileContextVisualization;
import common.Lazy;
import common.Node;
import common.RTTIManager;
import common.SimplifiedContextStack;
import common.Thunk;
import common.TopNode;
import common.Util;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.Stack;
import silver.core.Init;
import silver.core.NLocation;

public class Debug {
    private DecoratedNode root;
    private DecoratedNode currentNode;
    private Stack<DecoratedNode> nodeStack;
    HashMap<Integer, StringObjectPair> currentNodeSynthAttrs;
    HashMap<Integer, StringObjectPair> currentNodeInhAttrs;
    HashMap<Integer, StringObjectPair> currentNodeLocalAttrs;
    private int currentLine;
    private int currentColumn;

    public static DecoratedNode runDebug(DecoratedNode tree) {
        Debug debug = new Debug();
        debug.runingDebug(tree);
        return tree;
    }

    /*
     * Unable to fully structure code
     */
    public void runingDebug(DecoratedNode tree) {
        inp = new Scanner(System.in);
        System.out.println("Enter characters, and 'q' to quit.");
        toggleNameDisplay = false;
        toggleCStackDisplay = true;
        toggleHeadlessAttributes = false;
        toggleChoices = new String[]{"nameDisplay", "cStackDisplay", "fullAttributeNames"};
        this.root = tree;
        this.currentNode = tree;
        this.nodeStack = new Stack<E>();
        if (toggleNameDisplay) {
            this.printName(this.currentNode);
        }
        cStack = new FileContextVisualization("context.txt", "********************************");
        cStack.push(this.currentNode);
        if (toggleCStackDisplay) {
            cStack.show();
        }
        contextStack = cStack.getContextStack();
        sStack = new SimplifiedContextStack(contextStack);
        sStack.show();
        block61: while (true) {
            System.out.print(">DEBUGGER-PROMPT$");
            userInput = inp.nextLine();
            userInputList = userInput.split(" ");
            var13_13 = userInputList[0];
            var14_14 = -1;
            switch (var13_13.hashCode()) {
                case 3739: {
                    if (!var13_13.equals("up")) break;
                    var14_14 = 0;
                    break;
                }
                case 117: {
                    if (!var13_13.equals("u")) break;
                    var14_14 = 1;
                    break;
                }
                case 3089570: {
                    if (!var13_13.equals("down")) break;
                    var14_14 = 2;
                    break;
                }
                case 100: {
                    if (!var13_13.equals("d")) break;
                    var14_14 = 3;
                    break;
                }
                case 3594468: {
                    if (!var13_13.equals("undo")) break;
                    var14_14 = 4;
                    break;
                }
                case 483313230: {
                    if (!var13_13.equals("forwards")) break;
                    var14_14 = 5;
                    break;
                }
                case 3237472: {
                    if (!var13_13.equals("into")) break;
                    var14_14 = 6;
                    break;
                }
                case 1354491076: {
                    if (!var13_13.equals("backtrack")) break;
                    var14_14 = 7;
                    break;
                }
                case -868304044: {
                    if (!var13_13.equals("toggle")) break;
                    var14_14 = 8;
                    break;
                }
                case 3449687: {
                    if (!var13_13.equals("prod")) break;
                    var14_14 = 9;
                    break;
                }
                case 3373707: {
                    if (!var13_13.equals("name")) break;
                    var14_14 = 10;
                    break;
                }
                case 3244: {
                    if (!var13_13.equals("eq")) break;
                    var14_14 = 11;
                    break;
                }
                case -1235006146: {
                    if (!var13_13.equals("listSynth")) break;
                    var14_14 = 12;
                    break;
                }
                case -1244575278: {
                    if (!var13_13.equals("listInher")) break;
                    var14_14 = 13;
                    break;
                }
                case 3322014: {
                    if (!var13_13.equals("list")) break;
                    var14_14 = 14;
                    break;
                }
                case 108: {
                    if (!var13_13.equals("l")) break;
                    var14_14 = 15;
                    break;
                }
                case 3619493: {
                    if (!var13_13.equals("view")) break;
                    var14_14 = 16;
                    break;
                }
                case 118: {
                    if (!var13_13.equals("v")) break;
                    var14_14 = 17;
                    break;
                }
                case 1374064807: {
                    if (!var13_13.equals("algoDebugg")) break;
                    var14_14 = 18;
                    break;
                }
                case 97: {
                    if (!var13_13.equals("a")) break;
                    var14_14 = 19;
                    break;
                }
                case 103145323: {
                    if (!var13_13.equals("local")) break;
                    var14_14 = 20;
                    break;
                }
                case 3198785: {
                    if (!var13_13.equals("help")) break;
                    var14_14 = 21;
                    break;
                }
                case 3127582: {
                    if (!var13_13.equals("exit")) break;
                    var14_14 = 22;
                    break;
                }
                case 113: {
                    if (!var13_13.equals("q")) break;
                    var14_14 = 23;
                    break;
                }
                case 3482191: {
                    if (!var13_13.equals("quit")) break;
                    var14_14 = 24;
                }
            }
            switch (var14_14) {
                case 0: 
                case 1: {
                    if (userInputList.length != 1) {
                        System.out.println("invalid, correct usage: up<>");
                        break;
                    }
                    if (this.currentNode.getParent().getParent() instanceof TopNode || this.currentNode.getParent() == null) {
                        System.out.println("Root Node has no parent");
                        break;
                    }
                    if (this.currentNode.getParent() == null) {
                        System.out.println("Null parent");
                        break;
                    }
                    this.nodeStack.push(this.currentNode);
                    this.currentNode = this.currentNode.getParent();
                    if (toggleNameDisplay) {
                        this.printName(this.currentNode);
                    }
                    cStack.pop();
                    sStack.show();
                    if (!toggleCStackDisplay) continue block61;
                    cStack.show();
                    break;
                }
                case 2: 
                case 3: {
                    childNum = -1;
                    if (this.currentNode.getNode().hasForward()) {
                        System.out.println("can't go down on a forwarding node");
                        break;
                    }
                    if (userInputList.length != 1) ** GOTO lbl161
                    System.out.println("Which child?");
                    currentProduction = this.currentNode.undecorate().getProdleton().getTypeUnparse();
                    listCurrentProduction = currentProduction.split("\\s+");
                    childNames = Arrays.copyOfRange(listCurrentProduction, 2, listCurrentProduction.length);
                    childNum = Debug.chooseFormList(inp, childNames);
                    if (childNum == -1) {
                        break;
                    }
                    ** GOTO lbl170
lbl161:
                    // 1 sources

                    if (userInputList.length != 2) ** GOTO lbl168
                    try {
                        childNum = Integer.parseInt(userInputList[1]);
                        ** GOTO lbl170
                    }
                    catch (NumberFormatException e) {
                        System.out.println("invalid, correct usage: down <node #>");
                        break;
                    }
lbl168:
                    // 1 sources

                    System.out.println("invalid, correct usage: down <node #>");
                    break;
lbl170:
                    // 2 sources

                    childNode = this.down(childNum);
                    if (childNode == null) {
                        System.out.println("invalid child number");
                        break;
                    }
                    this.nodeStack.push(this.currentNode);
                    this.currentNode = childNode;
                    if (toggleNameDisplay) {
                        this.printName(this.currentNode);
                    }
                    cStack.push(this.currentNode);
                    sStack.show();
                    if (!toggleCStackDisplay) continue block61;
                    cStack.show();
                    break;
                }
                case 4: {
                    if (userInputList.length != 1) {
                        System.out.println("invalid, correct usage: undo<>");
                        break;
                    }
                    if (this.nodeStack.empty()) {
                        System.out.println("invalid no node to undo");
                        break;
                    }
                    this.currentNode = newNode = this.nodeStack.pop();
                    if (toggleNameDisplay) {
                        this.printName(this.currentNode);
                    }
                    cStack.pop();
                    sStack.show();
                    if (!toggleCStackDisplay) continue block61;
                    cStack.show();
                    break;
                }
                case 5: {
                    if (userInputList.length != 1) {
                        System.out.println("invalid, correct usage: forwards<>");
                        break;
                    }
                    childNode = this.forwards(this.currentNode);
                    if (childNode == null) {
                        System.out.println("invalid no node to forward");
                        break;
                    }
                    System.out.println("going forward");
                    this.currentNode = childNode;
                    if (toggleNameDisplay) {
                        this.printName(this.currentNode);
                    }
                    cStack.push(this.currentNode);
                    sStack.show();
                    if (!toggleCStackDisplay) continue block61;
                    cStack.show();
                    break;
                }
                case 6: {
                    attributeNameinto = "";
                    attributeNuminto = 0;
                    attributeListinto = Debug.allAttributesList(this.currentNode);
                    if (userInputList.length != 1) ** GOTO lbl231
                    System.out.println("Which attribute?");
                    attriburteArrayinto = attributeListinto.toArray(new String[attributeListinto.size()]);
                    attributeNuminto = Debug.chooseFormList(inp, attriburteArrayinto);
                    if (attributeNuminto == -1) continue block61;
                    if (attributeNuminto >= attributeListinto.size()) {
                        System.out.println("Invaild attribute number");
                        break;
                    }
                    attributeNameinto = attributeListinto.get(attributeNuminto);
                    ** GOTO lbl244
lbl231:
                    // 1 sources

                    if (userInputList.length != 2) ** GOTO lbl242
                    try {
                        attributeNuminto = Integer.parseInt(userInputList[1]);
                        attributeNameinto = attributeListinto.get(attributeNuminto);
                        ** GOTO lbl244
                    }
                    catch (NumberFormatException e) {
                        System.out.println("invalid, correct usage: view <node #>");
                        break;
                    }
                    catch (IndexOutOfBoundsException e) {
                        System.out.println("Index out of bounds");
                        break;
                    }
lbl242:
                    // 1 sources

                    System.out.println("invalid, correct usage: into <node #>");
                    break;
lbl244:
                    // 2 sources

                    childNode = this.into(this.currentNode, attributeNameinto);
                    if (childNode == null) {
                        System.out.println("invalid input");
                        break;
                    }
                    System.out.println("going into");
                    this.currentNode = childNode;
                    break;
                }
                case 7: {
                    if (userInputList.length != 1) {
                        System.out.println("invalid, correct usage: backtrack<>");
                        break;
                    }
                    childNode = this.backtrack(this.currentNode);
                    if (childNode == null) {
                        System.out.println("invalid no node to backtrack to");
                        break;
                    }
                    System.out.println("going backwrds");
                    this.currentNode = childNode;
                    if (toggleNameDisplay) {
                        this.printName(this.currentNode);
                    }
                    cStack.pop();
                    sStack.show();
                    if (!toggleCStackDisplay) continue block61;
                    cStack.show();
                    break;
                }
                case 8: {
                    toggelChoice = "";
                    if (userInputList.length == 1) {
                        toggelChoice = toggleChoices[Debug.chooseFormList(inp, toggleChoices)];
                    } else if (userInputList.length == 2) {
                        toggelChoice = userInputList[1];
                    }
                    if (toggelChoice.equals("nameDisplay")) {
                        if (toggleNameDisplay) {
                            System.out.println("Production Display off");
                            toggleNameDisplay = false;
                            break;
                        }
                        System.out.println("Production Display on");
                        toggleNameDisplay = true;
                        break;
                    }
                    if (toggelChoice.equals("fullAttributeNames")) {
                        if (toggleHeadlessAttributes) {
                            System.out.println("Headless Attributes off");
                            toggleHeadlessAttributes = false;
                            break;
                        }
                        System.out.println("Headless Attributes on");
                        toggleHeadlessAttributes = true;
                        break;
                    }
                    if (toggelChoice.equals("cStackDisplay")) {
                        if (toggleCStackDisplay) {
                            System.out.println("cStack Display off");
                            toggleCStackDisplay = false;
                            break;
                        }
                        System.out.println("cStack Display on");
                        toggleCStackDisplay = true;
                        break;
                    }
                    System.out.println("legal toggles: nameDisplay, fullAttributeNames, cStackDisplay");
                    break;
                }
                case 9: {
                    if (userInputList.length != 1) {
                        System.out.println("invalid, correct usage: prod<>");
                        break;
                    }
                    this.printProduction(this.currentNode);
                    break;
                }
                case 10: {
                    if (userInputList.length != 1) {
                        System.out.println("invalid, correct usage: prod<>");
                        break;
                    }
                    this.printName(this.currentNode);
                    break;
                }
                case 11: {
                    attributeNameView = "";
                    attributeNumView = 0;
                    attributeListView = Debug.allAttributesList(this.currentNode);
                    if (userInputList.length != 1) ** GOTO lbl328
                    System.out.println("Which attribute?");
                    attriburteArrayView = attributeListView.toArray(new String[attributeListView.size()]);
                    attributeNumView = Debug.chooseFormList(inp, attriburteArrayView);
                    if (attributeNumView == -1) continue block61;
                    if (attributeNumView >= attributeListView.size()) {
                        System.out.println("Invaild attribute number");
                        break;
                    }
                    attributeNameView = attributeListView.get(attributeNumView);
                    ** GOTO lbl341
lbl328:
                    // 1 sources

                    if (userInputList.length != 2) ** GOTO lbl339
                    try {
                        attributeNumView = Integer.parseInt(userInputList[1]);
                        attributeNameView = attributeListView.get(attributeNumView);
                        ** GOTO lbl341
                    }
                    catch (NumberFormatException e) {
                        System.out.println("invalid, correct usage: view <node #>");
                        break;
                    }
                    catch (IndexOutOfBoundsException e) {
                        System.out.println("Index out of bounds");
                        break;
                    }
lbl339:
                    // 1 sources

                    System.out.println("invalid, correct usage: into <node #>");
                    break;
lbl341:
                    // 2 sources

                    this.printEquation(this.currentNode, attributeNameView);
                    this.attributeDataHTML(this.currentNode, "");
                    break;
                }
                case 12: {
                    if (userInputList.length != 1 && userInputList.length != 2) {
                        System.out.println("invalid, correct usage: listSynth<node?>");
                        break;
                    }
                    if (this.listSynth(this.currentNode) != 0) continue block61;
                    System.out.println("no synthesized attributes");
                    break;
                }
                case 13: {
                    if (userInputList.length != 1 && userInputList.length != 2) {
                        System.out.println("invalid, correct usage: listInher <node?>");
                        break;
                    }
                    if (this.listInher(this.currentNode) != 0) continue block61;
                    System.out.println("no inherited attributes");
                    break;
                }
                case 14: 
                case 15: {
                    if (userInputList.length != 1 && userInputList.length != 2) {
                        System.out.println("invalid, correct usage: list<node?>");
                        break;
                    }
                    this.printAttributes(this.currentNode, toggleHeadlessAttributes);
                    break;
                }
                case 16: 
                case 17: {
                    attributeName = "";
                    attributeNum = 0;
                    attributeList = Debug.allAttributesList(this.currentNode);
                    if (userInputList.length != 1) ** GOTO lbl378
                    System.out.println("Which attribute?");
                    attriburteArray = attributeList.toArray(new String[attributeList.size()]);
                    attributeNum = Debug.chooseFormList(inp, attriburteArray);
                    if (attributeNum == -1) continue block61;
                    if (attributeNum >= attributeList.size()) {
                        System.out.println("Invaild attribute number");
                        break;
                    }
                    attributeName = attributeList.get(attributeNum);
                    ** GOTO lbl391
lbl378:
                    // 1 sources

                    if (userInputList.length != 2) ** GOTO lbl389
                    try {
                        attributeNum = Integer.parseInt(userInputList[1]);
                        attributeName = attributeList.get(attributeNum);
                        ** GOTO lbl391
                    }
                    catch (NumberFormatException e) {
                        System.out.println("invalid, correct usage: view <node #>");
                        break;
                    }
                    catch (IndexOutOfBoundsException e) {
                        System.out.println("Index out of bounds");
                        break;
                    }
lbl389:
                    // 1 sources

                    System.out.println("invalid, correct usage: view <node #>");
                    break;
lbl391:
                    // 2 sources

                    this.attributeDataHTML(this.currentNode, attributeName);
                    break;
                }
                case 18: 
                case 19: {
                    attributeName = "";
                    attributeNum = 0;
                    attributeList = Debug.allAttributesList(this.currentNode);
                    if (userInputList.length != 1) ** GOTO lbl407
                    System.out.println("Which attribute?");
                    attriburteArray = attributeList.toArray(new String[attributeList.size()]);
                    attributeNum = Debug.chooseFormList(inp, attriburteArray);
                    if (attributeNum == -1) continue block61;
                    if (attributeNum >= attributeList.size()) {
                        System.out.println("Invaild attribute number");
                        break;
                    }
                    attributeName = attributeList.get(attributeNum);
                    ** GOTO lbl420
lbl407:
                    // 1 sources

                    if (userInputList.length != 2) ** GOTO lbl418
                    try {
                        attributeNum = Integer.parseInt(userInputList[1]);
                        attributeName = attributeList.get(attributeNum);
                        ** GOTO lbl420
                    }
                    catch (NumberFormatException e) {
                        System.out.println("invalid, correct usage: view <node #>");
                        break;
                    }
                    catch (IndexOutOfBoundsException e) {
                        System.out.println("Index out of bounds");
                        break;
                    }
lbl418:
                    // 1 sources

                    System.out.println("invalid, correct usage: view <node #>");
                    break;
lbl420:
                    // 2 sources

                    this.algorithmicDebugg(this.currentNode, attributeName);
                    break;
                }
                case 20: {
                    if (userInputList.length != 1 && userInputList.length != 2) {
                        System.out.println("invalid, correct usage: local <node?>");
                        break;
                    }
                    listLocals = Debug.getLocalAttrs(this.currentNode);
                    if (listLocals.size() == 0) {
                        System.out.println("no inherited attributes");
                        break;
                    }
                    var27_36 = listLocals.iterator();
                    while (true) {
                        if (!var27_36.hasNext()) continue block61;
                        localAttribute = var27_36.next();
                        System.out.println("Attribute = " + localAttribute);
                    }
                }
                case 21: {
                    if (userInputList.length == 1) {
                        System.out.println("call help with one of these keywords to see its functionality:");
                        System.out.println("toggle <feature>");
                        System.out.println("up");
                        System.out.println("down <node>");
                        System.out.println("view <attr>");
                        System.out.println("forwards");
                        System.out.println("backtrack");
                        System.out.println("prod");
                        System.out.println("eq");
                        System.out.println("listSynth");
                        System.out.println("listInher");
                        System.out.println("local");
                        System.out.println("list");
                        System.out.println("into");
                        System.out.println("exit");
                        break;
                    }
                    if (userInputList.length == 2) {
                        if (userInputList[1].equals("up")) {
                            System.out.println("The current node changes to its the parent");
                            break;
                        }
                        if (userInputList[1].equals("down")) {
                            System.out.println("The current node changes to its child");
                            System.out.println("One optional input is the child number you want to travel to");
                            System.out.println("If no input is provided you will be prompted with a choice of child");
                            System.out.println("You cn call this function with \"d\"");
                            break;
                        }
                        if (userInputList[1].equals("view")) {
                            System.out.println("look at the value of an attribute in the current node");
                            System.out.println("One optional input is the attribute number you want to view");
                            System.out.println("If no input is provided you will be prompted with a choice of attribute");
                            System.out.println("You can call this function with \"v\"");
                            break;
                        }
                        if (userInputList[1].equals("forwards")) {
                            System.out.println("The current node changes to its forward");
                            break;
                        }
                        if (userInputList[1].equals("backtrack")) {
                            System.out.println("The current node changes to its backtrack");
                            break;
                        }
                        if (userInputList[1].equals("prod")) {
                            System.out.println("prints the production of the current node");
                            break;
                        }
                        if (userInputList[1].equals("eq")) {
                            System.out.println("prints the equation of the current node");
                            break;
                        }
                        if (userInputList[1].equals("listSynth")) {
                            System.out.println("prints the Synthisized attributes of the current node");
                            break;
                        }
                        if (userInputList[1].equals("listInher")) {
                            System.out.println("prints the inherited attributes of the current node");
                            break;
                        }
                        if (userInputList[1].equals("list")) {
                            System.out.println("prints the attributes of the current node");
                            break;
                        }
                        if (userInputList[1].equals("local")) {
                            System.out.println("prints the local attributes of the current node");
                            break;
                        }
                        if (userInputList[1].equals("into")) {
                            System.out.println("The current node changes to its higer order attribute");
                            System.out.println("One optional input is the attribute number you want to go into");
                            System.out.println("If no input is provided you will be prompted with a choice of attribute");
                            break;
                        }
                        if (userInputList[1].equals("toggle")) {
                            System.out.println("Activate or disactivate a feature");
                            System.out.println("One input is the feature number you want to toggle");
                            System.out.println("If no input is provided you will be prompted with a choice of toggles");
                            break;
                        }
                        System.out.println("try just calling help");
                        break;
                    }
                    System.out.println("try just calling help");
                    break;
                }
                case 22: 
                case 23: 
                case 24: {
                    System.out.println("debugger out");
                    break block61;
                }
                default: {
                    System.out.println("invalid input call help for legal inputs");
                }
            }
        }
    }

    public void setCurrentNode(DecoratedNode node) {
        this.currentNodeSynthAttrs = null;
        this.currentNodeInhAttrs = null;
        this.currentNodeLocalAttrs = null;
        this.currentNode = node;
    }

    public DecoratedNode up() {
        if (this.currentNode.getParent() != null) {
            this.currentNode = this.currentNode.getParent();
            return this.currentNode;
        }
        return null;
    }

    public DecoratedNode down(int child) {
        String[] childProductions = this.currentNode.undecorate().getProdleton().getChildTypes();
        try {
            if (childProductions[child].equals("null")) {
                return null;
            }
            DecoratedNode childNode = this.currentNode.childDecorated(child);
            return childNode;
        }
        catch (NullPointerException e) {
            System.out.println("Null pointer");
            return null;
        }
        catch (IndexOutOfBoundsException e) {
            System.out.println("Index out of bound");
            return null;
        }
    }

    public DecoratedNode forwards(DecoratedNode node) {
        if (node.getNode().hasForward()) {
            this.currentNode = node.forward();
            return this.currentNode;
        }
        return null;
    }

    public DecoratedNode backtrack(DecoratedNode node) {
        this.currentNode = node.getForwardParent();
        return this.currentNode;
    }

    public void printName(DecoratedNode node) {
        String partentProduction = node.undecorate().getProdleton().getTypeUnparse();
        System.out.println(partentProduction);
    }

    public void printProduction(DecoratedNode node) {
        String name = node.undecorate().getProdleton().getName();
        String[] childProductions = node.undecorate().getProdleton().getChildTypes();
        System.out.print(name + " ");
        for (int i = 0; i < childProductions.length; ++i) {
            System.out.print(childProductions[i] + " ");
        }
        System.out.print("\n");
    }

    public void printEquation(DecoratedNode node, String attriburteName) {
        Map<String, Lazy> lazyMap = Debug.allAttributesLazyMap(node);
        if (lazyMap.containsKey(attriburteName)) {
            Lazy attributeLazy = lazyMap.get(attriburteName);
            NLocation loc = attributeLazy.getSourceLocation();
            String qualifier = Integer.toHexString(System.identityHashCode(this));
            if (loc != null) {
                String file = loc.synthesized(Init.silver_core_filename__ON__silver_core_Location).toString();
                int line = (Integer)loc.synthesized(Init.silver_core_line__ON__silver_core_Location);
                int endline = (Integer)loc.synthesized(Init.silver_core_endLine__ON__silver_core_Location);
                Debug.equationHTML(file, line, endline);
                this.writeTojson(file, line, endline);
            }
        }
    }

    public void writeTojson(String filename, int lineNumber, int endline) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(".debugger_communicator.json"));){
            String currentDirectory = System.getProperty("user.dir");
            System.out.println(currentDirectory);
            int lastIndex = filename.lastIndexOf("/");
            String fileEnd = filename.substring(lastIndex + 1);
            writer.write("{\"file_path\": \"" + currentDirectory + "/" + fileEnd + "\", \"line_begin\": " + lineNumber + ", \"line_end\": " + endline + "}");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void equationHTML(String filename, int lineNumber, int endline) {
        try (BufferedReader br1 = new BufferedReader(new FileReader(filename));
             BufferedWriter writer = new BufferedWriter(new FileWriter("current_production.html"));){
            String line;
            writer.write("<!DOCTYPE html>\n");
            writer.write("<html>\n");
            writer.write("<body>\n");
            int currentLineNumber = 1;
            int productionLineNum = 0;
            while ((line = br1.readLine()) != null) {
                if (line.contains("::=")) {
                    productionLineNum = currentLineNumber;
                }
                if (currentLineNumber >= lineNumber) break;
                ++currentLineNumber;
            }
            currentLineNumber = 1;
            br1.close();
            BufferedReader br2 = new BufferedReader(new FileReader(filename));
            writer.write("<pre>\n");
            while ((line = br2.readLine()) != null) {
                if (currentLineNumber == lineNumber) {
                    writer.write("<span style=\"color: red;\"><strong>");
                }
                if (currentLineNumber >= productionLineNum) {
                    writer.write(line);
                    if (currentLineNumber == endline) {
                        writer.write("</strong></span>");
                        writer.newLine();
                    }
                    writer.newLine();
                }
                if (currentLineNumber >= productionLineNum && line.trim().equals("}")) break;
                ++currentLineNumber;
            }
            writer.write("</pre>\n");
            writer.write("</body>\n");
            writer.write("</html>\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int listSynth(DecoratedNode node) {
        RTTIManager.Prodleton<? extends Node> prodleton = node.getNode().getProdleton();
        RTTIManager.Nonterminalton<? extends Node> nonterminalton = prodleton.getNonterminalton();
        Set<String> synAttrSet = nonterminalton.getAllSynth();
        int numAttr = 0;
        for (String synAttr : synAttrSet) {
            System.out.println("Attribute = " + synAttr);
            ++numAttr;
        }
        return numAttr;
    }

    public int listInher(DecoratedNode node) {
        RTTIManager.Prodleton<? extends Node> prodleton = node.getNode().getProdleton();
        RTTIManager.Nonterminalton<? extends Node> nonterminalton = prodleton.getNonterminalton();
        Set<String> inhAttrSet = nonterminalton.getAllInh();
        int numAttr = 0;
        for (String inhAttr : inhAttrSet) {
            System.out.println("Attribute = " + inhAttr);
            ++numAttr;
        }
        return numAttr;
    }

    public void printAttributes(DecoratedNode node, boolean toggleHeadlessAttributes) {
        List<String> attributeList = Debug.allAttributesList(node);
        if (toggleHeadlessAttributes) {
            attributeList = this.removeHeaders(Debug.allAttributesList(node));
        }
        int i = 0;
        for (String attribute : attributeList) {
            System.out.println(Integer.toString(i) + ": " + attribute);
            ++i;
        }
    }

    public List<String> removeHeaders(List<String> stringList) {
        ArrayList<String> headlessList = new ArrayList<String>();
        for (String element : stringList) {
            int lastIndex = element.lastIndexOf(":");
            if (lastIndex == -1) {
                headlessList.add(element);
                continue;
            }
            headlessList.add(element.substring(lastIndex + 1));
        }
        return headlessList;
    }

    public void printAttrFromName(DecoratedNode node, String printAttribute) {
        Map<String, Object> attributeMap = Debug.allAttributesThunkMap(node);
        Thunk finalTunk = (Thunk)attributeMap.get(printAttribute);
        System.out.println(Util.genericShow(finalTunk.eval()));
    }

    public void attributeDataHTML(DecoratedNode node, String printAttribute) {
        Map<String, Object> attributeMap = Debug.allAttributesObjectMap(node);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter("attribute_values.html"));){
            writer.write("<!DOCTYPE html>\n");
            writer.write("<html>\n");
            writer.write("<body>\n");
            writer.write("<pre>\n");
            for (Map.Entry<String, Object> entry : attributeMap.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (key.equals(printAttribute)) {
                    writer.write("<span style=\"color: red;\"><strong>");
                }
                writer.write(key + ": " + Util.genericShow(value));
                if (key.equals(printAttribute)) {
                    writer.write("</strong></span>");
                }
                writer.newLine();
            }
            writer.write("</pre>\n");
            writer.write("</body>\n");
            writer.write("</html>\n");
        }
        catch (IOException e) {
            System.err.println("Error writing to file: " + e.getMessage());
        }
    }

    public void algorithmicDebugg(DecoratedNode node, String attriburteName) {
        Map<String, Lazy> lazyMap = Debug.allAttributesLazyMap(node);
        if (lazyMap.containsKey(attriburteName)) {
            Lazy attributeLazy = lazyMap.get(attriburteName);
            NLocation loc = attributeLazy.getSourceLocation();
            String qualifier = Integer.toHexString(System.identityHashCode(this));
            if (loc != null) {
                String filePath = loc.synthesized(Init.silver_core_filename__ON__silver_core_Location).toString();
                int startLine = (Integer)loc.synthesized(Init.silver_core_line__ON__silver_core_Location);
                int endLine = (Integer)loc.synthesized(Init.silver_core_endLine__ON__silver_core_Location);
                try {
                    System.out.println("Equation: \n");
                    Debug.printLines(filePath, startLine, endLine);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        System.out.println("Data: \n");
        Map<String, Object> attributeMap = Debug.allAttributesObjectMap(node);
        String partentProduction = node.undecorate().getProdleton().getTypeUnparse();
        int index1 = partentProduction.indexOf("::");
        int index2 = attriburteName.indexOf(":");
        String parentNameInEquation = partentProduction.substring(0, index1) + "." + attriburteName.substring(index2 + 1);
        System.out.println(parentNameInEquation + ": " + Util.genericShow(attributeMap.get(attriburteName)));
        String currentProduction = this.currentNode.undecorate().getProdleton().getTypeUnparse();
        String[] listCurrentProduction = currentProduction.split("\\s+");
        String[] childFullNames = Arrays.copyOfRange(listCurrentProduction, 2, listCurrentProduction.length);
        String[] childFrontNames = new String[childFullNames.length];
        for (int i = 0; i < childFullNames.length; ++i) {
            int index = childFullNames[i].indexOf("::");
            childFrontNames[i] = childFullNames[i].substring(0, index) + ".";
            System.out.println(childFrontNames[i]);
        }
    }

    public static void printLines(String filePath, int startLine, int endLine) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
            String line;
            int currentLine;
            for (currentLine = 1; (line = reader.readLine()) != null && currentLine < startLine; ++currentLine) {
            }
            while (line != null && currentLine <= endLine) {
                System.out.println(line);
                line = reader.readLine();
                ++currentLine;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static List<String> getLocalAttrs(DecoratedNode node) {
        int count = node.getNode().getNumberOfLocalAttrs();
        ArrayList<String> listLocals = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            Lazy attribute = node.getNode().getLocal(i);
            Object o = attribute.eval(node);
            listLocals.add(node.getNode().getNameOfLocalAttr(i));
        }
        return listLocals;
    }

    public DecoratedNode into(DecoratedNode node, String attriburteName) {
        Map<String, Object> attributeMap = Debug.allAttributesObjectMap(node);
        if (attributeMap.containsKey(attriburteName)) {
            System.out.println("In into function");
            Object attributeObject = attributeMap.get(attriburteName);
            return (DecoratedNode)attributeObject;
        }
        return null;
    }

    public static List<String> allAttributesList(DecoratedNode node) {
        RTTIManager.Prodleton<? extends Node> prodleton = node.getNode().getProdleton();
        RTTIManager.Nonterminalton<? extends Node> nonterminalton = prodleton.getNonterminalton();
        List<String> attributeList = nonterminalton.alphabeticalAttributes();
        List<String> localAttributeList = Debug.getLocalAttrs(node);
        attributeList.addAll(localAttributeList);
        attributeList.sort(null);
        return attributeList;
    }

    public static Map<String, Object> allAttributesObjectMap(DecoratedNode node) {
        List<String> attributeList = Debug.allAttributesList(node);
        RTTIManager.Prodleton<? extends Node> prodleton = node.getNode().getProdleton();
        RTTIManager.Nonterminalton<? extends Node> nonterminalton = prodleton.getNonterminalton();
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        for (String attribute : attributeList) {
            Integer index;
            if (nonterminalton.getSynOccursIndices().keySet().contains(attribute)) {
                index = nonterminalton.getSynOccursIndex(attribute);
                Lazy synthAttribute = node.getNode().getSynthesized(index);
                Object o = synthAttribute.eval(node);
                attributeMap.put(attribute, o);
                continue;
            }
            if (nonterminalton.getInhOccursIndices().keySet().contains(attribute)) {
                index = nonterminalton.getInhOccursIndex(attribute);
                Object o = node.evalInhSomehowButPublic(index);
                attributeMap.put(attribute, o);
                continue;
            }
            List<String> listLocals = Debug.getLocalAttrs(node);
            Integer index2 = listLocals.indexOf(attribute);
            Lazy localAttribute = node.getNode().getLocal(index2);
            Object o = localAttribute.eval(node);
            attributeMap.put(attribute, o);
        }
        return attributeMap;
    }

    public static Map<String, Object> allAttributesThunkMap(DecoratedNode node) {
        List<String> attributeList = Debug.allAttributesList(node);
        RTTIManager.Prodleton<? extends Node> prodleton = node.getNode().getProdleton();
        RTTIManager.Nonterminalton<? extends Node> nonterminalton = prodleton.getNonterminalton();
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        for (String attribute : attributeList) {
            Object o;
            Integer index;
            if (nonterminalton.getSynOccursIndices().keySet().contains(attribute)) {
                index = nonterminalton.getSynOccursIndex(attribute);
                o = node.contextSynthesizedLazy(index);
                attributeMap.put(attribute, o);
                continue;
            }
            if (nonterminalton.getInhOccursIndices().keySet().contains(attribute)) {
                index = nonterminalton.getInhOccursIndex(attribute);
                o = node.contextInheritedLazy(index);
                attributeMap.put(attribute, o);
                continue;
            }
            List<String> listLocals = Debug.getLocalAttrs(node);
            Integer index2 = listLocals.indexOf(attribute);
            Object o2 = node.localLazy(index2);
            attributeMap.put(attribute, o2);
        }
        return attributeMap;
    }

    public static Map<String, Lazy> allAttributesLazyMap(DecoratedNode node) {
        List<String> attributeList = Debug.allAttributesList(node);
        RTTIManager.Prodleton<? extends Node> prodleton = node.getNode().getProdleton();
        RTTIManager.Nonterminalton<? extends Node> nonterminalton = prodleton.getNonterminalton();
        HashMap<String, Lazy> attributeMap = new HashMap<String, Lazy>();
        for (String attribute : attributeList) {
            Integer index;
            if (nonterminalton.getSynOccursIndices().keySet().contains(attribute)) {
                index = nonterminalton.getSynOccursIndex(attribute);
                Lazy synthAttribute = node.getNode().getSynthesized(index);
                attributeMap.put(attribute, synthAttribute);
                continue;
            }
            if (nonterminalton.getInhOccursIndices().keySet().contains(attribute)) {
                index = nonterminalton.getInhOccursIndex(attribute);
                Lazy inheritedAttribute = node.getInheritedAttribute(index);
                attributeMap.put(attribute, inheritedAttribute);
                continue;
            }
            List<String> listLocals = Debug.getLocalAttrs(node);
            Integer index2 = listLocals.indexOf(attribute);
            Lazy localAttribute = node.getNode().getLocal(index2);
            attributeMap.put(attribute, localAttribute);
        }
        return attributeMap;
    }

    public static Integer chooseFormList(Scanner inp, String[] list) {
        for (int i = 0; i < list.length; ++i) {
            System.out.println(Integer.toString(i) + ": " + list[i]);
        }
        boolean continueLoop = true;
        int returnInt = -1;
        String stopper = "";
        while (continueLoop) {
            System.out.print(">DEBUGGER-PROMPT$");
            if (inp.hasNextInt()) {
                returnInt = inp.nextInt();
                inp.nextLine();
                continueLoop = false;
                continue;
            }
            stopper = inp.nextLine();
            if (stopper.equals("q")) {
                continueLoop = false;
                continue;
            }
            System.out.println("Please choose an integer or q to exit");
        }
        return returnInt;
    }

    public boolean isContractum(DecoratedNode node) {
        return node.getNode().hasForward();
    }

    public static class StringObjectPair {
        private String stringValue;
        private Object objectValue;

        public StringObjectPair(String stringValue, Object objectValue) {
            this.stringValue = stringValue;
            this.objectValue = objectValue;
        }

        public String getString() {
            return this.stringValue;
        }

        public Object getObject() {
            return this.objectValue;
        }
    }
}

