/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.FileCoordinate;

public class FileRange {
    private final FileCoordinate coord1;
    private final FileCoordinate coord2;

    public FileRange(FileCoordinate coord1, FileCoordinate coord2) {
        this.coord1 = coord1;
        this.coord2 = coord2;
    }

    public boolean contains(FileRange range) {
        return this.contains(range.coord1) && this.contains(range.coord2);
    }

    public boolean contains(FileCoordinate coord) {
        FileCoordinate topLeft = this.getTopLeft();
        FileCoordinate bottomRight = this.getBottomRight();
        if (coord.getRow() < topLeft.getRow() || coord.getRow() > bottomRight.getRow()) {
            return false;
        }
        return coord.getCol() >= topLeft.getCol() && coord.getCol() <= bottomRight.getCol();
    }

    public FileCoordinate getTopLeft() {
        int row = Math.min(this.coord1.getRow(), this.coord2.getRow());
        int col = Math.min(this.coord1.getCol(), this.coord2.getCol());
        if (this.coord1.getRow() == row && this.coord1.getCol() == col) {
            return this.coord1;
        }
        if (this.coord2.getRow() == row && this.coord2.getCol() == col) {
            return this.coord2;
        }
        return new FileCoordinate(row, col);
    }

    public FileCoordinate getBottomRight() {
        int row = Math.max(this.coord1.getRow(), this.coord2.getRow());
        int col = Math.max(this.coord1.getCol(), this.coord2.getCol());
        if (this.coord1.getRow() == row && this.coord1.getCol() == col) {
            return this.coord1;
        }
        if (this.coord2.getRow() == row && this.coord2.getCol() == col) {
            return this.coord2;
        }
        return new FileCoordinate(row, col);
    }

    public String toString() {
        return String.format("%s -> %s", this.getTopLeft(), this.getBottomRight());
    }
}

