/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.Feature;
import common.ProductionName;
import java.util.List;

public class SimplifiedContextBox {
    public int translation_x;
    public int higher_order_y;
    public String text_syntax;
    public String syntax_to_highlight;
    public ProductionName[] prods_visited;
    public List<Feature> features;
    private String sectionSep = "--------------------\n";

    public String getTreeOrderHTML() {
        if (this.translation_x == 0 && this.higher_order_y == 0) {
            return "0";
        }
        String res = "";
        if (this.translation_x > 0) {
            res = res + "TRANSLATION-" + this.translation_x;
        }
        if (this.higher_order_y > 0) {
            res = ", HIGHER-ORDER-" + this.higher_order_y;
        }
        return res;
    }

    public String getAllSyntaxHTML() {
        return this.text_syntax;
    }

    public String getSyntaxToHighlightHTML() {
        return this.syntax_to_highlight;
    }

    public String getProductionsVisitedHTML() {
        String res = "";
        for (int i = 0; i < this.prods_visited.length; ++i) {
            res = res + this.prods_visited[i].toString() + "; ";
        }
        return res;
    }

    public String getFeaturesHTML() {
        if (this.features.size() == 0) {
            return "";
        }
        String res = "";
        for (Feature feature : this.features) {
            res = res + feature.toString() + "; ";
        }
        return res;
    }

    public String getHTMLBox() {
        String res = "";
        res = res + "<div><h2>Tree Order:</h2>";
        res = res + "<p>" + this.getTreeOrderHTML() + "</p></div>";
        res = res + "<div><h2>ALL SYNTAX</h2>";
        res = res + "<p>" + this.getAllSyntaxHTML() + "</p></div>";
        res = res + "<div><h2>TO HIGHLIGHT</h2>";
        res = res + "<p>" + this.getSyntaxToHighlightHTML() + "</p></div>";
        res = res + "<div><h2>Productions Visited:</h2>";
        res = res + "<p>" + this.getProductionsVisitedHTML() + "</p></div>";
        res = res + "<div><h2>Features:</h2>";
        res = res + "<p>" + this.getFeaturesHTML() + "</p></div>";
        return res;
    }

    public String getSection1Str() {
        String top = "Tree Order: ";
        if (this.translation_x == 0 && this.higher_order_y == 0) {
            return top + "0\n";
        }
        top = top + "\n";
        String trans = "";
        if (this.translation_x > 0) {
            trans = "TRANSLATION-" + this.translation_x + "\n";
        }
        String higher = "";
        if (this.higher_order_y > 0) {
            higher = "HIGHER-ORDER-" + this.higher_order_y + "\n";
        }
        return top + trans + higher;
    }

    public String getSection2Str() {
        String header1 = "^^^^^ALL SYNTAX^^^^^\n";
        String header2 = "\n^^^^^TO HIGHLIGHT^^^^^\n";
        return header1 + this.text_syntax + header2 + this.syntax_to_highlight + "\n";
    }

    public String getSection3Str() {
        String res = "Productions Visited: \n";
        for (int i = 0; i < this.prods_visited.length; ++i) {
            res = res + "\t" + this.prods_visited[i].toString() + "\n";
        }
        return res;
    }

    public String getSection4Str() {
        if (this.features.size() == 0) {
            return "";
        }
        String res = "Features: \n";
        for (Feature feature : this.features) {
            res = res + "\t" + feature.toString() + "\n";
        }
        return res;
    }

    public String toString() {
        return this.getSection1Str() + this.sectionSep + this.getSection2Str() + this.sectionSep + this.getSection3Str() + this.sectionSep + this.getSection4Str();
    }
}

