/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar;

import edu.umn.cs.melt.copper.compiletime.logging.CompilerLevel;
import edu.umn.cs.melt.copper.compiletime.logging.CompilerLogHandler;
import edu.umn.cs.melt.copper.compiletime.logging.PrintCompilerLogHandler;
import edu.umn.cs.melt.copper.compiletime.pipeline.AuxiliaryMethods;
import edu.umn.cs.melt.copper.compiletime.pipeline.Pipeline;
import edu.umn.cs.melt.copper.compiletime.pipeline.UniversalProcessParameters;
import edu.umn.cs.melt.copper.compiletime.skins.xml.XMLSkinParser;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.ParserBean;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.FringeSymbols;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.GrammarName;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.GrammarSource;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammarbeans.visitors.ParserSpecProcessor;
import edu.umn.cs.melt.copper.legacy.compiletime.concretesyntax.GrammarParser;
import edu.umn.cs.melt.copper.legacy.compiletime.concretesyntax.oldxml.XMLGrammarParser;
import edu.umn.cs.melt.copper.legacy.compiletime.concretesyntax.skins.cup.CupSkinParser;
import edu.umn.cs.melt.copper.legacy.compiletime.finiteautomaton.lalrengine.lalr1.LALR1DFABuilder;
import edu.umn.cs.melt.copper.legacy.compiletime.logging.CompilerLogMessageSort;
import edu.umn.cs.melt.copper.legacy.compiletime.logging.CompilerLogger;
import edu.umn.cs.melt.copper.legacy.compiletime.logging.FinalReporter;
import edu.umn.cs.melt.copper.legacy.compiletime.logging.GrammarDumper;
import edu.umn.cs.melt.copper.legacy.compiletime.logging.PlainTextGrammarDumper;
import edu.umn.cs.melt.copper.legacy.compiletime.logging.StringBasedCompilerLogger;
import edu.umn.cs.melt.copper.legacy.compiletime.logging.XMLGrammarDumper;
import edu.umn.cs.melt.copper.legacy.compiletime.semantics.lalr1.ComposabilityChecker;
import edu.umn.cs.melt.copper.legacy.compiletime.semantics.lalr1.WellFormedGrammarChecker;
import edu.umn.cs.melt.copper.legacy.compiletime.srcbuilders.enginebuilders.EngineBuilder;
import edu.umn.cs.melt.copper.legacy.compiletime.srcbuilders.enginebuilders.lalr.LALREngineBuilder;
import edu.umn.cs.melt.copper.legacy.compiletime.srcbuilders.enginebuilders.moded.MainFunctionBuilders;
import edu.umn.cs.melt.copper.legacy.compiletime.srcbuilders.enginebuilders.moded.ModedEngineBuilder;
import edu.umn.cs.melt.copper.legacy.compiletime.srcbuilders.enginebuilders.single.SingleDFAEngineBuilder;
import edu.umn.cs.melt.copper.legacy.compiletime.srcbuilders.enginebuilders.split.SplitEngineBuilder;
import edu.umn.cs.melt.copper.main.CopperDumpControl;
import edu.umn.cs.melt.copper.main.CopperEngineType;
import edu.umn.cs.melt.copper.main.CopperSkinType;
import edu.umn.cs.melt.copper.main.ParserCompilerParameters;
import edu.umn.cs.melt.copper.runtime.auxiliary.Pair;
import edu.umn.cs.melt.copper.runtime.logging.CopperException;
import edu.umn.cs.melt.copper.runtime.logging.CopperParserException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;

public class LegacyPipeline
implements Pipeline {
    private HashSet<String> customSwitches = new HashSet();

    public LegacyPipeline() {
        this.customSwitches.add("isPretty");
        this.customSwitches.add("gatherStatistics");
        this.customSwitches.add("runtimeQuietLevel");
    }

    private CompilerLogger getOldStyleLogger(edu.umn.cs.melt.copper.compiletime.logging.CompilerLogger newStyleLogger, UniversalProcessParameters args) {
        StringBasedCompilerLogger logger = new StringBasedCompilerLogger();
        CompilerLogHandler handler = newStyleLogger.getHandler();
        if (handler instanceof PrintCompilerLogHandler) {
            logger.setOut(((PrintCompilerLogHandler)handler).getOut());
        }
        switch (newStyleLogger.getLevel()) {
            case MUTE: 
            case QUIET: {
                logger.setLevel(CompilerLogMessageSort.getQuietSort().getLevel());
                break;
            }
            case REGULAR: {
                logger.setLevel(CompilerLogMessageSort.getDefaultSort().getLevel());
                break;
            }
            case VERBOSE: {
                logger.setLevel(CompilerLogMessageSort.getVerboseSort().getLevel());
                break;
            }
            case VERY_VERBOSE: {
                logger.setLevel(CompilerLogMessageSort.getVeryVerboseSort().getLevel());
            }
        }
        return logger;
    }

    private GrammarSource parseInputGrammarLegacy(ParserCompilerParameters args) {
        ArrayList<Pair<String, Object>> inputs = args.getInputs();
        ArrayList<Pair<String, Reader>> files = new ArrayList<Pair<String, Reader>>();
        boolean fileError = false;
        for (Pair<String, Object> i : inputs) {
            Reader second = null;
            if (i.second() instanceof Reader) {
                second = (Reader)i.second();
            } else if (i.second() instanceof File) {
                try {
                    second = new FileReader((File)i.second());
                }
                catch (FileNotFoundException ex) {
                    System.err.println("File not found: " + i.second());
                    fileError = true;
                }
            } else if (i.second() instanceof String) {
                try {
                    second = new FileReader((String)i.second());
                }
                catch (FileNotFoundException ex) {
                    System.err.println("File not found: " + i.second());
                    fileError = true;
                }
            } else {
                System.err.println("Inputs to the legacy pipeline must be open streams or filenames");
                fileError = true;
            }
            files.add(Pair.cons(i.first(), second));
        }
        if (fileError) {
            return null;
        }
        boolean isComposition = args.isRunMDA();
        CopperSkinType useSkin = args.getUseSkin();
        if (isComposition && (useSkin != CopperSkinType.XML && files.size() != 2 || useSkin == CopperSkinType.XML && files.size() != 1)) {
            System.err.println("Switch -compose requires exactly two input grammars");
            return null;
        }
        edu.umn.cs.melt.copper.compiletime.logging.CompilerLogger newStyleLogger = AuxiliaryMethods.getOrMakeLogger(args);
        CompilerLogger logger = this.getOldStyleLogger(newStyleLogger, args);
        WellFormedGrammarChecker wfcheck = new WellFormedGrammarChecker(logger);
        GrammarSource grammar = null;
        if (logger.isLoggable(CompilerLogMessageSort.TICK)) {
            logger.logTick(1, "Reading grammar");
        }
        switch (useSkin) {
            case NATIVE: {
                try {
                    grammar = GrammarParser.parseGrammar(files, logger);
                }
                catch (Exception ex) {
                    if (logger.isLoggable(CompilerLogMessageSort.TICK)) {
                        System.err.println();
                    }
                    if (logger.isLoggable(CompilerLogMessageSort.DEBUG)) {
                        ex.printStackTrace(System.err);
                    }
                    return null;
                }
                grammar.getParserSources().setPackageName(args.getPackageName());
                grammar.getParserSources().setParserName(args.getParserName());
                break;
            }
            case OLD_XML: {
                try {
                    grammar = XMLGrammarParser.parseGrammar(files, logger);
                }
                catch (CopperException ex) {
                    if (logger.isLoggable(CompilerLogMessageSort.TICK)) {
                        System.err.println();
                    }
                    if (logger.isLoggable(CompilerLogMessageSort.DEBUG)) {
                        ex.printStackTrace(System.err);
                    }
                    return null;
                }
                catch (Exception ex) {
                    if (logger.isLoggable(CompilerLogMessageSort.TICK)) {
                        System.err.println();
                    }
                    if (logger.isLoggable(CompilerLogMessageSort.DEBUG)) {
                        ex.printStackTrace(System.err);
                    } else {
                        System.err.println("An unexpected fatal error has occurred. Run with -vv for debug information.");
                    }
                    return null;
                }
                if (args.getPackageName() != null) {
                    grammar.getParserSources().setPackageName(args.getPackageName());
                }
                if (args.getParserName() == null || args.getParserName().equals("")) break;
                grammar.getParserSources().setParserName(args.getParserName());
                break;
            }
            case XML: {
                try {
                    ParserBean parser = new XMLSkinParser(files, newStyleLogger).parse();
                    if (parser != null) {
                        grammar = ParserSpecProcessor.buildGrammarSource(parser, newStyleLogger);
                    }
                }
                catch (CopperException ex) {
                    if (logger.isLoggable(CompilerLogMessageSort.TICK)) {
                        System.err.println();
                    }
                    if (logger.isLoggable(CompilerLogMessageSort.DEBUG)) {
                        ex.printStackTrace(System.err);
                    }
                    return null;
                }
                catch (Exception ex) {
                    if (logger.isLoggable(CompilerLogMessageSort.TICK)) {
                        System.err.println();
                    }
                    if (logger.isLoggable(CompilerLogMessageSort.DEBUG)) {
                        ex.printStackTrace(System.err);
                    } else {
                        System.err.println("An unexpected fatal error has occurred. Run with -vv for debug information.");
                    }
                    return null;
                }
                if (args.getPackageName() != null) {
                    grammar.getParserSources().setPackageName(args.getPackageName());
                }
                if (args.getParserName() == null || args.getParserName().equals("")) break;
                grammar.getParserSources().setParserName(args.getParserName());
                break;
            }
            default: {
                try {
                    grammar = CupSkinParser.parseGrammar(files, logger);
                }
                catch (Exception ex) {
                    if (logger.isLoggable(CompilerLogMessageSort.TICK)) {
                        System.err.println();
                    }
                    if (logger.isLoggable(CompilerLogMessageSort.DEBUG)) {
                        ex.printStackTrace(System.err);
                    }
                    return null;
                }
                if (args.getPackageName() != null) {
                    grammar.getParserSources().setPackageName(args.getPackageName());
                }
                if (args.getParserName() == null || args.getParserName().equals("")) break;
                grammar.getParserSources().setParserName(args.getParserName());
            }
        }
        if (grammar != null) {
            if (logger.isLoggable(CompilerLogMessageSort.DEBUG)) {
                logger.logMessage(CompilerLogMessageSort.DEBUG, null, grammar.toString());
            }
            if (logger.isLoggable(CompilerLogMessageSort.TICK)) {
                logger.logTick(1, "\nChecking grammar well-formedness");
            }
            try {
                wfcheck.checkWellFormedness(grammar, args.isWarnUselessNTs());
            }
            catch (CopperException ex) {
                if (logger.isLoggable(CompilerLogMessageSort.TICK)) {
                    System.err.println();
                }
                if (logger.isLoggable(CompilerLogMessageSort.DEBUG)) {
                    ex.printStackTrace(System.err);
                }
                grammar = null;
            }
        }
        return grammar;
    }

    private int compileParserLegacy(ParserCompilerParameters args, GrammarSource grammar) throws CopperException {
        String ancillaries;
        EngineBuilder engineBuilder;
        String packageDecl;
        boolean isPretty = args.getCustomSwitch("isPretty", Boolean.class, Boolean.FALSE);
        if (args.hasCustomSwitch("isPretty") && args.getCustomSwitch("isPretty") instanceof Boolean) {
            isPretty = (Boolean)args.getCustomSwitch("isPretty");
        }
        boolean isComposition = args.isRunMDA();
        boolean gatherStatistics = args.getCustomSwitch("gatherStatistics", Boolean.class, Boolean.FALSE);
        CopperEngineType useEngine = args.getUseEngine();
        edu.umn.cs.melt.copper.compiletime.logging.CompilerLogger newStyleLogger = args.getLogger();
        CompilerLogger logger = this.getOldStyleLogger(newStyleLogger, args);
        String string = args.getPackageName() != null && !args.getPackageName().equals("") ? args.getPackageName() : (packageDecl = grammar.getParserSources().getPackageName() != null && !grammar.getParserSources().getPackageName().equals("") ? grammar.getParserSources().getPackageName() : "");
        String parserName = args.getParserName() != null && !args.getParserName().equals("") ? args.getParserName() : (grammar.getParserSources().getParserName() != null && !grammar.getParserSources().getParserName().equals("") ? grammar.getParserSources().getParserName() : "Parser");
        String runtimeQuietLevel = args.getCustomSwitch("runtimeQuietLevel", String.class, "ERROR");
        if (useEngine != CopperEngineType.OLD_AND_SLOW && gatherStatistics) {
            System.err.println("Error: No facilities for gathering statistics in newer parse engines.\nUse -oldnslow in addition to -gatherstats.");
            return 1;
        }
        HashSet<GrammarName> containedGrammars = new HashSet<GrammarName>();
        containedGrammars.add(new GrammarName(FringeSymbols.STARTPRIME.getId()));
        for (GrammarName gn : grammar.getContainedGrammars()) {
            containedGrammars.add(gn);
        }
        LALR1DFABuilder builder = new LALR1DFABuilder(grammar, containedGrammars, logger);
        LALR1DFABuilder hostBuilder = null;
        GrammarSource hostGrammar = null;
        HashSet<GrammarName> hostOnly = new HashSet<GrammarName>();
        hostOnly.add(new GrammarName(FringeSymbols.STARTPRIME.getId()));
        if (isComposition) {
            hostOnly.add(grammar.getHostGrammarName());
            hostGrammar = ComposabilityChecker.extractWantedGrammars(grammar, hostOnly);
            hostBuilder = new LALR1DFABuilder(grammar, hostOnly, logger);
        }
        if (logger.isLoggable(CompilerLogMessageSort.TICK)) {
            logger.logTick(1, "\nComputing context sets");
        }
        try {
            grammar.getContextSets().compute(grammar, containedGrammars, logger);
            if (isComposition) {
                hostGrammar.getContextSets().compute(hostGrammar, hostOnly, logger);
            }
        }
        catch (CopperException ex) {
            return 1;
        }
        if (logger.isLoggable(CompilerLogMessageSort.TICK)) {
            logger.logTick(1, "\nBuilding LR DFA");
        }
        try {
            builder.buildDFA();
            if (isComposition) {
                hostBuilder.buildDFA();
            }
        }
        catch (CopperException ex) {
            return 1;
        }
        if (logger.isLoggable(CompilerLogMessageSort.TICK)) {
            logger.logTick(1, "\nLALRizing DFA");
        }
        try {
            builder.LALRize();
            if (isComposition) {
                hostBuilder.LALRize();
            }
        }
        catch (CopperException ex) {
            return 1;
        }
        if (logger.isLoggable(CompilerLogMessageSort.TICK)) {
            logger.logTick(1, "\nBuilding parse table");
        }
        try {
            builder.buildLALR1Table();
            if (isComposition) {
                hostBuilder.buildLALR1Table();
            }
        }
        catch (CopperException ex) {
            return 1;
        }
        if (logger.isLoggable(CompilerLogMessageSort.TICK)) {
            logger.logTick(1, "\nCulling parse table conflicts");
        }
        try {
            builder.cullConflictsLALR1();
            if (isComposition) {
                hostBuilder.cullConflictsLALR1();
            }
        }
        catch (CopperException ex) {
            return 1;
        }
        if (isComposition) {
            if (logger.isLoggable(CompilerLogMessageSort.TICK)) {
                logger.logTick(1, "\nChecking grammar composability");
            }
            ComposabilityChecker cchecker = new ComposabilityChecker(logger);
            boolean passed = false;
            try {
                passed = cchecker.checkComposability(hostGrammar, grammar, hostBuilder.getLALR1DFA(), builder.getLALR1DFA());
            }
            catch (CopperException ex) {
                System.exit(1);
            }
            if (!passed && logger.isLoggable(CompilerLogMessageSort.ERROR)) {
                logger.logMessage(CompilerLogMessageSort.ERROR, null, "Grammars " + containedGrammars + " not composable");
            }
        }
        if (logger.isLoggable(CompilerLogMessageSort.TICK)) {
            logger.logTick(1, "\nGenerating parser source code...\n");
        }
        PrintStream out = null;
        if (args.getOutputType() == null) {
            out = System.out;
        } else {
            switch (args.getOutputType()) {
                case FILE: {
                    try {
                        out = new PrintStream(args.getOutputFile());
                    }
                    catch (FileNotFoundException ex) {
                        if (logger.isLoggable(CompilerLogMessageSort.ERROR)) {
                            logger.logErrorMessage(CompilerLogMessageSort.ERROR, null, "Output file " + args.getOutputFile() + " could not be opened for writing");
                        }
                        out = System.out;
                    }
                    break;
                }
                case STREAM: {
                    out = args.getOutputStream();
                }
            }
        }
        String rootType = grammar.getNTAttributes(grammar.getStartSym()).getType();
        String errorType = CopperParserException.class.getName();
        switch (useEngine) {
            case SINGLE: {
                engineBuilder = new SingleDFAEngineBuilder(builder.getGrammar(), builder.getLALR1DFA(), builder.getParseTable(), logger);
                ancillaries = edu.umn.cs.melt.copper.legacy.compiletime.srcbuilders.enginebuilders.single.MainFunctionBuilders.buildSingleDFAParserAncillaries(packageDecl, parserName, gatherStatistics, isPretty, runtimeQuietLevel) + edu.umn.cs.melt.copper.legacy.compiletime.srcbuilders.enginebuilders.single.MainFunctionBuilders.buildSingleDFAParserMainFunction(packageDecl, parserName, rootType, errorType, gatherStatistics, isPretty, runtimeQuietLevel);
                break;
            }
            case MODED: {
                engineBuilder = new ModedEngineBuilder(builder.getGrammar(), builder.getLALR1DFA(), builder.getParseTable(), logger);
                ancillaries = MainFunctionBuilders.buildModedParserAncillaries(packageDecl, parserName, gatherStatistics, isPretty, runtimeQuietLevel) + MainFunctionBuilders.buildModedParserMainFunction(packageDecl, parserName, rootType, errorType, gatherStatistics, isPretty, runtimeQuietLevel);
                break;
            }
            case SPLIT: {
                engineBuilder = new SplitEngineBuilder(builder.getGrammar(), builder.getLALR1DFA(), builder.getParseTable(), logger);
                ancillaries = edu.umn.cs.melt.copper.legacy.compiletime.srcbuilders.enginebuilders.split.MainFunctionBuilders.buildSplitParserAncillaries(packageDecl, parserName, gatherStatistics, isPretty, runtimeQuietLevel) + edu.umn.cs.melt.copper.legacy.compiletime.srcbuilders.enginebuilders.split.MainFunctionBuilders.buildSplitParserMainFunction(packageDecl, parserName, rootType, errorType, gatherStatistics, isPretty, runtimeQuietLevel);
                break;
            }
            default: {
                engineBuilder = new LALREngineBuilder(builder.getGrammar(), builder.getLALR1DFA(), builder.getParseTable(), logger);
                ancillaries = edu.umn.cs.melt.copper.legacy.compiletime.srcbuilders.enginebuilders.lalr.MainFunctionBuilders.buildGeneralParserAncillaries(packageDecl, parserName, gatherStatistics, isPretty, runtimeQuietLevel);
            }
        }
        try {
            engineBuilder.buildLALREngine(out, packageDecl == null || packageDecl.equals("") ? "" : "package " + packageDecl + ";", "", parserName, parserName + "Scanner", ancillaries, "");
        }
        catch (IOException ex) {
            System.err.println("I/O error in code generation");
            ex.printStackTrace(System.err);
            return 1;
        }
        catch (CopperException ex) {
            if (logger.isLoggable(CompilerLogMessageSort.DEBUG)) {
                ex.printStackTrace(System.err);
            }
            return 1;
        }
        catch (Exception ex) {
            System.err.println("Unexpected error in code generation");
            ex.printStackTrace(System.err);
            return 1;
        }
        if (args.getDump() == CopperDumpControl.ON || args.getDump() == CopperDumpControl.ERROR_ONLY && logger.hasErrors()) {
            PrintStream dumpStream = null;
            if (args.getDump() == CopperDumpControl.OFF || args.getDumpFile() == null || args.getDumpFile().equals(args.getLogFile())) {
                dumpStream = logger.getOut();
            } else {
                try {
                    dumpStream = new PrintStream(new FileOutputStream(args.getDumpFile()));
                }
                catch (FileNotFoundException ex) {
                    ex.printStackTrace();
                }
            }
            GrammarDumper dumper = null;
            switch (args.getDumpFormat()) {
                case HTML: 
                case XML: {
                    try {
                        dumper = new XMLGrammarDumper(dumpStream, grammar, builder.getLALR1DFA(), builder.getParseTable());
                    }
                    catch (ParserConfigurationException ex) {
                        ex.printStackTrace();
                    }
                    break;
                }
                case PLAIN: {
                    dumper = new PlainTextGrammarDumper(dumpStream, grammar, builder.getLALR1DFA(), builder.getParseTable());
                    break;
                }
                default: {
                    System.err.println("Invalid dump type -- bug in CLI.");
                    System.exit(1);
                }
            }
            dumper.completeDump();
            switch (args.getDumpFormat()) {
                case HTML: {
                    dumper.logHTML();
                    break;
                }
                case XML: {
                    dumper.logXML();
                    break;
                }
                case PLAIN: {
                    dumper.logPlain();
                    break;
                }
            }
        }
        FinalReporter finalReporter = new FinalReporter(logger, grammar, builder.getParseTable(), engineBuilder.getScannerStateCount());
        if (logger.isLoggable(CompilerLogMessageSort.FINAL_REPORT)) {
            finalReporter.logFinalReport();
        }
        logger.flushMessages();
        return 0;
    }

    @Override
    public int execute(ParserCompilerParameters args) {
        int errorlevel;
        GrammarSource grammar = this.parseInputGrammarLegacy(args);
        if (grammar == null) {
            errorlevel = 1;
        } else {
            try {
                errorlevel = this.compileParserLegacy(args, grammar);
            }
            catch (CopperException ex) {
                if (args.getLogger().isLoggable(CompilerLevel.VERY_VERBOSE)) {
                    ex.printStackTrace(System.err);
                }
                errorlevel = 1;
            }
        }
        return errorlevel;
    }

    @Override
    public Set<String> getCustomSwitches() {
        return null;
    }

    @Override
    public int processCustomSwitch(ParserCompilerParameters args, String[] cmdline, int index) {
        if (cmdline[index].equals("-pretty")) {
            args.setCustomSwitch("isPretty", true);
            return index + 1;
        }
        if (cmdline[index].equals("-gatherstats")) {
            if (args.getCustomSwitch("gatherStatistics", String.class, "ERROR").equals("ERROR")) {
                args.setCustomSwitch("runtimeQuietLevel", "NOTA_BENE");
            }
            args.setCustomSwitch("gatherStatistics", true);
            return index + 1;
        }
        if (cmdline[index].equals("-runv")) {
            args.setCustomSwitch("runtimeQuietLevel", "INFO");
            return index + 1;
        }
        return -1;
    }

    @Override
    public String customSwitchUsage() {
        String rv = "";
        rv = rv + "\t-gatherstats\tSet the output parser to print parsing statistics\n";
        rv = rv + "\t\t\tinstead of a parse tree.\n";
        rv = rv + "\t-pretty\t\tSet the output parser to \"pretty-print\" its output in\n";
        rv = rv + "\t\t\thuman-readable form.\n";
        rv = rv + "\t-runv\t\tSet the output parser to run with extra verbosity.\n";
        return rv;
    }
}

