/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.builders;

import edu.umn.cs.melt.copper.compiletime.lrdfa.LR0DFA;
import edu.umn.cs.melt.copper.compiletime.lrdfa.LR0ItemSet;
import edu.umn.cs.melt.copper.compiletime.lrdfa.LRLookaheadAndLayoutSets;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.ContextSets;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.ParserSpec;
import java.util.BitSet;

public class LALRLookaheadAndLayoutSetBuilder {
    private ParserSpec spec;
    private ContextSets contextSets;
    private LR0DFA dfa;
    private BitSet[][] beginningLayout;
    private BitSet[][] lookaheadLayout;
    private BitSet lookaheadLayoutBuffer;

    private LALRLookaheadAndLayoutSetBuilder(ParserSpec spec, ContextSets contextSets, LR0DFA dfa) {
        this.spec = spec;
        this.contextSets = contextSets;
        this.dfa = dfa;
        this.lookaheadLayoutBuffer = new BitSet();
    }

    public static LRLookaheadAndLayoutSets build(ParserSpec spec, ContextSets contextSets, LR0DFA dfa) {
        return new LALRLookaheadAndLayoutSetBuilder(spec, contextSets, dfa).buildLA();
    }

    private LRLookaheadAndLayoutSets buildLA() {
        LRLookaheadAndLayoutSets lookaheadSets = new LRLookaheadAndLayoutSets(this.dfa);
        this.beginningLayout = new BitSet[this.dfa.size()][lookaheadSets.getMaxItemCount()];
        this.lookaheadLayout = new BitSet[this.dfa.size()][lookaheadSets.getMaxItemCount()];
        for (int i = 0; i < this.dfa.size(); ++i) {
            for (int j = 0; j < this.dfa.getItemSet(i).size(); ++j) {
                this.beginningLayout[i][j] = new BitSet(this.spec.terminals.length());
                this.lookaheadLayout[i][j] = new BitSet(this.spec.terminals.length());
            }
        }
        BitSet activeTransitions = new BitSet();
        BitSet[] fringeStates = new BitSet[2];
        BitSet[][] fringeItems = new BitSet[2][this.dfa.size()];
        fringeStates[0] = new BitSet();
        fringeStates[1] = new BitSet();
        for (int i = 0; i < this.dfa.size(); ++i) {
            fringeItems[0][i] = new BitSet();
            fringeItems[1][i] = new BitSet();
        }
        int lastFringe = 1;
        int currentFringe = 0;
        fringeStates[lastFringe].set(1);
        fringeItems[lastFringe][1].set(0);
        this.beginningLayout[1][0].or(this.spec.p.getLayout());
        boolean setsChanged = true;
        while (setsChanged) {
            setsChanged = false;
            int I = fringeStates[lastFringe].nextSetBit(0);
            while (I >= 0) {
                BitSet seedItems = fringeItems[lastFringe][I];
                this.computeLookaheadClosure(lookaheadSets, I, seedItems);
                activeTransitions.clear();
                int item = seedItems.nextSetBit(0);
                while (item >= 0) {
                    int X;
                    if (this.dfa.getItemSet(I).getPosition(item) < this.spec.pr.getRHSLength(this.dfa.getItemSet(I).getProduction(item)) && (X = this.spec.pr.getRHSSym(this.dfa.getItemSet(I).getProduction(item), this.dfa.getItemSet(I).getPosition(item))) != this.spec.getEOFTerminal()) {
                        activeTransitions.set(X);
                    }
                    item = seedItems.nextSetBit(item + 1);
                }
                int X = activeTransitions.nextSetBit(0);
                while (X >= 0) {
                    int J = this.dfa.getTransition(I, X);
                    int i = 0;
                    int item2 = this.dfa.getGotoItems(I, X).nextSetBit(0);
                    while (item2 >= 0) {
                        if (seedItems.get(item2)) {
                            boolean changed = false;
                            changed |= ParserSpec.union(lookaheadSets.getLookahead(J, i), lookaheadSets.getLookahead(I, item2));
                            lookaheadSets.getItemLASources(J, i).or(lookaheadSets.getItemLASources(I, item2));
                            changed |= ParserSpec.union(this.beginningLayout[J][i], this.beginningLayout[I][item2]);
                            changed |= ParserSpec.union(this.lookaheadLayout[J][i], this.lookaheadLayout[I][item2]);
                            if (this.dfa.getItemSet(J).getPosition(i) < this.spec.pr.getRHSLength(this.dfa.getItemSet(J).getProduction(i))) {
                                ParserSpec.union(lookaheadSets.getLayout(J), this.spec.pr.getLayouts(this.dfa.getItemSet(J).getProduction(i)));
                            }
                            if (changed) {
                                fringeStates[currentFringe].set(J);
                                fringeItems[currentFringe][J].set(i);
                            }
                        }
                        ++i;
                        item2 = this.dfa.getGotoItems(I, X).nextSetBit(item2 + 1);
                    }
                    X = activeTransitions.nextSetBit(X + 1);
                }
                seedItems.clear();
                I = fringeStates[lastFringe].nextSetBit(I + 1);
            }
            fringeStates[lastFringe].clear();
            if (fringeStates[currentFringe].isEmpty()) continue;
            currentFringe = currentFringe == 0 ? 1 : 0;
            lastFringe = lastFringe == 0 ? 1 : 0;
            setsChanged = true;
        }
        return lookaheadSets;
    }

    private void computeLookaheadClosure(LRLookaheadAndLayoutSets lookaheadSets, int state, BitSet seedItems) {
        LR0ItemSet stateI = this.dfa.getItemSet(state);
        BitSet fringe1 = new BitSet();
        BitSet fringe2 = new BitSet();
        BitSet combinedFirst = new BitSet();
        BitSet newItemLASources = new BitSet();
        fringe1.or(seedItems);
        boolean setsChanged = true;
        while (setsChanged) {
            setsChanged = false;
            int item = fringe1.nextSetBit(0);
            while (item >= 0) {
                combinedFirst.clear();
                newItemLASources.clear();
                this.lookaheadLayoutBuffer.clear();
                boolean useLookahead = this.computeCombinedFirst(state, item, combinedFirst, newItemLASources);
                if (stateI.getPosition(item) == 0) {
                    lookaheadSets.getLayout(state).or(this.beginningLayout[state][item]);
                } else if (stateI.getPosition(item) < this.spec.pr.getRHSLength(stateI.getProduction(item))) {
                    this.lookaheadLayoutBuffer.or(this.spec.pr.getLayouts(stateI.getProduction(item)));
                }
                if (useLookahead) {
                    if (stateI.getPosition(item) == this.spec.pr.getRHSLength(stateI.getProduction(item)) || this.contextSets.isNullable(this.spec.pr.getRHSSym(stateI.getProduction(item), stateI.getPosition(item)))) {
                        lookaheadSets.getLayout(state).or(this.lookaheadLayout[state][item]);
                    }
                    this.lookaheadLayoutBuffer.or(this.lookaheadLayout[state][item]);
                }
                if (stateI.getPosition(item) < this.spec.pr.getRHSLength(stateI.getProduction(item))) {
                    for (int i = 0; i < stateI.size(); ++i) {
                        if (stateI.getPosition(i) != 0 || this.spec.pr.getLHS(stateI.getProduction(i)) != this.spec.pr.getRHSSym(stateI.getProduction(item), stateI.getPosition(item))) continue;
                        boolean setChanged = false;
                        setChanged |= ParserSpec.union(lookaheadSets.getLookahead(state, i), combinedFirst);
                        lookaheadSets.getItemLASources(state, i).or(newItemLASources);
                        setChanged = stateI.getPosition(item) == 0 ? (setChanged |= ParserSpec.union(this.beginningLayout[state][i], this.beginningLayout[state][item])) : (setChanged |= ParserSpec.union(this.beginningLayout[state][i], this.spec.pr.getLayouts(stateI.getProduction(item))));
                        if (this.spec.pr.getRHSLength(stateI.getProduction(i)) > 0 && this.spec.terminals.get(this.spec.pr.getRHSSym(stateI.getProduction(i), 0))) {
                            ParserSpec.union(lookaheadSets.getLayout(state), this.beginningLayout[state][i]);
                        }
                        setChanged |= ParserSpec.union(this.lookaheadLayout[state][i], this.lookaheadLayoutBuffer);
                        if (useLookahead) {
                            setChanged |= ParserSpec.union(lookaheadSets.getLookahead(state, i), lookaheadSets.getLookahead(state, item));
                            lookaheadSets.getItemLASources(state, i).or(lookaheadSets.getItemLASources(state, item));
                        }
                        if (!setChanged) continue;
                        setsChanged = true;
                        fringe2.set(i);
                    }
                }
                item = fringe1.nextSetBit(item + 1);
            }
            seedItems.or(fringe2);
            fringe1.clear();
            fringe1.or(fringe2);
        }
    }

    private boolean computeCombinedFirst(int state, int item, BitSet combinedFirst, BitSet newItemLASources) {
        int beta;
        LR0ItemSet itemSet = this.dfa.getItemSet(state);
        int production = itemSet.getProduction(item);
        int position = itemSet.getPosition(item);
        boolean stillNullable = true;
        this.lookaheadLayoutBuffer.clear();
        for (int i = position + 1; i < this.spec.pr.getRHSLength(production) && stillNullable; stillNullable &= this.contextSets.isNullable(beta), ++i) {
            beta = this.spec.pr.getRHSSym(production, i);
            BitSet first = this.contextSets.getFirst(beta);
            combinedFirst.or(first);
            newItemLASources.or(this.contextSets.getFirstNTs(beta));
            if (!this.lookaheadLayoutBuffer.isEmpty() || first.isEmpty()) continue;
            this.lookaheadLayoutBuffer.or(this.spec.pr.getLayouts(production));
        }
        return stillNullable;
    }
}

