/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.scannerdfa;

import edu.umn.cs.melt.copper.compiletime.auxiliary.SetOfCharsSyntax;
import edu.umn.cs.melt.copper.compiletime.scannerdfa.GeneralizedFA;
import java.util.BitSet;

public class GeneralizedDFA
extends GeneralizedFA {
    private static final long serialVersionUID = 3407854286295700768L;
    protected int[][] transitions;
    int startState;

    public GeneralizedDFA(GeneralizedFA fa) {
        super(0, 0);
        this.nextNewStateNumber = fa.nextNewStateNumber;
        this.nextNewCharRangeNumber = fa.nextNewCharRangeNumber;
        this.charRangeNumbers = fa.charRangeNumbers;
        this.charRanges = fa.charRanges;
        this.acceptStates = fa.acceptStates;
        this.transitions = new int[this.nextNewStateNumber][this.nextNewCharRangeNumber];
    }

    public int getStartState() {
        return this.startState;
    }

    public void setStartState(int startState) {
        this.startState = startState;
    }

    @Override
    public void lengthenArrays() {
        BitSet[] newAcceptStates = new BitSet[2 * this.acceptStates.length];
        System.arraycopy(this.acceptStates, 0, newAcceptStates, 0, this.acceptStates.length);
        this.acceptStates = newAcceptStates;
        int[][] newTransitions = new int[2 * this.transitions.length][this.alphabetSize + 1];
        System.arraycopy(this.transitions, 0, newTransitions, 0, this.transitions.length);
        newTransitions = this.transitions;
    }

    public GeneralizedDFA(int numRegexes, int alphabetSize) {
        super(numRegexes, alphabetSize);
        int initialArraySizes = this.getInitialArraySizes(numRegexes);
        this.transitions = new int[initialArraySizes][alphabetSize + 1];
    }

    @Override
    public boolean addTransition(SetOfCharsSyntax chars, int src, int dest) {
        int charRangeNumber;
        if (src >= this.stateCount() || dest >= this.stateCount()) {
            return false;
        }
        if (this.charRangeNumbers.containsKey(chars) && this.transitions[src][(Integer)this.charRangeNumbers.get(chars)] != 0) {
            return false;
        }
        if (!this.charRangeNumbers.containsKey(chars)) {
            this.charRangeNumbers.put(chars, this.nextNewCharRangeNumber);
            this.charRanges[this.nextNewCharRangeNumber] = chars;
            charRangeNumber = this.nextNewCharRangeNumber++;
        } else {
            charRangeNumber = (Integer)this.charRangeNumbers.get(chars);
        }
        this.transitions[src][charRangeNumber] = dest;
        return true;
    }

    public int[][] getTransitions() {
        return this.transitions;
    }

    public BitSet getConnectedStates(int state) {
        if (state >= this.stateCount()) {
            return null;
        }
        BitSet rv = new BitSet(this.stateCount());
        for (int i = 0; i < this.transitions[state].length; ++i) {
            rv.set(this.transitions[state][i]);
        }
        return rv;
    }

    public String toString() {
        int i;
        StringBuffer rv = new StringBuffer();
        rv.append("Start state: " + this.startState + "\n");
        rv.append("Character sets:\n");
        for (i = 0; i < this.nextNewCharRangeNumber; ++i) {
            rv.append(i + ": " + this.charRanges[i] + "\n");
        }
        for (i = 0; i < this.nextNewStateNumber; ++i) {
            rv.append("   " + i);
            for (int k = 0; k < String.valueOf(this.nextNewStateNumber - 1).length() - String.valueOf(i).length() + 1; ++k) {
                rv.append(" ");
            }
            rv.append("- ");
            for (int j = 0; j < this.nextNewCharRangeNumber; ++j) {
                rv.append(this.transitions[i][j]);
                for (int k = 0; k < String.valueOf(this.nextNewStateNumber - 1).length() - String.valueOf(this.transitions[i][j]).length() + 1; ++k) {
                    rv.append(" ");
                }
            }
            rv.append(" - Accepts: " + this.acceptStates[i]);
            rv.append("\n");
        }
        return rv.toString();
    }
}

