/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.ide.silver.property.ui;

import edu.umn.cs.melt.ide.silver.property.Property;
import edu.umn.cs.melt.ide.silver.property.ui.AbstractPropertyControl;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class IntegerPropertyControl
extends AbstractPropertyControl {
    private Label info;
    private Text input;

    public IntegerPropertyControl(Composite panel, String name) {
        super(panel, name);
    }

    public IntegerPropertyControl(Composite panel, String name, String display, String defaultVal, boolean isRequired) {
        super(panel, name, display, defaultVal, isRequired);
    }

    @Override
    public Control getInfoControl() {
        if (this.info == null) {
            this.info = new Label(this.panel, 0);
            this.info.setText(this.display);
            this.info.setToolTipText("An integer");
        }
        return this.info;
    }

    @Override
    public Control getInputControl() {
        if (this.input == null) {
            this.input = new Text(this.panel, 2048);
        }
        return this.input;
    }

    @Override
    public Property getProperty() {
        return Property.makeIntegerProperty(this.name, Integer.parseInt(this.input.getText()), this.defaultVal, this.display, this.isRequired);
    }

    @Override
    public boolean validate() {
        String value = this.input.getText();
        if (!this.isFilled(value)) {
            this.input.setToolTipText("This field cannot be empty.");
            this.input.setBackground(this.panel.getDisplay().getSystemColor(3));
            return false;
        }
        boolean valid = true;
        try {
            Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            valid = false;
        }
        if (!valid) {
            this.input.setToolTipText("The value is not an integer.");
            this.input.setBackground(this.panel.getDisplay().getSystemColor(3));
            return false;
        }
        this.reset();
        return true;
    }

    private void reset() {
        this.input.setToolTipText(null);
        this.input.setBackground(this.panel.getDisplay().getSystemColor(1));
    }

    @Override
    public String getKey() {
        return this.name;
    }

    @Override
    public void setValue(String value) {
        this.input.setText(value);
    }
}

