/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.ide.imp.builders;

import java.util.Hashtable;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;

public class Nature
implements IProjectNature,
IExecutableExtension {
    private IProject project;
    private String builderID;

    public void setInitializationData(IConfigurationElement config, String property, Object data) throws CoreException {
        if (!(data instanceof Hashtable)) {
            return;
        }
        Hashtable d = (Hashtable)data;
        this.builderID = (String)d.get("builder");
    }

    public static void addToProject(IProject project, String natureID) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        int i = 0;
        while (i < natures.length) {
            if (natures[i].equals(natureID)) {
                System.out.println("nature " + natureID + " already present.");
                return;
            }
            ++i;
        }
        String[] newNatures = new String[natures.length + 1];
        System.arraycopy(natures, 0, newNatures, 0, natures.length);
        newNatures[natures.length] = natureID;
        description.setNatureIds(newNatures);
        project.setDescription(description, null);
    }

    public void configure() throws CoreException {
        if (this.builderID == null) {
            System.out.println("no builderID configured for SV nature.");
            return;
        }
        IProjectDescription desc = this.getProject().getDescription();
        ICommand[] cmds = desc.getBuildSpec();
        int i = 0;
        while (i < cmds.length) {
            if (cmds[i].getBuilderName().equals(this.builderID)) {
                System.out.println("odd, the builder is already present.");
                return;
            }
            ++i;
        }
        ICommand buildCmd = desc.newCommand();
        buildCmd.setBuilderName(this.builderID);
        ICommand[] newCmds = new ICommand[cmds.length + 1];
        System.arraycopy(cmds, 0, newCmds, 0, cmds.length);
        newCmds[cmds.length] = buildCmd;
        desc.setBuildSpec(newCmds);
        this.project.setDescription(desc, null);
    }

    public void deconfigure() throws CoreException {
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject arg0) {
        this.project = arg0;
    }
}

