/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.ide.eclipse.property;

import edu.umn.cs.melt.ide.eclipse.property.IPropertyPageTab;
import edu.umn.cs.melt.ide.impl.SVInterface;
import edu.umn.cs.melt.ide.impl.SVRegistry;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.dialogs.PropertyPage;

public class MultiTabPropertyPage
extends PropertyPage {
    private String[] names;
    private IPropertyPageTab[] tabs;
    private int tabNum;
    private TabFolder folder;

    public MultiTabPropertyPage() {
        SVInterface sv = SVRegistry.get();
        this.tabs = sv.getPropertyTabs();
        this.names = new String[this.tabs.length];
        int i = 0;
        while (i < this.tabs.length) {
            this.names[i] = this.tabs[i].getName();
            ++i;
        }
        this.tabNum = this.tabs.length;
    }

    protected Control createContents(Composite parent) {
        this.folder = new TabFolder(parent, 0);
        int i = 0;
        while (i < this.tabNum) {
            TabItem item = new TabItem(this.folder, 0);
            item.setText(this.names[i]);
            Composite panel = new Composite((Composite)this.folder, 0);
            item.setControl((Control)panel);
            this.tabs[i].setPropertyPage(this);
            this.tabs[i].fillInTabItem(panel);
            ++i;
        }
        return this.folder;
    }

    public boolean performOk() {
        IPropertyPageTab tab = this.getSelectedTab();
        return tab != null ? tab.performOk() : true;
    }

    public void performDefaults() {
        IPropertyPageTab tab = this.getSelectedTab();
        if (tab != null) {
            tab.performDefaults();
        }
    }

    private IPropertyPageTab getSelectedTab() {
        int index = this.folder.getSelectionIndex();
        if (index > -1) {
            return this.tabs[index];
        }
        return null;
    }

    IProject getProject() {
        return (IProject)this.getElement().getAdapter(IProject.class);
    }
}

