/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.auxiliary;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;

public class SymbolTable<T>
implements Iterable<T>,
Serializable {
    private static final long serialVersionUID = -7596662020503434417L;
    private Hashtable<T, Integer> forward = new Hashtable();
    private Object[] reverse;

    public SymbolTable(Collection<T> objects) {
        this.reverse = objects.toArray();
        for (int i = 0; i < this.reverse.length; ++i) {
            this.forward.put(this.reverse[i], i);
        }
    }

    public T get(int i) {
        if (i < 0 || i >= this.size()) {
            return null;
        }
        return (T)this.reverse[i];
    }

    public int get(T o) {
        if (this.forward.containsKey(o)) {
            return this.forward.get(o);
        }
        return -1;
    }

    @Override
    public Iterator<T> iterator() {
        return this.forward.keySet().iterator();
    }

    public int size() {
        return this.reverse.length;
    }

    public Collection<T> cut(int offset, int count) {
        ArrayList<Object> cut = new ArrayList<Object>();
        if (offset < 0 || offset >= this.reverse.length || offset + count < 0 || offset + count >= this.reverse.length) {
            return cut;
        }
        for (int i = offset; i < offset + count; ++i) {
            cut.add(this.reverse[i]);
        }
        return cut;
    }

    public Collection<T> cut(BitSet members) {
        ArrayList<Object> cut = new ArrayList<Object>();
        int i = members.nextSetBit(0);
        while (i >= 0) {
            cut.add(this.reverse[i]);
            i = members.nextSetBit(i + 1);
        }
        return cut;
    }

    public int convert(SymbolTable<T> otherTable, int inOtherTable) {
        return this.get(otherTable.get(inOtherTable));
    }
}

