/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.srcbuilders.fragment;

import edu.umn.cs.melt.copper.compiletime.builders.ExtensionFragmentData;
import edu.umn.cs.melt.copper.compiletime.builders.ExtensionMappingSpec;
import edu.umn.cs.melt.copper.compiletime.builders.HostFragmentData;
import edu.umn.cs.melt.copper.compiletime.builders.SingleScannerDFAAnnotationBuilder;
import edu.umn.cs.melt.copper.compiletime.builders.SingleScannerDFABuilder;
import edu.umn.cs.melt.copper.compiletime.lrdfa.LRLookaheadAndLayoutSets;
import edu.umn.cs.melt.copper.compiletime.lrdfa.TransparentPrefixes;
import edu.umn.cs.melt.copper.compiletime.parsetable.LRParseTable;
import edu.umn.cs.melt.copper.compiletime.pipeline.ParserFragments;
import edu.umn.cs.melt.copper.compiletime.scannerdfa.GeneralizedDFA;
import edu.umn.cs.melt.copper.compiletime.scannerdfa.SingleScannerDFAAnnotations;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CopperASTBean;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CopperElementType;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.ParserAttribute;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.ParserBean;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.Regex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.Terminal;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.PSSymbolTable;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.ParserSpec;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.PrecedenceGraph;
import edu.umn.cs.melt.copper.main.ParserCompiler;
import edu.umn.cs.melt.copper.runtime.auxiliary.Pair;
import edu.umn.cs.melt.copper.runtime.auxiliary.internal.ByteArrayEncoder;
import edu.umn.cs.melt.copper.runtime.auxiliary.internal.QuotedStringFormatter;
import edu.umn.cs.melt.copper.runtime.engines.fragment.ParserFragmentEngine;
import edu.umn.cs.melt.copper.runtime.engines.semantics.SpecialParserAttributes;
import edu.umn.cs.melt.copper.runtime.engines.single.SingleDFAEngine;
import edu.umn.cs.melt.copper.runtime.engines.single.scanner.SingleDFAMatchData;
import edu.umn.cs.melt.copper.runtime.engines.single.semantics.SingleDFASemanticActionContainer;
import edu.umn.cs.melt.copper.runtime.io.InputPosition;
import edu.umn.cs.melt.copper.runtime.logging.CopperException;
import edu.umn.cs.melt.copper.runtime.logging.CopperParserException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ParserFragmentEngineBuilder {
    private static final int MARKING_TERMINAL_FRAGMENT_ID = 0;
    private HostFragmentData hostFragment;
    private List<ExtensionFragmentData> extensionFragments;
    private int extensionCount;
    private int fragmentCount;
    private int hostTerminalLength;
    private int[] extTerminalLengths;
    private int[] extStateOffset;
    private GeneralizedDFA markingTerminalScannerDFA;
    private SingleScannerDFAAnnotations markingTerminalScannerDFAAnnotations;
    private int[][] parseTable;
    private int[][][] deltas;
    private int[][] cmaps;
    private int totalStateCount;
    private int hostStateCount;
    private ArrayList<MarkingTerminalData> markingTerminalDatas;
    private int markingTerminalOffset;
    private int markingTerminalCount;
    private Map<Integer, MarkingTerminalData> markingTerminalLayouts;
    private int markingTerminalLayoutCount;
    private int[][] extTerminalUses;
    private int[] hostTerminalUses;
    private BitSet[] layoutSets;
    private BitSet[] prefixSets;
    private BitSet[] markingTerminalLayoutSets;
    private BitSet[] markingTerminalEmptyStateSets;
    private BitSet[][] prefixMaps;
    private BitSet[][] markingTerminalEmptyPrefixMaps;
    private BitSet[] shiftableSets;
    private BitSet[] markingTerminalShiftableSets;
    private BitSet[] extShiftableUnion;
    private BitSet hostStateShiftableUnion;
    private BitSet markingTerminalShiftableUnion;
    private int totalProductionCount;
    private int[] productionLengths;
    private Map<Integer, Map<Integer, Integer>> productionMap;
    private Map<Integer, Pair<Integer, Integer>> productionMapBack;
    private int[] productionCounts;
    private int[] productionLHSs;
    private String rootType;
    private String errorType;
    private Map<Integer, Pair<Integer, Integer>> disambiguationFunctionMapBack;
    private int totalDisambiguationFunctionCount;
    private int extTableOffset;
    private ParserBean hostParser;
    private String[] markingTerminalSymbolNames;
    private String[][] symbolNames;
    private String[] markingTerminalSymbolDisplayNames;
    private String[][] symbolDisplayNames;
    private List<ObjectToHash> objectsToHash;

    public ParserFragmentEngineBuilder(ParserFragments fragments) {
        this.hostFragment = fragments.hostFragment;
        this.extensionFragments = fragments.extensionFragments;
        this.extensionCount = this.extensionFragments.size();
        this.fragmentCount = this.extensionCount + 1;
        this.hostTerminalLength = this.hostFragment.fullSpec.terminals.length();
        this.extTerminalLengths = new int[this.extensionCount];
        for (int e = 0; e < this.extensionCount; ++e) {
            ExtensionMappingSpec spec = this.extensionFragments.get((int)e).extensionMappingSpec;
            this.extTerminalLengths[e] = spec.tableOffsetExtensionIndex(spec.extensionTerminalIndices.length());
        }
        this.extTableOffset = Math.max(this.hostTerminalLength, this.hostFragment.fullSpec.nonterminals.length());
        this.hostParser = this.hostFragment.symbolTable.getParser(this.hostFragment.fullSpec.parser);
    }

    public void buildEngine(PrintStream out, String packageDecl, String importDecls, String parserName, String scannerName, String parserAncillaries, String scannerAncillaries) throws IOException, CopperException {
        this.printSignature(out);
        this.printDecls(out, packageDecl, importDecls);
        this.rootType = this.hostFragment.symbolTable.getNonTerminal(this.hostFragment.fullSpec.pr.getRHSSym(this.hostFragment.fullSpec.getStartProduction(), 0)).getReturnType();
        this.rootType = this.rootType == null ? Object.class.getName() : this.rootType;
        this.errorType = CopperParserException.class.getName();
        out.println("public class " + parserName + " extends " + ParserFragmentEngine.class.getName() + "<" + this.rootType + "," + this.errorType + "> {");
        this.makeObjectsToBeHashed();
        this.printFixedMethods(out);
        this.printFragmentMethods(out);
        this.writeSemanticsClass(out);
        this.writeSemanticsClassUse(out);
        this.writeHashes(out);
        this.printParserAncillaryDecls(out);
        this.printParserAncillaryMethods(out);
        out.println(scannerAncillaries);
        this.writeStaticMemberInitializations(out);
        out.println("}");
    }

    private void generateSymbolNames() {
        MarkingTerminalData data;
        int t;
        this.markingTerminalSymbolNames = new String[this.markingTerminalCount + this.markingTerminalLayoutCount];
        this.symbolNames = new String[this.fragmentCount][];
        this.markingTerminalSymbolDisplayNames = new String[this.markingTerminalCount + this.markingTerminalLayoutCount];
        this.symbolDisplayNames = new String[this.fragmentCount][];
        for (t = 0; t < this.markingTerminalCount; ++t) {
            data = this.markingTerminalDatas.get(t);
            this.markingTerminalSymbolNames[t] = this.generateVariableName(data.extensionId + 1, data.extensionTerminal);
            this.markingTerminalSymbolDisplayNames[t] = data.terminal.getDisplayName();
        }
        for (t = 0; t < this.markingTerminalLayoutCount; ++t) {
            data = this.markingTerminalLayouts.get(t);
            this.markingTerminalSymbolNames[t + this.markingTerminalCount] = this.generateVariableName(data.extensionId + 1, data.extensionTerminal);
            this.markingTerminalSymbolDisplayNames[t + this.markingTerminalCount] = data.terminal.getDisplayName();
        }
        this.symbolNames[0] = new String[this.hostTerminalLength];
        this.symbolDisplayNames[0] = new String[this.hostTerminalLength];
        t = this.hostFragment.fullSpec.terminals.nextSetBit(0);
        while (t >= 0) {
            this.symbolNames[0][t] = this.generateVariableName(0, t);
            this.symbolDisplayNames[0][t] = ((CopperASTBean)this.hostFragment.symbolTable.get(t)).getDisplayName();
            t = this.hostFragment.fullSpec.terminals.nextSetBit(t + 1);
        }
        for (int e = 0; e < this.extensionCount; ++e) {
            ExtensionMappingSpec spec = this.extensionFragments.get((int)e).extensionMappingSpec;
            this.symbolNames[e + 1] = new String[this.extTerminalLengths[e]];
            this.symbolDisplayNames[e + 1] = new String[this.extTerminalLengths[e]];
            System.arraycopy(this.symbolNames[0], 0, this.symbolNames[e + 1], 0, this.hostTerminalLength);
            System.arraycopy(this.symbolDisplayNames[0], 0, this.symbolDisplayNames[e + 1], 0, this.hostTerminalLength);
            int t2 = spec.extensionTerminalIndices.nextSetBit(0);
            while (t2 >= 0) {
                this.symbolNames[e + 1][spec.tableOffsetExtensionIndex((int)t2)] = this.generateVariableName(e + 1, t2);
                this.symbolDisplayNames[e + 1][spec.tableOffsetExtensionIndex((int)t2)] = ((CopperASTBean)spec.extensionSymbolTable.get(t2)).getDisplayName();
                t2 = spec.extensionTerminalIndices.nextSetBit(t2 + 1);
            }
        }
    }

    private String[] getSymbolNames(int fragmentId) {
        return this.symbolNames[fragmentId];
    }

    private void writeSemanticsClass(PrintStream out) {
        ParserAttribute attr;
        out.println("  public class Semantics extends " + SingleDFASemanticActionContainer.class.getName() + "<" + this.errorType + "> {");
        int attrN = this.hostFragment.fullSpec.parserAttributes.nextSetBit(0);
        while (attrN >= 0) {
            attr = this.hostFragment.symbolTable.getParserAttribute(attrN);
            out.println("    public " + attr.getAttributeType() + " " + this.generateVariableName(0, attrN) + ";");
            attrN = this.hostFragment.fullSpec.parserAttributes.nextSetBit(attrN + 1);
        }
        out.println("    public Semantics() throws " + IOException.class.getName() + "," + this.errorType + " {");
        out.println("      runInit();");
        out.println("    }");
        out.println("    public void error(" + InputPosition.class.getName() + " pos," + String.class.getName() + " message) throws " + this.errorType + " {");
        out.println("      reportError(\"Error at \" + pos.toString() + \":\\n  \" + message);");
        out.println("    }");
        out.println("    public void runDefaultTermAction() throws " + IOException.class.getName() + "," + this.errorType + " {");
        if (this.hostParser.getDefaultTerminalCode() != null) {
            out.println("      " + this.hostParser.getDefaultTerminalCode() + "");
        }
        out.println("    }");
        out.println("    public void runDefaultProdAction() throws " + IOException.class.getName() + "," + this.errorType + " {");
        if (this.hostParser.getDefaultProductionCode() != null) {
            out.println("      " + this.hostParser.getDefaultProductionCode() + "");
        }
        out.println("    }");
        out.println("    public void runInit() throws " + IOException.class.getName() + "," + this.errorType + " {");
        if (this.hostParser.getParserInitCode() != null) {
            out.print("      " + this.hostParser.getParserInitCode());
        }
        attrN = this.hostFragment.fullSpec.parserAttributes.nextSetBit(0);
        while (attrN >= 0) {
            attr = this.hostFragment.symbolTable.getParserAttribute(attrN);
            if (attr.getCode() != null) {
                out.println("      " + attr.getCode());
            }
            attrN = this.hostFragment.fullSpec.parserAttributes.nextSetBit(attrN + 1);
        }
        out.println("    }");
        this.writeRunSemanticAction(out);
        this.writeRunProductionSemanticAction(out);
        this.writeRunTerminalSemanticAction(out);
        this.writeRunDisambiguationAction(out);
        this.writeRunDisambiguationActionMethods(out);
        out.println("    public void runPostParseCode(" + Object.class.getName() + " __root) {");
        if (this.hostParser.getPostParseCode() != null && !QuotedStringFormatter.isJavaWhitespace(this.hostParser.getPostParseCode())) {
            out.println("      " + this.rootType + " root = (" + this.rootType + ") __root;");
            out.println("      " + this.hostParser.getPostParseCode());
        }
        out.println("    }");
        out.println("  }");
    }

    private void writeRunSemanticAction(PrintStream out) {
        String code;
        int t;
        out.println("    public " + Object.class.getName() + " runSemanticAction(" + InputPosition.class.getName() + " _pos, " + Object.class.getName() + "[] _children, int _prod)");
        out.println("    throws " + IOException.class.getName() + "," + this.errorType + " {");
        out.println("      this._pos = _pos;");
        out.println("      this._children = _children;");
        out.println("      this._prod = _prod;");
        out.println("      this._specialAttributes = new " + SpecialParserAttributes.class.getName() + "(virtualLocation);");
        out.println("      " + Object.class.getName() + " RESULT = null;");
        out.println("      switch (_prod) {");
        for (Map.Entry<Integer, Pair<Integer, Integer>> entry : this.productionMapBack.entrySet()) {
            String productionCode;
            PSSymbolTable symbolTable;
            int p = entry.getKey();
            int fragment = entry.getValue().first();
            int fragmentIndex = entry.getValue().second();
            PSSymbolTable pSSymbolTable = symbolTable = fragment == 0 ? this.hostFragment.symbolTable : this.extensionFragments.get((int)(fragment - 1)).extensionMappingSpec.extensionSymbolTable;
            if (fragment == 0 && fragmentIndex == this.hostFragment.fullSpec.getStartProduction() || (productionCode = symbolTable.getProduction(fragmentIndex).getCode()) == null || QuotedStringFormatter.isJavaWhitespace(productionCode)) continue;
            out.println("        case " + p + ":");
            out.println("          RESULT = runSemanticAction_p" + p + "();");
            out.println("          break;");
        }
        out.println("        default:");
        out.println("          runDefaultProdAction();");
        out.println("          break;");
        out.println("      }");
        out.println("      return RESULT;");
        out.println("    }");
        out.println("    public " + Object.class.getName() + " runSemanticAction(" + InputPosition.class.getName() + " _pos, " + SingleDFAMatchData.class.getName() + " _terminal)");
        out.println("    throws " + IOException.class.getName() + "," + this.errorType + " {");
        out.println("      throw new " + UnsupportedOperationException.class.getName() + "();");
        out.println("    }");
        out.println("    public " + Object.class.getName() + " runSemanticTerminalAction(int fragmentId, " + InputPosition.class.getName() + " _pos, " + SingleDFAMatchData.class.getName() + " _terminal)");
        out.println("    throws " + IOException.class.getName() + "," + this.errorType + " {");
        out.println("      this._pos = _pos;");
        out.println("      this._terminal = _terminal;");
        out.println("      this._specialAttributes = new " + SpecialParserAttributes.class.getName() + "(virtualLocation);");
        out.println("      String lexeme = _terminal.lexeme;");
        out.println("      " + Object.class.getName() + " RESULT = null;");
        out.println("      if (fragmentId == 0) {");
        out.println("        switch(_terminal.firstTerm) {");
        for (t = 0; t < this.markingTerminalCount; ++t) {
            code = this.markingTerminalDatas.get((int)t).terminal.getCode();
            if (code == null || QuotedStringFormatter.isJavaWhitespace(code)) continue;
            out.println("          case " + t + ":");
            out.println("            RESULT = runSemanticAction_mt_" + t + "(lexeme);");
            out.println("            break;");
        }
        for (t = 0; t < this.markingTerminalLayoutCount; ++t) {
            code = this.markingTerminalLayouts.get((Object)Integer.valueOf((int)t)).terminal.getCode();
            if (code == null || QuotedStringFormatter.isJavaWhitespace(code)) continue;
            out.println("          case " + (t + this.markingTerminalCount) + ":");
            out.println("            RESULT = runSemanticAction_mt_" + (t + this.markingTerminalCount) + "(lexeme);");
            out.println("            break;");
        }
        out.println("          default:");
        out.println("            runDefaultTermAction();");
        out.println("            break;");
        out.println("        }");
        out.println("      } else {");
        out.println("        switch(_terminal.firstTerm) {");
        t = this.hostFragment.fullSpec.terminals.nextSetBit(0);
        while (t >= 0) {
            if (t != this.hostFragment.fullSpec.getEOFTerminal() && (code = this.hostFragment.symbolTable.getTerminal(t).getCode()) != null && !QuotedStringFormatter.isJavaWhitespace(code)) {
                out.println("          case " + t + ":");
                out.println("            RESULT = runSemanticAction_th_" + t + "(lexeme);");
                out.println("            break;");
            }
            t = this.hostFragment.fullSpec.terminals.nextSetBit(t + 1);
        }
        BitSet extensionTerminalUnion = new BitSet();
        for (int e = 0; e < this.extensionCount; ++e) {
            extensionTerminalUnion.or(this.extensionFragments.get((int)e).extensionMappingSpec.extensionTerminalIndices);
        }
        int t2 = extensionTerminalUnion.nextSetBit(0);
        while (t2 >= 0) {
            out.println("          case " + (t2 + this.extTableOffset) + ":");
            out.println("            switch (fragmentId - 1) {");
            for (int e = 0; e < this.extensionCount; ++e) {
                String code2;
                if (!this.extensionFragments.get((int)e).extensionMappingSpec.extensionTerminalIndices.get(t2) || (code2 = this.extensionFragments.get((int)e).extensionMappingSpec.extensionSymbolTable.getTerminal(t2).getCode()) == null || QuotedStringFormatter.isJavaWhitespace(code2)) continue;
                out.println("              case " + e + ":");
                out.println("                RESULT = runSemanticAction_te" + e + "_" + t2 + "(lexeme);");
                out.println("                break;");
            }
            out.println("              default:");
            out.println("                runDefaultTermAction();");
            out.println("                break;");
            out.println("            }");
            out.println("            break;");
            t2 = extensionTerminalUnion.nextSetBit(t2 + 1);
        }
        out.println("          default:");
        out.println("            runDefaultTermAction();");
        out.println("            break;");
        out.println("        }");
        out.println("      }");
        out.println("      return RESULT;");
        out.println("    }");
    }

    private void writeRunProductionSemanticAction(PrintStream out) {
        for (Map.Entry<Integer, Pair<Integer, Integer>> entry : this.productionMapBack.entrySet()) {
            int tableLHS;
            String productionCode;
            ParserSpec.ProductionData pr;
            int p = entry.getKey();
            int fragment = entry.getValue().first();
            int fragmentP = entry.getValue().second();
            boolean isExtension = fragment > 0;
            ExtensionMappingSpec extSpec = isExtension ? this.extensionFragments.get((int)(fragment - 1)).extensionMappingSpec : null;
            PSSymbolTable symbolTable = isExtension ? extSpec.extensionSymbolTable : this.hostFragment.symbolTable;
            ParserSpec.ProductionData productionData = pr = isExtension ? extSpec.pr : this.hostFragment.fullSpec.pr;
            if (fragment == 0 && fragmentP == this.hostFragment.fullSpec.getStartProduction() || (productionCode = symbolTable.getProduction(fragmentP).getCode()) == null || QuotedStringFormatter.isJavaWhitespace(productionCode)) continue;
            String returnType = null;
            returnType = isExtension ? ((tableLHS = pr.getLHS(fragmentP)) > extSpec.extensionSymbolTableOffset ? symbolTable.getNonTerminal(tableLHS - extSpec.extensionSymbolTableOffset).getReturnType() : this.hostFragment.symbolTable.getNonTerminal(tableLHS).getReturnType()) : symbolTable.getNonTerminal(pr.getLHS(fragmentP)).getReturnType();
            returnType = returnType == null ? Object.class.getName() : returnType;
            out.println("    public " + returnType + " runSemanticAction_p" + p + "() throws " + this.errorType + " {");
            if (symbolTable.getProduction(fragmentP).getRhsVarNames() != null) {
                int k = 0;
                for (String var : symbolTable.getProduction(fragmentP).getRhsVarNames()) {
                    if (var != null) {
                        int sym = pr.getRHSSym(fragmentP, k);
                        String type = null;
                        if (isExtension && sym >= extSpec.extensionSymbolTableOffset) {
                            int extSym = sym - extSpec.extensionSymbolTableOffset;
                            if (extSpec.extensionTerminalIndices.get(extSym)) {
                                type = symbolTable.getTerminal(sym).getReturnType();
                            } else if (extSpec.extensionNonterminalIndices.get(extSym)) {
                                type = symbolTable.getNonTerminal(sym).getReturnType();
                            }
                        } else if (this.hostFragment.fullSpec.terminals.get(sym)) {
                            type = symbolTable.getTerminal(sym).getReturnType();
                        } else if (this.hostFragment.fullSpec.nonterminals.get(sym)) {
                            type = symbolTable.getNonTerminal(sym).getReturnType();
                        }
                        type = type == null ? Object.class.getName() : type;
                        out.print("            ");
                        String suppressWarnings = type.contains("<") ? "@SuppressWarnings(\"unchecked\") " : "";
                        out.println("      " + suppressWarnings + type + " " + var + " = (" + type + ") _children[" + k + "];");
                    }
                    ++k;
                }
            }
            out.print("      " + returnType + " RESULT = null;\n");
            out.print("      " + productionCode + "\n");
            out.print("      return RESULT;\n");
            out.print("    }\n");
        }
    }

    private void writeRunTerminalSemanticAction(PrintStream out) {
        String returnType;
        String code;
        int t;
        for (t = 0; t < this.markingTerminalCount; ++t) {
            code = this.markingTerminalDatas.get((int)t).terminal.getCode();
            returnType = this.markingTerminalDatas.get((int)t).terminal.getReturnType();
            if (code == null || QuotedStringFormatter.isJavaWhitespace(code)) continue;
            out.println("    public " + returnType + " runSemanticAction_mt_" + t + "(final String lexeme)");
            out.println("    throws " + this.errorType + " {");
            out.println("      " + returnType + " RESULT = null;");
            out.println("      " + code + "");
            out.println("      return RESULT;");
            out.println("    }");
        }
        for (t = 0; t < this.markingTerminalLayoutCount; ++t) {
            code = this.markingTerminalLayouts.get((Object)Integer.valueOf((int)t)).terminal.getCode();
            returnType = this.markingTerminalLayouts.get((Object)Integer.valueOf((int)t)).terminal.getReturnType();
            if (code == null || QuotedStringFormatter.isJavaWhitespace(code)) continue;
            out.println("    public " + returnType + " runSemanticAction_mt_" + (t + this.markingTerminalCount) + "(final String lexeme)");
            out.println("    throws " + this.errorType + " {");
            out.println("      " + returnType + " RESULT = null;");
            out.println("      " + code + "");
            out.println("      return RESULT;");
            out.println("    }");
        }
        t = this.hostFragment.fullSpec.terminals.nextSetBit(0);
        while (t >= 0) {
            if (t != this.hostFragment.fullSpec.getEOFTerminal()) {
                code = this.hostFragment.symbolTable.getTerminal(t).getCode();
                returnType = this.hostFragment.symbolTable.getTerminal(t).getReturnType();
                if (code != null && !QuotedStringFormatter.isJavaWhitespace(code)) {
                    out.println("    public " + returnType + " runSemanticAction_th_" + t + "(final String lexeme)");
                    out.println("    throws " + this.errorType + " {");
                    out.println("      " + returnType + " RESULT = null;");
                    out.println("      " + code + "");
                    out.println("      return RESULT;");
                    out.println("    }");
                }
            }
            t = this.hostFragment.fullSpec.terminals.nextSetBit(t + 1);
        }
        for (int e = 0; e < this.extensionCount; ++e) {
            ExtensionMappingSpec extSpec = this.extensionFragments.get((int)e).extensionMappingSpec;
            int t2 = extSpec.extensionTerminalIndices.nextSetBit(0);
            while (t2 >= 0) {
                String code2 = extSpec.extensionSymbolTable.getTerminal(t2).getCode();
                String returnType2 = extSpec.extensionSymbolTable.getTerminal(t2).getReturnType();
                if (code2 != null && !QuotedStringFormatter.isJavaWhitespace(code2)) {
                    out.println("    public " + returnType2 + " runSemanticAction_te" + e + "_" + t2 + "(final String lexeme)");
                    out.println("    throws " + this.errorType + " {");
                    out.println("      " + returnType2 + " RESULT = null;");
                    out.println("      " + code2 + "");
                    out.println("      return RESULT;");
                    out.println("    }");
                }
                t2 = extSpec.extensionTerminalIndices.nextSetBit(t2 + 1);
            }
        }
    }

    private void writeRunDisambiguationAction(PrintStream out) {
        out.println("    public int runDisambiguationAction(" + InputPosition.class.getName() + " _pos," + SingleDFAMatchData.class.getName() + " match)");
        out.println("    throws " + IOException.class.getName() + "," + this.errorType + " {");
        out.println("      String lexeme = match.lexeme;");
        boolean first = true;
        for (Map.Entry<Integer, Pair<Integer, Integer>> entry : this.disambiguationFunctionMapBack.entrySet()) {
            int df = entry.getKey();
            String elseStr = "} else ";
            if (first) {
                elseStr = "";
                first = false;
            }
            out.println("      " + elseStr + "if (match.terms.equals(disambiguationGroups[" + df + "])) {");
            out.println("        return disambiguate_" + df + "(lexeme);");
        }
        if (first) {
            out.println("      return -1;");
        } else {
            out.println("      } else {");
            out.println("        return -1;");
            out.println("      }");
        }
        out.println("    }");
    }

    private void writeRunDisambiguationActionMethods(PrintStream out) {
        for (Map.Entry<Integer, Pair<Integer, Integer>> entry : this.disambiguationFunctionMapBack.entrySet()) {
            int df = entry.getKey();
            int fragment = entry.getValue().first();
            int fragmentIndex = entry.getValue().second();
            ParserSpec.DisambiguationFunctionData dfData = fragment == 0 ? this.hostFragment.fullSpec.df : this.extensionFragments.get((int)(fragment - 1)).extensionMappingSpec.df;
            out.println("    public int disambiguate_" + df + "(final String lexeme) throws " + this.errorType + " {");
            if (dfData.hasDisambiguateTo(fragmentIndex)) {
                out.println("      return /* " + this.getSymbolNames(fragment)[dfData.getDisambiguateTo(df)] + " */ " + dfData.getDisambiguateTo(df) + ";");
            } else {
                BitSet members = dfData.getMembers(fragmentIndex);
                int t = members.nextSetBit(0);
                while (t >= 0) {
                    out.println("      @SuppressWarnings(\"unused\") final int " + this.getSymbolNames(fragment)[t] + " = " + t + ";");
                    t = members.nextSetBit(t + 1);
                }
                PSSymbolTable symbolTable = fragment == 0 ? this.hostFragment.symbolTable : this.extensionFragments.get((int)(fragment - 1)).extensionMappingSpec.extensionSymbolTable;
                out.println("      " + symbolTable.getDisambiguationFunction(fragmentIndex).getCode());
            }
            out.println("    }");
        }
    }

    private void writeSemanticsClassUse(PrintStream out) {
        out.println("  public Semantics semantics;");
        out.println("  public " + Object.class.getName() + " runSemanticAction(" + InputPosition.class.getName() + " _pos," + Object.class.getName() + "[] _children,int _prod)");
        out.println("  throws " + IOException.class.getName() + "," + this.errorType + " {");
        out.println("    return semantics.runSemanticAction(_pos, _children, _prod);");
        out.println("  }");
        out.println("  public " + Object.class.getName() + " runFragmentSemanticAction(int fragmentId, " + InputPosition.class.getName() + " _pos," + SingleDFAMatchData.class.getName() + " _terminal)");
        out.println("  throws " + IOException.class.getName() + "," + this.errorType + " {");
        out.println("    return semantics.runSemanticTerminalAction(fragmentId, _pos, _terminal);");
        out.println("  }");
        if (this.hostParser.getPostParseCode() != null && !QuotedStringFormatter.isJavaWhitespace(this.hostParser.getPostParseCode())) {
            out.println("  public void runPostParseCode(" + Object.class.getName() + " __root) {");
            out.println("    semantics.runPostParseCode(__root);");
            out.println("  }");
        }
        out.println("  public int runFragmentDisambiguationAction(int fragmentId, " + InputPosition.class.getName() + " _pos," + SingleDFAMatchData.class.getName() + " matches)");
        out.println("  throws " + IOException.class.getName() + "," + this.errorType + " {");
        out.println("    return semantics.runDisambiguationAction(_pos,matches);");
        out.println("  }");
        out.println("  public " + SpecialParserAttributes.class.getName() + " getSpecialAttributes() {");
        out.println("    return semantics.getSpecialAttributes();");
        out.println("  }");
        out.println("  public void startEngine(" + InputPosition.class.getName() + " initialPos)");
        out.println("  throws " + IOException.class.getName() + "," + this.errorType + " {");
        out.println("     super.startEngine(initialPos);");
        out.println("     semantics = new Semantics();");
        out.println("  }");
    }

    private void printSignature(PrintStream out) {
        out.println("/*");
        out.println(" * Built at " + new Date(System.currentTimeMillis()));
        out.println(" * by Copper version " + ParserCompiler.VERSION);
        out.println(" *           build " + ParserCompiler.BUILD);
        out.println(" */");
    }

    private void printDecls(PrintStream out, String packageDecl, String importDecls) {
        out.println(packageDecl);
        out.println(importDecls);
        String preambleCode = this.hostParser.getPreambleCode();
        if (preambleCode != null) {
            out.println(preambleCode);
        }
    }

    private void printFixedMethods(PrintStream out) {
        out.println("  protected String formatError(String error) {");
        out.println("    String location = \"\";");
        out.println("    location += \"line \" + virtualLocation.getLine() + \", column \" + virtualLocation.getColumn();");
        out.println("    if (currentState.pos.getFileName().length() > 40) {");
        out.println("      location += \"\\n         \";");
        out.println("    }");
        out.println("    location += \" in file \" + virtualLocation.getFileName();");
        out.println("    location += \"\\n         (parser state: \" + currentState.statenum + \"; real character index: \" + currentState.pos.getPos() + \")\";");
        out.println("    return \"Error at \" + location + \":\\n  \" + error;");
        out.println("  }");
        out.println("  protected void reportError(String message) throws " + this.errorType + " {");
        out.println("    throw new " + CopperParserException.class.getName() + "(message);");
        out.println("  }");
        out.println("  protected void reportSyntaxError(int fragmentId) throws " + this.errorType + " {");
        out.println("    " + ArrayList.class.getName() + "<String> expectedTerminalsReal = bitVecToRealStringList(fragmentId, getFragmentShiftableSets(fragmentId)[currentState.statenum]);");
        out.println("    " + ArrayList.class.getName() + "<String> expectedTerminalsDisplay = bitVecToDisplayStringList(fragmentId, getFragmentShiftableSets(fragmentId)[currentState.statenum]);");
        out.println("    " + ArrayList.class.getName() + "<String> matchedTerminalsReal = bitVecToRealStringList(fragmentId, disjointMatch.terms);");
        out.println("    " + ArrayList.class.getName() + "<String> matchedTerminalsDisplay = bitVecToDisplayStringList(fragmentId, disjointMatch.terms);");
        out.println("    throw new edu.umn.cs.melt.copper.runtime.logging.CopperSyntaxError(virtualLocation,currentState.pos,currentState.statenum,expectedTerminalsReal,expectedTerminalsDisplay,matchedTerminalsReal,matchedTerminalsDisplay);");
        out.println("  }");
    }

    private void printFragmentMethods(PrintStream out) {
        out.println("  protected int getFragmentCount() {");
        out.println("    return " + this.fragmentCount + ";");
        out.println("  }");
        out.println("  protected int stateToFragmentId(int state) {");
        out.println("    if (state < " + this.hostStateCount + ") {");
        out.println("      return 0;");
        for (int e = 1; e < this.extensionCount; ++e) {
            out.println("    } else if (state < " + this.extStateOffset[e] + ") {");
            out.println("      return " + e + ";");
        }
        out.println("    } else {");
        out.println("      return " + this.extensionCount + ";");
        out.println("    }");
        out.println("  }");
        out.println("  protected int getMarkingTerminalOffset() {");
        out.println("    return " + this.markingTerminalOffset + ";");
        out.println("  }");
    }

    private void printParserAncillaryDecls(PrintStream out) {
        for (ObjectToHash obj : this.objectsToHash) {
            out.println("  private static " + obj.type + " " + obj.name + ";");
        }
        out.println("  private static " + BitSet.class.getName() + "[] disambiguationGroups;");
    }

    private void printParserAncillaryMethods(PrintStream out) {
        out.println("  public int[][] getParseTable() {");
        out.println("    return parseTable;");
        out.println("  }");
        out.println("  protected String[] getSymbolNamesInclMT(int fragmentId) {");
        out.println("    if (fragmentId == 0) {");
        out.println("      return markingTerminalSymbolNames;");
        out.println("    } else {");
        out.println("      return symbolNames[fragmentId];");
        out.println("    }");
        out.println("  }");
        out.println("  protected String[] getSymbolDisplayNamesInclMT(int fragmentId) {");
        out.println("    if (fragmentId == 0) {");
        out.println("      return markingTerminalSymbolDisplayNames;");
        out.println("    } else {");
        out.println("      return symbolDisplayNames[fragmentId];");
        out.println("    }");
        out.println("  }");
        out.println("  protected int[] getProductionLengths() {");
        out.println("    return productionLengths;");
        out.println("  }");
        out.println("  public int[] getProductionLHSs() {");
        out.println("    return productionLHSs;");
        out.println("  }");
        out.println("  protected int transition(int fragmentId, int state, char ch) {");
        out.println("    return deltas[fragmentId][state][cmaps[fragmentId][ch]];");
        out.println("  }");
        out.println("  protected " + BitSet.class.getName() + "[] getFragmentAcceptSets(int fragmentId) {");
        out.println("    return acceptSetss[fragmentId];");
        out.println("  }");
        out.println("  protected " + BitSet.class.getName() + "[] getFragmentRejectSets(int fragmentId) {");
        out.println("    return rejectSetss[fragmentId];");
        out.println("  }");
        out.println("  protected " + BitSet.class.getName() + "[] getFragmentPossibleSets(int fragmentId) {");
        out.println("    return possibleSetss[fragmentId];");
        out.println("  }");
        out.println("  protected int getFragmentTerminalCount(int fragmentId) {");
        out.println("    if (fragmentId == 0) {");
        out.println("      return " + (this.markingTerminalCount + this.markingTerminalLayoutCount) + ";");
        out.println("    } else {");
        out.println("      return extTerminalLengths[fragmentId - 1];");
        out.println("    }");
        out.println("  }");
        out.println("  protected int getFragmentStartState(int fragmentId) {");
        out.println("    switch (fragmentId) {");
        out.println("      case 0:");
        out.println("        return " + this.markingTerminalScannerDFA.getStartState() + ";");
        for (int e = 0; e < this.extensionCount; ++e) {
            out.println("      case " + (e + 1) + ":");
            out.println("        return " + this.extensionFragments.get((int)e).scannerDFA.getStartState() + ";");
        }
        out.println("      default:");
        out.println("        return -1;");
        out.println("    }");
        out.println("  }");
        out.println("  public int getPARSER_START_STATENUM() {");
        out.println("    return 1;");
        out.println("  }");
        out.println("  public int getEOF_SYMNUM() {");
        out.println("    return " + this.hostFragment.fullSpec.getEOFTerminal() + ";");
        out.println("  }");
        out.println("  public " + BitSet.class.getName() + "[][] getFragmentPrefixMaps(int fragmentId) {");
        out.println("    if (fragmentId == 0) {");
        out.println("      return markingTerminalEmptyPrefixMaps;");
        out.println("    } else {");
        out.println("      return prefixMaps;");
        out.println("    }");
        out.println("  }");
        out.println("  public " + BitSet.class.getName() + "[] getDisambiguationGroups() {");
        out.println("    return disambiguationGroups;");
        out.println("  }");
        out.println("  public " + BitSet.class.getName() + "[] getFragmentLayoutSets(int fragmentId) {");
        out.println("    if (fragmentId == 0) {");
        out.println("      return markingTerminalLayoutSets;");
        out.println("    } else {");
        out.println("      return layoutSets;");
        out.println("    }");
        out.println("  }");
        out.println("  public " + BitSet.class.getName() + "[] getFragmentPrefixSets(int fragmentId) {");
        out.println("    if (fragmentId == 0) {");
        out.println("      return markingTerminalEmptyStateSets;");
        out.println("    } else {");
        out.println("      return prefixSets;");
        out.println("    }");
        out.println("  }");
        out.println("  protected int getFragmentTerminalUses(int fragmentId, int t) {");
        out.println("    if (fragmentId == 0) {");
        out.println("      return t < " + this.markingTerminalCount + " ? " + 4 + " : " + 1 + ";");
        out.println("    } else if (t >= hostTerminalUses.length) {");
        out.println("      return extTerminalUses[fragmentId - 1][t];");
        out.println("    } else {");
        out.println("      return hostTerminalUses[t] & extTerminalUses[fragmentId - 1][t];");
        out.println("    }");
        out.println("  }");
        out.println("  public " + BitSet.class.getName() + " getFragmentShiftableUnion(int fragmentId) {");
        out.println("    if (fragmentId == 0) {");
        out.println("      return markingTerminalShiftableUnion;");
        out.println("    } else {");
        out.println("      return extShiftableUnion[fragmentId - 1];");
        out.println("    }");
        out.println("  }");
        out.println("  public " + BitSet.class.getName() + "[] getFragmentShiftableSets(int fragmentId) {");
        out.println("    if (fragmentId == 0) {");
        out.println("      return markingTerminalShiftableSets;");
        out.println("    } else {");
        out.println("      return shiftableSets;");
        out.println("    }");
        out.println("  }");
    }

    private void makeObjectsToBeHashed() {
        this.objectsToHash = new ArrayList<ObjectToHash>();
        this.objectsToHash.add(new ObjectToHash(this.extTerminalLengths, "int[]", "extTerminalLengths"));
        this.prepProductionIndices();
        this.prepDisambiguationFunctionIndices();
        this.makeParseTableAndSets();
        this.objectsToHash.add(new ObjectToHash(this.parseTable, "int[][]", "parseTable"));
        this.objectsToHash.add(new ObjectToHash(this.hostTerminalUses, "int[]", "hostTerminalUses"));
        this.objectsToHash.add(new ObjectToHash(this.extTerminalUses, "int[][]", "extTerminalUses"));
        this.objectsToHash.add(new ObjectToHash(this.markingTerminalEmptyStateSets, BitSet.class.getName() + "[]", "markingTerminalEmptyStateSets"));
        this.objectsToHash.add(new ObjectToHash(this.markingTerminalLayoutSets, BitSet.class.getName() + "[]", "markingTerminalLayoutSets"));
        this.objectsToHash.add(new ObjectToHash(this.layoutSets, BitSet.class.getName() + "[]", "layoutSets"));
        this.objectsToHash.add(new ObjectToHash(this.prefixSets, BitSet.class.getName() + "[]", "prefixSets"));
        this.objectsToHash.add(new ObjectToHash(this.prefixMaps, BitSet.class.getName() + "[][]", "prefixMaps"));
        this.objectsToHash.add(new ObjectToHash(this.markingTerminalEmptyPrefixMaps, BitSet.class.getName() + "[][]", "markingTerminalEmptyPrefixMaps"));
        this.objectsToHash.add(new ObjectToHash(this.shiftableSets, BitSet.class.getName() + "[]", "shiftableSets"));
        this.objectsToHash.add(new ObjectToHash(this.markingTerminalShiftableSets, BitSet.class.getName() + "[]", "markingTerminalShiftableSets"));
        this.objectsToHash.add(new ObjectToHash(this.extShiftableUnion, BitSet.class.getName() + "[]", "extShiftableUnion"));
        this.objectsToHash.add(new ObjectToHash(this.markingTerminalShiftableUnion, BitSet.class.getName(), "markingTerminalShiftableUnion"));
        this.generateMarkingTerminalScanner();
        this.deltas = new int[this.fragmentCount][][];
        this.cmaps = new int[this.fragmentCount][];
        this.deltas[0] = this.markingTerminalScannerDFA.getTransitions();
        this.cmaps[0] = this.markingTerminalScannerDFAAnnotations.charMap;
        for (int i = 0; i < this.extensionCount; ++i) {
            this.deltas[i + 1] = this.extensionFragments.get((int)i).scannerDFA.getTransitions();
            this.cmaps[i + 1] = this.extensionFragments.get((int)i).scannerDFAAnnotations.charMap;
        }
        this.objectsToHash.add(new ObjectToHash(this.deltas, "int[][][]", "deltas"));
        this.objectsToHash.add(new ObjectToHash(this.cmaps, "int[][]", "cmaps"));
        this.addScannerAnnotationsToBeHashed();
        this.makeProductionLengths();
        this.objectsToHash.add(new ObjectToHash(this.productionLengths, "int[]", "productionLengths"));
        this.makeProductionLHSs();
        this.objectsToHash.add(new ObjectToHash(this.productionLHSs, "int[]", "productionLHSs"));
        this.generateSymbolNames();
        this.objectsToHash.add(new ObjectToHash(this.symbolNames, "String[][]", "symbolNames"));
        this.objectsToHash.add(new ObjectToHash(this.markingTerminalSymbolNames, "String[]", "markingTerminalSymbolNames"));
        this.objectsToHash.add(new ObjectToHash(this.symbolDisplayNames, "String[][]", "symbolDisplayNames"));
        this.objectsToHash.add(new ObjectToHash(this.markingTerminalSymbolDisplayNames, "String[]", "markingTerminalSymbolDisplayNames"));
    }

    private int prepElementIndices(Map<Integer, Map<Integer, Integer>> map, Map<Integer, Pair<Integer, Integer>> mapBack, int[] counts, BitSet hostElements, BitSet[] extensionElements) {
        int newIndex = 0;
        counts[0] = hostElements.cardinality();
        map.put(0, new TreeMap());
        int x = hostElements.nextSetBit(0);
        while (x >= 0) {
            map.get(0).put(x, newIndex);
            mapBack.put(newIndex, new Pair<Integer, Integer>(0, x));
            ++newIndex;
            x = hostElements.nextSetBit(x + 1);
        }
        for (int e = 0; e < this.extensionCount; ++e) {
            BitSet elements = extensionElements[e];
            counts[e + 1] = elements.cardinality();
            map.put(e + 1, new TreeMap());
            int p = elements.nextSetBit(0);
            while (p >= 0) {
                map.get(e + 1).put(p, newIndex);
                mapBack.put(newIndex, new Pair<Integer, Integer>(e + 1, p));
                ++newIndex;
                p = elements.nextSetBit(p + 1);
            }
        }
        int totalElementCount = newIndex;
        return totalElementCount;
    }

    private void prepProductionIndices() {
        this.productionMap = new TreeMap<Integer, Map<Integer, Integer>>();
        this.productionMapBack = new TreeMap<Integer, Pair<Integer, Integer>>();
        this.productionCounts = new int[this.fragmentCount];
        BitSet[] extProductions = new BitSet[this.extensionCount];
        for (int e = 0; e < this.extensionCount; ++e) {
            extProductions[e] = this.extensionFragments.get((int)e).extensionMappingSpec.extensionProductionIndices;
        }
        this.totalProductionCount = this.prepElementIndices(this.productionMap, this.productionMapBack, this.productionCounts, this.hostFragment.fullSpec.productions, extProductions);
    }

    private void prepDisambiguationFunctionIndices() {
        TreeMap<Integer, Map<Integer, Integer>> disambiguationFunctionMap = new TreeMap<Integer, Map<Integer, Integer>>();
        this.disambiguationFunctionMapBack = new TreeMap<Integer, Pair<Integer, Integer>>();
        int[] disambiguationFunctionCounts = new int[this.fragmentCount];
        BitSet[] extDisambiguationFunctions = new BitSet[this.extensionCount];
        for (int e = 0; e < this.extensionCount; ++e) {
            extDisambiguationFunctions[e] = this.extensionFragments.get((int)e).extensionMappingSpec.extensionDisambiguationFunctionIndices;
        }
        this.totalDisambiguationFunctionCount = this.prepElementIndices(disambiguationFunctionMap, this.disambiguationFunctionMapBack, disambiguationFunctionCounts, this.hostFragment.fullSpec.disambiguationFunctions, extDisambiguationFunctions);
    }

    private void addScannerAnnotationsToBeHashed() {
        BitSet[][] acceptSetss = new BitSet[this.fragmentCount][];
        acceptSetss[0] = this.markingTerminalScannerDFAAnnotations.acceptSets;
        for (int e = 0; e < this.extensionCount; ++e) {
            acceptSetss[e + 1] = this.extensionFragments.get((int)e).scannerDFAAnnotations.acceptSets;
        }
        this.objectsToHash.add(new ObjectToHash(acceptSetss, BitSet.class.getName() + "[][]", "acceptSetss"));
        BitSet[][] rejectSetss = new BitSet[this.fragmentCount][];
        rejectSetss[0] = this.markingTerminalScannerDFAAnnotations.rejectSets;
        for (int e = 0; e < this.extensionCount; ++e) {
            rejectSetss[e + 1] = this.extensionFragments.get((int)e).scannerDFAAnnotations.rejectSets;
        }
        this.objectsToHash.add(new ObjectToHash(rejectSetss, BitSet.class.getName() + "[][]", "rejectSetss"));
        BitSet[][] possibleSetss = new BitSet[this.fragmentCount][];
        possibleSetss[0] = this.markingTerminalScannerDFAAnnotations.possibleSets;
        for (int e = 0; e < this.extensionCount; ++e) {
            possibleSetss[e + 1] = this.extensionFragments.get((int)e).scannerDFAAnnotations.possibleSets;
        }
        this.objectsToHash.add(new ObjectToHash(possibleSetss, BitSet.class.getName() + "[][]", "possibleSetss"));
    }

    private void generateMarkingTerminalScanner() {
        Collections.sort(this.markingTerminalDatas);
        TreeMap<Integer, Regex> regexes = new TreeMap<Integer, Regex>();
        BitSet terminals = new BitSet();
        for (int t = 0; t < this.markingTerminalCount; ++t) {
            MarkingTerminalData data = this.markingTerminalDatas.get(t);
            regexes.put(t, this.extensionFragments.get((int)data.extensionId).markingTerminalRegexes.get(data.extensionTerminal));
            terminals.set(t);
        }
        for (int l = 0; l < this.markingTerminalLayoutCount; ++l) {
            regexes.put(this.markingTerminalCount + l, this.markingTerminalLayouts.get((Object)Integer.valueOf((int)l)).terminal.getRegex());
            terminals.set(this.markingTerminalCount + l);
        }
        this.markingTerminalScannerDFA = SingleScannerDFABuilder.build(regexes, terminals, -1);
        this.markingTerminalScannerDFAAnnotations = SingleScannerDFAAnnotationBuilder.build(new PrecedenceGraph(this.markingTerminalCount + this.markingTerminalLayoutCount), this.markingTerminalScannerDFA);
    }

    private void makeParseTableAndSets() {
        ExtensionFragmentData fragment;
        int i;
        this.totalStateCount = this.hostStateCount = this.hostFragment.parseTable.size();
        int maxTableSymbols = this.hostFragment.fullSpec.nonterminals.length();
        this.markingTerminalDatas = new ArrayList();
        this.extStateOffset = new int[this.extensionCount];
        for (i = 0; i < this.extensionCount; ++i) {
            fragment = this.extensionFragments.get(i);
            ExtensionMappingSpec spec = this.extensionFragments.get((int)i).extensionMappingSpec;
            this.extStateOffset[i] = this.totalStateCount;
            this.totalStateCount += fragment.appendedExtensionTable.size();
            int extTableWidth = spec.tableOffsetExtensionIndex(spec.extensionNonterminalIndices.length());
            if (extTableWidth <= maxTableSymbols) continue;
            maxTableSymbols = extTableWidth;
        }
        this.markingTerminalOffset = maxTableSymbols;
        for (i = 0; i < this.extensionCount; ++i) {
            fragment = this.extensionFragments.get(i);
            Set<Integer> markingTerminals = fragment.markingTerminalLHS.keySet();
            for (int mt : markingTerminals) {
                int lhs = fragment.markingTerminalLHS.get(mt);
                int offsetState = fragment.markingTerminalStates.get(mt) + this.extStateOffset[i];
                Terminal terminal = fragment.extensionMappingSpec.extensionSymbolTable.getTerminal(mt);
                this.markingTerminalDatas.add(new MarkingTerminalData(i, mt, lhs, offsetState, maxTableSymbols, terminal));
                ++maxTableSymbols;
            }
        }
        this.markingTerminalCount = this.markingTerminalDatas.size();
        this.parseTable = new int[this.totalStateCount][maxTableSymbols];
        this.layoutSets = new BitSet[this.totalStateCount];
        this.prefixSets = new BitSet[this.totalStateCount];
        this.prefixMaps = new BitSet[this.totalStateCount][];
        this.shiftableSets = new BitSet[this.totalStateCount];
        this.hostTerminalUses = new int[this.hostTerminalLength];
        this.hostStateShiftableUnion = SingleDFAEngine.newBitVec(this.hostTerminalLength, new int[0]);
        this.copyParseTable(-1);
        this.extTerminalUses = new int[this.extensionCount][];
        this.extShiftableUnion = new BitSet[this.extensionCount];
        for (i = 0; i < this.extensionCount; ++i) {
            this.extTerminalUses[i] = new int[this.extTerminalLengths[i]];
            this.extShiftableUnion[i] = SingleDFAEngine.newBitVec(this.extTerminalLengths[i], new int[0]);
            this.copyParseTable(i);
            this.extShiftableUnion[i].or(this.hostStateShiftableUnion);
        }
        this.markingTerminalLayoutSets = new BitSet[this.totalStateCount];
        this.fillMarkingTerminalMetaData(this.markingTerminalDatas);
        this.markingTerminalEmptyStateSets = new BitSet[this.totalStateCount];
        this.markingTerminalEmptyPrefixMaps = new BitSet[this.totalStateCount][this.markingTerminalCount + this.markingTerminalLayoutCount];
        BitSet empty = SingleDFAEngine.newBitVec(this.markingTerminalCount, new int[0]);
        for (int state = 0; state < this.totalStateCount; ++state) {
            this.markingTerminalEmptyStateSets[state] = empty;
            for (int t = 0; t < this.markingTerminalCount + this.markingTerminalLayoutCount; ++t) {
                this.markingTerminalEmptyPrefixMaps[state][t] = empty;
            }
        }
    }

    private void copyParseTable(int extensionId) {
        LRParseTable table = null;
        BitSet hostTerminals = this.hostFragment.fullSpec.terminals;
        BitSet hostNonterminals = this.hostFragment.fullSpec.nonterminals;
        ExtensionFragmentData extensionFragmentData = null;
        ExtensionMappingSpec extSpec = null;
        BitSet extNonterminals = null;
        BitSet offsetExtNonterminals = null;
        LRLookaheadAndLayoutSets layouts = null;
        TransparentPrefixes prefixes = null;
        BitSet shiftableUnion = null;
        boolean isExtension = extensionId >= 0;
        int stateOffset = 0;
        if (isExtension) {
            extensionFragmentData = this.extensionFragments.get(extensionId);
            table = extensionFragmentData.appendedExtensionTable;
            extSpec = extensionFragmentData.extensionMappingSpec;
            extNonterminals = extSpec.extensionNonterminalIndices;
            offsetExtNonterminals = new BitSet();
            int nt = extNonterminals.nextSetBit(0);
            while (nt >= 0) {
                offsetExtNonterminals.set(extSpec.tableOffsetExtensionIndex(nt));
                nt = extNonterminals.nextSetBit(nt + 1);
            }
            stateOffset = this.extStateOffset[extensionId];
            layouts = extensionFragmentData.extensionLookaheadAndLayoutSets;
            prefixes = extensionFragmentData.transparentPrefixes;
            shiftableUnion = this.extShiftableUnion[extensionId];
        } else {
            table = this.hostFragment.parseTable;
            layouts = this.hostFragment.lookaheadSets;
            prefixes = this.hostFragment.prefixes;
            shiftableUnion = this.hostStateShiftableUnion;
        }
        for (int state = 0; state < table.size(); ++state) {
            int t = table.getValidLA(state).nextSetBit(0);
            while (t >= 0) {
                boolean isNonterminal;
                boolean isTerminal;
                if (extSpec != null) {
                    isTerminal = extSpec.isTableOffsetTerminal(t);
                    isNonterminal = extSpec.isTableOffsetNonterminal(t);
                } else {
                    isTerminal = hostTerminals.get(t);
                    isNonterminal = hostNonterminals.get(t);
                }
                int actionParameter = table.getActionParameter(state, t);
                if (isTerminal) {
                    int symType;
                    byte actionType = table.getActionType(state, t);
                    if (actionType == 0) {
                        symType = 0;
                    } else if (actionType == 1 && t == this.hostFragment.fullSpec.getEOFTerminal()) {
                        symType = 3;
                    } else if (actionType == 1) {
                        symType = 1;
                        if (isExtension && actionParameter < 0) {
                            actionParameter = ExtensionMappingSpec.decodeExtensionIndex(actionParameter) + this.extStateOffset[extensionId];
                        }
                    } else if (actionType == 2) {
                        symType = 2;
                        actionParameter = isExtension && actionParameter < 0 ? this.productionMap.get(extensionId + 1).get(ExtensionMappingSpec.decodeExtensionIndex(actionParameter)).intValue() : this.productionMap.get(0).get(actionParameter).intValue();
                    } else {
                        symType = 0;
                    }
                    this.parseTable[state + stateOffset][t] = SingleDFAEngine.newAction(symType, actionParameter);
                    if (isExtension) {
                        int[] nArray = this.extTerminalUses[extensionId];
                        int n = t;
                        nArray[n] = nArray[n] & 4;
                    } else {
                        int n = t;
                        this.hostTerminalUses[n] = this.hostTerminalUses[n] & 4;
                    }
                } else if (isNonterminal) {
                    if (isExtension && actionParameter < 0) {
                        actionParameter = ExtensionMappingSpec.decodeExtensionIndex(actionParameter) + this.extStateOffset[extensionId];
                    }
                    this.parseTable[state + stateOffset][t] = SingleDFAEngine.newAction(1, actionParameter);
                }
                t = table.getValidLA(state).nextSetBit(t + 1);
            }
            this.shiftableSets[state + stateOffset] = SingleDFAEngine.newBitVec(isExtension ? this.extTerminalLengths[extensionId] : this.hostTerminalLength, new int[0]);
            this.shiftableSets[state + stateOffset].or(table.getValidLA(state));
            this.layoutSets[state + stateOffset] = SingleDFAEngine.newBitVec(isExtension ? this.extTerminalLengths[extensionId] : this.hostTerminalLength, new int[0]);
            this.layoutSets[state + stateOffset].or(layouts.getLayout(state));
            this.shiftableSets[state + stateOffset].or(layouts.getLayout(state));
            this.prefixSets[state + stateOffset] = SingleDFAEngine.newBitVec(isExtension ? this.extTerminalLengths[extensionId] : this.hostTerminalLength, new int[0]);
            this.prefixSets[state + stateOffset].or(prefixes.getPrefixes(state));
            this.shiftableSets[state + stateOffset].or(prefixes.getPrefixes(state));
            this.shiftableSets[state + stateOffset].andNot(hostNonterminals);
            if (isExtension) {
                this.shiftableSets[state + stateOffset].andNot(offsetExtNonterminals);
            }
            shiftableUnion.or(this.shiftableSets[state + stateOffset]);
            int layout = layouts.getLayout(state).nextSetBit(0);
            while (layout >= 0) {
                if (isExtension) {
                    int[] nArray = this.extTerminalUses[extensionId];
                    int n = layout;
                    nArray[n] = nArray[n] & 1;
                } else {
                    int n = layout;
                    this.hostTerminalUses[n] = this.hostTerminalUses[n] & 1;
                }
                layout = layouts.getLayout(state).nextSetBit(layout + 1);
            }
            this.prefixMaps[state + stateOffset] = new BitSet[isExtension ? this.extTerminalLengths[extensionId] : this.hostTerminalLength];
            int prefix = prefixes.getPrefixes(state).nextSetBit(0);
            while (prefix >= 0) {
                if (isExtension) {
                    int[] nArray = this.extTerminalUses[extensionId];
                    int n = prefix;
                    nArray[n] = nArray[n] & 2;
                } else {
                    int n = prefix;
                    this.hostTerminalUses[n] = this.hostTerminalUses[n] & 2;
                }
                if (prefix != this.hostFragment.fullSpec.getEOFTerminal()) {
                    this.prefixMaps[state + stateOffset][prefix] = SingleDFAEngine.newBitVec(isExtension ? this.extTerminalLengths[extensionId] : this.hostTerminalLength, new int[0]);
                    this.prefixMaps[state + stateOffset][prefix].or(prefixes.getFollowingTerminals(state, prefix));
                }
                prefix = prefixes.getPrefixes(state).nextSetBit(prefix + 1);
            }
        }
    }

    private void fillMarkingTerminalMetaData(List<MarkingTerminalData> markingTerminalDatas) {
        this.markingTerminalLayouts = new TreeMap<Integer, MarkingTerminalData>();
        TreeMap markingTerminalLayoutsByFragment = new TreeMap();
        this.markingTerminalLayoutCount = 0;
        this.markingTerminalShiftableSets = new BitSet[this.totalStateCount];
        for (int i = 0; i < this.fragmentCount; ++i) {
            markingTerminalLayoutsByFragment.put(i, new TreeMap());
        }
        this.fillFragmentStatesWithMTData(-1, (Map)markingTerminalLayoutsByFragment.get(0));
        for (int extensionId = 0; extensionId < this.extensionCount; ++extensionId) {
            this.fillFragmentStatesWithMTData(extensionId, (Map)markingTerminalLayoutsByFragment.get(extensionId + 1));
        }
        this.markingTerminalShiftableUnion = SingleDFAEngine.newBitVec(this.markingTerminalCount + this.markingTerminalLayoutCount, new int[0]);
        this.markingTerminalShiftableUnion.set(0, this.markingTerminalCount + this.markingTerminalLayoutCount);
    }

    private void fillFragmentStatesWithMTData(int extensionId, Map<Integer, Integer> fragmentMarkingTerminalLayouts) {
        boolean isExtension = extensionId >= 0;
        LRParseTable table = isExtension ? this.extensionFragments.get((int)extensionId).appendedExtensionTable : this.hostFragment.parseTable;
        BitSet[] initNTs = isExtension ? this.extensionFragments.get((int)extensionId).initNTs : this.hostFragment.initNTs;
        Map<Integer, Map<Integer, Set<Integer>>> laSources = isExtension ? this.extensionFragments.get((int)extensionId).laSources : this.hostFragment.laSources;
        int stateOffset = isExtension ? this.extStateOffset[extensionId] : 0;
        for (int state = 0; state < table.size(); ++state) {
            int offsetState = state + stateOffset;
            this.markingTerminalShiftableSets[offsetState] = SingleDFAEngine.newBitVec(this.markingTerminalCount + this.markingTerminalLayoutCount, new int[0]);
            this.markingTerminalLayoutSets[offsetState] = SingleDFAEngine.newBitVec(this.markingTerminalCount + this.markingTerminalLayoutCount, new int[0]);
            BitSet stateInitNTs = initNTs[state];
            int nt = stateInitNTs.nextSetBit(0);
            while (nt >= 0) {
                for (MarkingTerminalData mtData : this.markingTerminalDatas) {
                    if (nt != mtData.hostLHS) continue;
                    this.parseTable[offsetState][mtData.endIndex] = SingleDFAEngine.newAction(1, mtData.offsetTransitionState);
                    this.fillMTLayoutData(state, offsetState, mtData, fragmentMarkingTerminalLayouts, extensionId);
                }
                nt = stateInitNTs.nextSetBit(nt + 1);
            }
            Map<Integer, Set<Integer>> stateLASources = laSources.get(state);
            for (MarkingTerminalData mtData : this.markingTerminalDatas) {
                Set<Integer> productions = stateLASources.get(mtData.hostLHS);
                if (productions == null || productions.isEmpty()) continue;
                for (int production : productions) {
                    int newProductionIndex = 0;
                    newProductionIndex = production < 0 ? this.productionMap.get(extensionId + 1).get(ExtensionMappingSpec.decodeExtensionIndex(production)).intValue() : this.productionMap.get(0).get(production).intValue();
                    this.parseTable[offsetState][mtData.endIndex] = SingleDFAEngine.newAction(2, newProductionIndex);
                    this.fillMTLayoutData(state, offsetState, mtData, fragmentMarkingTerminalLayouts, extensionId);
                }
            }
        }
    }

    private void fillMTLayoutData(int state, int offsetState, MarkingTerminalData mtData, Map<Integer, Integer> fragmentMarkingTerminalLayouts, int extensionId) {
        boolean isExtension = extensionId >= 0;
        PSSymbolTable symbolTable = isExtension ? this.extensionFragments.get((int)extensionId).extensionMappingSpec.extensionSymbolTable : this.hostFragment.symbolTable;
        LRLookaheadAndLayoutSets fragmentLayoutSets = isExtension ? this.extensionFragments.get((int)extensionId).extensionLookaheadAndLayoutSets : this.hostFragment.lookaheadSets;
        this.markingTerminalShiftableSets[offsetState].set(mtData.endIndex - this.markingTerminalOffset);
        BitSet layouts = fragmentLayoutSets.getLayout(state);
        int l = layouts.nextSetBit(0);
        while (l >= 0) {
            if (!fragmentMarkingTerminalLayouts.containsKey(l)) {
                MarkingTerminalData layout = l < this.extTableOffset ? new MarkingTerminalData(-1, l, -1, -1, -1, this.hostFragment.symbolTable.getTerminal(l)) : new MarkingTerminalData(extensionId, l - this.extTableOffset, -1, -1, -1, symbolTable.getTerminal(l - this.extTableOffset));
                this.markingTerminalLayouts.put(this.markingTerminalLayoutCount, layout);
                fragmentMarkingTerminalLayouts.put(l, this.markingTerminalLayoutCount);
                ++this.markingTerminalLayoutCount;
            }
            this.markingTerminalShiftableSets[offsetState].set(fragmentMarkingTerminalLayouts.get(l) + this.markingTerminalCount);
            this.markingTerminalLayoutSets[offsetState].set(fragmentMarkingTerminalLayouts.get(l) + this.markingTerminalCount);
            l = layouts.nextSetBit(l + 1);
        }
    }

    private void makeProductionLengths() {
        this.productionLengths = new int[this.totalProductionCount];
        for (Map.Entry<Integer, Pair<Integer, Integer>> entry : this.productionMapBack.entrySet()) {
            int index = entry.getKey();
            int fragment = entry.getValue().first();
            int fragmentIndex = entry.getValue().second();
            if (fragment == 0) {
                this.productionLengths[index] = this.hostFragment.fullSpec.pr.getRHSLength(fragmentIndex);
                continue;
            }
            this.productionLengths[index] = this.extensionFragments.get((int)(fragment - 1)).extensionMappingSpec.pr.getRHSLength(fragmentIndex);
        }
    }

    private void makeProductionLHSs() {
        this.productionLHSs = new int[this.totalProductionCount];
        for (Map.Entry<Integer, Pair<Integer, Integer>> entry : this.productionMapBack.entrySet()) {
            int index = entry.getKey();
            int fragment = entry.getValue().first();
            int fragmentIndex = entry.getValue().second();
            if (fragment == 0) {
                this.productionLHSs[index] = this.hostFragment.fullSpec.pr.getLHS(fragmentIndex);
                continue;
            }
            ExtensionMappingSpec spec = this.extensionFragments.get((int)(fragment - 1)).extensionMappingSpec;
            int encodedLHS = spec.untranslateAndOffsetComposedSymbol(spec.pr.getLHS(fragmentIndex));
            this.productionLHSs[index] = encodedLHS < 0 ? spec.decodeAndTableOffsetExtensionIndex(encodedLHS) : encodedLHS;
        }
    }

    private void writeHashes(PrintStream out) throws IOException {
        ByteArrayOutputStream stringOut = new ByteArrayOutputStream();
        for (ObjectToHash obj : this.objectsToHash) {
            this.writeHash(obj.obj, obj.name, stringOut, out);
        }
    }

    private void writeHash(Object obj, String prefix, ByteArrayOutputStream stringOut, PrintStream out) throws IOException {
        stringOut.reset();
        ObjectOutputStream outp = new ObjectOutputStream(stringOut);
        outp.writeObject(obj);
        out.println("  public static final byte[] " + prefix + "Hash = " + ByteArrayEncoder.class.getName() + ".literalToByteArray\n(new String[]{ " + ByteArrayEncoder.byteArrayToLiteral(16, stringOut.toByteArray()) + "});\n");
    }

    private void writeStaticMemberInitializations(PrintStream out) {
        out.println("  public static void initArrays() throws " + IOException.class.getName() + "," + ClassNotFoundException.class.getName() + " {");
        for (ObjectToHash obj : this.objectsToHash) {
            out.println("    " + obj.name + " = (" + obj.type + ") " + ByteArrayEncoder.class.getName() + ".readHash(" + obj.name + "Hash);");
        }
        out.println("  }");
        out.println("  static {");
        out.println("    try { initArrays(); }");
        out.println("    catch(" + IOException.class.getName() + " ex) { ex.printStackTrace(); System.exit(1); }");
        out.println("    catch(" + ClassNotFoundException.class.getName() + " ex) { ex.printStackTrace(); System.exit(1); }");
        this.initializeDisambiguationGroups(out);
        out.println("  }");
    }

    private void initializeDisambiguationGroups(PrintStream out) {
        out.println("    disambiguationGroups = new " + BitSet.class.getName() + "[" + this.totalDisambiguationFunctionCount + "];");
        for (Map.Entry<Integer, Pair<Integer, Integer>> entry : this.disambiguationFunctionMapBack.entrySet()) {
            int df = entry.getKey();
            int fragment = entry.getValue().first();
            int fragmentIndex = entry.getValue().second();
            BitSet members = fragment == 0 ? this.hostFragment.fullSpec.df.getMembers(fragmentIndex) : this.extensionFragments.get((int)(fragment - 1)).extensionMappingSpec.df.getMembers(fragmentIndex);
            int terminalCount = fragment == 0 ? this.hostTerminalLength : this.extTerminalLengths[fragment - 1];
            out.print("    disambiguationGroups[" + df + "] = newBitVec(" + terminalCount);
            int t = members.nextSetBit(0);
            while (t >= 0) {
                out.print(", " + t);
                t = members.nextSetBit(t + 1);
            }
            out.print(");\n");
        }
    }

    private String generateVariableName(int fragment, int element) {
        PSSymbolTable symbolTable;
        PSSymbolTable pSSymbolTable = symbolTable = fragment == 0 ? this.hostFragment.symbolTable : this.extensionFragments.get((int)(fragment - 1)).extensionMappingSpec.extensionSymbolTable;
        if (((CopperASTBean)symbolTable.get(element)).getType() == CopperElementType.SPECIAL) {
            ParserSpec spec = this.hostFragment.fullSpec;
            if (element == spec.getEOFTerminal()) {
                return "EOF";
            }
            if (element == spec.getStartNonterminal()) {
                return "START";
            }
            if (element == spec.getStartProduction()) {
                return "STARTP";
            }
            return null;
        }
        return ((CopperASTBean)symbolTable.get(element)).getName().toString();
    }

    private static class MarkingTerminalData
    implements Comparable<MarkingTerminalData> {
        public int extensionId;
        public int extensionTerminal;
        public int hostLHS;
        public int offsetTransitionState;
        public int endIndex;
        public Terminal terminal;

        public MarkingTerminalData(int extensionId, int extensionTerminal, int hostLHS, int offsetTransitionState, int endIndex, Terminal terminal) {
            this.extensionId = extensionId;
            this.extensionTerminal = extensionTerminal;
            this.hostLHS = hostLHS;
            this.offsetTransitionState = offsetTransitionState;
            this.endIndex = endIndex;
            this.terminal = terminal;
        }

        @Override
        public int compareTo(MarkingTerminalData o) {
            if (o == null) {
                return -1;
            }
            return this.endIndex - o.endIndex;
        }
    }

    private static class ObjectToHash {
        public Object obj;
        public String type;
        public String name;

        public ObjectToHash(Object obj, String type, String name) {
            this.obj = obj;
            this.type = type;
            this.name = name;
        }
    }
}

