/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.legacy.compiletime.srcbuilders.parsetablebuilders;

import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.FringeSymbols;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.GrammarSource;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.GrammarSymbol;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.NonTerminal;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.Production;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.Terminal;
import edu.umn.cs.melt.copper.legacy.compiletime.finiteautomaton.lalrengine.lalr1.LALR1DFA;
import edu.umn.cs.melt.copper.legacy.compiletime.finiteautomaton.lalrengine.lalr1.LALR1StateItem;
import edu.umn.cs.melt.copper.legacy.compiletime.logging.CompilerLogMessageSort;
import edu.umn.cs.melt.copper.legacy.compiletime.logging.CompilerLogger;
import edu.umn.cs.melt.copper.legacy.compiletime.parsetable.AcceptAction;
import edu.umn.cs.melt.copper.legacy.compiletime.parsetable.FullReduceAction;
import edu.umn.cs.melt.copper.legacy.compiletime.parsetable.GLRParseTable;
import edu.umn.cs.melt.copper.legacy.compiletime.parsetable.ParseAction;
import edu.umn.cs.melt.copper.legacy.compiletime.parsetable.ParseActionVisitor;
import edu.umn.cs.melt.copper.legacy.compiletime.parsetable.ReadOnlyParseTable;
import edu.umn.cs.melt.copper.legacy.compiletime.parsetable.ShiftAction;
import edu.umn.cs.melt.copper.legacy.compiletime.srcbuilders.parsetablebuilders.ParseTableBuilder;
import edu.umn.cs.melt.copper.runtime.logging.CopperException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;

public class GLRParseTableBuilder
extends ParseTableBuilder
implements ParseActionVisitor<String, CopperException> {
    private GrammarSource grammar;
    private LALR1DFA dfa;
    private GLRParseTable parseTable;
    private CompilerLogger logger;
    private Hashtable<GrammarSymbol, Integer> symbolTransTable;
    private Hashtable<Production, Integer> productionTransTable;

    public GLRParseTableBuilder(GrammarSource grammar, LALR1DFA dfa, GLRParseTable parseTable, CompilerLogger logger, Hashtable<GrammarSymbol, Integer> symbolTransTable, Hashtable<Production, Integer> productionTransTable) {
        this.grammar = grammar;
        this.dfa = dfa;
        this.parseTable = parseTable;
        this.logger = logger;
        this.symbolTransTable = symbolTransTable;
        this.productionTransTable = productionTransTable;
    }

    @Override
    public void outputInitFunctions(PrintStream out) throws CopperException {
        out.print("    private static " + GLRParseTable.class.getName() + " parseTable;\n\n");
        out.print("    public " + ReadOnlyParseTable.class.getName() + " getParseTable()\n");
        out.print("    {\n");
        out.print("        return parseTable;\n");
        out.print("    }\n");
        out.print("    /** Create a set of terminals. */\n");
        out.print("    protected static " + HashSet.class.getName() + "<" + Terminal.class.getName() + "> tset(" + Terminal.class.getName() + "... ts)\n");
        out.print("    {\n");
        out.print("        " + HashSet.class.getName() + "<" + Terminal.class.getName() + "> rv = new " + HashSet.class.getName() + "<" + Terminal.class.getName() + ">();\n");
        out.print("        for(" + Terminal.class.getName() + " t : ts) rv.add(t);\n");
        out.print("        return rv;\n");
        out.print("    }\n");
        out.print("    /** Add a parse action. */\n");
        out.print("    protected static void addA(int statenum," + Terminal.class.getName() + " sym," + ParseAction.class.getName() + " action)\n");
        out.print("    {\n");
        out.print("        parseTable.addAction(statenum,sym,action);\n");
        out.print("    }\n");
        out.print("    /** Add a goto action. */\n");
        out.print("    protected static void addG(int statenum," + NonTerminal.class.getName() + " sym," + ShiftAction.class.getName() + " action)\n");
        out.print("    {\n");
        out.print("        parseTable.addGotoAction(statenum,sym,action);\n");
        out.print("    }\n");
        out.print("    /** Add layout. */\n");
        out.print("    protected static void addL(int statenum," + Terminal.class.getName() + " layout," + Terminal.class.getName() + "... tokensFollowing)\n");
        out.print("    {\n");
        out.print("        for(" + Terminal.class.getName() + " t : tokensFollowing) parseTable.addLayout(statenum,layout,t);\n");
        out.print("    }\n");
        out.print("    /** Add transparent prefixes. */\n");
        out.print("    protected static void addTP(int statenum," + Terminal.class.getName() + " prefix," + Terminal.class.getName() + "... tokensFollowing)\n");
        out.print("    {\n");
        out.print("        for(" + Terminal.class.getName() + " t : tokensFollowing) parseTable.addPrefix(statenum,prefix,t);\n");
        out.print("    }\n");
        TreeSet<Integer> sortedStates = new TreeSet<Integer>();
        for (int statenum : this.parseTable.getStates()) {
            sortedStates.add(statenum);
        }
        for (int statenum : sortedStates) {
            out.print("    /*\n");
            for (LALR1StateItem item : this.dfa.getState(statenum).getItems()) {
                out.print("        " + item);
                if (item.isReducible()) {
                    out.print("\t" + this.dfa.getLookahead(this.dfa.getState(statenum), item));
                }
                out.print("\n");
            }
            out.print("\n    */\n");
            out.print("    public static void init_" + statenum + "()\n");
            out.print("    {\n");
            if (this.parseTable.hasShiftable(statenum)) {
                for (Terminal t : this.parseTable.getShiftable(statenum)) {
                    int j = 0;
                    Collection<ParseAction> actions = this.parseTable.getParseActions(statenum, t);
                    for (ParseAction action : actions) {
                        if (j > 0 && this.logger.isLoggable(CompilerLogMessageSort.ERROR)) {
                            this.logger.logMessage(CompilerLogMessageSort.ERROR, null, "Parse table conflict in cell (" + statenum + "," + t + ") between/among actions " + actions);
                        }
                        out.print("        addA(" + statenum + ",sym_" + this.symbolTransTable.get(t) + "," + action.acceptVisitor(this) + ");\n");
                        ++j;
                    }
                }
            }
            if (this.parseTable.hasGotoable(statenum)) {
                for (NonTerminal nt : this.parseTable.getGotoable(statenum)) {
                    ShiftAction action = this.parseTable.getGotoAction(statenum, nt);
                    out.print("        addG(" + statenum + ",sym_" + this.symbolTransTable.get(nt) + "," + action.acceptVisitor(this) + ");\n");
                }
            }
            if (this.parseTable.hasLayout(statenum)) {
                for (Terminal layout : this.parseTable.getLayout(statenum)) {
                    out.print("        addL(" + statenum + ",");
                    if (layout.equals(FringeSymbols.EMPTY)) {
                        out.print("eps()");
                    } else {
                        out.print("sym_" + this.symbolTransTable.get(layout));
                    }
                    for (Terminal t : this.parseTable.getShiftableFollowingLayout(statenum, layout)) {
                        out.print(",sym_" + this.symbolTransTable.get(t));
                    }
                    out.print(");\n");
                }
            }
            if (this.parseTable.hasPrefixes(statenum)) {
                for (Terminal prefix : this.parseTable.getPrefixes(statenum)) {
                    if (prefix.equals(FringeSymbols.EMPTY)) continue;
                    out.print("        addTP(" + statenum + ",");
                    out.print("sym_" + this.symbolTransTable.get(prefix));
                    for (Terminal t : this.parseTable.getShiftableFollowingPrefix(statenum, prefix)) {
                        out.print(",sym_" + this.symbolTransTable.get(t));
                    }
                    out.print(");\n");
                }
            }
            out.print("    }\n");
        }
    }

    @Override
    public void outputInitStatements(PrintStream out) throws CopperException {
        for (Terminal t : this.grammar.getT()) {
            out.print("        sym_" + this.symbolTransTable.get(t) + " = t(\"" + t.getId() + "\");\n");
        }
        for (NonTerminal nt : this.grammar.getNT()) {
            out.print("        sym_" + this.symbolTransTable.get(nt) + " = nt(\"" + nt.getId() + "\");\n");
        }
        for (NonTerminal nt : this.grammar.getNT()) {
            if (!this.grammar.pContains(nt)) continue;
            for (Production p : this.grammar.getP(nt)) {
                out.print("        p_" + this.productionTransTable.get(p) + " = p(\"" + p.getName() + "\",sym_" + this.symbolTransTable.get(p.getLeft()));
                for (GrammarSymbol sym : p.getRight()) {
                    out.print(",sym_" + this.symbolTransTable.get(sym));
                }
                out.print(");\n");
            }
        }
        out.print("        parseTable = new " + GLRParseTable.class.getName() + "();\n");
        Iterator<Object> iterator = this.parseTable.getStates().iterator();
        while (iterator.hasNext()) {
            int statenum = (Integer)iterator.next();
            out.print("        init_" + statenum + "();\n");
        }
    }

    @Override
    public String visitAcceptAction(AcceptAction action) {
        return "a()";
    }

    @Override
    public String visitFullReduceAction(FullReduceAction action) {
        return "fr(p_" + this.productionTransTable.get(action.getProd()) + ")";
    }

    @Override
    public String visitShiftAction(ShiftAction action) {
        return "sh(" + action.getDestState() + ")";
    }
}

