/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.legacy.compiletime.engines.lalr.scanner;

import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.FringeSymbols;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.Symbol;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.Terminal;
import edu.umn.cs.melt.copper.legacy.compiletime.auxiliary.DynHashSet;
import edu.umn.cs.melt.copper.legacy.compiletime.engines.ParserState;
import edu.umn.cs.melt.copper.legacy.compiletime.engines.lalr.QScannerStateInfo;
import edu.umn.cs.melt.copper.legacy.compiletime.engines.lalr.scanner.QScannerMatch;
import edu.umn.cs.melt.copper.legacy.compiletime.engines.lalr.scanner.QScannerMatchData;
import edu.umn.cs.melt.copper.legacy.compiletime.logging.CompilerLogMessageSort;
import edu.umn.cs.melt.copper.legacy.compiletime.logging.CompilerLogger;
import edu.umn.cs.melt.copper.legacy.compiletime.parsetable.ReadOnlyParseTable;
import edu.umn.cs.melt.copper.legacy.compiletime.statistics.ScannerStatistics;
import edu.umn.cs.melt.copper.runtime.io.InputPosition;
import edu.umn.cs.melt.copper.runtime.io.ScannerBuffer;
import edu.umn.cs.melt.copper.runtime.logging.CopperException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;

public abstract class QScanner {
    protected int startState;
    protected ScannerBuffer buffer;
    protected CompilerLogger logger;
    private ScannerStatistics statistics;
    private boolean gatherStatistics;
    protected HashSet<Terminal> lastShiftable;
    protected InputPosition lastPosition;
    protected HashSet<QScannerMatchData> lastMatched;
    protected Hashtable<Terminal, Symbol> precClassMap;

    public ScannerStatistics retrieveStatistics() {
        return this.statistics;
    }

    protected QScanner(boolean gatherStatistics) {
        this.statistics = gatherStatistics ? new ScannerStatistics() : null;
        this.gatherStatistics = gatherStatistics;
        this.lastShiftable = new HashSet();
        this.lastPosition = null;
        this.lastMatched = null;
    }

    protected abstract int transition(int var1, char var2);

    protected abstract QScannerStateInfo getStateInfo(int var1);

    protected abstract QScannerMatch getMatch(Terminal var1, InputPosition var2, InputPosition var3, ArrayList<QScannerMatchData> var4);

    protected abstract String runSemanticAction(Terminal var1) throws CopperException;

    public HashSet<QScannerMatchData> runLayoutScan(ParserState state, ReadOnlyParseTable table) throws CopperException, IOException {
        return this.runLayoutScanInternal(state, table, false);
    }

    public HashSet<QScannerMatchData> runDisjointScan(ParserState state, ReadOnlyParseTable table) throws CopperException, IOException {
        return this.runLayoutScanInternal(state, table, true);
    }

    /*
     * WARNING - void declaration
     */
    private HashSet<QScannerMatchData> runLayoutScanInternal(ParserState state, ReadOnlyParseTable table, boolean runDisjoint) throws CopperException, IOException {
        ArrayList<QScannerMatchData> layouts;
        int statenum = state.getStatenum();
        InputPosition whence = state.getPos();
        HashSet<Terminal> shiftable = new HashSet<Terminal>();
        for (Terminal terminal : table.getShiftable(statenum)) {
            shiftable.add(terminal);
        }
        if (!runDisjoint && whence.equals(this.lastPosition) && (this.lastMatched.iterator().next().getToken().equals(FringeSymbols.EOF) || !this.lastMatched.iterator().next().getPositionPreceding().equals(this.lastMatched.iterator().next().getPositionFollowing()))) {
            boolean partiallyDisjoint = false;
            for (QScannerMatchData m : this.lastMatched) {
                if (shiftable.contains(m.getToken())) continue;
                partiallyDisjoint = true;
                break;
            }
            if (!partiallyDisjoint) {
                this.lastShiftable = shiftable;
                return this.lastMatched;
            }
        }
        if (this.gatherStatistics) {
            if (!whence.equals(this.lastPosition)) {
                this.statistics.tsapSummation += this.statistics.timesScannedAtPos;
                ++this.statistics.tokensSought;
                this.statistics.timesScannedAtPos = 1;
            } else {
                if (!shiftable.equals(this.lastShiftable)) {
                    ++this.statistics.shiftableChanged;
                }
                if (this.lastShiftable.containsAll(shiftable)) {
                    ++this.statistics.shiftableWasSubsetOnRepeat;
                    if (shiftable.contains(this.lastMatched)) {
                        ++this.statistics.lastMatchedTokenInSubset;
                    }
                }
                ++this.statistics.repeatScans;
                ++this.statistics.timesScannedAtPos;
                if (this.statistics.timesScannedAtPos > this.statistics.maxScansPerToken) {
                    this.statistics.maxScansPerToken = this.statistics.timesScannedAtPos;
                }
            }
        }
        this.lastPosition = whence;
        this.lastShiftable = shiftable;
        if (!table.hasLayout(statenum)) {
            layouts = new ArrayList<QScannerMatchData>();
            return this.runPrefixScan(state, table, whence, shiftable, layouts, runDisjoint);
        }
        layouts = new ArrayList();
        boolean bl = false;
        while (true) {
            void var8_13;
            Collection<Terminal> shiftableLayout = table.getLayout(statenum);
            HashSet<QScannerMatchData> matchingLayout = this.runScan(whence, shiftableLayout, layouts);
            if (layouts.isEmpty() && matchingLayout.isEmpty() && table.hasShiftableAfterLayout(statenum, FringeSymbols.EMPTY)) {
                matchingLayout.add(new QScannerMatchData(FringeSymbols.EMPTY, whence, whence, new ArrayList<QScannerMatchData>()));
                shiftable.retainAll(table.getShiftableFollowingLayout(statenum, FringeSymbols.EMPTY));
                break;
            }
            if (matchingLayout.size() == 1) {
                QScannerMatchData layout = matchingLayout.iterator().next();
                Terminal layoutT = layout.getToken();
                whence = InputPosition.advance(whence, layoutT.getLexeme().length(), layoutT.getLexeme());
                shiftable.retainAll(table.getShiftableFollowingLayout(statenum, layoutT));
                if (layoutT.getLexeme().length() == 0) {
                    if (!layouts.isEmpty()) break;
                    layouts.add(layout);
                    break;
                }
                layouts.add(layout);
            } else {
                if (matchingLayout.size() > 1) {
                    return matchingLayout;
                }
                if (layouts.isEmpty() && matchingLayout.isEmpty()) {
                    if (!this.logger.isLoggable(CompilerLogMessageSort.ERROR)) break;
                    this.logger.logErrorMessage(CompilerLogMessageSort.ERROR, whence, "Expected layout of types " + shiftableLayout + " at layout scan " + (int)var8_13);
                    break;
                }
                if (matchingLayout.isEmpty()) break;
            }
            ++var8_13;
        }
        HashSet<QScannerMatchData> hashSet = this.runPrefixScan(state, table, whence, shiftable, layouts, runDisjoint);
        if (!hashSet.isEmpty()) {
            this.lastMatched = hashSet;
        }
        return hashSet;
    }

    public HashSet<QScannerMatchData> runPrefixScan(ParserState state, ReadOnlyParseTable table, InputPosition whence, Collection<Terminal> shiftable, ArrayList<QScannerMatchData> layouts, boolean runDisjoint) throws IOException, CopperException {
        if (!table.hasPrefixes(state.getStatenum())) {
            if (!runDisjoint) {
                return this.runScan(whence, shiftable, layouts);
            }
            return this.runScan(whence, table.getShiftableUnion(), layouts);
        }
        Collection<Terminal> shiftablePrefixes = table.getPrefixes(state.getStatenum());
        HashSet<QScannerMatchData> matchingPrefixes = this.runScan(whence, shiftablePrefixes, layouts);
        if (matchingPrefixes.isEmpty()) {
            if (!runDisjoint) {
                return this.runScan(whence, shiftable, layouts);
            }
            return this.runScan(whence, table.getShiftableUnion(), layouts);
        }
        if (matchingPrefixes.size() > 1) {
            return matchingPrefixes;
        }
        QScannerMatchData prefixD = matchingPrefixes.iterator().next();
        Terminal prefix = prefixD.getToken();
        layouts.add(prefixD);
        shiftable = table.getShiftableFollowingPrefix(state.getStatenum(), prefix);
        whence = InputPosition.advance(whence, prefix.getLexeme().length(), prefix.getLexeme());
        if (!runDisjoint) {
            return this.runScan(whence, shiftable, layouts);
        }
        return this.runScan(whence, table.getShiftableUnion(), layouts);
    }

    public HashSet<QScannerMatchData> runScan(InputPosition whence, Iterable<Terminal> shiftable, ArrayList<QScannerMatchData> layouts) throws IOException, CopperException {
        DynHashSet<QScannerMatch> present = this.runSingleScan(whence, shiftable, layouts);
        HashSet<QScannerMatchData> finalMatches = new HashSet<QScannerMatchData>();
        if (present == null) {
            finalMatches.add(new QScannerMatchData(FringeSymbols.EOF, whence, whence, layouts));
        } else {
            finalMatches = this.consolidateMatches(present);
        }
        return finalMatches;
    }

    private HashSet<QScannerMatchData> consolidateMatches(DynHashSet<QScannerMatch> present) throws IOException, CopperException {
        HashSet<QScannerMatchData> finalMatches = new HashSet<QScannerMatchData>();
        for (QScannerMatch match : present) {
            for (QScannerMatchData lexeme : match.getLexemes()) {
                String newLex = this.runSemanticAction(lexeme.getToken());
                if (newLex == null) continue;
                finalMatches.add(new QScannerMatchData(lexeme.getToken().newLexeme(newLex), lexeme.getPositionPreceding(), lexeme.getPositionFollowing(), lexeme.getLayouts()));
            }
        }
        return finalMatches;
    }

    private DynHashSet<QScannerMatch> runSingleScan(InputPosition whence, Iterable<Terminal> shiftable, ArrayList<QScannerMatchData> layouts) throws IOException, CopperException {
        int currentState = this.startState;
        char symbol = '\u0000';
        HashSet<Terminal> shiftableS = new HashSet<Terminal>();
        for (Terminal t : shiftable) {
            if (t.equals(FringeSymbols.EMPTY)) continue;
            shiftableS.add(t);
        }
        DynHashSet<QScannerMatch> present = new DynHashSet<QScannerMatch>();
        InputPosition p = InputPosition.copy(whence);
        while (true) {
            HashSet<Terminal> tP = new HashSet<Terminal>(this.getStateInfo(currentState).getPossibleSyms());
            tP.retainAll(shiftableS);
            if (p.equals(whence) && shiftableS.contains(FringeSymbols.EOF)) {
                tP.add(FringeSymbols.EOF);
            }
            if (tP.isEmpty()) break;
            shiftableS.retainAll(tP);
            HashSet<Terminal> tA = new HashSet<Terminal>(this.getStateInfo(currentState).getAcceptingSyms());
            tA.retainAll(shiftableS);
            if (!tA.isEmpty()) {
                present.clear();
            } else {
                HashSet<Terminal> tR = new HashSet<Terminal>(this.getStateInfo(currentState).getRejectingSyms());
                tR.retainAll(shiftableS);
                if (!tR.isEmpty()) {
                    present.clear();
                }
            }
            for (Terminal t : tA) {
                Terminal token = t.newLexeme(this.buffer.readStringFromBuffer(whence.getPos(), p.getPos()));
                QScannerMatch m = this.getMatch(token, InputPosition.copy(whence), InputPosition.copy(p), layouts);
                present.put(m);
            }
            symbol = this.buffer.charAt(p.getPos());
            if (symbol == ScannerBuffer.EOFIndicator) break;
            currentState = this.transition(currentState, symbol);
            p = InputPosition.advance(p, symbol);
        }
        if (symbol == ScannerBuffer.EOFIndicator && p.equals(whence) && shiftableS.contains(FringeSymbols.EOF)) {
            return null;
        }
        return present;
    }
}

