/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.ide.silver.property.ui;

import edu.umn.cs.melt.ide.silver.property.Property;
import edu.umn.cs.melt.ide.silver.property.ui.AbstractPropertyControl;
import java.io.File;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PathPropertyControl
extends AbstractPropertyControl {
    private Button info;
    private Text input;

    public PathPropertyControl(Composite panel, String name) {
        super(panel, name);
    }

    public PathPropertyControl(Composite panel, String name, String display, String defaultVal, boolean isRequired) {
        super(panel, name, display, defaultVal, isRequired);
    }

    @Override
    public Control getInfoControl() {
        if (this.info == null) {
            this.info = new Button(this.panel, 0);
            this.info.setText(this.display);
            this.info.setToolTipText("A local file system path");
            final Shell shell = this.panel.getShell();
            this.info.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DirectoryDialog dirDialog = new DirectoryDialog(shell);
                    dirDialog.setText("Select " + PathPropertyControl.this.name);
                    PathPropertyControl.this.input.setText(dirDialog.open());
                }
            });
        }
        return this.info;
    }

    @Override
    public Control getInputControl() {
        if (this.input == null) {
            this.input = new Text(this.panel, 2048);
        }
        return this.input;
    }

    @Override
    public Property getProperty() {
        return Property.makePathProperty(this.name, this.input.getText(), this.defaultVal, this.display, this.isRequired);
    }

    @Override
    public String getKey() {
        return this.name;
    }

    @Override
    public void setValue(String value) {
        this.input.setText(value);
    }

    @Override
    public boolean validate() {
        String value = this.input.getText();
        if (!this.isFilled(value)) {
            this.input.setToolTipText("This field cannot be empty.");
            this.input.setBackground(this.panel.getDisplay().getSystemColor(3));
            return false;
        }
        File f = new File(value);
        if (!f.exists()) {
            this.input.setToolTipText("Path doesn't exist");
            this.input.setBackground(this.panel.getDisplay().getSystemColor(3));
            return false;
        }
        this.reset();
        return true;
    }

    private void reset() {
        this.input.setToolTipText(null);
        this.input.setBackground(this.panel.getDisplay().getSystemColor(1));
    }
}

