/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.ContextStack;
import common.Feature;
import common.NodeContextMessage;
import common.ProductionName;
import common.SimplifiedContextBox;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Stack;

public class SimplifiedContextStack {
    private ContextStack full_stack;
    private String filename;
    private String filename_html;
    private Stack<SimplifiedContextBox> simple_stack = new Stack();
    private boolean need_set_all_prods = true;
    private ProductionName[] productions;
    private int[] partition;

    public SimplifiedContextStack(ContextStack full_stack) {
        this.full_stack = full_stack;
        this.partition = new int[full_stack.get_height()];
        this.filename = "simpleDebugContext.txt";
        this.filename_html = "simpleDebugContext.html";
    }

    public SimplifiedContextStack(ContextStack full_stack, String fn) {
        this.full_stack = full_stack;
        this.partition = new int[full_stack.get_height()];
        this.filename = fn;
        this.filename_html = "simpleDebugContext.html";
    }

    public SimplifiedContextStack(ContextStack full_stack, String fn, String fn_html) {
        this.full_stack = full_stack;
        this.partition = new int[full_stack.get_height()];
        this.filename = fn;
        this.filename_html = fn_html;
    }

    public Stack<SimplifiedContextBox> getSimplifiedStack() {
        this.need_set_all_prods = true;
        this.makeSimplifiedStack();
        return this.simple_stack;
    }

    public void updateSimplifiedStack() {
        this.need_set_all_prods = true;
        this.makeSimplifiedStack();
    }

    public void show() {
        this.updateSimplifiedStack();
        String border = "*******************";
        try {
            FileWriter myWriter = new FileWriter(this.filename);
            for (int i = this.simple_stack.size() - 1; i >= 0; --i) {
                SimplifiedContextBox sbox = (SimplifiedContextBox)this.simple_stack.get(i);
                myWriter.write(border + "\n" + sbox.toString() + "\n" + border);
            }
            myWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void generateHTMLFile() {
        this.updateSimplifiedStack();
        try (FileWriter myWriter = new FileWriter(this.filename_html);){
            myWriter.write("<html><head><title>Simplified Context Stack</title></head><body>\n");
            for (int i = this.simple_stack.size() - 1; i >= 0; --i) {
                SimplifiedContextBox sbox = (SimplifiedContextBox)this.simple_stack.get(i);
                myWriter.write(sbox.getHTMLBox());
                myWriter.write("<hr>");
            }
            myWriter.write("</body></html>");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void makeSimplifiedStack() {
        this.simple_stack = new Stack();
        this.fillInPartition();
        int prev_partition_index = 0;
        int start = 0;
        int end = -1;
        for (int i = 0; i < this.partition.length; ++i) {
            if (this.partition[i] > prev_partition_index) {
                SimplifiedContextBox sbox = this.makeSimplifiedBox(start, end);
                this.simple_stack.push(sbox);
                end = start = i;
                ++prev_partition_index;
                continue;
            }
            ++end;
        }
        SimplifiedContextBox sbox = this.makeSimplifiedBox(start, end);
        this.simple_stack.push(sbox);
    }

    private SimplifiedContextBox makeSimplifiedBox(int i, int j) {
        if (i > j) {
            System.out.println("Invalid Partition Indices: " + i + ", " + j);
            return null;
        }
        SimplifiedContextBox sbox = new SimplifiedContextBox();
        NodeContextMessage first = this.full_stack.get(i);
        NodeContextMessage last = this.full_stack.get(j);
        sbox.translation_x = first.getTranslationX();
        sbox.higher_order_y = first.getHigherOrderY();
        sbox.text_syntax = first.getTextRepr();
        sbox.syntax_to_highlight = last.getTextRepr();
        this.SetAllProds();
        sbox.prods_visited = Arrays.copyOfRange(this.productions, i, j + 1);
        sbox.features = new ArrayList<Feature>();
        this.fillInFeaturesList(sbox, i, j);
        return sbox;
    }

    private void fillInFeaturesList(SimplifiedContextBox sbox, int i, int j) {
        for (int k = i; k <= j; ++k) {
            Feature f;
            String targetName;
            String nodeName;
            NodeContextMessage node = this.full_stack.get(k);
            if (node.isRedex()) {
                nodeName = this.productions[k].toString();
                targetName = "";
                if (k < j) {
                    targetName = this.productions[k + 1].toString();
                }
                f = new Feature(nodeName, "redex", targetName);
                sbox.features.add(f);
            }
            if (node.isContractum()) {
                nodeName = this.productions[k].toString();
                targetName = "";
                if (k > 0) {
                    targetName = this.productions[k - 1].toString();
                }
                f = new Feature(nodeName, "contractum", targetName);
                sbox.features.add(f);
            }
            if (!node.isAttributeRoot()) continue;
            nodeName = this.productions[k].toString();
            targetName = "";
            if (k > 0) {
                targetName = this.productions[k - 1].toString();
            }
            f = new Feature(nodeName, "attribute root", targetName);
            sbox.features.add(f);
        }
    }

    private void SetAllProds() {
        int prod_index;
        if (!this.need_set_all_prods) {
            return;
        }
        ProductionName[] all_prods = new ProductionName[this.full_stack.get_height()];
        for (int index = 0; index < this.full_stack.get_height(); ++index) {
            ProductionName pn;
            all_prods[index] = pn = new ProductionName(this.full_stack.get(index).getProdName(), -1);
        }
        for (prod_index = 0; prod_index < all_prods.length; ++prod_index) {
            int seq_num = 1;
            String name = all_prods[prod_index].name;
            for (int visit_index = 0; visit_index < prod_index; ++visit_index) {
                String cur_name = all_prods[visit_index].name;
                if (cur_name.compareTo(name) != 0) continue;
                ++seq_num;
            }
            all_prods[prod_index].index = seq_num;
        }
        for (prod_index = 0; prod_index < all_prods.length; ++prod_index) {
            if (all_prods[prod_index].index != 1) continue;
            boolean is_unique = true;
            for (int k = 0; k < all_prods.length; ++k) {
                if (k == prod_index || all_prods[k].name.compareTo(all_prods[prod_index].name) != 0) continue;
                is_unique = false;
                break;
            }
            if (!is_unique) continue;
            all_prods[prod_index].index = 0;
        }
        this.productions = all_prods;
        this.need_set_all_prods = false;
    }

    private void fillInPartition() {
        this.partition = new int[this.full_stack.get_height()];
        int previous_x = 0;
        int previous_y = 0;
        int partition_index = 0;
        for (int i = 0; i < this.full_stack.get_height(); ++i) {
            NodeContextMessage node = this.full_stack.get(i);
            int cur_x = node.getTranslationX();
            int cur_y = node.getHigherOrderY();
            if (cur_x == previous_x && cur_y == previous_y) {
                this.partition[i] = partition_index;
                continue;
            }
            previous_x = cur_x;
            previous_y = cur_y;
            this.partition[i] = ++partition_index;
        }
    }
}

