/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.spec.numeric;

import edu.umn.cs.melt.copper.compiletime.auxiliary.SymbolTable;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.PrecedenceGraph;
import edu.umn.cs.melt.copper.runtime.auxiliary.internal.PrettyPrinter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Queue;
import java.util.Stack;

public class Digraph {
    private static final int WHITE = 0;
    private static final int GRAY = 1;
    private static final int BLACK = 2;
    protected int vertexCount;
    protected boolean[][] adjacencyMatrix;
    protected int[] inDegrees;

    public Digraph(int vertexCount) {
        this.vertexCount = vertexCount;
        this.adjacencyMatrix = new boolean[vertexCount][vertexCount];
        this.inDegrees = new int[vertexCount];
    }

    public boolean hasEdge(int bottom, int top) {
        if (top < 0 || top >= this.vertexCount || bottom < 0 || bottom >= this.vertexCount) {
            return false;
        }
        return this.adjacencyMatrix[top][bottom];
    }

    public boolean addEdge(int bottom, int top) {
        if (top < 0 || top >= this.vertexCount || bottom < 0 || bottom >= this.vertexCount) {
            return true;
        }
        if (!this.adjacencyMatrix[top][bottom]) {
            int n = bottom;
            this.inDegrees[n] = this.inDegrees[n] + 1;
        }
        boolean rv = this.adjacencyMatrix[top][bottom];
        this.adjacencyMatrix[top][bottom] = true;
        return rv;
    }

    protected Digraph cut(BitSet vertices) {
        if (vertices.length() > this.vertexCount) {
            return null;
        }
        Digraph rv = new Digraph(this.vertexCount);
        int i = vertices.nextSetBit(0);
        while (i >= 0) {
            int j = vertices.nextSetBit(0);
            while (j >= 0) {
                rv.adjacencyMatrix[i][j] = this.adjacencyMatrix[i][j];
                if (rv.adjacencyMatrix[i][j]) {
                    int n = j;
                    rv.inDegrees[n] = rv.inDegrees[n] + 1;
                }
                j = vertices.nextSetBit(i + 1);
            }
            i = vertices.nextSetBit(i + 1);
        }
        return rv;
    }

    protected boolean detectCycles(BitSet vertices, Queue<BitSet> detectedCycles, Queue<Integer> topologicallySortedVertices) {
        int[] colors = new int[this.vertexCount];
        Stack<Integer> searchStack = new Stack<Integer>();
        int i = vertices.nextSetBit(0);
        while (i >= 0) {
            if (colors[i] == 0) {
                searchStack.push(i);
                this.detectCyclesVisit(vertices, detectedCycles, topologicallySortedVertices, colors, searchStack);
                searchStack.pop();
            }
            i = vertices.nextSetBit(i + 1);
        }
        return !detectedCycles.isEmpty();
    }

    private void detectCyclesVisit(BitSet vertices, Collection<BitSet> detectedCycles, Queue<Integer> topologicallySortedVertices, int[] colors, Stack<Integer> searchStack) {
        int u = searchStack.peek();
        colors[u] = 1;
        int v = vertices.nextSetBit(0);
        while (v >= 0) {
            if (this.hasEdge(u, v)) {
                if (colors[v] == 0) {
                    searchStack.push(v);
                    this.detectCyclesVisit(vertices, detectedCycles, topologicallySortedVertices, colors, searchStack);
                    searchStack.pop();
                } else if (colors[v] == 1) {
                    BitSet cycleMembers = new BitSet(this.vertexCount);
                    cycleMembers.set(v);
                    for (int i = searchStack.size() - 1; i >= 0 && (Integer)searchStack.get(i) != v; --i) {
                        cycleMembers.set(i);
                    }
                    detectedCycles.add(cycleMembers);
                }
            }
            v = vertices.nextSetBit(v + 1);
        }
        colors[u] = 2;
        if (topologicallySortedVertices != null) {
            topologicallySortedVertices.offer(u);
        }
    }

    public <T> String toString(SymbolTable<T> symbolTable) {
        int i;
        String rv = "";
        ArrayList<String> vertexStrings = new ArrayList<String>(this.vertexCount);
        for (i = 0; i < this.vertexCount; ++i) {
            vertexStrings.set(i, i + ": " + symbolTable.get(i));
        }
        rv = rv + "Vertices: [\n" + PrettyPrinter.iterablePrettyPrint(vertexStrings, "  ", 1) + "];\nAdjacency matrix\n(read as column < row): \n";
        for (i = 0; i < this.adjacencyMatrix.length; ++i) {
            rv = rv + "   ";
            for (int j = 0; j < this.adjacencyMatrix.length; ++j) {
                rv = this.adjacencyMatrix[i][j] ? rv + "1 " : rv + "0 ";
            }
            rv = rv + "\n";
        }
        return rv;
    }

    public <T> String toDot(String graphName, SymbolTable<T> symbolTable) {
        int i;
        StringBuffer rv = new StringBuffer();
        rv.append("digraph ").append(graphName).append("\n{\n");
        for (i = 0; i < this.vertexCount; ++i) {
            rv.append("\tt" + i + " [shape=box, label=\"" + symbolTable.get(i) + "\"];\n");
        }
        rv.append("\n");
        for (i = 0; i < this.vertexCount; ++i) {
            for (int j = 0; j < this.vertexCount; ++j) {
                if (!this.adjacencyMatrix[i][j]) continue;
                rv.append("\tt" + i + " -> t" + j + ";\n");
            }
        }
        rv.append("}\n");
        return rv.toString();
    }

    public String toEquivalenceClassDot(String graphName) {
        int i;
        StringBuffer rv = new StringBuffer();
        ArrayList<BitSet> existingAdjacencyListsL = new ArrayList<BitSet>();
        Hashtable<BitSet, Integer> existingAdjacencyListsM = new Hashtable<BitSet, Integer>();
        Hashtable adjacencyListMaps = new Hashtable();
        for (int i2 = 0; i2 < this.vertexCount; ++i2) {
            BitSet adjacencyList = new BitSet(this.vertexCount * 2);
            for (int j = 0; j < this.vertexCount; ++j) {
                adjacencyList.set(j, this.adjacencyMatrix[i2][j]);
                adjacencyList.set(this.vertexCount + j, this.adjacencyMatrix[j][i2]);
            }
            if (!existingAdjacencyListsM.containsKey(adjacencyList)) {
                BitSet verticesWithAdjacencyList = new BitSet(this.vertexCount);
                existingAdjacencyListsL.add(verticesWithAdjacencyList);
                existingAdjacencyListsM.put(adjacencyList, existingAdjacencyListsL.size() - 1);
            }
            ((BitSet)existingAdjacencyListsL.get((Integer)existingAdjacencyListsM.get(adjacencyList))).set(i2);
            adjacencyListMaps.put(i2, existingAdjacencyListsM.get(adjacencyList));
        }
        PrecedenceGraph equivalenceClassGraph = new PrecedenceGraph(existingAdjacencyListsL.size());
        ArrayList<String> labels = new ArrayList<String>();
        for (i = 0; i < existingAdjacencyListsL.size(); ++i) {
            String label = "";
            int sqrt = (int)Math.ceil(Math.sqrt(((BitSet)existingAdjacencyListsL.get(i)).cardinality()));
            int k = 0;
            int j = ((BitSet)existingAdjacencyListsL.get(i)).nextSetBit(0);
            while (j >= 0) {
                if (k != 0) {
                    label = label + ",";
                    label = ((BitSet)existingAdjacencyListsL.get(i)).cardinality() >= 5 && k % sqrt == 0 ? label + "\\n" : label + " ";
                }
                label = label + j;
                ++k;
                j = ((BitSet)existingAdjacencyListsL.get(i)).nextSetBit(j + 1);
            }
            labels.add(label);
        }
        for (i = 0; i < this.vertexCount; ++i) {
            for (int j = 0; j < this.vertexCount; ++j) {
                if (!this.adjacencyMatrix[i][j]) continue;
                equivalenceClassGraph.addEdge((Integer)adjacencyListMaps.get(j), (Integer)adjacencyListMaps.get(i));
            }
        }
        rv.append(equivalenceClassGraph.toDot(graphName, new SymbolTable(labels)));
        return rv.toString();
    }
}

