/*
 * Decompiled with CFR 0.152.
 */
package common.rawlib;

import common.ConsCell;
import common.IOToken;
import common.StringCatter;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.List;
import silver.core.NIOVal;

public class RawProcessHandle {
    private Process proc;
    private BufferedReader our_stdout = null;
    private BufferedReader our_stderr = null;

    public RawProcessHandle(Process p) {
        this.proc = p;
    }

    public RawProcessHandle(List<String> cmd_args) {
        ProcessBuilder pb = new ProcessBuilder(cmd_args);
        pb.redirectOutput(ProcessBuilder.Redirect.PIPE);
        pb.redirectInput(ProcessBuilder.Redirect.PIPE);
        pb.redirectError(ProcessBuilder.Redirect.PIPE);
        try {
            this.proc = pb.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void checkInitializeStdout() {
        if (this.our_stdout == null) {
            InputStream instream = this.proc.getInputStream();
            InputStreamReader r = new InputStreamReader(instream);
            this.our_stdout = new BufferedReader(r);
        }
    }

    private void checkInitializeStderr() {
        if (this.our_stderr == null) {
            InputStream instream = this.proc.getErrorStream();
            InputStreamReader r = new InputStreamReader(instream);
            this.our_stderr = new BufferedReader(r);
        }
    }

    private String readAll(BufferedReader reader) {
        String output = "";
        try {
            while (reader.ready()) {
                char last_char = (char)reader.read();
                output = output + last_char;
            }
            return output;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String readUntil(BufferedReader reader, String ending) {
        String output = "";
        try {
            while (!output.endsWith(ending)) {
                char last_char = (char)reader.read();
                output = output + last_char;
            }
            return output;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String readLineStdout() {
        try {
            this.checkInitializeStdout();
            return this.our_stdout.readLine();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String readAllStdout() {
        try {
            this.checkInitializeStdout();
            return this.readAll(this.our_stdout);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String readUntilStdout(String ending) {
        try {
            this.checkInitializeStdout();
            return this.readUntil(this.our_stdout, ending);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String readLineStderr() {
        try {
            this.checkInitializeStderr();
            return this.our_stderr.readLine();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String readAllStderr() {
        try {
            this.checkInitializeStderr();
            return this.readAll(this.our_stderr);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String readUntilStderr(String ending) {
        try {
            this.checkInitializeStderr();
            return this.readUntil(this.our_stderr, ending);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void writeString(String msg) {
        OutputStream ostream = this.proc.getOutputStream();
        try {
            ostream.write(msg.getBytes());
            ostream.flush();
            return;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void waitOnEnd() {
        try {
            this.proc.waitFor();
            return;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static NIOVal spawnProcess(StringCatter cmd, ConsCell args, IOToken io) {
        List<String> full_cmd = ConsCell.toList(args);
        full_cmd.add(0, cmd.toString());
        return io.wrap(new RawProcessHandle(full_cmd));
    }

    public IOToken sendToProcess(StringCatter msg, IOToken io) {
        this.writeString(msg.toString());
        return io;
    }

    public NIOVal readLineFromProcess(IOToken io) {
        return io.wrap(new StringCatter(this.readLineStdout()));
    }

    public NIOVal readAllFromProcess(IOToken io) {
        return io.wrap(new StringCatter(this.readAllStdout()));
    }

    public NIOVal readUntilFromProcess(IOToken io, StringCatter s) {
        return io.wrap(new StringCatter(this.readUntilStdout(s.toString())));
    }

    public NIOVal readErrLineFromProcess(IOToken io) {
        return io.wrap(new StringCatter(this.readLineStderr()));
    }

    public NIOVal readErrAllFromProcess(IOToken io) {
        return io.wrap(new StringCatter(this.readAllStderr()));
    }

    public NIOVal readErrUntilFromProcess(IOToken io, StringCatter s) {
        return io.wrap(new StringCatter(this.readUntilStdout(s.toString())));
    }

    public IOToken waitForProcess(IOToken io) {
        this.waitOnEnd();
        return io;
    }
}

