/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.builders;

import edu.umn.cs.melt.copper.compiletime.spec.numeric.ContextSets;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.ParserSpec;
import java.util.BitSet;

public class ContextSetBuilder {
    public static ContextSets build(ParserSpec spec) {
        ContextSets c = new ContextSets(Math.max(spec.terminals.length(), spec.nonterminals.length()));
        int t = spec.terminals.nextSetBit(0);
        while (t >= 0) {
            c.getFirst(t).set(t);
            t = spec.terminals.nextSetBit(t + 1);
        }
        int nt = spec.nonterminals.nextSetBit(0);
        while (nt >= 0) {
            c.getFirstNTs(nt).set(nt);
            nt = spec.nonterminals.nextSetBit(nt + 1);
        }
        boolean setsChanged = true;
        while (setsChanged) {
            setsChanged = false;
            int nt2 = spec.nonterminals.nextSetBit(0);
            while (nt2 >= 0) {
                BitSet productions = spec.nt.getProductions(nt2);
                if (!spec.nt.getProductions(nt2).isEmpty()) {
                    int p = productions.nextSetBit(0);
                    while (p >= 0) {
                        int i;
                        int x = spec.pr.getLHS(p);
                        boolean isNullable = true;
                        for (int i2 = 0; i2 < spec.pr.getRHSLength(p); ++i2) {
                            isNullable &= c.isNullable(spec.pr.getRHSSym(p, i2));
                        }
                        if (isNullable) {
                            setsChanged |= !c.isNullable(x);
                            c.setNullable(x, true);
                        }
                        int frontNullableIndex = -1;
                        int rearNullableIndex = -1;
                        for (i = 0; i < spec.pr.getRHSLength(p); ++i) {
                            if (c.isNullable(spec.pr.getRHSSym(p, i))) continue;
                            if (frontNullableIndex == -1) {
                                frontNullableIndex = i;
                            }
                            rearNullableIndex = i;
                        }
                        block7: for (i = 0; i < spec.pr.getRHSLength(p); ++i) {
                            if (frontNullableIndex == -1 || i <= frontNullableIndex) {
                                setsChanged |= ParserSpec.union(c.getFirst(x), c.getFirst(spec.pr.getRHSSym(p, i)));
                                setsChanged |= ParserSpec.union(c.getFirstNTs(x), c.getFirstNTs(spec.pr.getRHSSym(p, i)));
                            }
                            if (rearNullableIndex == -1 || i >= rearNullableIndex) {
                                setsChanged |= ParserSpec.union(c.getFollow(spec.pr.getRHSSym(p, i)), c.getFollow(x));
                            }
                            boolean nullableSoFar = true;
                            for (int j = i + 1; j < spec.pr.getRHSLength(p); ++j) {
                                if (j > i + 1) {
                                    nullableSoFar &= c.isNullable(spec.pr.getRHSSym(p, j - 1));
                                }
                                if (!nullableSoFar) continue block7;
                                setsChanged |= ParserSpec.union(c.getFollow(spec.pr.getRHSSym(p, i)), c.getFirst(spec.pr.getRHSSym(p, j)));
                            }
                        }
                        p = productions.nextSetBit(p + 1);
                    }
                }
                nt2 = spec.nonterminals.nextSetBit(nt2 + 1);
            }
        }
        return c;
    }
}

