/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.spec.numeric;

import edu.umn.cs.melt.copper.compiletime.auxiliary.SymbolTable;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CopperASTBean;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.OperatorAssociativity;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.Production;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.Regex;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.PrecedenceGraph;
import java.io.Serializable;
import java.util.BitSet;

public class ParserSpec
implements Serializable {
    private static final long serialVersionUID = -5024964891089039358L;
    public BitSet terminals;
    public BitSet nonterminals;
    public BitSet productions;
    public BitSet disambiguationFunctions;
    public BitSet terminalClasses;
    public BitSet operatorClasses;
    public BitSet parserAttributes;
    public BitSet grammars;
    public int parser;
    public SymbolTable<CopperASTBean> symbolTable;
    public int[] owners;
    public BitSet bridgeConstructs;
    public transient TerminalData t;
    public transient NonterminalData nt;
    public ProductionData pr;
    public DisambiguationFunctionData df;
    public transient TerminalClassData tc;
    public transient GrammarData g;
    public transient ParserData p;

    public static boolean union(BitSet lhs, BitSet rhs) {
        int card = lhs.cardinality();
        lhs.or(rhs);
        return lhs.cardinality() > card;
    }

    public int getEOFTerminal() {
        return this.terminals.nextSetBit(0);
    }

    public int getStartNonterminal() {
        return this.nonterminals.nextSetBit(0);
    }

    public int getStartProduction() {
        return this.productions.nextSetBit(0);
    }

    public ParserSpec(SymbolTable<CopperASTBean> symbolTable) {
        this.symbolTable = symbolTable;
        int symbolCount = symbolTable.size();
        this.terminals = new BitSet(symbolCount);
        this.nonterminals = new BitSet(symbolCount);
        this.productions = new BitSet(symbolCount);
        this.disambiguationFunctions = new BitSet(symbolCount);
        this.terminalClasses = new BitSet(symbolCount);
        this.operatorClasses = new BitSet(symbolCount);
        this.parserAttributes = new BitSet(symbolCount);
        this.grammars = new BitSet(symbolCount);
        this.owners = new int[symbolCount];
        this.bridgeConstructs = new BitSet(symbolCount);
    }

    public void initAttributes(SymbolTable<CopperASTBean> symbolTable) {
        int maxRHS = 2;
        int i = this.productions.nextSetBit(this.productions.nextSetBit(0) + 1);
        while (i >= 0) {
            maxRHS = Math.max(maxRHS, ((Production)symbolTable.get(i)).getRhs().size());
            i = this.productions.nextSetBit(i + 1);
        }
        this.t = new TerminalData(this.terminals.length());
        this.nt = new NonterminalData(this.nonterminals.length());
        this.pr = new ProductionData(this.productions.length(), maxRHS);
        this.df = new DisambiguationFunctionData(this.disambiguationFunctions.length());
        this.tc = new TerminalClassData(this.terminalClasses.length());
        this.g = new GrammarData(this.grammars.length());
        this.p = new ParserData(this.parser + 1);
    }

    public String productionToString(SymbolTable<CopperASTBean> symbolTable, int production) {
        StringBuffer rv = new StringBuffer();
        rv.append(symbolTable.get(this.pr.getLHS(production)).getDisplayName()).append(" ::=");
        for (int rhs = 0; rhs < this.pr.getRHSLength(production); ++rhs) {
            rv.append(" ").append(symbolTable.get(this.pr.getRHSSym(production, rhs)).getDisplayName());
        }
        return rv.toString();
    }

    public String toString(SymbolTable<CopperASTBean> symbolTable) {
        StringBuffer rv = new StringBuffer();
        rv.append("Terminals:\n");
        int i = this.terminals.nextSetBit(0);
        while (i >= 0) {
            rv.append("    [").append(i).append("] ").append(symbolTable.get(i).getName()).append(" (").append(symbolTable.get(i).getDisplayName()).append(")\n");
            i = this.terminals.nextSetBit(i + 1);
        }
        rv.append("Nonterminals:\n");
        i = this.nonterminals.nextSetBit(0);
        while (i >= 0) {
            rv.append("    [").append(i).append("] ").append(symbolTable.get(i).getName()).append(" (").append(symbolTable.get(i).getDisplayName()).append(")\n");
            i = this.nonterminals.nextSetBit(i + 1);
        }
        rv.append("Productions:\n");
        i = this.productions.nextSetBit(0);
        while (i >= 0) {
            rv.append("    [").append(i).append("] ").append(symbolTable.get(this.pr.getLHS(i)).getDisplayName()).append(" ::=");
            for (int rhs = 0; rhs < this.pr.getRHSLength(i); ++rhs) {
                rv.append(" ").append(symbolTable.get(this.pr.getRHSSym(i, rhs)).getDisplayName());
            }
            rv.append("\n");
            i = this.productions.nextSetBit(i + 1);
        }
        rv.append("Disambiguation functions:\n");
        i = this.disambiguationFunctions.nextSetBit(0);
        while (i >= 0) {
            rv.append("    [").append(i).append("] ").append(symbolTable.get(i).getName()).append(" (").append(symbolTable.get(i).getDisplayName()).append(")\n");
            i = this.disambiguationFunctions.nextSetBit(i + 1);
        }
        rv.append("Terminal classes:\n");
        i = this.terminalClasses.nextSetBit(0);
        while (i >= 0) {
            rv.append("    [").append(i).append("] ").append(symbolTable.get(i).getName()).append(" (").append(symbolTable.get(i).getDisplayName()).append(")\n");
            i = this.terminalClasses.nextSetBit(i + 1);
        }
        rv.append("Operator classes:\n");
        i = this.operatorClasses.nextSetBit(0);
        while (i >= 0) {
            rv.append("    [").append(i).append("] ").append(symbolTable.get(i).getName()).append(" (").append(symbolTable.get(i).getDisplayName()).append(")\n");
            i = this.operatorClasses.nextSetBit(i + 1);
        }
        rv.append("Parser attributes:\n");
        i = this.parserAttributes.nextSetBit(0);
        while (i >= 0) {
            rv.append("    [").append(i).append("] ").append(symbolTable.get(i).getName()).append(" (").append(symbolTable.get(i).getDisplayName()).append(")\n");
            i = this.parserAttributes.nextSetBit(i + 1);
        }
        rv.append("Grammars:\n");
        i = this.grammars.nextSetBit(0);
        while (i >= 0) {
            rv.append("    [").append(i).append("] ").append(symbolTable.get(i).getName()).append(" (").append(symbolTable.get(i).getDisplayName()).append(")\n");
            i = this.grammars.nextSetBit(i + 1);
        }
        rv.append("Parsers:\n");
        rv.append("    [").append(this.parser).append("] ").append(symbolTable.get(this.parser).getName()).append(" (").append(symbolTable.get(this.parser).getDisplayName()).append(")\n");
        rv.append("Precedence graph:\n");
        rv.append(this.t.precedences);
        return rv.toString();
    }

    public static final class ParserData {
        protected BitSet layout = new BitSet();

        public final BitSet getLayout() {
            return this.layout;
        }

        public ParserData(int count) {
        }
    }

    public static final class GrammarData {
        protected BitSet[] layouts;

        public final BitSet getLayouts(int tc) {
            return this.layouts[tc];
        }

        public GrammarData(int count) {
            this.layouts = new BitSet[count];
            for (int i = 0; i < count; ++i) {
                this.layouts[i] = new BitSet();
            }
        }
    }

    public static final class TerminalClassData {
        protected BitSet[] members;

        public final BitSet getMembers(int tc) {
            return this.members[tc];
        }

        public TerminalClassData(int count) {
            this.members = new BitSet[count];
            for (int i = 0; i < count; ++i) {
                this.members[i] = new BitSet();
            }
        }
    }

    public static final class DisambiguationFunctionData
    implements Serializable {
        private static final long serialVersionUID = -6379317437173398929L;
        protected BitSet[] members;
        protected int[] disambiguateTos;
        protected BitSet applicableToSubsets;

        public final BitSet getMembers(int dg) {
            return this.members[dg];
        }

        public final int getDisambiguateTo(int dg) {
            return this.disambiguateTos[dg];
        }

        public final boolean hasDisambiguateTo(int dg) {
            return this.disambiguateTos[dg] != -1;
        }

        public final boolean getApplicableToSubsets(int dg) {
            return this.applicableToSubsets.get(dg);
        }

        public final BitSet getApplicableToSubsets() {
            return this.applicableToSubsets;
        }

        public final void setDisambiguateTo(int dg, int t) {
            this.disambiguateTos[dg] = t;
        }

        public final void setApplicableToSubsets(int dg, boolean a) {
            this.applicableToSubsets.set(dg, a);
        }

        public DisambiguationFunctionData(int count) {
            this.members = new BitSet[count];
            this.disambiguateTos = new int[count];
            this.applicableToSubsets = new BitSet();
            for (int i = 0; i < count; ++i) {
                this.members[i] = new BitSet();
            }
        }
    }

    public static final class ProductionData
    implements Serializable {
        private static final long serialVersionUID = 5306191791546758652L;
        protected int[] LHSs;
        protected int[] RHSLengths;
        protected int[][] RHSs;
        protected int[] operators;
        protected int[] precedences;
        protected int[] precedenceClasses;
        protected boolean[] hasLayout;
        protected BitSet[] layouts;

        public final int getLHS(int p) {
            return this.LHSs[p];
        }

        public final int getRHSLength(int p) {
            return this.RHSLengths[p];
        }

        public final int getRHSSym(int p, int s) {
            return this.RHSs[p][s];
        }

        public final int getOperator(int p) {
            return this.operators[p];
        }

        public final int getPrecedence(int p) {
            return this.precedences[p];
        }

        public final int getPrecedenceClass(int p) {
            return this.precedenceClasses[p];
        }

        public final boolean hasLayout(int p) {
            return this.hasLayout[p];
        }

        public final BitSet getLayouts(int p) {
            return this.layouts[p];
        }

        public final void setLHS(int p, int lhs) {
            this.LHSs[p] = lhs;
        }

        public final void setRHSLength(int p, int length) {
            this.RHSLengths[p] = length;
        }

        public final void setRHSSym(int p, int s, int sym) {
            this.RHSs[p][s] = sym;
        }

        public final void setOperator(int p, int o) {
            this.operators[p] = o;
        }

        public final void setPrecedence(int p, int pr) {
            this.precedences[p] = pr;
        }

        public final void setPrecedenceClass(int p, int pc) {
            this.precedenceClasses[p] = pc;
        }

        public final void setHasLayout(int p, boolean h) {
            this.hasLayout[p] = h;
        }

        public ProductionData(int count, int maxRHS) {
            this.LHSs = new int[count];
            this.RHSLengths = new int[count];
            this.RHSs = new int[count][maxRHS];
            this.operators = new int[count];
            this.precedences = new int[count];
            this.precedenceClasses = new int[count];
            this.hasLayout = new boolean[count];
            this.layouts = new BitSet[count];
            for (int i = 0; i < count; ++i) {
                this.layouts[i] = new BitSet();
            }
        }
    }

    public static final class NonterminalData {
        protected BitSet[] productions;

        public final BitSet getProductions(int nt) {
            return this.productions[nt];
        }

        public NonterminalData(int count) {
            this.productions = new BitSet[count];
            for (int i = 0; i < count; ++i) {
                this.productions[i] = new BitSet();
            }
        }
    }

    public static final class TerminalData {
        protected Regex[] regexes;
        protected BitSet[] terminalClasses;
        protected int[] transparentPrefixes;
        protected int[] operatorClasses;
        protected int[] operatorPrecedences;
        protected OperatorAssociativity[] operatorAssociativities;
        public PrecedenceGraph precedences;

        public final Regex getRegex(int t) {
            return this.regexes[t];
        }

        public final BitSet getTerminalClasses(int t) {
            return this.terminalClasses[t];
        }

        public final int getTransparentPrefix(int t) {
            return this.transparentPrefixes[t];
        }

        public final int getOperatorClass(int t) {
            return this.operatorClasses[t];
        }

        public final boolean hasOperatorPrecedence(int t) {
            return this.operatorPrecedences[t] != -1;
        }

        public final int getOperatorPrecedence(int t) {
            return this.operatorPrecedences[t];
        }

        public final OperatorAssociativity getOperatorAssociativity(int t) {
            return this.operatorAssociativities[t];
        }

        public final void setRegex(int t, Regex regex) {
            this.regexes[t] = regex;
        }

        public final void setTransparentPrefix(int t, int prefix) {
            this.transparentPrefixes[t] = prefix;
        }

        public final void setOperatorClass(int t, int c) {
            this.operatorClasses[t] = c;
        }

        public final void setOperatorPrecedence(int t, int p) {
            this.operatorPrecedences[t] = p;
        }

        public final void setOperatorAssociativity(int t, OperatorAssociativity a) {
            this.operatorAssociativities[t] = a;
        }

        public TerminalData(int count) {
            this.regexes = new Regex[count];
            this.terminalClasses = new BitSet[count];
            this.transparentPrefixes = new int[count];
            this.operatorClasses = new int[count];
            this.operatorPrecedences = new int[count];
            this.operatorAssociativities = new OperatorAssociativity[count];
            this.precedences = new PrecedenceGraph(count);
            for (int i = 0; i < count; ++i) {
                this.terminalClasses[i] = new BitSet();
            }
        }
    }
}

