/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.legacy.compiletime.semantics.lalr1;

import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.GrammarSource;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.Terminal;
import edu.umn.cs.melt.copper.legacy.compiletime.engines.lalr.QScannerStateInfo;
import edu.umn.cs.melt.copper.legacy.compiletime.logging.CompilerLogMessageSort;
import edu.umn.cs.melt.copper.legacy.compiletime.logging.CompilerLogger;
import edu.umn.cs.melt.copper.legacy.compiletime.logging.LexicalConflictResolution;
import edu.umn.cs.melt.copper.legacy.compiletime.parsetable.ParseTable;
import edu.umn.cs.melt.copper.runtime.auxiliary.internal.PrettyPrinter;
import edu.umn.cs.melt.copper.runtime.logging.CopperException;
import java.util.HashSet;
import java.util.TreeSet;

public abstract class LexicalAmbiguityChecker {
    public CompilerLogger logger;

    public LexicalAmbiguityChecker(CompilerLogger logger) {
        this.logger = logger;
    }

    protected HashSet<Terminal> disambiguateState(QScannerStateInfo info, GrammarSource grammarData, Iterable<Terminal> shiftable) {
        HashSet<Terminal> finalAcceptSet = new HashSet<Terminal>();
        for (Terminal t : shiftable) {
            if (!info.getAcceptingSyms().contains(t)) continue;
            finalAcceptSet.add(t);
        }
        return finalAcceptSet;
    }

    protected void reportAmbiguity(GrammarSource grammar, HashSet<Terminal> ambiguity, TreeSet<Integer> places, LexicalConflictResolution resolution) throws CopperException {
        CompilerLogMessageSort severity = resolution != null ? CompilerLogMessageSort.LEXICAL_CONFLICT : CompilerLogMessageSort.UNRESOLVED_LEXICAL_CONFLICT;
        HashSet<String> displayNamedAmbiguity = new HashSet<String>();
        for (Terminal t : ambiguity) {
            displayNamedAmbiguity.add(grammar.getDisplayName(t.getId()));
        }
        String ambigHash = PrettyPrinter.iterablePrettyPrint(displayNamedAmbiguity, "   ", PrettyPrinter.getOptimalItemsPerLine(displayNamedAmbiguity, 80));
        this.logger.logLexicalConflict(severity, resolution, places, ambiguity, " " + (ambiguity.size() == 2 ? "between" : "among") + " terminals:\n" + ambigHash + (resolution != null ? "\nResolved by " + (Object)((Object)resolution) + "." : ""));
    }

    public abstract void checkLexicalAmbiguities(GrammarSource var1, QScannerStateInfo[] var2, ParseTable var3) throws CopperException;
}

